/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.Updater;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public abstract class SwitchAttribute
extends Updater
implements UtilEventListener {
    protected Sanbox2Sml theSwitch = null;
    protected String[] updateCommands = null;
    protected String[] applyCommands = null;
    protected int updateCompleteEvent;
    protected int applyCompleteEvent;

    public SwitchAttribute() {
    }

    public SwitchAttribute(Sanbox2Sml sanbox2Sml) {
        this.theSwitch = sanbox2Sml;
    }

    public SwitchAttribute(Sanbox2Sml sanbox2Sml, int n) {
        this.theSwitch = sanbox2Sml;
        this.updateCompleteEvent = n;
    }

    public SwitchAttribute(Sanbox2Sml sanbox2Sml, int n, String[] stringArray, int n2, String[] stringArray2) {
        this.theSwitch = sanbox2Sml;
        this.updateCompleteEvent = n;
        this.updateCommands = stringArray;
        this.applyCompleteEvent = n2;
        this.applyCommands = stringArray2;
    }

    public boolean update() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        int n = 0;
        while (n < this.updateCommands.length) {
            utilMsgSml.addSmlCommand(this.updateCommands[n]);
            ++n;
        }
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean apply(String[] stringArray) {
        if (this.applyCommands == null) {
            throw new UnsupportedOperationException();
        }
        if (stringArray.length != this.applyCommands.length) {
            return false;
        }
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        utilMsgSml.setSetCommand();
        int n = 0;
        while (n < this.applyCommands.length) {
            if (stringArray[n] != null) {
                utilMsgSml.addSmlCommand(this.applyCommands[n] + "." + stringArray[n]);
            } else {
                utilMsgSml.addSmlCommand(this.applyCommands[n]);
            }
            ++n;
        }
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    public void handleResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        if (utilMsgSml.AllResponsesOk()) {
            if (utilMsgSml.getIsSetCommand()) {
                this.theSwitch.eventHandler.fireChassisEvent(this.applyCompleteEvent, null, true);
            } else {
                this.saveResponse(object);
                this.theSwitch.eventHandler.fireChassisEvent(this.updateCompleteEvent, null, true);
            }
        } else if (utilMsgSml.getIsSetCommand()) {
            this.theSwitch.eventHandler.fireChassisEvent(this.applyCompleteEvent, null, utilMsgSml.getErrorType());
        } else {
            this.theSwitch.eventHandler.fireChassisEvent(this.updateCompleteEvent, null, utilMsgSml.getErrorType());
        }
    }

    protected abstract void saveResponse(Object var1);

    protected void setTheSwitch(Sanbox2Sml sanbox2Sml) {
        this.theSwitch = sanbox2Sml;
    }

    protected SanboxChassis getTheSwitch() {
        return this.theSwitch;
    }

    protected void setUpdateCommands(String[] stringArray) {
        this.updateCommands = stringArray;
    }

    protected String[] getUpdateCommands() {
        return this.updateCommands;
    }

    protected void setApplyCommands(String[] stringArray) {
        this.applyCommands = stringArray;
    }

    protected String[] getApplyCommands() {
        return this.applyCommands;
    }

    protected void setUpdateCompleteEvent(int n) {
        this.updateCompleteEvent = n;
    }

    protected int getUpdateCompleteEvent() {
        return this.updateCompleteEvent;
    }

    protected void setApplyCompleteEvent(int n) {
        this.applyCompleteEvent = n;
    }

    protected int getApplyCompleteEvent() {
        return this.applyCompleteEvent;
    }

    public void receiveMessage(UtilMessage utilMessage) {
        this.theSwitch.updateStatusWithMsgResponse(utilMessage);
        this.handleResponse(utilMessage);
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1) + ": switch=" + this.theSwitch + " updateEvent=" + this.updateCompleteEvent;
    }

    public int getEvent() {
        return this.getUpdateCompleteEvent();
    }
}

