/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.FCStatistics;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public class PortStatisticsAttr
extends SwitchAttribute {
    public static final int UPDATE_COMPLETE_EVENT = 221;
    private static final int NUMBER_OF_STATS = 43;
    private boolean resetBaseline;

    public PortStatisticsAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 221);
    }

    public boolean apply(String[] stringArray) {
        throw new UnsupportedOperationException();
    }

    public boolean update() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        String string = "Oper.UserPort.0.";
        int n = 0;
        int n2 = this.theSwitch.getPortCount();
        while (n < n2) {
            utilMsgSml.addSmlCommand(string + n + ".C64.Counters");
            ++n;
        }
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean update(int n, boolean bl) {
        this.resetBaseline = bl;
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.theSwitch, this);
        utilMsgSml.addSmlCommand("Oper.UserPort.0." + n + ".C64.Counters");
        return this.theSwitch.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean update(Object[] objectArray) {
        if (!(objectArray[0] instanceof Integer)) {
            throw new IllegalArgumentException("args[0] not an Integer");
        }
        if (!(objectArray[1] instanceof Boolean)) {
            throw new IllegalArgumentException("args[1] not a Boolean");
        }
        return this.update((Integer)objectArray[0], (Boolean)objectArray[1]);
    }

    protected void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        int n = utilMsgSml.getNumberOfResponses();
        if (n == 1) {
            int n2 = this.getPortNumber(utilMsgSml);
            this.saveStats(this.parseStats(utilMsgSml.getResponse(0).getResponse()), n2);
        } else {
            int n3 = 0;
            while (n3 < n) {
                this.saveStats(this.parseStats(utilMsgSml.getResponse(n3).getResponse()), n3);
                ++n3;
            }
        }
        this.resetBaseline = false;
    }

    private int getPortNumber(UtilMsgSml utilMsgSml) {
        String string = utilMsgSml.getRequest(0).getReqStr();
        return Integer.parseInt(string.substring(16, string.indexOf(".", 16)));
    }

    private long[] parseStats(String string) {
        long[] lArray = new long[43];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (n < lArray.length && n3 <= string.length()) {
            long l;
            n3 = string.indexOf(",", n2);
            if (n3 < 0) {
                n3 = string.length();
            }
            lArray[n] = l = Long.parseLong(string.substring(n2, n3), 16);
            ++n;
            n2 = ++n3;
        }
        return lArray;
    }

    private void saveStats(long[] lArray, int n) {
        FCStatistics fCStatistics = this.theSwitch.getPort(n).getStats();
        fCStatistics.resetTimeStamp();
        if (fCStatistics.getNumberOfStatistics() == 0) {
            int n2 = 0;
            while (n2 < lArray.length) {
                fCStatistics.addValue(lArray[n2], DeviceUtilities.getResource("Sanbox2PortStats." + n2));
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < lArray.length) {
                fCStatistics.setValue(lArray[n3], n3);
                ++n3;
            }
        }
        if (this.resetBaseline) {
            fCStatistics.resetBaseline();
        }
    }
}

