/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.NameServerEntrySml;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgNameServerInfoSml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgNextNsPortIdSml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;
import java.util.Vector;

public class NameServerAttr
extends SwitchAttribute
implements UtilEventListener {
    public static final int UPDATE_COMPLETE_EVENT = 219;
    private static final int SML_GET_NS_TIMESTAMP = 95;
    protected String nameServerDomainIds = null;
    protected String currentNameServerTimeStamp = null;
    Sanbox2 sanbox2;
    UtilAgent utilAgent;
    private int nameServerScanNumber = 0;
    protected Vector nameServerEntryList = new Vector();

    public NameServerAttr(Sanbox2 sanbox2) {
        super((Sanbox2Sml)sanbox2, 219);
        this.sanbox2 = sanbox2;
        this.utilAgent = (UtilAgent)this.sanbox2.getComAgent();
    }

    public void saveResponse(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean update() {
        if (this.sanbox2.getFirmwareVersion() > 2) {
            return this.updateNameServerTimeStamp();
        }
        this.startNameServerScan();
        return this.getFirstNsPortId(null);
    }

    private boolean updateNameServerTimeStamp() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(95);
        utilMsgSml.addSmlCommand("Oper.NameServerAll.0.AllChangedTime");
        utilMsgSml.addSmlCommand("Oper.Eport.LsdbRecordList.255");
        return this.utilAgent.sendSml(utilMsgSml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startNameServerScan() {
        Vector vector = this.nameServerEntryList;
        synchronized (vector) {
            ++this.nameServerScanNumber;
            this.sanbox2.setAcquiringNameServerInfo(true);
            this.nameServerEntryList = new Vector();
        }
    }

    protected boolean getFirstNsPortId(String string) {
        UtilMsgNextNsPortIdSml utilMsgNextNsPortIdSml = new UtilMsgNextNsPortIdSml((UtilDestination)this.sanbox2, this, string, -1, this.nameServerScanNumber);
        return this.utilAgent.sendSml(utilMsgNextNsPortIdSml);
    }

    protected boolean getNextNsPortId(String string, int n) {
        UtilMsgNextNsPortIdSml utilMsgNextNsPortIdSml = new UtilMsgNextNsPortIdSml((UtilDestination)this.sanbox2, this, string, n, this.nameServerScanNumber);
        return this.utilAgent.sendSml(utilMsgNextNsPortIdSml);
    }

    protected boolean getNameServerInfo(String string, int n) {
        UtilMsgNameServerInfoSml utilMsgNameServerInfoSml = new UtilMsgNameServerInfoSml(this.sanbox2, this, string, n, this.nameServerScanNumber, this.getRole());
        return this.utilAgent.sendSml(utilMsgNameServerInfoSml);
    }

    protected boolean getRole() {
        return this.sanbox2.getFirmwareVersion() >= 6;
    }

    protected boolean scanNextDomainId() {
        if (this.sanbox2.getFirmwareVersion() < 3) {
            return false;
        }
        if (this.nameServerDomainIds != null) {
            int n = this.nameServerDomainIds.indexOf(44);
            if (n < 0) {
                n = this.nameServerDomainIds.length();
            }
            String string = this.nameServerDomainIds.substring(0, n);
            this.nameServerDomainIds = n < this.nameServerDomainIds.length() ? this.nameServerDomainIds.substring(n + 1) : null;
            return this.getFirstNsPortId(string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(UtilMessage utilMessage) {
        if (utilMessage instanceof UtilMsgNextNsPortIdSml) {
            UtilMsgNextNsPortIdSml utilMsgNextNsPortIdSml = (UtilMsgNextNsPortIdSml)utilMessage;
            Vector vector = null;
            boolean bl = true;
            Vector vector2 = this.nameServerEntryList;
            synchronized (vector2) {
                if (this.nameServerScanNumber == utilMsgNextNsPortIdSml.getScanNumber()) {
                    int n = utilMsgNextNsPortIdSml.getStatus();
                    if (n != 103) {
                        if (utilMsgNextNsPortIdSml.getNumberOfResponses() > 0 && utilMsgNextNsPortIdSml.getResponse(0).getErrorCode() == 24) {
                            if (!this.scanNextDomainId()) {
                                vector = this.nameServerEntryList;
                                bl = true;
                            }
                        } else if (!this.scanNextDomainId()) {
                            vector = this.nameServerEntryList;
                            bl = false;
                        }
                    } else {
                        int n2 = utilMsgNextNsPortIdSml.getNextPortId();
                        this.getNameServerInfo(utilMsgNextNsPortIdSml.getDomainIdString(), n2);
                    }
                }
            }
            if (vector != null) {
                this.finishedScan(vector, bl);
            }
        } else if (utilMessage instanceof UtilMsgNameServerInfoSml) {
            UtilMsgNameServerInfoSml utilMsgNameServerInfoSml = (UtilMsgNameServerInfoSml)utilMessage;
            Vector vector = null;
            Vector vector3 = this.nameServerEntryList;
            synchronized (vector3) {
                if (this.nameServerScanNumber == utilMsgNameServerInfoSml.getScanNumber()) {
                    int n = utilMsgNameServerInfoSml.getStatus();
                    if (n == 103) {
                        if (utilMsgNameServerInfoSml.AllResponsesOk()) {
                            NameServerEntrySml nameServerEntrySml = new NameServerEntrySml();
                            nameServerEntrySml.saveNameServerInfo(utilMsgNameServerInfoSml);
                            this.nameServerEntryList.add(nameServerEntrySml);
                        }
                        this.getNextNsPortId(utilMsgNameServerInfoSml.getDomainIdString(), utilMsgNameServerInfoSml.getPortId());
                    } else if (!this.scanNextDomainId()) {
                        vector = this.nameServerEntryList;
                    }
                }
            }
            if (vector != null) {
                this.finishedScan(vector, false);
            }
        } else if (utilMessage instanceof UtilMsgSml) {
            UtilMsgSml utilMsgSml = (UtilMsgSml)utilMessage;
            switch (utilMsgSml.getGroupKey()) {
                case 95: {
                    if (utilMsgSml.getStatus() == 103) {
                        if (utilMsgSml.getResponse(0).getErrorCode() == 0) {
                            String string = utilMsgSml.getResponse(0).getResponse();
                            if (this.currentNameServerTimeStamp != null && this.currentNameServerTimeStamp.equals(string)) {
                                if (!this.sanbox2.getAcquiringNameServerInfo()) {
                                    string = this.currentNameServerTimeStamp;
                                    this.finishedScan(null, false);
                                    this.currentNameServerTimeStamp = string;
                                }
                                return;
                            }
                            this.startNameServerScan();
                            this.currentNameServerTimeStamp = string;
                            this.nameServerDomainIds = utilMsgSml.getResponse(1).getResponse();
                            this.scanNextDomainId();
                            return;
                        }
                        this.finishedScan(null, false);
                        break;
                    }
                    if (this.sanbox2.getAcquiringNameServerInfo()) break;
                    this.finishedScan(null, false);
                }
            }
        }
    }

    protected void finishedScan(Vector vector, boolean bl) {
        this.sanbox2.finishedNameSeverScan(vector, bl);
        if (!bl) {
            this.currentNameServerTimeStamp = null;
        }
    }
}

