/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.switchAttributes;

import com.qlogic.device.fcfabric.LoopbackPortTestResult;
import com.qlogic.device.fcfabric.switchAttributes.SwitchAttribute;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.messages.UtilMsgSml;

public class LoopbackTestAttr
extends SwitchAttribute {
    private Sanbox2Sml sanbox2;
    static final int SML_STOP_LOOPBACK_TEST = 76;
    static final int SML_LOOPBACK_TEST_STATUS = 77;
    static final int SML_ONLINE_LOOPBACK_TEST = 78;
    static final int SML_LOOPBACK_TEST = 54;
    private int loopbackPort;
    public static final int UPDATE_COMPLETE_EVENT = 285;
    private String[] updateStrings = new String[]{"Oper.Switch.TestStatus", "Oper.Switch.TestFrames", "Oper.Switch.TestFailures"};

    public LoopbackTestAttr(Sanbox2Sml sanbox2Sml) {
        super(sanbox2Sml, 285);
        this.sanbox2 = sanbox2Sml;
        this.setUpdateCommands(this.updateStrings);
    }

    public boolean update() {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(77);
        utilMsgSml.addSmlCommand("Oper.Switch.TestStatus");
        utilMsgSml.addSmlCommand("Oper.Switch.TestFrames");
        utilMsgSml.addSmlCommand("Oper.Switch.TestFailures");
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean apply() {
        throw new UnsupportedOperationException();
    }

    public boolean applyLoopbackTest(int n, int n2) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(54);
        if (n2 == 1) {
            utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".TestInternal");
        } else if (n2 == 2) {
            utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".TestExternal");
        } else {
            utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".TestOnline");
        }
        utilMsgSml.setSetCommand();
        this.loopbackPort = n;
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyLoopbackTest(int n, long l, int n2, long l2, boolean bl, int n3) {
        String string = this.convertTo8DigitHexString(l2);
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(78);
        utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".Test.FrameCount." + l);
        utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".Test.FrameSize." + n2);
        utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".Test.Pattern." + string);
        if (bl) {
            utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".Test.StopOnError.True");
        } else {
            utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".Test.StopOnError.False");
        }
        switch (n3) {
            case 1: {
                utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".TestInternal");
                break;
            }
            case 2: {
                utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".TestExternal");
                break;
            }
            case 3: {
                utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".TestOnline");
                break;
            }
            default: {
                return false;
            }
        }
        utilMsgSml.setSetCommand();
        this.loopbackPort = n;
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyLoopbackTest(int n, long l, int n2, boolean bl, int n3) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(78);
        utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".Test.FrameCount." + l);
        utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".Test.FrameSize." + n2);
        utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".Test.Pattern.Default");
        if (bl) {
            utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".Test.StopOnError.True");
        } else {
            utilMsgSml.addSmlCommand("Config.UserPort.0." + n + ".Test.StopOnError.False");
        }
        switch (n3) {
            case 1: {
                utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".TestInternal");
                break;
            }
            case 2: {
                utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".TestExternal");
                break;
            }
            case 3: {
                utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".TestOnline");
                break;
            }
            default: {
                return false;
            }
        }
        utilMsgSml.setSetCommand();
        this.loopbackPort = n;
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    public boolean applyStopLoopbackTest(int n) {
        UtilMsgSml utilMsgSml = new UtilMsgSml(this.sanbox2, this);
        utilMsgSml.setGroupKey(76);
        utilMsgSml.addSmlCommand("Cmd.UserPort.0." + n + ".TestCancel");
        utilMsgSml.setSetCommand();
        this.loopbackPort = n;
        return this.sanbox2.getUtilAgent().sendSml(utilMsgSml);
    }

    private void saveLoopbackTestStatus(UtilMsgSml utilMsgSml) {
        LoopbackPortTestResult loopbackPortTestResult = new LoopbackPortTestResult();
        if (utilMsgSml.AllResponsesOk()) {
            String string = utilMsgSml.getResponse(0).getResponse();
            String string2 = utilMsgSml.getResponse(1).getResponse();
            long l = Long.parseLong(string2);
            string2 = utilMsgSml.getResponse(2).getResponse();
            long l2 = Long.parseLong(string2);
            loopbackPortTestResult.setTestStatus(string);
            loopbackPortTestResult.setFrameCount(l);
            loopbackPortTestResult.setFailureCount(l2);
            loopbackPortTestResult.setTestDone(false);
            this.sanbox2.eventHandler.fireChassisEvent(285, (Object)loopbackPortTestResult, true);
        } else {
            this.sanbox2.eventHandler.fireChassisEvent(285, null, utilMsgSml.getErrorType());
        }
    }

    protected void saveResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
    }

    public void handleResponse(Object object) {
        UtilMsgSml utilMsgSml = (UtilMsgSml)object;
        switch (utilMsgSml.getGroupKey()) {
            case 54: {
                if (utilMsgSml.AllResponsesOk()) {
                    LoopbackPortTestResult loopbackPortTestResult = new LoopbackPortTestResult(this.loopbackPort, true);
                    this.sanbox2.eventHandler.fireChassisEvent(280, (Object)loopbackPortTestResult, true);
                    break;
                }
                int n = utilMsgSml.getNumberOfResponses();
                int n2 = 0;
                if (n > 0) {
                    n2 = utilMsgSml.getResponse(0).getErrorCode();
                }
                LoopbackPortTestResult loopbackPortTestResult = new LoopbackPortTestResult(this.loopbackPort, n2);
                this.sanbox2.eventHandler.fireChassisEvent(280, (Object)loopbackPortTestResult, utilMsgSml.getErrorType());
                break;
            }
            case 78: {
                if (utilMsgSml.AllResponsesOk()) {
                    LoopbackPortTestResult loopbackPortTestResult = new LoopbackPortTestResult(this.loopbackPort, true);
                    this.sanbox2.eventHandler.fireChassisEvent(280, (Object)loopbackPortTestResult, true);
                    break;
                }
                int n = utilMsgSml.getNumberOfResponses();
                int n3 = 0;
                if (n > 4) {
                    n3 = utilMsgSml.getResponse(4).getErrorCode();
                }
                LoopbackPortTestResult loopbackPortTestResult = new LoopbackPortTestResult(this.loopbackPort, n3);
                this.sanbox2.eventHandler.fireChassisEvent(280, (Object)loopbackPortTestResult, utilMsgSml.getErrorType());
                break;
            }
            case 76: {
                if (utilMsgSml.AllResponsesOk()) {
                    this.sanbox2.eventHandler.fireChassisEvent(283, null, true);
                    break;
                }
                this.sanbox2.eventHandler.fireChassisEvent(283, null, utilMsgSml.getErrorType());
                break;
            }
            case 77: {
                this.saveLoopbackTestStatus(utilMsgSml);
            }
        }
    }

    private String convertTo8DigitHexString(long l) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l));
        int n2 = n = stringBuffer.length();
        while (n2 < 8) {
            stringBuffer.insert(0, "0");
            ++n2;
        }
        if (n > 8) {
            stringBuffer = new StringBuffer(stringBuffer.substring(n - 8));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "LoopbackTestAttr: switch=" + this.theSwitch.getChassisName();
    }
}

