/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.archiver;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.Sanbox8000Blade;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.archiver.Sanbox2Archiver;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.util.JElement;
import java.io.IOException;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Sanbox8000Archiver
extends Sanbox2Archiver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorType restoreSwitchSpecificParameters(SanboxChassis sanboxChassis, Element element) throws IOException {
        Object object;
        Sanbox8000 sanbox8000 = (Sanbox8000)((Object)sanboxChassis);
        Vector<Sanbox8000Blade> vector = new Vector<Sanbox8000Blade>();
        int[] nArray = new int[sanbox8000.getNumberOfBlades()];
        Element element2 = DeviceUtilities.getSubElement(element, "Parameters");
        if (element2 == null) {
            throw new IOException("failed parsing <Parameters> tag");
        }
        Element element3 = DeviceUtilities.getSubElement(element2, "Blades");
        if (element3 == null) {
            throw new IOException("failed parsing <Blades> tag");
        }
        Node node = element3.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals("Blade")) {
                object = (Element)node;
                int n = Integer.parseInt(object.getAttribute("Number"));
                Sanbox8000Blade sanbox8000Blade = sanbox8000.getBlade(n);
                vector.add(sanbox8000Blade);
                String string = DeviceUtilities.getData((Element)object, "ConfigAdminState");
                nArray[n] = Integer.parseInt(string);
            }
            node = node.getNextSibling();
        }
        object = this;
        synchronized (object) {
            sanbox8000.applyBladeConfigAdminStates(vector, nArray);
            ErrorType errorType = this.waitForEvent(342);
            if (errorType != null) {
                return null;
            }
        }
        return null;
    }

    public JElement getChassisTag(SanboxChassis sanboxChassis) {
        JElement jElement = super.getChassisTag(sanboxChassis);
        Sanbox8000 sanbox8000 = (Sanbox8000)((Object)sanboxChassis);
        JElement jElement2 = new JElement("Blades");
        int n = 0;
        while (n < sanbox8000.getNumberOfBlades()) {
            Sanbox8000Blade sanbox8000Blade = sanbox8000.getBlade(n);
            JElement jElement3 = new JElement("Blade");
            jElement3.setAttribute("Number", new Integer(n).toString());
            jElement3.addContent(new JElement("ConfigAdminState", Integer.toString(sanbox8000Blade.getBladeConfigState())));
            jElement3.addContent(new JElement("OperAdminState", Integer.toString(sanbox8000Blade.getBladeOperState())));
            jElement3.addContent(new JElement("BladeState", Integer.toString(sanbox8000Blade.getBladeState())));
            jElement3.addContent(new JElement("BoardTemp", Integer.toString(sanbox8000Blade.getBoardTemp())));
            jElement3.addContent(new JElement("TempStatus", Integer.toString(sanbox8000Blade.getTempStatus())));
            jElement3.addContent(new JElement("CreditPool", Integer.toString(sanbox8000Blade.getUnusedCreditPool())));
            jElement2.addContent(jElement3);
            ++n;
        }
        jElement.addContent(jElement2);
        return jElement;
    }

    protected ErrorType applyTempMonitoringInfo(Sanbox2 sanbox2, Element element) {
        return null;
    }

    protected void getTempMonitoringInfo(Sanbox2 sanbox2, Element element) {
    }
}

