/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.archiver;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.SnmpInfo;
import com.qlogic.device.fcfabric.SnmpTrapConfig;
import com.qlogic.device.fcfabric.UserAccount;
import com.qlogic.device.fcfabric.archiver.SanboxChassisArchiver;
import com.qlogic.device.fcfabric.archiver.events.ArchiverEvent;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.event.GuiError;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.device.fcfabric.zoning.ZoningFile;
import com.qlogic.util.JElement;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Sanbox2Archiver
extends SanboxChassisArchiver {
    public void setIgnoreNotifcations(SanboxChassis sanboxChassis, boolean bl) {
        Sanbox2 sanbox2 = (Sanbox2)sanboxChassis;
        sanbox2.setIgnoreNotifications(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ErrorType applySwitchConfig(SanboxChassis sanboxChassis, int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n6, int n7, int n8, Element element, Element element2) throws IOException {
        Sanbox2Archiver sanbox2Archiver = this;
        synchronized (sanbox2Archiver) {
            Object object;
            String string = DeviceUtilities.getData(element2, "BroadcastMode");
            boolean bl = string.equals("True");
            string = element.getAttribute("number");
            int n9 = Integer.parseInt(string);
            Node node = element.getFirstChild();
            while (node != null) {
                int n10;
                if (node.getNodeName().equals("Port") && (n10 = Integer.parseInt(DeviceUtilities.getData((Element)(object = (Element)node), "Number"))) < nArray4.length) {
                    string = DeviceUtilities.getData((Element)object, "ConfigPortType");
                    nArray4[n10] = Integer.parseInt(string);
                }
                node = node.getNextSibling();
            }
            object = (Sanbox2)sanboxChassis;
            ErrorType errorType = this.applyTempMonitoringInfo((Sanbox2)object, element2);
            if (errorType != null) {
                System.err.println("temp mon error");
                return errorType;
            }
            ((Sanbox2)object).requestAdmin();
            errorType = this.waitForEvent(238);
            if (errorType != null) {
                System.err.println("req admin error");
                return errorType;
            }
            ((Sanbox2)object).editConfig();
            errorType = this.waitForEvent(237);
            if (errorType != null) {
                System.err.println("edit config error");
                return errorType;
            }
            ((Sanbox2)object).applyBroadcastSupport(bl);
            errorType = this.waitForEvent(308);
            if (errorType != null) {
                System.err.println("broadcast support error");
                return errorType;
            }
            ((Sanbox2)object).applyDomainIdLock(n2);
            errorType = this.waitForEvent(331);
            if (errorType != null) {
                System.err.println("domain id lock error");
                return errorType;
            }
            ((Sanbox2)object).applySwitchConfig(n, n4, n7, n8);
            errorType = this.waitForEvent(231);
            if (errorType != null) {
                System.err.println("switch config error");
                return errorType;
            }
            ((Sanbox2)object).saveConfig();
            errorType = this.waitForEvent(235);
            if (errorType != null) {
                System.err.println("save config error");
                return errorType;
            }
            ((Sanbox2)object).activateConfigAndReleaseAdmin();
            errorType = this.waitForEvent(264);
            if (errorType != null) {
                System.err.println("activate config & rel admin error");
                return errorType;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorType applyPortInfo(SanboxChassis sanboxChassis, Element element, int n) throws IOException {
        Sanbox2Archiver sanbox2Archiver = this;
        synchronized (sanbox2Archiver) {
            Sanbox2 sanbox2 = (Sanbox2)sanboxChassis;
            sanbox2.requestAdmin();
            ErrorType errorType = this.waitForEvent(238);
            if (errorType != null) {
                return errorType;
            }
            sanbox2.editConfig();
            errorType = this.waitForEvent(237);
            if (errorType != null) {
                return errorType;
            }
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeName().equals("Port")) {
                    Element element2 = (Element)node;
                    String string = DeviceUtilities.getData(element2, "Number");
                    int n2 = Integer.parseInt(string);
                    FCPort fCPort = sanboxChassis.getPort(n2);
                    string = DeviceUtilities.getData(element2, "AdminState");
                    int n3 = Integer.parseInt(string);
                    sanbox2.applyPortState(n2, n3);
                    errorType = this.waitForEvent(317);
                    if (errorType != null) {
                        return errorType;
                    }
                    string = DeviceUtilities.getData(element2, "ConfigPortType");
                    int n4 = Integer.parseInt(string);
                    sanbox2.applyPortMode(n2, n4);
                    errorType = this.waitForEvent(273);
                    if (errorType != null) {
                        return errorType;
                    }
                    string = DeviceUtilities.getData(element2, "Speed");
                    int n5 = Integer.parseInt(string);
                    sanbox2.applyPortSpeed(n2, n5);
                    errorType = this.waitForEvent(227);
                    if (errorType != null) {
                        return errorType;
                    }
                    string = DeviceUtilities.getData(element2, "BbCredits");
                    int n6 = Integer.parseInt(string);
                    sanbox2.applyBBCredits(n2, n6);
                    errorType = this.waitForEvent(258);
                    if (errorType != null) {
                        return errorType;
                    }
                    string = DeviceUtilities.getData(element2, "RscnEnable");
                    boolean bl = string.equals("True");
                    sanbox2.applyRscn(n2, bl);
                    errorType = this.waitForEvent(298);
                    if (errorType != null) {
                        return errorType;
                    }
                    string = DeviceUtilities.getData(element2, "ExtCredits");
                    int n7 = Integer.parseInt(string);
                    sanbox2.applyExtCredit(n2, n7);
                    errorType = this.waitForEvent(287);
                    if (errorType != null) {
                        return errorType;
                    }
                    try {
                        string = DeviceUtilities.getData(element2, "DeviceScanEnable");
                        boolean bl2 = string.equals("True");
                        sanbox2.applyDeviceScan(n2, bl2);
                        errorType = this.waitForEvent(355);
                        if (errorType != null) {
                            return errorType;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                node = node.getNextSibling();
            }
            sanbox2.saveConfig();
            errorType = this.waitForEvent(235);
            if (errorType != null) {
                return errorType;
            }
            sanbox2.activateConfigAndReleaseAdmin();
            errorType = this.waitForEvent(264);
            if (errorType != null) {
                return errorType;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorType applyNetworkParameters(SanboxChassis sanboxChassis, SnmpInfo snmpInfo, IPInfo iPInfo, Element element) throws IOException {
        ErrorType errorType = null;
        Sanbox2 sanbox2 = (Sanbox2)sanboxChassis;
        String string = DeviceUtilities.getData(element, "InBandMangement");
        int n = Integer.parseInt(string);
        Element element2 = DeviceUtilities.getSubElement(element, "Syslog");
        if (element2 == null) {
            return new GuiError(106);
        }
        String string2 = DeviceUtilities.getData(element2, "Enabled");
        boolean bl = string2.equals("True");
        String string3 = DeviceUtilities.getData(element2, "HostAddress");
        InetAddress inetAddress = InetAddress.getByName(string3);
        Sanbox2Archiver sanbox2Archiver = this;
        synchronized (sanbox2Archiver) {
            sanbox2.applySyslogInfo(bl, inetAddress);
            errorType = this.waitForEvent(315);
            if (errorType != null) {
                return errorType;
            }
            sanbox2.requestAdmin();
            errorType = this.waitForEvent(238);
            if (errorType != null) {
                return errorType;
            }
            sanbox2.editConfig();
            errorType = this.waitForEvent(237);
            if (errorType != null) {
                return errorType;
            }
            sanbox2.applyInbandEnable(n);
            errorType = this.waitForEvent(349);
            if (errorType != null) {
                return errorType;
            }
            sanbox2.applyName(snmpInfo.getName());
            errorType = this.waitForEvent(254);
            if (errorType != null) {
                return errorType;
            }
            sanbox2.saveConfig();
            errorType = this.waitForEvent(235);
            if (errorType != null) {
                return errorType;
            }
            sanbox2.activateConfigAndReleaseAdmin();
            errorType = this.waitForEvent(264);
            if (errorType != null) {
                return errorType;
            }
        }
        Element element3 = DeviceUtilities.getSubElement(element, "SnmpTraps");
        if (element3 == null) {
            return new GuiError(106);
        }
        String string4 = element3.getAttribute("Number");
        int n2 = Integer.parseInt(string4);
        int n3 = 0;
        Node node = element3.getFirstChild();
        while (node != null && n3 < n2) {
            if (node.getNodeName().equals("SnmpTrap")) {
                Element element4 = (Element)node;
                SnmpTrapConfig snmpTrapConfig = snmpInfo.getSnmpTrapConfig(n3++);
                string = DeviceUtilities.getData(element4, "IpAddress");
                InetAddress inetAddress2 = InetAddress.getByName(string);
                snmpTrapConfig.setAddress(inetAddress2);
                string = DeviceUtilities.getData(element4, "Port");
                int n4 = Integer.parseInt(string);
                snmpTrapConfig.setPort(n4);
                string = DeviceUtilities.getData(element4, "Severity");
                snmpTrapConfig.setSeverity(string);
                string = DeviceUtilities.getData(element4, "Enabled");
                boolean bl2 = string.equals("True");
                snmpTrapConfig.setEnabled(bl2);
                try {
                    string = DeviceUtilities.getData(element4, "Version");
                    int n5 = Integer.parseInt(string);
                    snmpTrapConfig.setVersion(n5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            node = node.getNextSibling();
        }
        errorType = super.applyNetworkParameters(sanboxChassis, snmpInfo, iPInfo, element);
        if (errorType != null) {
            return errorType;
        }
        sanboxChassis.getComAgent().setIpAddress(iPInfo.getIpAddress());
        return null;
    }

    protected ErrorType applyTempMonitoringInfo(Sanbox2 sanbox2, Element element) throws IOException {
        String string = DeviceUtilities.getData(element, "TempMonEnable");
        int n = Integer.parseInt(string);
        string = DeviceUtilities.getData(element, "WarningTemp");
        int n2 = Integer.parseInt(string);
        string = DeviceUtilities.getData(element, "FailureTemp");
        int n3 = Integer.parseInt(string);
        sanbox2.applyTempMonitoring(n, n2, n3);
        return this.waitForEvent(359);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorType restoreSwitchSpecificParameters(SanboxChassis sanboxChassis, Element element) throws IOException {
        Sanbox2 sanbox2 = (Sanbox2)sanboxChassis;
        if (sanbox2.getFirmwareVersion() != 2) {
            Object object;
            this.fireEvent(new ArchiverEvent((SanboxChassisArchiver)this, 9509, true));
            Element element2 = DeviceUtilities.getSubElement(element, "Parameters");
            if (element2 == null) {
                throw new IOException("failed parsing <Parameters> tag");
            }
            Element element3 = DeviceUtilities.getSubElement(element2, "AlarmThresholds");
            if (element3 == null) {
                GuiError guiError = new GuiError(106);
                this.fireEvent(new ArchiverEvent((SanboxChassisArchiver)this, 9510, guiError));
                return guiError;
            }
            int n = Integer.parseInt(element3.getAttribute("Number"));
            boolean bl = element3.getAttribute("AllEnabled").equals("True");
            sanbox2.setEditingTrapConfig(true);
            sanbox2.setTrapsEnabled(bl);
            Node node = element3.getFirstChild();
            while (node != null) {
                if (node.getNodeName().equals("AlarmThreshold")) {
                    object = (Element)node;
                    int n2 = Integer.parseInt(object.getAttribute("Number"));
                    String string = DeviceUtilities.getData((Element)object, "Enabled");
                    boolean bl2 = string.equals("True");
                    string = DeviceUtilities.getData((Element)object, "Rising");
                    int n3 = Integer.parseInt(string);
                    string = DeviceUtilities.getData((Element)object, "Falling");
                    int n4 = Integer.parseInt(string);
                    string = DeviceUtilities.getData((Element)object, "SampleInterval");
                    int n5 = Integer.parseInt(string);
                    sanbox2.setTrapConfig(n2, n3, n4, n5, bl2);
                }
                node = node.getNextSibling();
            }
            sanbox2.setEditingTrapConfig(false);
            object = this;
            synchronized (object) {
                sanbox2.applyTrapConfig();
                ErrorType errorType = this.waitForEvent(275);
                this.fireEvent(new ArchiverEvent((SanboxChassisArchiver)this, 9510, errorType));
                if (errorType != null) {
                    return errorType;
                }
            }
        }
        return null;
    }

    public JElement getPortConfigTag(SanboxChassis sanboxChassis, FCPort fCPort) {
        JElement jElement = super.getPortConfigTag(sanboxChassis, fCPort);
        S16Port s16Port = (S16Port)fCPort;
        jElement.addContent(new JElement("Speed", Integer.toString(s16Port.getAdminPortSpeed())));
        jElement.addContent(new JElement("BbCredits", Integer.toString(s16Port.getBBCredits())));
        jElement.addContent(new JElement("RscnEnable", s16Port.getRscnEnable() ? "True" : "False"));
        jElement.addContent(new JElement("ExtCredits", Integer.toString(s16Port.getExtCredits())));
        jElement.addContent(new JElement("DeviceScanEnable", s16Port.getDeviceScanEnable() ? "True" : "False"));
        PortStates portStates = fCPort.getPortStates();
        if (portStates == null) {
            throw new IllegalArgumentException();
        }
        jElement.addContent(new JElement("ConfigPortType", Integer.toString(portStates.getConfigPortType())));
        return jElement;
    }

    public JElement getChassisTag(SanboxChassis sanboxChassis) {
        JElement jElement;
        JElement jElement2 = super.getChassisTag(sanboxChassis);
        Sanbox2 sanbox2 = (Sanbox2)sanboxChassis;
        if (sanbox2.getInactiveFlashVersionString() == null) {
            throw new IllegalArgumentException();
        }
        JElement jElement3 = new JElement("InactiveFlashVersion", sanbox2.getInactiveFlashVersionString());
        jElement2.addContent(jElement3);
        JElement jElement4 = new JElement("InBandMangement", Integer.toString(sanbox2.getInbandEnable()));
        jElement2.addContent(jElement4);
        if (sanbox2.getSyslogAddr() == null) {
            throw new IllegalArgumentException();
        }
        JElement jElement5 = new JElement("Syslog");
        jElement5.addContent(new JElement("Enabled", sanbox2.isSyslogEnabled() ? "True" : "False"));
        jElement5.addContent(new JElement("HostAddress", sanbox2.getSyslogAddr().getHostAddress()));
        jElement2.addContent(jElement5);
        this.getTempMonitoringInfo(sanbox2, jElement2);
        SnmpInfo snmpInfo = sanboxChassis.getSnmpInfo();
        if (snmpInfo == null) {
            throw new IllegalArgumentException();
        }
        JElement jElement6 = new JElement("SnmpTraps");
        jElement6.setAttribute("Number", "5");
        int n = 0;
        while (n < 5) {
            jElement = new JElement("SnmpTrap");
            SnmpTrapConfig snmpTrapConfig = snmpInfo.getSnmpTrapConfig(n);
            jElement.addContent(new JElement("IpAddress", snmpTrapConfig.getAddress().getHostAddress()));
            jElement.addContent(new JElement("Port", Integer.toString(snmpTrapConfig.getPort())));
            jElement.addContent(new JElement("Severity", snmpTrapConfig.getSeverity()));
            jElement.addContent(new JElement("Enabled", snmpTrapConfig.isEnabled() ? "True" : "False"));
            jElement.addContent(new JElement("Version", Integer.toString(snmpTrapConfig.getVersion())));
            jElement6.addContent(jElement);
            ++n;
        }
        jElement2.addContent(jElement6);
        jElement = new JElement("AlarmThresholds");
        jElement.setAttribute("Number", Integer.toString(sanbox2.getNumberOfTraps()));
        jElement.setAttribute("AllEnabled", sanbox2.getTrapsEnabled() ? "True" : "False");
        int n2 = 0;
        while (n2 < sanbox2.getNumberOfTraps()) {
            JElement jElement7 = new JElement("AlarmThreshold");
            jElement7.setAttribute("Number", Integer.toString(n2));
            jElement7.addContent(new JElement("Enabled", sanbox2.getTrapEnable(n2) ? "True" : "False"));
            jElement7.addContent(new JElement("Rising", Integer.toString(sanbox2.getTrapRisingThreadhold(n2))));
            jElement7.addContent(new JElement("Falling", Integer.toString(sanbox2.getTrapFallingThreadhold(n2))));
            jElement7.addContent(new JElement("SampleInterval", Integer.toString(sanbox2.getTrapSampleInterval(n2))));
            jElement.addContent(jElement7);
            ++n2;
        }
        jElement2.addContent(jElement);
        jElement2.addContent(new JElement("InactiveVersion", sanbox2.getInactiveFlashVersionString()));
        jElement2.addContent(new JElement("OperationalState", sanbox2.getOperationalStateString()));
        jElement2.addContent(new JElement("BroadcastMode", sanbox2.isBroadcastSupportEnabled() ? "True" : "False"));
        jElement2.addContent(this.getAlarmLogTag(sanbox2));
        jElement2.addContent(this.getUserAccountInfoTag(sanbox2));
        return jElement2;
    }

    public JElement getUserAccountInfoTag(Sanbox2 sanbox2) {
        JElement jElement = new JElement("UserAccountInfo");
        Vector vector = sanbox2.getUserAccountList();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            UserAccount userAccount = (UserAccount)vector.elementAt(n2);
            JElement jElement2 = new JElement("UserAccount");
            jElement2.addContent(new JElement("Login", userAccount.getLogin()));
            jElement2.addContent(new JElement("AdminAuthority", Boolean.toString(userAccount.getAdminAuthority())));
            jElement2.addContent(new JElement("Expiration", Integer.toString(userAccount.getExpiration())));
            jElement.addContent(jElement2);
            ++n2;
        }
        return jElement;
    }

    protected void getTempMonitoringInfo(Sanbox2 sanbox2, JElement jElement) {
        JElement jElement2 = new JElement("TempMonEnable", Integer.toString(sanbox2.getTempMonEnable()));
        jElement.addContent(jElement2);
        JElement jElement3 = new JElement("WarningTemp", Integer.toString(sanbox2.getWarningTemp()));
        jElement.addContent(jElement3);
        JElement jElement4 = new JElement("FailureTemp", Integer.toString(sanbox2.getFailureTemp()));
        jElement.addContent(jElement4);
    }

    private JElement getAlarmLogTag(Sanbox2 sanbox2) {
        JElement jElement = new JElement("AlarmLog");
        Vector vector = sanbox2.getAlarmLog();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            jElement.addContent(new JElement("Entry", string));
            ++n;
        }
        return jElement;
    }

    public JElement fillZoningTag(SanboxChassis sanboxChassis) {
        JElement jElement = super.fillZoningTag(sanboxChassis);
        JElement jElement2 = new JElement("ActiveZoning");
        Sanbox2 sanbox2 = (Sanbox2)sanboxChassis;
        Zones zones = sanbox2.getActiveEportZoning();
        jElement2.addContent(ZoningFile.getZoningConfigTag(zones));
        jElement.addContent(jElement2);
        return jElement;
    }
}

