/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.util.StringUtilities;
import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class WorldWideName {
    private static final WorldWideName unknownQlogicSwitchWWN = new WorldWideName(1152922332948332544L);
    private static final String UNKNOWN = "Unknown";
    private static final ResourceBundle defCompanyNames = new DefVendorBundle();
    private static ResourceBundle companyNames;
    private final long WWName;
    private final String delimitedWwnStr;

    public WorldWideName(long l) {
        this.WWName = l;
        this.delimitedWwnStr = WorldWideName.longToString(this.WWName);
    }

    public WorldWideName(String string) {
        this.WWName = string.indexOf(58) >= 0 ? WorldWideName.delimitedWwnToLong(string) : (string.equals(UNKNOWN) ? unknownQlogicSwitchWWN.getWWName() : StringUtilities.parseLongHexString(string));
        this.delimitedWwnStr = WorldWideName.longToString(this.WWName);
    }

    public static WorldWideName getUnknownQlogicWwn() {
        return unknownQlogicSwitchWWN;
    }

    public static long delimitedWwnToLong(String string) {
        if (string.length() != 23) {
            throw new IllegalArgumentException(string);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length() - 3;
        while (n > 0) {
            if (stringBuffer.charAt(n) != ':') {
                throw new IllegalArgumentException(string);
            }
            stringBuffer.deleteCharAt(n);
            n -= 3;
        }
        return StringUtilities.parseLongHexString(stringBuffer.toString());
    }

    private static String longToString(long l) {
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l));
        while (stringBuffer.length() < 16) {
            stringBuffer.insert(0, "0");
        }
        int n = 2;
        while (n < stringBuffer.length()) {
            stringBuffer.insert(n, ":");
            n += 3;
        }
        return stringBuffer.toString();
    }

    public final String delimit() {
        if (this == unknownQlogicSwitchWWN) {
            return UNKNOWN;
        }
        return this.delimitedWwnStr;
    }

    public static synchronized void setVendors(ResourceBundle resourceBundle) {
        companyNames = resourceBundle;
    }

    public final long getWWName() {
        return this.WWName;
    }

    public boolean hasCompanyId() {
        int n = (int)(this.WWName >> 60);
        switch (n) {
            case 1: 
            case 2: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean isFcWwn() {
        int n = (int)(this.WWName >> 60);
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public final synchronized int getCompanyId() {
        int n = (int)(this.WWName >> 60);
        switch (n) {
            case 1: 
            case 2: {
                return (int)(this.WWName >> 24 & 0xFFFFFFL);
            }
            case 3: 
            case 4: {
                return -1;
            }
            case 5: {
                return (int)(this.WWName >> 36 & 0xFFFFFFL);
            }
        }
        return (int)(this.WWName >> 36 & 0xFFFFFFL);
    }

    public synchronized String getCompanyName() {
        if (!this.isFcWwn()) {
            return "Invalid";
        }
        if (!this.hasCompanyId()) {
            return "";
        }
        return WorldWideName.getCompanyName(this.getCompanyId());
    }

    public static synchronized String getCompanyName(int n) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toHexString(n));
        int n2 = stringBuffer.length();
        if (n2 < 6) {
            stringBuffer.insert(0, "000000".substring(n2));
        }
        try {
            String string = companyNames != null ? companyNames.getString(stringBuffer.toString().toUpperCase()) : defCompanyNames.getString(stringBuffer.toString().toUpperCase());
            return string;
        }
        catch (MissingResourceException missingResourceException) {
            return stringBuffer.toString();
        }
    }

    public boolean equals(Object object) {
        WorldWideName worldWideName;
        return object instanceof WorldWideName && this.WWName == (worldWideName = (WorldWideName)object).getWWName();
    }

    public String toString() {
        if (this == unknownQlogicSwitchWWN) {
            return UNKNOWN;
        }
        return Long.toHexString(this.WWName);
    }

    private static class DefVendorBundle
    extends ListResourceBundle {
        private Object[][] contents = new Object[][]{{"00C0DD", "QLogic Corporation"}, {"00E08B", "QLOGIC CORP."}, {"006048", "EMC CORPORATION"}, {"00109B", "VIXEL CORPORATION"}, {"080088", "MCDATA CORPORATION"}, {"006069", "BROCADE COMMUNICATIONS CORPORATION"}, {"00B0D0", "Dell Computer Corp."}, {"00C04F", "DELL COMPUTER CORPORATION"}, {"080020", "SUN MICROSYSTEMS"}, {"00007D", "SUN MICROSYSTEMS, Inc."}, {"0020F2", "SUN MICROSYSTEMS, INC."}, {"0004CF", "Seagate Technology"}, {"002037", "SEAGATE TECHNOLOGY"}, {"0000C9", "EMULEX CORPORATION"}, {"000173", "JNI Corporation"}, {"000629", "IBM CORPORATION"}, {"002035", "IBM CORPORATION"}, {"08005A", "IBM CORPORATION"}, {"10005A", "IBM CORPORATION"}, {"000255", "IBM Corporation"}, {"005076", "IBM"}, {"0004AC", "IBM CORP."}, {"006094", "IBM CORP."}, {"00E069", "JAYCOR NETWORKS, INC."}, {"0060E8", "HITACHI COMPUTER PRODUCTS"}};

        private DefVendorBundle() {
        }

        public Object[][] getContents() {
            return this.contents;
        }
    }
}

