/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.EPortEntryList;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.FCStatistics;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.IPHost;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.NameServerEntry;
import com.qlogic.device.fcfabric.Pollable;
import com.qlogic.device.fcfabric.SnmpInfo;
import com.qlogic.device.fcfabric.Updater;
import com.qlogic.device.fcfabric.User;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.archiver.SanboxChassisArchiver;
import com.qlogic.device.fcfabric.event.ChassisEventHandler;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMsgVersionReq;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import com.qlogic.util.StringUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public abstract class SanboxChassis
implements Chassis,
IPHost,
Pollable {
    public static final int DEFAULT_FC_ADDR = 0xFFFFFD;
    public static final int UNKNOWN = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    public static final int ENABLED = 1;
    public static final int DISABLED = 2;
    public static final int ON = 1;
    public static final int OFF = 2;
    protected int overallStatus = 3;
    protected List reasonForStatus = new ArrayList();
    public static final int ONLINE = 1;
    public static final int OFFLINE = 2;
    public static final int TEST = 3;
    public static final int DOWNED = 4;
    public static final int REACHABLE = 1;
    public static final int UNREACHABLE = 2;
    public static final int TIMED_OUT = 3;
    public static final int NOT_LOGGED_IN = 4;
    public static final int TOO_MANY_SESSIONS = 5;
    public static final int NO_ENTRY_SWITCH_SESSION = 6;
    public static final int LOGIN_FAILURE = 7;
    public static final int NORMAL_MODE = 1;
    public static final int HUB_MODE = 2;
    public static final int IOT_STAGE = 0;
    public static final int CROSS_CONNECT_STAGE = 1;
    public static final int HUB_STAGE = 2;
    public static final int ZONE_BY_PORT = 0;
    public static final int ZONE_BY_WWN = 1;
    public static final int ZONE_BY_ALPA = 2;
    public static final int INTERNAL_LOOPBACK_TEST = 1;
    public static final int EXTERNAL_LOOPBACK_TEST = 2;
    public static final int ONLINE_LOOPBACK_TEST = 3;
    public static final int LOOPBACK_TEST_START = 3;
    public static final int LOOPBACK_TEST_STOP = 4;
    public static final int LOOPBACK_TEST_RESET = 5;
    public static final int TOTAL_BYTES_PERF_MON = 1;
    public static final int TX_BYTES_PERF_MON = 2;
    public static final int RX_BYTES_PERF_MON = 3;
    public static final int TOTAL_FRAMES_PERF_MON = 4;
    public static final int TX_FRAMES_PERF_MON = 5;
    public static final int RX_FRAMES_PERF_MON = 6;
    public static final int TOTAL_ERRORS_PERF_MON = 7;
    public static final int DOMAIN_ID_LOCK_UNKNOWN = -1;
    public static final int DOMAIN_ID_UNLOCKED = 0;
    public static final int DOMAIN_ID_LOCKED = 1;
    public static final int SECURITY_UNKNOWN = 0;
    public static final int SECURITY_OFF = 1;
    public static final int SECURITY_ON = 2;
    public static final int RESET_DELAY = 3;
    protected int domainIdLock = -1;
    protected WorldWideName WWName = null;
    protected String chassisName = null;
    protected int fcAddress = 0;
    private boolean lockAddress = false;
    protected int fabricId = 0;
    protected int chassisType = 0;
    protected int chassisMode = 1;
    protected int adminMode = 1;
    protected int stageType = 0;
    protected byte[] macAddress = new byte[6];
    protected Fabric fabric = null;
    protected boolean registeredForNotifications = false;
    protected int temperature = 0;
    protected int temperatureStatus = 3;
    protected IPInfo ipInfo = null;
    protected int fanCount = 0;
    protected int powerSupplyCount = 0;
    protected int[] fanStatus = new int[0];
    protected int[] powerSupplyStatus = new int[0];
    protected boolean inOrderDelivery = false;
    protected int beaconStatus = 0;
    private int status = 1;
    protected String flashVersionString = "unknown";
    protected Date flashTimestamp;
    protected String pendingVersionString = "unknown";
    protected Date pendingTimestamp;
    protected String promSwVersionString = "unknown";
    protected int sysConfigRegister = -1;
    protected int moduleAddr;
    protected int raTimeout = 0;
    protected int rtTimeout = 0;
    protected int edTimeout = 0;
    protected int mfsTimeout = 0;
    protected SnmpInfo snmpInfo = null;
    protected FCStatistics stats = null;
    protected int portCount = 0;
    protected int configuredDomainId;
    protected int securityEnabled = 0;
    protected boolean acquiringNameServerInfo;
    public ChassisEventHandler eventHandler;
    protected Vector chassisParamMsgList = new Vector();
    protected Vector portParamMsgList = new Vector();
    protected Vector timeoutParamMsgList = new Vector();
    protected HashMap nameServerMap = new HashMap();
    protected String sysDesc;
    private static final String[] chassisTypeStr = new String[]{"SANbox 16 port", "Unknown", "SANbox 8 port", "Director fcpa4", "Director blade", "Director FCM", "Director FC9000", "DP3-SCQ", "SANbox2 8-port", "Unknown", "Director fsw2_16", "Director fio_8", "Director fio_16mp", "Unknown", "Unknown", "Unknown", "SANbox2 16 port", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Connectrix-SCQ", "SANbox2-8C", "Spider2-16", "Unknown", "IBM SwitchBlade", "unknown", "unknown", "unknown", "unknown", "SwitchBlade"};
    private static final String[] chassisModeStr = new String[]{DeviceUtilities.getResource("SanboxChassis.unknown"), DeviceUtilities.getResource("SanboxChassis.online"), DeviceUtilities.getResource("SanboxChassis.offline"), DeviceUtilities.getResource("SanboxChassis.test")};
    private static final String[] adminModeStr = new String[]{DeviceUtilities.getResource("SanboxChassis.unknown"), DeviceUtilities.getResource("SanboxChassis.online"), DeviceUtilities.getResource("SanboxChassis.offline"), DeviceUtilities.getResource("SanboxChassis.test")};
    private static final String[] stageTypeStr = new String[]{DeviceUtilities.getResource("SanboxChassis.unknown"), DeviceUtilities.getResource("SanboxChassis.slPrivateLoop"), DeviceUtilities.getResource("SanboxChassis.iot"), DeviceUtilities.getResource("SanboxChassis.cc")};
    protected EPortEntryList lsdb = new EPortEntryList();
    private ZoningConfig zoningConfig = new ZoningConfig();
    public ComAgent comAgent = null;

    public SanboxChassis() {
        this.chassisName = new String("unknown");
        this.reasonForStatus.add("Status.unknown");
        this.eventHandler = new ChassisEventHandler(this);
    }

    public SanboxChassis(ComAgent comAgent) {
        this.comAgent = comAgent;
        this.chassisName = new String("unknown");
        this.reasonForStatus.add("Status.unknown");
        this.eventHandler = new ChassisEventHandler(this);
    }

    protected SanboxChassis(int n, ComAgent comAgent) {
        this.comAgent = comAgent;
        this.setFcAddress(n);
        this.chassisName = new String("unknown");
        this.eventHandler = new ChassisEventHandler(this);
    }

    public abstract SanboxChassisArchiver getArchiver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EPortEntryList getLsdb() {
        EPortEntryList ePortEntryList = this.lsdb;
        synchronized (ePortEntryList) {
            return (EPortEntryList)this.lsdb.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLsdb(EPortEntryList ePortEntryList) {
        EPortEntryList ePortEntryList2 = this.lsdb;
        synchronized (ePortEntryList2) {
            this.lsdb = ePortEntryList;
        }
    }

    public abstract boolean supportsBrocadeMergeMode();

    public void checkForRelogin(UtilMsgVersionReq utilMsgVersionReq, UtilDestination utilDestination, UtilEventListener utilEventListener) {
        if (utilMsgVersionReq.getStatus() == 104 && utilMsgVersionReq.getErrorCode() == 14) {
            String string = null;
            String string2 = null;
            Object var6_6 = null;
            Fabric fabric = FabricList.getFabric(this);
            if (fabric != null) {
                string = fabric.getUserName();
                string2 = fabric.getPassword();
            }
            if (string != null) {
                ((UtilAgent)this.comAgent).sendLoginRequest(utilDestination, utilEventListener, string, string2);
            }
        }
    }

    public abstract boolean verifyFwChecksum(File var1);

    public ChassisEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void addChassisEventListener(ChassisEventListener chassisEventListener) {
        this.getEventHandler().addChassisEventListener(chassisEventListener);
    }

    public void removeChassisEventListener(ChassisEventListener chassisEventListener) {
        this.getEventHandler().removeChassisEventListener(chassisEventListener);
    }

    public boolean isReachable() {
        return this.status == 1;
    }

    public int getTemperatureStatus() {
        return this.temperatureStatus;
    }

    public void setTemperatureStatus(int n) {
        this.temperatureStatus = n;
    }

    public int getFanCount() {
        return this.fanCount;
    }

    public int getPowerSupplyCount() {
        return this.powerSupplyCount;
    }

    public int getFanStatus(int n) {
        if (n < 0 || n >= this.fanCount) {
            return 5;
        }
        return this.fanStatus[n];
    }

    public int getPowerSupplyStatus(int n) {
        if (n < 0 || n >= this.powerSupplyCount) {
            return 5;
        }
        return this.powerSupplyStatus[n];
    }

    public int getSwitchBeaconStatus() {
        return this.beaconStatus;
    }

    public void setSwitchBeaconStatus(int n) {
        this.beaconStatus = n;
    }

    public void setFanCount(int n) {
        if (this.fanStatus.length < n) {
            this.fanStatus = new int[n];
        }
        this.fanCount = n;
    }

    public void setPowerSupplyCount(int n) {
        if (this.powerSupplyStatus.length < n) {
            this.powerSupplyStatus = new int[n];
        }
        this.powerSupplyCount = n;
    }

    public int getOverallStatus() {
        return this.overallStatus;
    }

    public List getReasonForStatus() {
        return this.reasonForStatus;
    }

    public boolean isInOrderDeliverySet() {
        return this.inOrderDelivery;
    }

    protected void setInOrderDelivery(boolean bl) {
        this.inOrderDelivery = bl;
    }

    public int getChassisStatus() {
        return this.status;
    }

    public void setChassisStatus(int n) {
        boolean bl = this.status != n;
        this.status = n;
        if (bl) {
            this.eventHandler.fireChassisEvent(203, (Object)new Integer(this.status), true);
        }
    }

    public abstract FCPort getPort(int var1);

    public FCPort getPortByAddr(int n) {
        int n2 = this.getPortCount() - 1;
        while (n2 >= 0) {
            FCPort fCPort = this.getPort(n2);
            if (fCPort != null && fCPort.getFcAddress() == n) {
                return fCPort;
            }
            --n2;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Chassis)) {
            return false;
        }
        Chassis chassis = (Chassis)object;
        return this.WWName.equals(chassis.getWWName());
    }

    public String toString() {
        if (this.chassisName == null || this.chassisName.equals("unknown")) {
            if (this.WWName != null) {
                return this.WWName.delimit();
            }
            return this.delimitFCAddress();
        }
        return this.chassisName;
    }

    public WorldWideName getWWName() {
        return this.WWName;
    }

    public String getChassisName() {
        return this.chassisName;
    }

    public void setChassisName(String string) {
        this.chassisName = string;
    }

    public int getDomainIdLock() {
        return this.domainIdLock;
    }

    public void setDomainIdLock(int n) {
        this.domainIdLock = n;
    }

    public String getDomainIdLockString() {
        if (this.domainIdLock == 1) {
            return DeviceUtilities.getResource("SanboxChassis.locked");
        }
        if (this.domainIdLock == 0) {
            return DeviceUtilities.getResource("SanboxChassis.unlocked");
        }
        return DeviceUtilities.getResource("SanboxChassis.unknown");
    }

    public IPInfo getIpInfo() {
        return this.ipInfo;
    }

    public void setIpInfo(IPInfo iPInfo) {
        this.ipInfo = iPInfo;
    }

    public int getEPortSecurity() {
        boolean bl = true;
        int n = -1;
        int n2 = 0;
        while (n2 < this.portCount) {
            FCPort fCPort = this.getPort(n2);
            if (n == -1) {
                n = fCPort.getEPortSecurity();
            } else if (n != fCPort.getEPortSecurity()) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int n) {
        this.temperature = n;
    }

    public int getDomainId() {
        return this.getFcAddress() >> 16;
    }

    public String getDomainIdString() {
        return Integer.toString(this.getDomainId());
    }

    public abstract int getConfiguredDomainId();

    public abstract String getConfiguredDomainIdString();

    public String delimitFCAddress() {
        int n = 0;
        String string = Integer.toHexString(this.fcAddress);
        n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n < 6) {
            int n2 = 6;
            while (n2 > n) {
                stringBuffer.insert(0, "0");
                --n2;
            }
        }
        return stringBuffer.toString();
    }

    public int getChassisType() {
        return this.chassisType;
    }

    protected void setChassisType(int n) {
        this.chassisType = n;
    }

    public int getChassisMode() {
        return this.chassisMode;
    }

    protected void setChassisMode(int n) {
        this.chassisMode = n;
    }

    public int getAdminMode() {
        return this.adminMode;
    }

    public void setAdminMode(int n) {
        this.adminMode = n;
    }

    public int getSecurityEnabled() {
        return this.securityEnabled;
    }

    public void setSecurityEnabled(int n) {
        this.securityEnabled = n;
    }

    public int getRaTimeout() {
        return this.raTimeout;
    }

    public void setRaTimeout(int n) {
        this.raTimeout = n;
    }

    public int getRtTimeout() {
        return this.rtTimeout;
    }

    public void setRtTimeout(int n) {
        this.rtTimeout = n;
    }

    public int getEdTimeout() {
        return this.edTimeout;
    }

    public void setEdTimeout(int n) {
        this.edTimeout = n;
    }

    public int getMfsTimeout() {
        return this.mfsTimeout;
    }

    protected void setMfsTimeout(int n) {
        this.mfsTimeout = n;
    }

    public String delimitMacAddress() {
        int n = 0;
        String string = StringUtilities.byteArrayToString(this.macAddress, 0, this.macAddress.length, null);
        n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 2;
        while (n2 < n) {
            stringBuffer.insert(n2, ":");
            ++n;
            n2 += 3;
        }
        return stringBuffer.toString();
    }

    public byte[] getMacAddress() {
        return this.macAddress;
    }

    protected void setMacAddress(byte[] byArray) {
        this.macAddress = byArray;
    }

    public int getStageType() {
        return this.stageType;
    }

    protected void setStageType(int n) {
        this.stageType = n;
    }

    public String getSysDesc() {
        return this.sysDesc;
    }

    public void setSysDesc(String string) {
        this.sysDesc = string;
    }

    public String getChassisTypeString() {
        return chassisTypeStr[this.chassisType];
    }

    public String getChassisModeString() {
        return chassisModeStr[this.chassisMode];
    }

    public String getAdminModeString() {
        return adminModeStr[this.adminMode];
    }

    public String getStageTypeString() {
        if (this.stageType < stageTypeStr.length) {
            return stageTypeStr[this.stageType];
        }
        return Integer.toString(this.stageType);
    }

    public String getFlashVersionString() {
        return this.flashVersionString;
    }

    public void setFlashVersionString(String string) {
        this.flashVersionString = string;
    }

    public Date getFlashTimestamp() {
        return this.flashTimestamp;
    }

    public void setFlashTimestamp(Date date) {
        this.flashTimestamp = date;
    }

    public String getSwPromVersionString() {
        return this.promSwVersionString;
    }

    public void setSwPromVersionString(String string) {
        this.promSwVersionString = string;
    }

    private String convertVersion(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        return new String("V " + n4 + "." + n3 + "." + n2);
    }

    public FCStatistics getStats() {
        return this.stats;
    }

    protected void setStats(FCStatistics fCStatistics) {
        this.stats = fCStatistics;
    }

    public SnmpInfo getSnmpInfo() {
        return this.snmpInfo;
    }

    public void setSnmpInfo(SnmpInfo snmpInfo) {
        this.snmpInfo = snmpInfo;
    }

    public abstract boolean resetToFactoryDefaults();

    public abstract boolean resetDefaultZoning();

    public abstract int getPortCount();

    public ComAgent getComAgent() {
        return this.comAgent;
    }

    protected void setComAgent(ComAgent comAgent) {
        this.comAgent = comAgent;
    }

    public boolean getDiscoveredByIpAddress() {
        if (this.getComAgent() != null && this.getComAgent().getConnectionWwn() != null) {
            return this.getComAgent().getConnectionWwn().equals(this.getWWName());
        }
        return false;
    }

    public FCPort getFirstPort() {
        return this.getPort(0);
    }

    public FCPort getNextPort(FCPort fCPort) {
        int n = fCPort.getPortNumber() + 1;
        if (n >= this.getPortCount()) {
            return null;
        }
        return this.getPort(n);
    }

    public FCNode getFirstNode() {
        FCPort fCPort = this.getFirstPort();
        while (fCPort != null) {
            if (fCPort.getNodeCount() > 0) {
                return fCPort.getNode(0);
            }
            fCPort = this.getNextPort(fCPort);
        }
        return null;
    }

    public FCNode getNextNode(FCNode fCNode) {
        boolean bl = false;
        FCPort fCPort = this.getFirstPort();
        while (fCPort != null) {
            int n = 0;
            while (n < fCPort.getNodeCount()) {
                FCNode fCNode2 = fCPort.getNode(n);
                if (bl) {
                    return fCNode2;
                }
                if (fCNode2 == fCNode) {
                    if (n + 1 < fCPort.getNodeCount()) {
                        return fCPort.getNode(n + 1);
                    }
                    bl = true;
                }
                ++n;
            }
            fCPort = this.getNextPort(fCPort);
        }
        return null;
    }

    public boolean getIsRegisteredForNotifications() {
        return this.registeredForNotifications;
    }

    public void setNotInFabric() {
        this.setFcAddress(0);
        this.setChassisStatus(2);
    }

    public void setFcAddressAndLock(int n) {
        this.setFcAddress(n);
        this.lockAddress = true;
    }

    public void unlockAddress() {
        this.lockAddress = false;
    }

    public void setFcAddress(int n) {
        if (!this.lockAddress) {
            this.fcAddress = n;
            if (this.getDiscoveredByIpAddress()) {
                this.comAgent.setEntryKey(new Integer(n));
            }
        }
    }

    public int getFcAddress() {
        return this.fcAddress;
    }

    public boolean pingChassis() {
        return this.updateVersion();
    }

    public void finishedNameSeverScan(Vector vector, boolean bl) {
        this.finishedNameSeverScan(vector, bl, true);
    }

    public boolean isWwnInNameServer(long l) {
        return this.nameServerMap.get(new Long(l)) != null;
    }

    public boolean isFcAddressInNameServer(int n) {
        return this.nameServerMap.get(new Integer(n)) != null;
    }

    public void finishedNameSeverScan(Vector vector, boolean bl, boolean bl2) {
        if (bl) {
            boolean bl3 = false;
            int n = -1;
            boolean bl4 = false;
            FCPort fCPort = null;
            int n2 = vector.size();
            ArrayList<FCNode> arrayList = new ArrayList<FCNode>();
            int n3 = -1;
            this.nameServerMap = new HashMap();
            int n4 = this.getFcAddress() & 0xFF0000;
            int n5 = 0;
            while (n5 < n2) {
                NameServerEntry nameServerEntry = (NameServerEntry)vector.get(n5);
                int n6 = nameServerEntry.getFcAddress() & 0xFFFF00;
                this.nameServerMap.put(new Long(nameServerEntry.getPortWWName().getWWName()), nameServerEntry);
                this.nameServerMap.put(new Integer(nameServerEntry.getFcAddress()), nameServerEntry);
                if (n6 != n4) {
                    if (arrayList.size() != 0) {
                        if (fCPort != null) {
                            this.clearPortsNodeList(n3 + 1, fCPort.getPortNumber() - 1);
                            n3 = fCPort.getPortNumber();
                            fCPort.setNodeList(arrayList);
                        }
                        arrayList.clear();
                    }
                    n4 = n6;
                }
                if ((fCPort = this.getPortByAddr(n4)) != null) {
                    arrayList.add(new FCNode(nameServerEntry, fCPort));
                } else {
                    bl3 = true;
                }
                ++n5;
            }
            this.clearPortsNodeList(n3 + 1, this.getPortCount() - 1);
            if (arrayList.size() != 0) {
                fCPort.setNodeList(arrayList);
            }
            if (bl2 && bl3) {
                this.eventHandler.fireChassisEvent(296, (Object)vector, true);
            }
            this.eventHandler.fireChassisEvent(219, (Object)this, true);
        } else {
            this.eventHandler.fireChassisEvent(219, null, false);
        }
        this.setAcquiringNameServerInfo(false);
    }

    public boolean getAcquiringNameServerInfo() {
        return this.acquiringNameServerInfo;
    }

    public void setAcquiringNameServerInfo(boolean bl) {
        this.acquiringNameServerInfo = bl;
    }

    public void saveFabricNameServerList(Vector vector) {
    }

    protected void clearPortsNodeList(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            FCPort fCPort = this.getPort(n3);
            fCPort.clearNodeList();
            ++n3;
        }
    }

    public abstract User getLoginInfo();

    public abstract boolean updateChassisInfo();

    public abstract boolean updateIpInfo();

    public abstract boolean applyIpInfo(IPInfo var1);

    public abstract boolean applyLoopbackTest(int var1, int var2);

    public abstract boolean applyOnlineLoopbackTest(int var1, long var2, int var4, long var5, boolean var7);

    public abstract boolean applyChassisMode(int var1);

    public abstract boolean updateAll();

    public abstract boolean updateVersion();

    public abstract boolean updateBeacon();

    public abstract boolean updateSnmpInfo();

    public abstract boolean updatePortStates();

    public abstract boolean updatePortStatistics();

    public abstract boolean updateChassisStatistics();

    public abstract void cancelEPortZoningLoad();

    public abstract boolean applyEPortZoning(Zones var1);

    public abstract void cancelEPortZoningSave();

    public abstract boolean applyActivateZoneSet(ZoneSet var1);

    public abstract boolean applyDeactivateZoneSet();

    public abstract boolean applyBeaconToggle(boolean var1);

    public abstract boolean reset();

    public boolean hotReset() {
        throw new UnsupportedOperationException();
    }

    public boolean canNdcla() {
        return false;
    }

    public abstract boolean startPerformanceMonitoring();

    public abstract boolean stopPerformanceMonitoring();

    public abstract boolean isPerformanceMonitoringActive();

    public abstract boolean updateNameServerInfo();

    public abstract boolean updateSwitchConfig();

    public abstract boolean updateLsdb();

    public abstract boolean applySnmpInfo(SnmpInfo var1);

    public ZoningConfig getZoningConfig() {
        return this.zoningConfig;
    }

    public abstract boolean isAutoSaveSettable();

    public abstract boolean applyZoningConfig(ZoningConfig var1);

    public abstract Zones getEportZoningDb();

    public abstract Zones getActiveEportZoning();

    public boolean isInPromMode() {
        return this.getChassisStatus() == 1 && this.WWName.getWWName() != 0L && this.moduleAddr == 0 && (this.sysConfigRegister & 0x400000) == 0;
    }

    public abstract List getUpdaters();

    public Updater getUpdater(int n) {
        List list = this.getUpdaters();
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Updater updater = (Updater)list.get(n4);
            int n5 = updater.getEvent();
            if (n == n5) {
                return updater;
            }
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return null;
    }
}

