/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.util.StringUtilities;

public class Sanbox8000Blade {
    public static final int BLADE_OPER_STATE_ONLINE = 0;
    public static final int BLADE_OPER_STATE_OFFLINE = 1;
    public static final int BLADE_OPER_STATE_DIAG = 2;
    public static final int BLADE_OPER_STATE_DOWNED = 3;
    public static final int BLADE_OPER_STATE_NOT_INSTALLED = 4;
    public static final int BLADE_OPER_STATE_UNKNOWN = 5;
    public static final int BLADE_STATE_UNKNOWN = 0;
    public static final int BLADE_STATE_GOOD = 1;
    public static final int BLADE_STATE_BAD = 2;
    public static final int BLADE_STATE_NOT_INSTALLED = 3;
    public static final int DIAG_STATUS_UNKNOWN = 0;
    public static final int DIAG_STATUS_PASSED = 1;
    public static final int DIAG_STATUS_FAILED = 2;
    public static final int DIAG_STATUS_COMPROMISED = 3;
    public static final int TEMP_STATUS_UNKNOWN = 0;
    public static final int TEMP_STATUS_NORMAL = 1;
    public static final int TEMP_STATUS_WARM = 2;
    public static final int TEMP_STATUS_OVERHEATING = 3;
    public static final int TEST_STATUS_READY = 1;
    public static final int TEST_STATUS_WORKING = 2;
    public static final int TEST_STATUS_PASSED = 3;
    public static final int TEST_STATUS_FAILED = 4;
    private int bladeConfigState = 0;
    private int bladeState = 0;
    private int bladeOperState = 5;
    private int bladeNumber = -1;
    private int diagStatus = 0;
    private int tempStatus = 0;
    private int boardTemp;
    private int unusedCreditPool;
    private String serialNumber;
    private String zirconVersion;
    private Sanbox8000 sanbox8000Sw;
    private int testStatus = 1;

    public Sanbox8000Blade(Sanbox8000 sanbox8000, int n) {
        this.sanbox8000Sw = sanbox8000;
        this.bladeNumber = n;
    }

    public Sanbox8000 getChassis() {
        return this.sanbox8000Sw;
    }

    public int getBladeNumber() {
        return this.bladeNumber;
    }

    public int getSlotNumber() {
        return Sanbox8000Blade.bladeToSlot(this.bladeNumber);
    }

    public boolean isInstalled() {
        return this.bladeState != 3;
    }

    public int getBladeOperState() {
        return this.bladeOperState;
    }

    public void setBladeOperState(int n) {
        this.bladeOperState = n;
    }

    public int getBladeState() {
        return this.bladeState;
    }

    public void setBladeConfigState(int n) {
        this.bladeConfigState = n;
    }

    public int getBladeConfigState() {
        return this.bladeConfigState;
    }

    public void setBladeState(int n) {
        this.bladeState = n;
    }

    public int getDiagStatus() {
        return this.diagStatus;
    }

    public void setDiagStatus(int n) {
        this.diagStatus = n;
    }

    public int getTempStatus() {
        return this.tempStatus;
    }

    public void setTempStatus(int n) {
        this.tempStatus = n;
    }

    public int getBoardTemp() {
        return this.boardTemp;
    }

    public void setBoardTemp(int n) {
        this.boardTemp = n;
    }

    public int getUnusedCreditPool() {
        return this.unusedCreditPool;
    }

    public void setUnusedCreditPool(int n) {
        this.unusedCreditPool = n;
    }

    public int getBladeTestStatus() {
        return this.testStatus;
    }

    public void setBladeTestStatus(int n) {
        this.testStatus = n;
    }

    public void setZirconVersion(String string) {
        this.zirconVersion = string;
    }

    public String getZirconVersion() {
        return this.zirconVersion;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public static int bladeToSlot(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return n + 1;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return n + 2;
            }
        }
        return -1;
    }

    public String toString() {
        Object[] objectArray = new Object[]{Integer.toString(this.getBladeNumber()), Integer.toString(this.getSlotNumber())};
        String string = DeviceUtilities.getResource("Sanbox8000Blade.toString");
        return StringUtilities.formatString(string, objectArray);
    }
}

