/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.NameServerEntry;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.event.ChassisEventHandler;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ForeignSwitch
implements Chassis {
    protected Vector nodeList = new Vector();
    protected ChassisEventHandler eventHandler = null;
    protected ComAgent comAgent = null;
    protected WorldWideName WWName = null;
    protected int fcAddress = 0;
    protected String vendorName = "Non-QLogic";
    private int discoveryReason;
    protected InetAddress ipAddr = null;

    public ForeignSwitch(int n, WorldWideName worldWideName, ComAgent comAgent, int n2) {
        this.comAgent = comAgent;
        this.fcAddress = n;
        this.WWName = worldWideName;
        this.discoveryReason = n2;
        this.eventHandler = new ChassisEventHandler(this);
    }

    public ComAgent getComAgent() {
        return this.comAgent;
    }

    public boolean getDiscoveredByIpAddress() {
        WorldWideName worldWideName = this.getComAgent().getConnectionWwn();
        if (worldWideName == null) {
            return false;
        }
        return worldWideName.equals(this.getWWName());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Chassis)) {
            return false;
        }
        Chassis chassis = (Chassis)object;
        return this.getWWName().equals(chassis.getWWName());
    }

    public int getPortCount() {
        return 0;
    }

    public FCPort getFirstPort() {
        return null;
    }

    public FCPort getNextPort(FCPort fCPort) {
        return null;
    }

    public FCNode getFirstNode() {
        if (this.nodeList.size() > 0) {
            return (FCNode)this.nodeList.firstElement();
        }
        return null;
    }

    public FCNode getNextNode(FCNode fCNode) {
        int n;
        if (this.nodeList.size() > 0 && (n = this.nodeList.indexOf(fCNode)) >= 0 && n + 1 < this.nodeList.size()) {
            return (FCNode)this.nodeList.elementAt(n + 1);
        }
        return null;
    }

    public WorldWideName getWWName() {
        return this.WWName;
    }

    public int getDomainId() {
        return this.getFcAddress() >> 16;
    }

    public void setWWName(WorldWideName worldWideName) {
        this.WWName = worldWideName;
    }

    public InetAddress getIpAddr() {
        return this.ipAddr;
    }

    public void setIpAddr(InetAddress inetAddress) {
        this.ipAddr = inetAddress;
    }

    public int getChassisType() {
        return -1;
    }

    public int getChassisId() {
        return 0;
    }

    public ChassisEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void addChassisEventListener(ChassisEventListener chassisEventListener) {
        this.getEventHandler().addChassisEventListener(chassisEventListener);
    }

    public void removeChassisEventListener(ChassisEventListener chassisEventListener) {
        this.getEventHandler().removeChassisEventListener(chassisEventListener);
    }

    public int getFcAddress() {
        return this.fcAddress;
    }

    public String delimitFCAddress() {
        int n = 0;
        String string = Integer.toHexString(this.fcAddress);
        n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n < 6) {
            int n2 = 6;
            while (n2 > n) {
                stringBuffer.insert(0, "0");
                --n2;
            }
        }
        return stringBuffer.toString();
    }

    public void setFcAddress(int n) {
        this.fcAddress = n;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String string) {
        this.vendorName = string;
    }

    public int getTemperature() {
        return 0;
    }

    public int getTemperatureStatus() {
        return 0;
    }

    public int getFanCount() {
        return 1;
    }

    public int getPowerSupplyCount() {
        return 1;
    }

    public int getFanStatus(int n) {
        return 0;
    }

    public int getPowerSupplyStatus(int n) {
        return 0;
    }

    public boolean isInOrderDeliverySet() {
        return true;
    }

    public boolean updateAll() {
        return false;
    }

    public boolean updateChassisStatistics() {
        return false;
    }

    public boolean updatePortStatistics() {
        return false;
    }

    public String toString() {
        if (this.getIpAddr() != null) {
            return this.getIpAddr().getHostAddress();
        }
        if (this.WWName != null) {
            return this.WWName.delimit();
        }
        return "Unidentified switch";
    }

    public boolean updateChassisInfo() {
        return false;
    }

    public boolean calculateOverallStatus() {
        return false;
    }

    public void setDiscoveryReason(int n) {
        this.discoveryReason = n;
        this.eventHandler.fireChassisEvent(208, null, true);
    }

    public int getDiscoveryReason() {
        return this.discoveryReason;
    }

    public List getReasonForStatus() {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (this.discoveryReason) {
            case 1: {
                arrayList.add("Status.loginFailure");
                break;
            }
            case 2: {
                arrayList.add("Status.invalidLoginData");
                break;
            }
            case 3: {
                arrayList.add("Status.maxSessions");
                break;
            }
            case 4: {
                arrayList.add("Status.noResponse");
                break;
            }
            case 6: {
                arrayList.add("Status.nonQlogicSwitch");
                break;
            }
            default: {
                arrayList.add("Status.unmanageable");
            }
        }
        return arrayList;
    }

    public int getOverallStatus() {
        return 3;
    }

    public boolean pingChassis() {
        return true;
    }

    public void setNotInFabric() {
        this.fcAddress = 0;
    }

    public void saveFabricNameServerList(Vector vector) {
        int n = vector.size();
        boolean bl = false;
        Vector<FCNode> vector2 = new Vector<FCNode>();
        int n2 = 0;
        while (n2 < n) {
            NameServerEntry nameServerEntry = (NameServerEntry)vector.get(n2);
            int n3 = nameServerEntry.getFcAddress() & 0xFF0000;
            if (n3 == this.getFcAddress()) {
                FCNode fCNode = new FCNode(nameServerEntry, this);
                if (!this.nodeList.contains(fCNode)) {
                    bl = true;
                }
                vector2.add(fCNode);
            }
            ++n2;
        }
        if (bl || vector2.size() != this.nodeList.size()) {
            this.nodeList = vector2;
            this.eventHandler.fireChassisEvent(219, (Object)this, true);
        }
    }

    public FCPort getPort(int n) {
        return null;
    }

    public boolean isReachable() {
        return this.fcAddress != 0;
    }
}

