/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.EPortEntry;
import com.qlogic.device.fcfabric.EPortEntryList;
import com.qlogic.device.fcfabric.EPortLink;
import com.qlogic.device.fcfabric.FCDiscoverer;
import com.qlogic.device.fcfabric.FCDiscovery;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.FabricLink;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.ForeignSwitch;
import com.qlogic.device.fcfabric.Pollable;
import com.qlogic.device.fcfabric.PollingItem;
import com.qlogic.device.fcfabric.PollingQueue;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.Updater;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ComAgentEvent;
import com.qlogic.device.fcfabric.event.ComAgentEventListener;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Fabric
extends Thread
implements ChassisEventListener,
ComAgentEventListener,
FabricEventListener,
Pollable {
    public static final int MIN_DOMAIN_ID = 1;
    public static final int MAX_DOMAIN_ID = 239;
    private static final int QLOGIC_CO_ID = 49373;
    private static final long DEF_SLEEP_TIME = 500L;
    public static final long MAX_TIME_ACTIVE = 180000L;
    public static final int NO_SUCH_EVENT = -1;
    public static final int FABRIC_MAPPING = 0;
    public static final int EMPTY_FABRIC_MAPPING = 1;
    public static final int NODE_MAPPING = 2;
    public static final int SWITCH_UPDATE = 3;
    public static final int SWITCH_STATS = 4;
    public static final int PORT_STATS = 5;
    public static final int EPORT_ZONING = 6;
    public static final int PING_SWITCH = 7;
    public static final int DEF_FABRIC_MAPPING_TOV = 30000;
    public static final int DEF_EMPTY_FABRIC_MAPPING_TOV = 1000;
    public static final int DEF_NODE_MAPPING_TOV = 15000;
    public static final int DEF_SWITCH_UPDATE_TOV = 20000;
    public static final int DEF_SWITCH_STATS_TOV = 35000;
    public static final int DEF_PORT_STATS_TOV = 45000;
    public static final int DEF_EPORT_ZONING_TOV = 120000;
    public static final int DEF_PING_SWITCH = 5000;
    private ComAgent comAgent;
    private static final int MAP_IDLE = 0;
    private static final int MAP_START = 1;
    private static final int MAP_PROC = 2;
    private static final int MAP_STOP = 3;
    private byte[] mappingLock = new byte[0];
    private int mapping;
    private FCDiscoverer fcDisc = new FCDiscoverer();
    private Vector listeners = new Vector();
    private Vector events = new Vector();
    private int[] pollingFilter;
    private String name;
    private String statusReason = null;
    private String userName;
    private String password;
    private InetAddress ipAddr;
    private Vector switchList = new Vector();
    private Vector linkList = new Vector();
    private volatile boolean shouldRun;
    public static final float POLL_RAPID_MULTIPLIER = 1.0f;
    public static final float POLL_MEDIUM_MULTIPLIER = 1.5f;
    public static final float POLL_SLOW_MULTIPLIER = 2.0f;
    private long[] defPollTOVs = new long[]{30000L, 1000L, 15000L, 20000L, 35000L, 45000L, 120000L, 5000L};
    private PollingQueue pollEvents = new PollingQueue();
    private HashMap pollingTargets = new HashMap();
    private List updaters;
    private static final int FM_EMPTY = 0;
    private static final int FM_SANBOX = 1;
    private static final int FM_SANBOX2 = 2;
    private static final int FM_MIXED = 3;
    private int overallStatus = 3;
    private boolean closingSessions;
    private int sessionsToClose;
    private Vector sessionCloseFails;

    public Fabric(InetAddress inetAddress, String string, String string2, String string3) {
        this.name = string;
        this.userName = string2;
        this.password = string3;
        this.setName("Fabric-" + string);
        this.ipAddr = inetAddress;
        this.addEventListener(this);
        this.createUpdaters();
        this.comAgent = new UtilAgent(this.ipAddr);
        this.comAgent.addComAgentListener(this);
        this.comAgent.getLoginInfo().setUsername(this.userName);
        this.comAgent.getLoginInfo().setPassword(this.password);
        ((UtilAgent)this.comAgent).startMessageThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = 0L;
        this.shouldRun = true;
        if (this.pollEvents.add(this, this.getUpdater(2010), this.now(), this.defPollTOVs[1])) ** GOTO lbl28
        this.cleanup();
        return;
lbl-1000:
        // 1 sources

        {
            try {
                this.processEvents();
                this.doPolling();
                var1_1 = this.pollEvents.getRootWakeTime() - System.currentTimeMillis();
                if (var1_1 <= 0L) {
                    var1_1 = 500L;
                }
                var3_2 = this;
                synchronized (var3_2) {
                    if (this.shouldRun && this.events.size() == 0) {
                        try {
                            this.wait(var1_1);
                        }
                        catch (InterruptedException var4_5) {
                            // empty catch block
                        }
                    }
                    continue;
                }
            }
            catch (OutOfMemoryError var3_3) {
                var4_4 = this.toString() + " : " + var3_3.toString() + "\n" + FabricUtilities.stackTraceToString(var3_3.getStackTrace());
                FabricUtilities.logMessage(var4_4);
                System.err.println(var4_4);
            }
lbl28:
            // 4 sources

            ** while (this.shouldRun)
        }
lbl29:
        // 1 sources

        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        this.comAgent.die();
        Fabric fabric = this;
        synchronized (fabric) {
            int n = this.switchList.size() - 1;
            while (n >= 0) {
                this.removeSwitch((Chassis)this.switchList.get(n));
                --n;
            }
        }
    }

    public void start() {
        if (this.shouldRun) {
            return;
        }
        super.start();
    }

    public void die() {
        this.stopMapping();
        this.shouldRun = false;
    }

    private void doPolling() {
        PollingItem pollingItem;
        while ((pollingItem = this.pollEvents.removeRoot()) != null) {
            Pollable pollable = pollingItem.getTarget();
            int n = pollingItem.getAction().getEvent();
            if (pollable instanceof SanboxChassis && !((SanboxChassis)pollable).isReachable() && n != 212) {
                pollingItem.setRequeue(true);
                this.requeue(pollingItem);
                continue;
            }
            if (pollable instanceof Sanbox && ((Sanbox)pollable).hasUnsupportedFw() && n != 212) {
                this.requeue(pollingItem);
                continue;
            }
            if (this.pollingFilter != null && Arrays.binarySearch(this.pollingFilter, n) < 0) {
                pollingItem.setRequeue(true);
                this.requeue(pollingItem);
                continue;
            }
            pollingItem.activate();
            ArrayList<PollingItem> arrayList = (ArrayList<PollingItem>)this.pollingTargets.get(pollingItem.getTarget());
            if (arrayList == null) {
                arrayList = new ArrayList<PollingItem>();
            }
            arrayList.add(pollingItem);
            this.pollingTargets.put(pollingItem.getTarget(), arrayList);
        }
    }

    private void poll(PollingItem pollingItem) {
        if (pollingItem.getTarget() instanceof Chassis && !this.exists((Chassis)((Object)pollingItem.getTarget()))) {
            return;
        }
        List list = (List)this.pollingTargets.get(pollingItem.getTarget());
        if (list != null) {
            int n = list.indexOf(pollingItem);
            if (n == -1) {
                this.pollEvents.add(pollingItem);
            } else {
                pollingItem = (PollingItem)list.get(n);
                pollingItem.setRequeue(true);
                long l = System.currentTimeMillis() - pollingItem.getActTime();
                if (l >= 180000L) {
                    FabricUtilities.logMessage(this + ": PollingItem active too long: " + pollingItem);
                    this.complete(pollingItem.getTarget(), pollingItem.getAction().getEvent(), true);
                }
            }
        } else {
            this.pollEvents.add(pollingItem);
        }
    }

    private void complete(Pollable pollable, int n) {
        this.complete(pollable, n, true);
    }

    private void complete(Pollable pollable, int n, boolean bl) {
        List list = (List)this.pollingTargets.get(pollable);
        if (list == null) {
            return;
        }
        PollingItem pollingItem = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            pollingItem = (PollingItem)iterator.next();
            if (pollingItem.getAction().getEvent() != n) continue;
            pollingItem.deactivate();
            iterator.remove();
            if (n == 2010) {
                if (this.switchList.size() > 0) {
                    pollingItem.setInterval(this.defPollTOVs[0]);
                } else {
                    pollingItem.setInterval(this.defPollTOVs[1]);
                }
            }
            if (pollingItem.getTarget() instanceof Chassis && !this.exists((Chassis)((Object)pollingItem.getTarget()))) continue;
            this.requeue(pollingItem);
            break;
        }
    }

    private void requeue(PollingItem pollingItem) {
        if (pollingItem.shouldRequeue()) {
            pollingItem.setRequeue(false);
            pollingItem.setWakeTime(this.now() + 500L);
        } else if (pollingItem.isRepeating()) {
            pollingItem.setWakeTime(this.now() + Fabric.getDefPollInterval(this.defPollTOVs, pollingItem));
        } else {
            return;
        }
        this.pollEvents.add(pollingItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map() {
        this.poll(new PollingItem(this, this.getUpdater(2010), this.now()));
        Fabric fabric = this;
        synchronized (fabric) {
            this.notifyAll();
        }
    }

    private void stopMapping() {
        this.fireEvent(2010, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mapFabric() {
        byte[] byArray = this.mappingLock;
        synchronized (this.mappingLock) {
            if (this.mapping != 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            this.mapping = 1;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            FCDiscovery fCDiscovery = this.fcDisc.DiscoverSwitch(this.comAgent);
            switch (fCDiscovery.getErrorCode()) {
                case 4: {
                    this.fireEvent(2022, null);
                    break;
                }
                case 7: {
                    this.fireEvent(2021, null);
                    break;
                }
                case 5: {
                    this.fireEvent(2015, null);
                    break;
                }
                case 3: {
                    this.fireEvent(2016, null);
                    break;
                }
                case 1: 
                case 2: {
                    this.fireEvent(2017, null);
                }
            }
            Chassis chassis = fCDiscovery.getChassis();
            if (chassis == null || chassis instanceof ForeignSwitch) {
                this.fireEvent(2010, null);
                return false;
            }
            WorldWideName worldWideName = chassis.getWWName();
            int n = chassis.getFcAddress();
            if (!worldWideName.isFcWwn() || n == 0 || n >= 0xF00000) {
                this.fireEvent(2010, null);
                return false;
            }
            this.comAgent.setConnectionWwnAndFcAddress(chassis.getWWName(), chassis.getFcAddress());
            if (!this.addSwitch(chassis)) {
                chassis = this.getConnectionSwitch();
            }
            if (chassis != null && !(chassis instanceof ForeignSwitch)) {
                ((SanboxChassis)chassis).setChassisStatus(1);
                if (!((SanboxChassis)chassis).updateLsdb()) {
                    this.fireEvent(2010, null);
                }
            } else {
                this.fireEvent(2010, null);
            }
            return true;
        }
    }

    private void processLsdb() {
        Chassis chassis;
        if (this.mapping != 2 || (chassis = this.getConnectionSwitch()) == null) {
            this.fireEvent(2010, null);
            return;
        }
        EPortEntryList ePortEntryList = chassis.getLsdb();
        int n = ePortEntryList.size() - 1;
        while (this.mapping == 2 && n >= 0) {
            EPortEntry ePortEntry = (EPortEntry)ePortEntryList.elementAt(n);
            WorldWideName worldWideName = ePortEntry.getWWName();
            chassis = this.getSwitchByWWN(worldWideName);
            if (this.shouldDiscover(chassis, ePortEntry)) {
                int n2 = ePortEntry.getDomainId() << 16;
                FCDiscovery fCDiscovery = this.fcDisc.DiscoverSwitch(n2, worldWideName, this.comAgent);
                Chassis chassis2 = fCDiscovery.getChassis();
                if (chassis2 instanceof ForeignSwitch) {
                    ((ForeignSwitch)chassis2).setIpAddr(ePortEntry.getIpAddr());
                }
                if (this.addSwitch(chassis2)) {
                    chassis = chassis2;
                }
            }
            if (chassis != null) {
                this.mapLinks(chassis, ePortEntry);
            }
            --n;
        }
        this.updateReachability();
        this.updateLinkStates();
        this.fireEvent(2010, null);
    }

    private void mapLinks(Chassis chassis, EPortEntry ePortEntry) {
        int n = ePortEntry.getLinkResponseCount() - 1;
        while (n >= 0) {
            EPortLink ePortLink = ePortEntry.getLinkAt(n);
            int n2 = ePortLink.getLocalPort();
            Chassis chassis2 = this.getSwitchByDomainID(ePortLink.getNeighborDomainID());
            int n3 = ePortLink.getRemotePort();
            if (chassis2 != null) {
                this.addLink(chassis, n2, chassis2, n3);
            }
            --n;
        }
    }

    private boolean shouldDiscover(Chassis chassis, EPortEntry ePortEntry) {
        if (chassis == null) {
            return true;
        }
        if (chassis instanceof ForeignSwitch && ((ForeignSwitch)chassis).getDiscoveryReason() != 6) {
            return true;
        }
        if (chassis.getDomainId() != ePortEntry.getDomainId()) {
            return true;
        }
        return !chassis.isReachable();
    }

    public void refresh() {
        this.fireEvent(2012);
    }

    private synchronized void doRefresh() {
        Chassis chassis = null;
        if (this.comAgent.getComAgentStatus() == 2) {
            this.comAgent.connect();
        }
        this.map();
        Iterator iterator = this.switchList.iterator();
        while (iterator.hasNext()) {
            chassis = (Chassis)iterator.next();
            if (!(chassis instanceof Pollable)) continue;
            Pollable pollable = (Pollable)((Object)chassis);
            Iterator iterator2 = pollable.getUpdaters().iterator();
            while (iterator2.hasNext()) {
                Updater updater = (Updater)iterator2.next();
                int n = updater.getEvent();
                if (n == 232 || n == 285) continue;
                this.poll(new PollingItem(pollable, updater, this.now()));
            }
        }
        this.notifyAll();
    }

    public void refresh(Chassis chassis) {
        this.fireEvent(2013, chassis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh(Chassis chassis) {
        Pollable pollable;
        if (this.comAgent.getComAgentStatus() == 2) {
            this.comAgent.connect();
        }
        if (chassis instanceof Pollable) {
            pollable = (Pollable)((Object)chassis);
            Iterator iterator = pollable.getUpdaters().iterator();
            while (iterator.hasNext()) {
                Updater updater = (Updater)iterator.next();
                int n = updater.getEvent();
                if (n == 232 || n == 285) continue;
                this.poll(new PollingItem(pollable, updater, this.now()));
            }
        }
        pollable = this;
        synchronized (pollable) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveEvent(ComAgentEvent comAgentEvent) {
        if (this.closingSessions) {
            return;
        }
        switch (comAgentEvent.getEventType()) {
            case 1: 
            case 4: {
                this.events.add(comAgentEvent);
                Fabric fabric = this;
                synchronized (fabric) {
                    this.notifyAll();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveEvent(FabricEvent fabricEvent) {
        if (this.closingSessions) {
            return;
        }
        this.events.add(fabricEvent);
        Fabric fabric = this;
        synchronized (fabric) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getEventType() == 261) {
            Chassis chassis = chassisEvent.getChassis();
            chassis.setNotInFabric();
            FabricUtilities.logMessage(this + " : setting " + chassis + " [" + chassis.getWWName().delimit() + "] not in fabric");
        } else {
            this.events.add(chassisEvent);
            Fabric fabric = this;
            synchronized (fabric) {
                this.notifyAll();
            }
        }
    }

    private void processEvents() {
        while (!this.events.isEmpty()) {
            Object e = this.events.remove(0);
            if (e instanceof ChassisEvent) {
                this.processEvent((ChassisEvent)e);
                continue;
            }
            if (e instanceof FabricEvent) {
                this.processEvent((FabricEvent)e);
                continue;
            }
            if (!(e instanceof ComAgentEvent)) continue;
            this.processEvent((ComAgentEvent)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(ComAgentEvent comAgentEvent) {
        if (comAgentEvent.getEventType() == 4 && this.comAgent.getComAgentStatus() == 1) {
            this.refresh();
        }
        Fabric fabric = this;
        synchronized (fabric) {
            int n = this.switchList.size() - 1;
            while (n >= 0) {
                ((Chassis)this.switchList.get(n)).calculateOverallStatus();
                --n;
            }
        }
        this.updateLinkStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processEvent(FabricEvent fabricEvent) {
        int n = fabricEvent.getEventType();
        this.complete(this, n);
        switch (n) {
            case 2020: {
                this.doCloseSessions();
                return;
            }
            case 2003: {
                this.map();
            }
            case 2004: {
                byte[] byArray = this.mappingLock;
                synchronized (this.mappingLock) {
                    if (this.mapping != 2) return;
                    this.updateLinkStates();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
            case 2005: 
            case 2006: {
                this.calculateOverallStatus();
                return;
            }
            case 2010: {
                byte[] byArray = this.mappingLock;
                synchronized (this.mappingLock) {
                    this.mapping = 0;
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    return;
                }
            }
            case 2011: {
                this.map();
                return;
            }
            case 2012: {
                this.doRefresh();
                return;
            }
            case 2014: {
                this.doRediscovery();
                return;
            }
            case 2013: {
                if (!(fabricEvent.getValue() instanceof Chassis)) return;
                this.doRefresh((Chassis)fabricEvent.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(ChassisEvent chassisEvent) {
        if (!this.exists(chassisEvent.getChassis())) {
            return;
        }
        Pollable pollable = null;
        Updater updater = null;
        Object var4_4 = null;
        Chassis chassis = chassisEvent.getChassis();
        int n = chassisEvent.getEventType();
        if (this.closingSessions) {
            if (n == 352) {
                --this.sessionsToClose;
                if (!chassisEvent.isSuccessful()) {
                    this.sessionCloseFails.add(chassisEvent.getChassis());
                }
                if (this.sessionsToClose == 0) {
                    this.fireEvent(2019, this.sessionCloseFails);
                }
            }
            return;
        }
        if (chassis instanceof Pollable) {
            pollable = (Pollable)((Object)chassis);
            this.complete(pollable, n, chassisEvent.isSuccessful());
        }
        switch (n) {
            case 232: {
                byte[] byArray = this.mappingLock;
                synchronized (this.mappingLock) {
                    if (this.mapping == 1) {
                        this.mapping = 2;
                    }
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    this.processLsdb();
                    break;
                }
            }
            case 242: 
            case 247: 
            case 260: {
                if (chassisEvent.getChassis() instanceof Sanbox2) {
                    updater = pollable.getUpdater(377);
                    this.poll(new PollingItem(pollable, updater, this.now()));
                    updater = pollable.getUpdater(378);
                    this.poll(new PollingItem(pollable, updater, this.now()));
                    Fabric fabric = this;
                    synchronized (fabric) {
                        this.notifyAll();
                        break;
                    }
                }
                if (!(chassisEvent.getChassis() instanceof Sanbox)) break;
                updater = pollable.getUpdater(241);
                this.poll(new PollingItem(pollable, updater, this.now()));
                Fabric fabric = this;
                synchronized (fabric) {
                    this.notifyAll();
                    break;
                }
            }
            case 262: {
                chassis.calculateOverallStatus();
                break;
            }
            case 379: {
                Object[] objectArray;
                if (chassisEvent.getValue() instanceof Object[]) {
                    updater = (Updater)((Object[])chassisEvent.getValue())[0];
                    objectArray = (Object[])((Object[])chassisEvent.getValue())[1];
                    this.poll(new PollingItem(pollable, updater, objectArray, this.now()));
                } else {
                    updater = (Updater)chassisEvent.getValue();
                    this.poll(new PollingItem(pollable, updater, this.now()));
                }
                objectArray = this;
                synchronized (objectArray) {
                    this.notifyAll();
                    break;
                }
            }
            case 291: {
                this.refresh(chassis);
                break;
            }
            case 296: {
                chassis = this.getFirstSwitch();
                while (chassis != null) {
                    if (!(chassis instanceof SanboxChassis)) {
                        Vector vector = (Vector)chassisEvent.getValue();
                        chassis.saveFabricNameServerList(vector);
                    }
                    chassis = this.getNextSwitch(chassis);
                }
                break;
            }
            case 240: {
                this.calculateOverallStatus();
                break;
            }
            case 212: 
            case 316: {
                this.calculateOverallStatus();
                chassis.calculateOverallStatus();
                break;
            }
            case 200: 
            case 210: 
            case 230: 
            case 269: {
                chassis.calculateOverallStatus();
                break;
            }
            case 201: {
                SanboxChassis sanboxChassis;
                if (!chassisEvent.isSuccessful() || this.getConnectionSwitch() != chassis || !(chassis instanceof SanboxChassis) || (sanboxChassis = (SanboxChassis)chassis).getIpInfo().getIpAddress().equals(this.comAgent.getIpAddress())) break;
                this.comAgent.setIpAddress(sanboxChassis.getIpInfo().getIpAddress());
                break;
            }
            case 203: {
                chassis.calculateOverallStatus();
                if (!chassis.isReachable()) break;
                this.refresh(chassis);
                break;
            }
            case 208: {
                this.calculateOverallStatus();
                this.updateLinkStates();
                break;
            }
            case 244: 
            case 252: 
            case 268: {
                if (!chassisEvent.isSuccessful()) {
                    return;
                }
                this.refresh();
                break;
            }
            case 299: {
                if (chassis == null || !(chassis instanceof Sanbox2)) break;
                if (chassis.equals(this.getConnectionSwitch())) {
                    this.comAgent.setIpAddress(((Sanbox2)chassis).getChangedIpAddress());
                }
                ((Sanbox2)chassis).updateIpInfo();
            }
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public SanboxChassis getConnectionSwitch() {
        Chassis chassis = this.getSwitchByWWN(this.comAgent.getConnectionWwn());
        if (chassis instanceof SanboxChassis) {
            return (SanboxChassis)chassis;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chassis getSwitchByWWN(WorldWideName worldWideName) {
        if (worldWideName == null) {
            return null;
        }
        Fabric fabric = this;
        synchronized (fabric) {
            int n = 0;
            int n2 = this.switchList.size();
            while (n < n2) {
                Chassis chassis = (Chassis)this.switchList.get(n);
                WorldWideName worldWideName2 = chassis.getWWName();
                if (worldWideName2.equals(worldWideName)) {
                    return chassis;
                }
                ++n;
            }
        }
        return null;
    }

    public synchronized Chassis getSwitchByFcAddr(int n) {
        int n2 = 0;
        int n3 = this.switchList.size();
        while (n2 < n3) {
            Chassis chassis = (Chassis)this.switchList.get(n2);
            if (chassis.getFcAddress() == n) {
                return chassis;
            }
            ++n2;
        }
        return null;
    }

    public synchronized Chassis getSwitchByDomainID(int n) {
        int n2 = 0;
        int n3 = this.switchList.size();
        while (n2 < n3) {
            Chassis chassis = (Chassis)this.switchList.get(n2);
            if (chassis.getDomainId() == n) {
                return chassis;
            }
            ++n2;
        }
        return null;
    }

    public Chassis getFirstSwitch() {
        return this.getNextSwitch(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chassis getNextSwitch(Chassis chassis) {
        try {
            if (chassis == null) {
                return (Chassis)this.switchList.get(0);
            }
            Chassis chassis2 = null;
            Fabric fabric = this;
            synchronized (fabric) {
                chassis2 = (Chassis)this.switchList.get(this.switchList.indexOf(chassis) + 1);
            }
            return chassis2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public FCPort getPortByAddr(int n) {
        int n2 = 0;
        int n3 = this.switchList.size();
        while (n2 < n3) {
            SanboxChassis sanboxChassis;
            FCPort fCPort;
            Chassis chassis = (Chassis)this.switchList.get(n2);
            if (chassis instanceof SanboxChassis && (fCPort = (sanboxChassis = (SanboxChassis)chassis).getPortByAddr(n)) != null) {
                return fCPort;
            }
            ++n2;
        }
        return null;
    }

    public synchronized boolean exists(Chassis chassis) {
        int n = 0;
        int n2 = this.switchList.size();
        while (n < n2) {
            Chassis chassis2 = (Chassis)this.switchList.get(n);
            if (chassis.getWWName().equals(chassis2.getWWName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized boolean exists(FabricLink fabricLink) {
        int n = 0;
        int n2 = this.linkList.size();
        while (n < n2) {
            if (fabricLink.equals((FabricLink)this.linkList.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized boolean addSwitch(Chassis chassis) {
        Chassis chassis2;
        Object object;
        if (chassis == null) {
            return false;
        }
        if (this.exists(chassis)) {
            object = null;
            int n = 0;
            int n2 = this.switchList.size();
            while (n < n2) {
                chassis2 = (Chassis)this.switchList.get(n);
                if (chassis2.getWWName().equals(chassis.getWWName())) {
                    object = (Chassis)this.switchList.get(n);
                    break;
                }
                ++n;
            }
            if (object != null) {
                if (object instanceof ForeignSwitch) {
                    if (object.getClass() == chassis.getClass()) {
                        int n3 = ((ForeignSwitch)chassis).getDiscoveryReason();
                        ((ForeignSwitch)object).setDiscoveryReason(n3);
                        return false;
                    }
                    this.removeSwitch((Chassis)object);
                } else {
                    if (object.getFcAddress() != chassis.getFcAddress()) {
                        object.setFcAddress(chassis.getFcAddress());
                    }
                    return false;
                }
            }
        }
        this.switchList.add(chassis);
        if (chassis instanceof SanboxChassis) {
            chassis2 = (SanboxChassis)chassis;
            ((SanboxChassis)chassis2).getEventHandler().addChassisEventListener(this);
            object = ((SanboxChassis)chassis2).getUpdaters().iterator();
            while (object.hasNext()) {
                Updater updater = (Updater)object.next();
                if (chassis2 instanceof Sanbox2) {
                    switch (updater.getEvent()) {
                        case 212: 
                        case 309: 
                        case 318: {
                            this.pollEvents.add((Pollable)((Object)chassis2), updater, this.now(), this.defPollTOVs[7]);
                            break;
                        }
                        case 221: {
                            this.pollEvents.add((Pollable)((Object)chassis2), updater, this.now(), this.defPollTOVs[5]);
                            break;
                        }
                        case 222: {
                            this.pollEvents.add((Pollable)((Object)chassis2), updater, this.now(), this.defPollTOVs[4]);
                            break;
                        }
                        case 232: 
                        case 285: {
                            break;
                        }
                        default: {
                            this.pollEvents.add((Pollable)((Object)chassis2), updater, this.now());
                            break;
                        }
                    }
                    continue;
                }
                if (!(chassis2 instanceof Sanbox)) continue;
                switch (updater.getEvent()) {
                    case 212: 
                    case 309: {
                        this.pollEvents.add((Pollable)((Object)chassis2), updater, this.now(), this.defPollTOVs[7]);
                        break;
                    }
                    case 221: {
                        this.pollEvents.add((Pollable)((Object)chassis2), updater, this.now(), this.defPollTOVs[5]);
                        break;
                    }
                    case 222: {
                        this.pollEvents.add((Pollable)((Object)chassis2), updater, this.now(), this.defPollTOVs[4]);
                        break;
                    }
                    case 219: {
                        this.pollEvents.add((Pollable)((Object)chassis2), updater, this.now(), this.defPollTOVs[2]);
                        break;
                    }
                    case 241: {
                        this.pollEvents.add((Pollable)((Object)chassis2), updater, this.now(), this.defPollTOVs[6]);
                        break;
                    }
                    default: {
                        this.pollEvents.add((Pollable)((Object)chassis2), updater, this.now(), this.defPollTOVs[3]);
                    }
                }
            }
        }
        this.fireEvent(2002, chassis);
        this.calculateOverallStatus();
        this.notifyAll();
        return true;
    }

    public void rediscover() {
        this.fireEvent(2014);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doRediscovery() {
        var1_1 = this.fcDisc.DiscoverSwitch(this.comAgent);
        var2_2 = this;
        synchronized (var2_2) {
            this.fireEvent(2010, null);
            var3_3 = var1_1.getChassis();
            if (var3_3 != null && !(var3_3 instanceof ForeignSwitch)) ** GOTO lbl12
            this.fireEvent(2018, var1_1);
            return;
lbl-1000:
            // 1 sources

            {
                this.removeSwitch(var3_3);
lbl12:
                // 2 sources

                ** while ((var3_3 = this.getFirstSwitch()) != null)
            }
lbl13:
            // 1 sources

            this.fireEvent(2011, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeSwitch(Chassis chassis) {
        if (this.exists(chassis) && FabricList.getFabric(chassis) == this) {
            Object object;
            if (chassis instanceof SanboxChassis) {
                chassis.getEventHandler().removeChassisEventListener(this);
                if (chassis instanceof Sanbox2) {
                    ((Sanbox2)chassis).dispose();
                }
            }
            this.pollingTargets.remove(chassis);
            Iterator iterator = this.events.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof ChassisEvent) || ((ChassisEvent)object).getChassis() != chassis) continue;
                iterator.remove();
            }
            if (chassis instanceof Pollable) {
                this.pollEvents.remove((Pollable)((Object)chassis));
            }
            object = this.mappingLock;
            synchronized (this.mappingLock) {
                if (chassis.getDiscoveredByIpAddress() && this.mapping != 0) {
                    this.fireEvent(2010, null);
                }
                // ** MonitorExit[var4_3 /* !! */ ] (shouldn't be in output)
                int n = this.linkList.size() - 1;
                while (n >= 0) {
                    FabricLink fabricLink = (FabricLink)this.linkList.get(n);
                    if (fabricLink != null && (fabricLink.getSwitch1().equals(chassis) || fabricLink.getSwitch2().equals(chassis))) {
                        this.removeLink(fabricLink);
                    }
                    --n;
                }
                this.switchList.remove(chassis);
                chassis.setNotInFabric();
                this.fireEvent(2003, chassis);
                return true;
            }
        }
        return false;
    }

    public void setComAgent(ComAgent comAgent) {
        this.comAgent = comAgent;
        this.fireEvent(2009, this.comAgent);
    }

    public ComAgent getComAgent() {
        return this.comAgent;
    }

    private void updateReachability() {
        EPortEntryList ePortEntryList;
        SanboxChassis sanboxChassis = this.getConnectionSwitch();
        if (sanboxChassis == null || (ePortEntryList = sanboxChassis.getLsdb()) == null) {
            return;
        }
        List list = this.getSwitches();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Chassis chassis = (Chassis)iterator.next();
            if (!(chassis instanceof ForeignSwitch)) continue;
            EPortEntry ePortEntry = ePortEntryList.getEntry(chassis.getWWName());
            if (ePortEntry == null) {
                chassis.setNotInFabric();
                continue;
            }
            chassis.setFcAddress(ePortEntry.getDomainId() << 16);
        }
    }

    private void updateLinkStates() {
        EPortEntryList ePortEntryList;
        SanboxChassis sanboxChassis = this.getConnectionSwitch();
        if (sanboxChassis == null || (ePortEntryList = sanboxChassis.getLsdb()) == null || ePortEntryList.isEmpty()) {
            return;
        }
        Vector vector = this.getLinks();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            FabricLink fabricLink = (FabricLink)iterator.next();
            Chassis chassis = fabricLink.getSwitch1();
            Chassis chassis2 = fabricLink.getSwitch2();
            int n = !chassis.isReachable() && !chassis2.isReachable() || sanboxChassis.getChassisStatus() != 1 ? 3 : (!ePortEntryList.exists(fabricLink) ? 2 : 0);
            if (!fabricLink.setState(n)) continue;
            this.fireEvent(2006, fabricLink);
        }
    }

    public synchronized boolean addLink(Chassis chassis, int n, Chassis chassis2, int n2) {
        if (chassis == null || chassis2 == null) {
            return false;
        }
        FabricLink fabricLink = this.getLinkByEnd(chassis, n);
        FabricLink fabricLink2 = this.getLinkByEnd(chassis2, n2);
        if (fabricLink != null) {
            if (fabricLink2 != null && fabricLink.equals(fabricLink2)) {
                return false;
            }
            this.removeLink(fabricLink);
        }
        if (fabricLink2 != null) {
            this.removeLink(fabricLink2);
        }
        FabricLink fabricLink3 = new FabricLink(chassis, n, chassis2, n2);
        this.linkList.add(fabricLink3);
        this.fireEvent(2004, fabricLink3);
        return true;
    }

    public synchronized FabricLink getLinkByEnd(Chassis chassis, int n) {
        FabricLink fabricLink = null;
        int n2 = this.linkList.size() - 1;
        while (n2 >= 0) {
            fabricLink = (FabricLink)this.linkList.get(n2);
            if (fabricLink.getSwitch1().equals(chassis) && fabricLink.getPortNumber1() == n) {
                return fabricLink;
            }
            if (fabricLink.getSwitch2().equals(chassis) && fabricLink.getPortNumber2() == n) {
                return fabricLink;
            }
            --n2;
        }
        return null;
    }

    public synchronized FabricLink getLinkByEnd(Chassis chassis, FCPort fCPort) {
        FabricLink fabricLink = null;
        int n = fCPort.getPortNumber();
        int n2 = this.linkList.size() - 1;
        while (n2 >= 0) {
            fabricLink = (FabricLink)this.linkList.get(n2);
            if (fabricLink.getSwitch1().equals(chassis) && fabricLink.getPortNumber1() == n) {
                return fabricLink;
            }
            if (fabricLink.getSwitch2().equals(chassis) && fabricLink.getPortNumber2() == n) {
                return fabricLink;
            }
            --n2;
        }
        return null;
    }

    public FabricLink getFirstLink() {
        return this.getNextLink(null);
    }

    public synchronized FabricLink getNextLink(FabricLink fabricLink) {
        try {
            if (fabricLink == null) {
                return (FabricLink)this.linkList.firstElement();
            }
            int n = this.linkList.indexOf(fabricLink);
            return (FabricLink)this.linkList.get(n + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public FabricLink[] getLinksBySwitch(SanboxChassis sanboxChassis) {
        ArrayList<FabricLink> arrayList = new ArrayList<FabricLink>();
        int n = sanboxChassis.getPortCount() - 1;
        while (n > 0) {
            FabricLink fabricLink = this.getLinkByEnd((Chassis)sanboxChassis, n);
            if (fabricLink != null) {
                arrayList.add(fabricLink);
            }
            --n;
        }
        return (FabricLink[])arrayList.toArray();
    }

    public Vector getLinks() {
        return (Vector)this.linkList.clone();
    }

    public List getSwitches() {
        return (List)this.switchList.clone();
    }

    public synchronized boolean removeLink(FabricLink fabricLink) {
        if (this.exists(fabricLink)) {
            this.linkList.remove(fabricLink);
            this.fireEvent(2005, fabricLink);
            return true;
        }
        return false;
    }

    public InetAddress getIpAddr() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(this.ipAddr.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        return inetAddress;
    }

    public String getFabricName() {
        return this.name;
    }

    public float getPollingMultiplier() {
        return this.defPollTOVs[3] / 20000L;
    }

    public synchronized void setPollingMultiplier(float f) {
        this.defPollTOVs[0] = (long)(30000.0f * f);
        this.defPollTOVs[1] = (long)(1000.0f * f);
        this.defPollTOVs[2] = (long)(15000.0f * f);
        this.defPollTOVs[3] = (long)(20000.0f * f);
        this.defPollTOVs[4] = (long)(35000.0f * f);
        this.defPollTOVs[5] = (long)(45000.0f * f);
        this.defPollTOVs[6] = (long)(120000.0f * f);
        Iterator iterator = this.pollingTargets.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                PollingItem pollingItem = (PollingItem)iterator2.next();
                if (!pollingItem.isRepeating()) continue;
                pollingItem.setInterval(Fabric.getDefPollInterval(this.defPollTOVs, pollingItem));
            }
        }
        this.pollEvents.setIntervals(this.defPollTOVs);
    }

    public static long getDefPollInterval(long[] lArray, PollingItem pollingItem) {
        switch (pollingItem.getAction().getEvent()) {
            case 212: {
                return lArray[7];
            }
            case 221: {
                return lArray[5];
            }
            case 222: {
                return lArray[4];
            }
            case 219: {
                return lArray[2];
            }
            case 241: {
                return lArray[6];
            }
            case 2010: {
                return lArray[0];
            }
        }
        return lArray[3];
    }

    public synchronized void setPollingInterval(Pollable pollable, int n, long l) {
        List list;
        if (!this.pollEvents.setInterval(pollable, n, l) && (list = (List)this.pollingTargets.get(pollable)) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PollingItem pollingItem = (PollingItem)iterator.next();
                if (pollingItem.getAction().getEvent() != n) continue;
                pollingItem.setInterval(l);
                return;
            }
        }
    }

    public synchronized long getPollingInterval(Pollable pollable, int n) {
        List list;
        long l = this.pollEvents.getInterval(pollable, n);
        if (l == -1L && (list = (List)this.pollingTargets.get(pollable)) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PollingItem pollingItem = (PollingItem)iterator.next();
                if (pollingItem.getAction().getEvent() != n) continue;
                return pollingItem.getInterval();
            }
        }
        return l;
    }

    public int switchCount() {
        return this.switchList.size();
    }

    public int linkCount() {
        return this.linkList.size();
    }

    public void setFabricName(String string) {
        this.name = string;
    }

    public synchronized void enablePolling() {
        this.stopMapping();
        this.pollEvents.enable();
    }

    public synchronized void disablePolling() {
        this.stopMapping();
        this.pollEvents.disable();
    }

    public synchronized void setPollingFilter(int[] nArray) {
        this.pollingFilter = nArray;
    }

    public synchronized int[] getPollingFilter() {
        return this.pollingFilter;
    }

    public synchronized void pingOnly(boolean bl) {
        int[] nArray;
        this.stopMapping();
        if (bl) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 212;
        } else {
            nArray = null;
        }
        this.pollingFilter = nArray;
    }

    public synchronized void perfmonPollingOnly(boolean bl) {
        if (!bl) {
            this.pollingFilter = null;
            return;
        }
        int[] nArray = new int[]{212, 200, 253, 240, 201, 329, 269, 356, 318, 230, 232, 2010};
        Arrays.sort(nArray);
        this.pollingFilter = nArray;
    }

    public String toString() {
        String string = this.name;
        if (this.statusReason != null) {
            string = string + " " + this.statusReason;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Fabric)) {
            return false;
        }
        return this.name.equals(((Fabric)object).getFabricName());
    }

    public synchronized boolean isMixedFabric() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = this.switchList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Sanbox) {
                bl = true;
            } else if (e instanceof Sanbox2) {
                bl2 = true;
            }
            if (bl3 = bl && bl2) break;
        }
        return bl3;
    }

    public synchronized boolean hasSanbox() {
        Iterator iterator = this.switchList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Sanbox)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasSanbox2() {
        Iterator iterator = this.switchList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Sanbox2) && !(e instanceof Sanbox8000)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidDomainID(int n, int n2) {
        if (n2 == n) {
            return true;
        }
        return this.isUniqueDomainID(n, n2) && n2 >= this.minValidDomainID() && n2 <= this.maxValidDomainID();
    }

    public boolean isUniqueDomainID(int n, int n2) {
        if (n2 == n) {
            return true;
        }
        return this.getSwitchByDomainID(n2) == null;
    }

    public int minValidDomainID() {
        SanboxChassis sanboxChassis;
        if (this.hasSanbox() && (sanboxChassis = this.getConnectionSwitch()) != null) {
            int n = sanboxChassis.getDomainId() & 0xF0;
            return n == 0 ? 1 : n;
        }
        return 1;
    }

    public int maxValidDomainID() {
        if (this.hasSanbox()) {
            int n = this.minValidDomainID();
            return n == 1 ? 15 : n + 15;
        }
        return 239;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(FabricEventListener fabricEventListener) {
        if (fabricEventListener == null) {
            return;
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(fabricEventListener)) {
                this.listeners.add(fabricEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(FabricEventListener fabricEventListener) {
        if (fabricEventListener == null) {
            return;
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.contains(fabricEventListener)) {
                this.listeners.remove(fabricEventListener);
            }
        }
    }

    public void fireEvent(int n) {
        this.fireEvent(n, null);
    }

    public void fireEvent(int n, Object object) {
        FabricEvent fabricEvent = new FabricEvent(this, n, object);
        Vector vector = (Vector)this.listeners.clone();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ((FabricEventListener)iterator.next()).receiveEvent(fabricEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean calculateOverallStatus() {
        int n = this.overallStatus;
        int n2 = 0;
        Chassis chassis = this.getConnectionSwitch();
        if (chassis == null) {
            return false;
        }
        int n3 = 0;
        int n4 = -1;
        this.statusReason = null;
        Fabric fabric = this;
        synchronized (fabric) {
            int n5;
            int n6 = 0;
            int n7 = this.switchList.size();
            while (n6 < n7) {
                ZoningConfig zoningConfig;
                chassis = (Chassis)this.switchList.get(n6);
                n5 = chassis.getOverallStatus();
                if (n5 == 3) {
                    if (chassis.getDiscoveredByIpAddress()) {
                        n2 = Math.max(n2, 3);
                        break;
                    }
                    if (!(chassis instanceof ForeignSwitch) || chassis.getWWName().getCompanyId() == 49373) {
                        n2 = Math.max(n2, 1);
                    }
                } else if (n5 == 2) {
                    n2 = Math.max(n2, 2);
                    break;
                }
                if (n3 == 0) {
                    if (chassis instanceof SanboxChassis) {
                        n3 = ((SanboxChassis)chassis).getSecurityEnabled();
                    }
                } else if (chassis instanceof SanboxChassis && ((SanboxChassis)chassis).getSecurityEnabled() != 0 && n3 != ((SanboxChassis)chassis).getSecurityEnabled()) {
                    n2 = Math.max(n2, 2);
                    this.addStatus(DeviceUtilities.getResource("Fabric.inconsistentSecurity"));
                }
                if (chassis instanceof SanboxChassis && (zoningConfig = ((SanboxChassis)chassis).getZoningConfig()) != null) {
                    if (n4 == -1) {
                        n4 = zoningConfig.getDefaultVisibility();
                    } else if (chassis instanceof SanboxChassis && zoningConfig.getDefaultVisibility() != -1 && n4 != zoningConfig.getDefaultVisibility()) {
                        n2 = Math.max(n2, 2);
                        this.addStatus(DeviceUtilities.getResource("Fabric.inconsistentZoningConfig"));
                    }
                }
                ++n6;
            }
            if (n2 == 0) {
                int n8 = 0;
                int n9 = this.linkList.size();
                while (n8 < n9) {
                    n5 = ((FabricLink)this.linkList.get(n8)).getState();
                    if (n5 == 2 || n5 == 3) {
                        n2 = Math.max(n2, 1);
                        break;
                    }
                    ++n8;
                }
            }
        }
        this.overallStatus = n2;
        if (n != this.overallStatus) {
            this.fireEvent(2001, new Integer(this.overallStatus));
            return true;
        }
        return false;
    }

    private void addStatus(String string) {
        if (this.statusReason == null) {
            this.statusReason = string;
            return;
        }
        if (this.statusReason.indexOf(string) < 0) {
            this.statusReason = this.statusReason + string;
        }
    }

    public int getOverallStatus() {
        return this.overallStatus;
    }

    private synchronized void updateAllSwitchStatus() {
        Iterator iterator = this.switchList.iterator();
        while (iterator.hasNext()) {
            ((Chassis)iterator.next()).calculateOverallStatus();
        }
    }

    public long now() {
        return System.currentTimeMillis() + 1L;
    }

    public List getUpdaters() {
        return this.updaters;
    }

    public Updater getUpdater(int n) {
        List list = this.getUpdaters();
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            Updater updater = (Updater)list.get(n2);
            if (updater.getEvent() == n) {
                return updater;
            }
            --n2;
        }
        return null;
    }

    private void createUpdaters() {
        this.updaters = new Vector();
        this.updaters.add(new Updater(){

            public int getEvent() {
                return 2010;
            }

            public boolean update() {
                return Fabric.this.mapFabric();
            }
        });
    }

    public void closeSessions() {
        this.fireEvent(2020);
    }

    private void doCloseSessions() {
        this.closingSessions = true;
        this.stopMapping();
        this.disablePolling();
        this.sessionsToClose = 0;
        this.sessionCloseFails = new Vector();
        this.comAgent.flushTheQueue();
        Iterator iterator = this.switchList.iterator();
        while (iterator.hasNext()) {
            Chassis chassis = (Chassis)iterator.next();
            if (chassis instanceof Sanbox2) {
                if (((Sanbox2)chassis).closeMgmtSession()) {
                    ++this.sessionsToClose;
                    continue;
                }
                this.sessionCloseFails.add(chassis);
                continue;
            }
            if (!(chassis instanceof Sanbox8000)) continue;
            if (((Sanbox8000)chassis).closeMgmtSession()) {
                ++this.sessionsToClose;
                continue;
            }
            this.sessionCloseFails.add(chassis);
        }
    }

    public void enableSessionTimer(boolean bl) {
        Iterator iterator = this.switchList.iterator();
        while (iterator.hasNext()) {
            Chassis chassis = (Chassis)iterator.next();
            if (!(chassis instanceof Sanbox2)) continue;
            ((Sanbox2)chassis).applySessionTimer(bl);
        }
    }
}

