/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DeviceUtilities {
    private static final ResourceBundle resources = ResourceBundle.getBundle("Device");

    public static String getResource(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static Element getSubElement(Element element, String string) {
        return DeviceUtilities.getSubElement(element, string, 0);
    }

    public static Element getSubElement(Element element, String string, int n) {
        NodeList nodeList = element.getElementsByTagName(string);
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            if (nodeList.item(n2) instanceof Element && --n < 0) {
                return (Element)nodeList.item(n2);
            }
            ++n2;
        }
        return null;
    }

    public static String getData(Element element, String string) throws IOException {
        return DeviceUtilities.getData(element, string, 0);
    }

    public static String getData(Element element, String string, int n) throws IOException {
        Element element2 = DeviceUtilities.getSubElement(element, string, n);
        if (element2 == null) {
            throw new IOException("failed parsing <" + string + "> tag");
        }
        short s = element2.getNodeType();
        NodeList nodeList = element2.getChildNodes();
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            if (nodeList.item(n2).getNodeType() == 3) {
                Node node = nodeList.item(n2);
                String string2 = node.getNodeValue();
                return DeviceUtilities.stripWhiteSpace(string2);
            }
            ++n2;
        }
        return null;
    }

    public static String getData(Element element) throws IOException {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3) {
                Text text = (Text)node;
                String string = text.getNodeValue();
                return DeviceUtilities.stripWhiteSpace(string);
            }
            node = node.getNextSibling();
        }
        return null;
    }

    private static String stripWhiteSpace(String string) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c != ' ' && c != '\n') {
                if (n < 0) {
                    n = n3;
                }
                n2 = n3;
            }
            ++n3;
        }
        return string.substring(n, n2 + 1);
    }
}

