/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.topology;

import com.qlogic.ui.Topology;
import com.qlogic.ui.topology.AbstractTopologyLayout;
import com.qlogic.ui.topology.TopologyNode;

public class DefaultTopologyLayout
extends AbstractTopologyLayout {
    protected static final int DEFAULT_NODE_SPACING = 96;
    protected int nextX;
    protected int nextY;

    public DefaultTopologyLayout(Topology topology) {
        super(topology);
    }

    protected void initializeLayout() {
        this.nextX = 48;
        this.nextY = 48;
    }

    public void layoutNode(TopologyNode topologyNode) {
        int n = Math.max(this.getTopology().getMinimumSize().width, this.getTopology().getVisibleRect().width);
        if (this.nextX > n - 48) {
            this.nextX = 48;
            this.nextY += 96;
        }
        topologyNode.setLocation(this.nextX, this.nextY);
        this.nextX += 96;
    }

    protected void snapToPosition(TopologyNode topologyNode) {
        int n = topologyNode.getX() - topologyNode.getX() % 96 + 48;
        int n2 = topologyNode.getY() - topologyNode.getY() % 96 + 48;
        topologyNode.setLocation(n, n2);
    }

    protected int compareNodes(TopologyNode topologyNode, TopologyNode topologyNode2) {
        if (topologyNode.getY() < topologyNode2.getY()) {
            return -1;
        }
        if (topologyNode.getY() > topologyNode2.getY()) {
            return 1;
        }
        if (topologyNode.getX() < topologyNode2.getX()) {
            return -1;
        }
        if (topologyNode.getX() > topologyNode2.getX()) {
            return 1;
        }
        return 0;
    }
}

