/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.eventBrowser;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.SortedSet;

class AvlTree
extends AbstractSet
implements SortedSet,
Iterator {
    Comparator comparator = null;
    TreeNode root = null;
    private ArrayList path = new ArrayList();

    public AvlTree() {
    }

    public AvlTree(Comparator comparator) {
        this.comparator = comparator;
    }

    public AvlTree(Collection collection) {
        this.addAll(collection);
    }

    public AvlTree(SortedSet sortedSet) {
        this.comparator = sortedSet.comparator();
        this.addAll(sortedSet);
    }

    public boolean hasNext() {
        return this.path.size() > 0;
    }

    public Object next() {
        int n = this.path.size() - 1;
        TreeNode treeNode = (TreeNode)this.path.get(n);
        if (treeNode.right != null) {
            TreeNode treeNode2 = treeNode.right;
            while (treeNode2 != null) {
                this.path.add(treeNode2);
                treeNode2 = treeNode2.left;
            }
        } else {
            Object object;
            do {
                this.path.remove(n--);
            } while (this.path.size() > 0 && this.compare(treeNode.value, object = ((TreeNode)this.path.get((int)n)).value) >= 0);
        }
        return treeNode.value;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void resetIteration() {
        this.resetIteration(0);
    }

    private void resetIteration(int n) {
        int n2 = n;
        this.path.clear();
        TreeNode treeNode = this.root;
        while (true) {
            if (treeNode == null) {
                this.path.clear();
                throw new NoSuchElementException(Integer.toString(n));
            }
            this.path.add(treeNode);
            if (n2 == treeNode.leftCount) {
                return;
            }
            if (n2 < treeNode.leftCount) {
                treeNode = treeNode.left;
                continue;
            }
            n2 -= treeNode.leftCount + 1;
            treeNode = treeNode.right;
        }
    }

    int compare(Object object, Object object2) {
        if (this.comparator == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return this.comparator.compare(object, object2);
    }

    public Object get(int n) {
        if (this.root == null) {
            return new NoSuchElementException();
        }
        return this.root.get(n);
    }

    public int indexOf(Object object) {
        try {
            return this.root.indexOf(object);
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException(object.toString());
        }
    }

    public boolean add(Object object) {
        if (this.root == null) {
            this.root = new TreeNode(object);
            return true;
        }
        return this.root.insert(object);
    }

    public Iterator iterator() {
        this.resetIteration();
        return this;
    }

    public int size() {
        return this.root == null ? 0 : this.root.size();
    }

    public boolean contains(Object object) {
        try {
            this.root.indexOf(object);
            return true;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean remove(Object object) {
        if (this.root == null) {
            return false;
        }
        if (this.compare(this.root.value, object) == 0 && this.root.depth == 1) {
            this.root = null;
            return true;
        }
        return this.root.remove(object);
    }

    public void clear() {
        this.root = null;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public SortedSet subSet(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    public SortedSet headSet(Object object) {
        AvlTree avlTree = new AvlTree(this.comparator());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.compare(e, object) >= 0) break;
            avlTree.add(e);
        }
        return avlTree;
    }

    public SortedSet tailSet(Object object) {
        throw new UnsupportedOperationException();
    }

    public Object first() {
        return this.get(0);
    }

    public Object last() {
        return this.get(this.size() - 1);
    }

    public String toString() {
        if (this.root == null) {
            return "[]";
        }
        return this.root.toString();
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        Random random = new Random();
        AvlTree avlTree = new AvlTree();
        int n3 = 0;
        while (n3 < 100) {
            Integer n4 = new Integer(random.nextInt(15));
            if (avlTree.add(n4)) {
                ++n;
            } else {
                avlTree.remove(n4);
                ++n2;
            }
            ++n3;
        }
        System.out.println(avlTree);
        Iterator iterator = avlTree.iterator();
        System.out.print("[ ");
        while (iterator.hasNext()) {
            System.out.print(iterator.next().toString() + " ");
        }
        System.out.println("]");
    }

    private class TreeNode {
        Object value;
        TreeNode left;
        TreeNode right;
        int leftCount;
        int rightCount;
        int depth;

        public TreeNode(Object object) {
            this.value = object;
            this.right = null;
            this.left = null;
            this.rightCount = 0;
            this.leftCount = 0;
            this.depth = 1;
        }

        private void rotateLeft() {
            TreeNode treeNode = this.right;
            Object object = this.value;
            this.value = treeNode.value;
            treeNode.value = object;
            this.right = treeNode.right;
            this.rightCount = treeNode.rightCount;
            treeNode.right = treeNode.left;
            treeNode.rightCount = treeNode.leftCount;
            treeNode.left = this.left;
            treeNode.leftCount = this.leftCount;
            this.left = treeNode;
            this.leftCount = this.left.size();
            this.left.recomputeDepth();
            this.recomputeDepth();
        }

        private void rotateRight() {
            TreeNode treeNode = this.left;
            Object object = this.value;
            this.value = treeNode.value;
            treeNode.value = object;
            this.left = treeNode.left;
            this.leftCount = treeNode.leftCount;
            treeNode.left = treeNode.right;
            treeNode.leftCount = treeNode.rightCount;
            treeNode.right = this.right;
            treeNode.rightCount = this.rightCount;
            this.right = treeNode;
            this.rightCount = this.right.size();
            this.right.recomputeDepth();
            this.recomputeDepth();
        }

        private int recomputeDepth() {
            this.depth = this.left == null && this.right == null ? 1 : (this.left == null && this.right != null ? 1 + this.right.depth : (this.left != null && this.right == null ? 1 + this.left.depth : 1 + Math.max(this.left.depth, this.right.depth)));
            return this.depth;
        }

        private void balance() {
            this.recomputeDepth();
            if (this.left != null && (this.right == null || this.left.depth > this.right.depth + 1)) {
                if (this.left.right != null && (this.left.left == null || this.left.right.depth > this.left.left.depth)) {
                    this.left.rotateLeft();
                }
                this.rotateRight();
            } else if (this.right != null && (this.left == null || this.right.depth > this.left.depth + 1)) {
                if (this.right.left != null && (this.right.right == null || this.right.left.depth > this.right.right.depth)) {
                    this.right.rotateRight();
                }
                this.rotateLeft();
            }
        }

        public int size() {
            return this.leftCount + this.rightCount + 1;
        }

        public boolean insert(Object object) {
            int n = AvlTree.this.compare(object, this.value);
            if (n == 0) {
                return false;
            }
            if (n < 0) {
                if (this.left == null) {
                    this.left = new TreeNode(object);
                    this.leftCount = 1;
                    if (this.right == null) {
                        this.depth = 2;
                    }
                    return true;
                }
                if (this.left.insert(object)) {
                    ++this.leftCount;
                    this.balance();
                    return true;
                }
                return false;
            }
            if (this.right == null) {
                this.right = new TreeNode(object);
                this.rightCount = 1;
                if (this.left == null) {
                    this.depth = 2;
                }
                return true;
            }
            if (this.right.insert(object)) {
                ++this.rightCount;
                this.balance();
                return true;
            }
            return false;
        }

        public boolean remove(Object object) {
            int n = AvlTree.this.compare(object, this.value);
            if (n == 0) {
                if (this.left != null) {
                    if (this.right == null || this.left.depth > this.right.depth) {
                        this.rotateRight();
                    } else {
                        this.rotateLeft();
                    }
                } else if (this.right != null) {
                    this.rotateLeft();
                } else {
                    throw new IllegalStateException(object.toString());
                }
                return this.remove(object);
            }
            if (n < 0) {
                if (this.left == null) {
                    return false;
                }
                if (AvlTree.this.compare(this.left.value, object) == 0 && this.left.depth == 1) {
                    this.left = null;
                    this.leftCount = 0;
                } else {
                    this.left.remove(object);
                    --this.leftCount;
                }
            } else {
                if (this.right == null) {
                    return false;
                }
                if (this.right.value.equals(object) && this.right.depth == 1) {
                    this.right = null;
                    this.rightCount = 0;
                } else {
                    this.right.remove(object);
                    --this.rightCount;
                }
            }
            this.balance();
            return true;
        }

        public int indexOf(Object object) {
            try {
                int n = AvlTree.this.compare(object, this.value);
                if (n < 0) {
                    return this.left.indexOf(object);
                }
                if (n == 0) {
                    return this.leftCount;
                }
                return this.leftCount + 1 + this.right.indexOf(object);
            }
            catch (NullPointerException nullPointerException) {
                throw new NoSuchElementException(object.toString());
            }
        }

        public Object get(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == this.leftCount) {
                return this.value;
            }
            if (n < this.leftCount) {
                return this.left.get(n);
            }
            if (this.right != null) {
                return this.right.get(n - this.leftCount - 1);
            }
            throw new NoSuchElementException();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[ ");
            if (this.left != null) {
                stringBuffer.append(this.left.toString());
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.value.toString());
            stringBuffer.append(" ");
            if (this.right != null) {
                stringBuffer.append(this.right.toString());
                stringBuffer.append(" ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

