/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.ui.topology.DefaultTopologyLinkRenderer;
import com.qlogic.ui.topology.DefaultTopologyModel;
import com.qlogic.ui.topology.DefaultTopologyNodeRenderer;
import com.qlogic.ui.topology.DefaultTopologySelectionModel;
import com.qlogic.ui.topology.TopologyEvent;
import com.qlogic.ui.topology.TopologyGridLayout;
import com.qlogic.ui.topology.TopologyLayout;
import com.qlogic.ui.topology.TopologyLink;
import com.qlogic.ui.topology.TopologyLinkRenderer;
import com.qlogic.ui.topology.TopologyListener;
import com.qlogic.ui.topology.TopologyMenuManager;
import com.qlogic.ui.topology.TopologyModel;
import com.qlogic.ui.topology.TopologyNode;
import com.qlogic.ui.topology.TopologyNodeRenderer;
import com.qlogic.ui.topology.TopologySelectionEvent;
import com.qlogic.ui.topology.TopologySelectionListener;
import com.qlogic.ui.topology.TopologySelectionModel;
import com.qlogic.ui.topology.TopologyUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.PanelUI;

public class Topology
extends JPanel
implements TopologyListener,
TopologySelectionListener,
Scrollable {
    private static final int MAX_BUF = 65535;
    public static final int DEFAULT_GRID_SIZE = 16;
    public static final int MAXIMUM_GRID_SIZE = 128;
    TopologyModel model;
    Hashtable nodelist = new Hashtable();
    TopologySelectionModel selectionModel;
    TopologyNode focusNode;
    TopologyLayout layout = new TopologyGridLayout(this);
    boolean snapToPosition = false;
    int gridSize = 16;
    boolean dragEnabled = true;
    boolean autoLayout = false;
    Hashtable defaultRenderers = new Hashtable();
    Hashtable nodeRenderers = new Hashtable();
    TopologyNodeRenderer defaultNodeRenderer;
    TopologyLinkRenderer linkRenderer;
    Hashtable defaultMenuManagers = new Hashtable();
    Hashtable menuManagers = new Hashtable();
    TopologyMenuManager backgroundMenuManager;
    protected EventListenerList actionListenerList = new EventListenerList();
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$lang$Object;

    public Topology(TopologyModel topologyModel) {
        this.setBackground(Color.white);
        this.createDefaultRenderers();
        this.setUI(new TopologyUI(this));
        this.setSelectionModel(new DefaultTopologySelectionModel());
        this.setModel(topologyModel);
    }

    public Topology() {
        this(new DefaultTopologyModel());
    }

    protected void rebuildNodeList() {
        this.nodelist.clear();
        if (this.model != null) {
            int n = 0;
            while (n < this.model.getNodeCount()) {
                this.insertNode(this.model.nodeAtIndex(n));
                ++n;
            }
        }
    }

    public Dimension getVisibleSize() {
        return this.getSize();
    }

    public PanelUI getUI() {
        return (PanelUI)this.ui;
    }

    public void setUI(TopologyUI topologyUI) {
        super.setUI(topologyUI);
    }

    public void updateUI() {
        this.setUI(new TopologyUI(this));
    }

    public boolean isSnapToPositionEnabled() {
        return this.snapToPosition;
    }

    public void setSnapToPosition(boolean bl) {
        this.snapToPosition = bl;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public boolean isAutoLayoutEnabled() {
        return this.autoLayout;
    }

    public void setAutoLayout(boolean bl) {
        this.autoLayout = bl;
    }

    public boolean hasFocus(TopologyNode topologyNode) {
        return this.focusNode == topologyNode;
    }

    public void setFocus(TopologyNode topologyNode) {
        this.focusNode = topologyNode;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension == null) {
            dimension = new Dimension(400, 300);
        }
        return dimension;
    }

    public void addTopologyActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = Topology.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeTopologyActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = Topology.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    protected void fireAction(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener == null ? Topology.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    public void activateObject(Object object) {
        if (object instanceof TopologyNode) {
            object = ((TopologyNode)object).getObject();
        }
        ActionEvent actionEvent = new ActionEvent(object, 1001, "Activate " + object.toString());
        this.fireAction(actionEvent);
    }

    public TopologyLayout getTopologyLayout() {
        return this.layout;
    }

    public void setTopologyLayout(TopologyLayout topologyLayout) {
        this.layout = topologyLayout;
        this.layoutAllNodes();
    }

    public void layoutNode(TopologyNode topologyNode) {
        this.layout.layoutNode(topologyNode);
        this.repaint();
    }

    public void layoutNodeAt(TopologyNode topologyNode, int n, int n2) {
        this.layout.layoutNodeAt(topologyNode, n, n2);
        this.repaint();
    }

    public void layoutAllNodes() {
        this.layout.layoutAllNodes();
        this.repaint();
    }

    protected void createDefaultRenderers() {
        this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = Topology.class$("java.lang.Object")) : class$java$lang$Object, new DefaultTopologyNodeRenderer());
        this.setTopologyLinkRenderer(new DefaultTopologyLinkRenderer(this));
    }

    public TopologyNodeRenderer getNodeRenderer(Object object) {
        if (object == null) {
            return null;
        }
        Object v = this.nodeRenderers.get(object);
        if (v != null) {
            return (TopologyNodeRenderer)v;
        }
        return this.getDefaultRenderer(object.getClass());
    }

    public Component getNodeRenderer(TopologyNode topologyNode) {
        if (topologyNode == null) {
            return null;
        }
        TopologyNodeRenderer topologyNodeRenderer = this.getNodeRenderer(topologyNode.getObject());
        return this.prepareRenderer(topologyNodeRenderer, topologyNode);
    }

    public Component getNodeRenderer(TopologyNode topologyNode, boolean bl) {
        if (topologyNode == null) {
            return null;
        }
        TopologyNodeRenderer topologyNodeRenderer = this.getNodeRenderer(topologyNode.getObject());
        if (bl) {
            return this.prepareRenderer(topologyNodeRenderer, topologyNode);
        }
        return (Component)((Object)topologyNodeRenderer);
    }

    public void setNodeRenderer(Object object, TopologyNodeRenderer topologyNodeRenderer) {
        if (topologyNodeRenderer != null) {
            this.nodeRenderers.put(object, topologyNodeRenderer);
        } else {
            this.nodeRenderers.remove(object);
        }
    }

    public TopologyNodeRenderer getDefaultRenderer(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object object = this.defaultRenderers.get(clazz);
        if (object != null) {
            return (TopologyNodeRenderer)object;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            object = this.getDefaultRenderer(classArray[n]);
            if (object != null) {
                return (TopologyNodeRenderer)object;
            }
            ++n;
        }
        if (clazz != (class$java$lang$Object == null ? (class$java$lang$Object = Topology.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getDefaultRenderer(clazz.getSuperclass());
        }
        return null;
    }

    public void setDefaultRenderer(Class clazz, TopologyNodeRenderer topologyNodeRenderer) {
        if (topologyNodeRenderer != null) {
            this.defaultRenderers.put(clazz, topologyNodeRenderer);
        } else {
            this.defaultRenderers.remove(clazz);
        }
    }

    public Component prepareRenderer(TopologyNodeRenderer topologyNodeRenderer, Object object) {
        if (object == null) {
            return null;
        }
        return this.prepareRenderer(topologyNodeRenderer, this.getTopologyNode(object));
    }

    public Component prepareRenderer(TopologyNodeRenderer topologyNodeRenderer, TopologyNode topologyNode) {
        if (topologyNode == null) {
            return null;
        }
        return topologyNodeRenderer.getTopologyNodeRendererComponent(this, topologyNode, this.selectionModel.isSelected(topologyNode), this.hasFocus(topologyNode));
    }

    public TopologyLinkRenderer getTopologyLinkRenderer() {
        return this.linkRenderer;
    }

    public void setTopologyLinkRenderer(TopologyLinkRenderer topologyLinkRenderer) {
        if (topologyLinkRenderer == null) {
            topologyLinkRenderer = new DefaultTopologyLinkRenderer(this);
        }
        this.linkRenderer = topologyLinkRenderer;
    }

    public TopologyModel getModel() {
        return this.model;
    }

    public void setModel(TopologyModel topologyModel) {
        TopologyModel topologyModel2 = this.getModel();
        if (topologyModel2 != null) {
            this.removeAllNodes();
            topologyModel2.removeTopologyListener(this);
        }
        this.model = topologyModel;
        if (topologyModel != null) {
            topologyModel.addTopologyListener(this);
        }
        this.rebuildNodeList();
    }

    public TopologyNode getTopologyNode(Object object) {
        return (TopologyNode)this.nodelist.get(object);
    }

    public Vector getTopologyNodeList() {
        Vector<TopologyNode> vector = new Vector<TopologyNode>();
        int n = 0;
        while (n < this.getNodeCount()) {
            vector.addElement(this.getTopologyNodeAtIndex(n));
            ++n;
        }
        return vector;
    }

    public TopologyNode getTopologyNodeAtIndex(int n) {
        return this.getTopologyNode(this.getNodeAtIndex(n));
    }

    public Point getNodeLocation(Object object) {
        return this.getTopologyNode(object).getLocation();
    }

    public TopologyNode getLinkEndPoint1(TopologyLink topologyLink) {
        return this.getTopologyNode(topologyLink.getEndPoint1());
    }

    public TopologyNode getLinkEndPoint2(TopologyLink topologyLink) {
        return this.getTopologyNode(topologyLink.getEndPoint2());
    }

    public void moveNode(TopologyNode topologyNode, int n, int n2) {
        topologyNode.setLocationDelta(n, n2);
        this.repaint();
    }

    public void reindexTopologyNode(TopologyNode topologyNode, int n) {
        this.model.reindexNode(topologyNode.getObject(), n);
    }

    /*
     * Unable to fully structure code
     */
    public void removeAllNodes() {
        block1: {
            if (!(this.model instanceof DefaultTopologyModel)) ** GOTO lbl5
            ((DefaultTopologyModel)this.model).removeAllNodes();
            break block1;
lbl-1000:
            // 1 sources

            {
                this.model.removeNodeAtIndex(0);
lbl5:
                // 2 sources

                ** while (this.getNodeCount() > 0)
            }
        }
    }

    public int getNodeCount() {
        return this.model.getNodeCount();
    }

    public int getLinkCount() {
        return this.model.getLinkCount();
    }

    public Object getNodeAtIndex(int n) {
        return this.model.nodeAtIndex(n);
    }

    public TopologyLink getLinkAtIndex(int n) {
        return this.model.linkAtIndex(n);
    }

    public boolean isEditable() {
        return true;
    }

    public TopologyLink[] getNodeLinks(Object object) {
        return this.model.getNodeLinks(object);
    }

    public void addNode(Object object) {
        this.model.addNode(object);
    }

    public void addNode(Object object, Point point) {
        TopologyNode topologyNode = new TopologyNode(object);
        topologyNode.setLocation(point);
        this.nodelist.put(object, topologyNode);
        this.model.addNode(object);
    }

    public void addNode(Object object, int n, int n2) {
        this.addNode(object, new Point(n, n2));
    }

    public void reindexNode(Object object, int n) {
        this.model.reindexNode(object, n);
    }

    public void removeNode(Object object) {
        this.model.removeNode(object);
    }

    public void removeTopologyNode(TopologyNode topologyNode) {
        this.model.removeNode(topologyNode.getObject());
    }

    public void addLink(TopologyLink topologyLink) {
        this.model.addLink(topologyLink);
    }

    public void removeLink(TopologyLink topologyLink) {
        this.model.removeLink(topologyLink);
    }

    protected void insertNode(Object object) {
        if (this.nodelist.containsKey(object)) {
            return;
        }
        TopologyNode topologyNode = new TopologyNode(object);
        this.nodelist.put(object, topologyNode);
        if (this.layout != null) {
            this.layout.layoutNode(topologyNode);
        }
    }

    protected void deleteNode(Object object) {
        if (!this.nodelist.containsKey(object)) {
            return;
        }
        TopologyNode topologyNode = (TopologyNode)this.nodelist.get(object);
        this.selectionModel.removeSelection(topologyNode);
        this.nodeRenderers.remove(object);
        this.nodelist.remove(object);
    }

    protected void insertLink(TopologyLink topologyLink) {
    }

    protected void deleteLink(TopologyLink topologyLink) {
        this.selectionModel.removeSelection(topologyLink);
    }

    public void topologyChanged(TopologyEvent topologyEvent) {
        if (topologyEvent != null) {
            Object object = topologyEvent.getObject();
            int n = topologyEvent.getType();
            if (object instanceof TopologyLink) {
                if (n != 1) {
                    if (n == 2) {
                        this.insertLink((TopologyLink)object);
                    } else if (n == 3) {
                        this.deleteLink((TopologyLink)object);
                    } else if (n != 4) {
                        if (n == 5) {
                            // empty if block
                        }
                    }
                }
            } else if (n != 1) {
                if (n == 2) {
                    this.insertNode(object);
                } else if (n == 3) {
                    this.deleteNode(object);
                } else if (n != 4) {
                    if (n == 5) {
                        // empty if block
                    }
                }
            }
        }
        this.repaint();
    }

    public TopologySelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(TopologySelectionModel topologySelectionModel) {
        if (this.selectionModel != null) {
            this.selectionModel.removeSelectionListener(this);
        }
        if (topologySelectionModel != null) {
            topologySelectionModel.addSelectionListener(this);
        }
        this.selectionModel = topologySelectionModel;
    }

    public void selectionChanged(TopologySelectionEvent topologySelectionEvent) {
        this.repaint();
    }

    public int getSelectionCount() {
        if (this.selectionModel == null) {
            return 0;
        }
        return this.selectionModel.getCount();
    }

    public Vector getSelectionList() {
        if (this.selectionModel == null) {
            return new Vector();
        }
        Vector vector = this.selectionModel.getSelectionList();
        Vector vector2 = new Vector(vector.size());
        int n = 0;
        while (n < vector.size()) {
            Object object = vector.elementAt(n);
            if (object instanceof TopologyNode) {
                object = ((TopologyNode)object).getObject();
            }
            vector2.add(object);
            ++n;
        }
        return vector2;
    }

    public boolean isSelected(Object object) {
        if (this.selectionModel == null) {
            return false;
        }
        if (!(object instanceof TopologyLink)) {
            object = this.getTopologyNode(object);
        }
        return this.selectionModel.isSelected(object);
    }

    public Object getSelection() {
        if (this.selectionModel == null) {
            throw new NoSuchElementException("No selection model defined");
        }
        Object object = this.selectionModel.getSelection();
        if (object instanceof TopologyNode) {
            object = ((TopologyNode)object).getObject();
        }
        return object;
    }

    public void setSelection(Object object) {
        if (this.selectionModel == null) {
            throw new IllegalArgumentException("No selection model defined");
        }
        if (!(object instanceof TopologyLink)) {
            object = this.getTopologyNode(object);
        }
        this.selectionModel.setSelection(object);
    }

    public void addSelection(Object object) {
        if (this.selectionModel == null) {
            throw new IllegalArgumentException("No selection model defined");
        }
        if (!(object instanceof TopologyLink)) {
            object = this.getTopologyNode(object);
        }
        this.selectionModel.addSelection(object);
    }

    public void removeSelection(Object object) {
        if (this.selectionModel == null) {
            return;
        }
        if (!(object instanceof TopologyLink)) {
            object = this.getTopologyNode(object);
        }
        this.selectionModel.removeSelection(object);
    }

    public void addSelectionList(Vector vector) {
        if (this.selectionModel == null) {
            throw new IllegalStateException("No selection model defined");
        }
        Vector vector2 = new Vector(vector.size());
        int n = 0;
        while (n < vector.size()) {
            Object object = vector.elementAt(n);
            if (object instanceof TopologyNode) {
                object = ((TopologyNode)object).getObject();
            }
            vector2.add(object);
            ++n;
        }
        this.selectionModel.addSelectionList(vector2);
    }

    public void selectAllNodes() {
        if (this.selectionModel == null) {
            throw new IllegalStateException("No selection model defined");
        }
        Vector<TopologyNode> vector = new Vector<TopologyNode>();
        int n = 0;
        while (n < this.model.getNodeCount()) {
            vector.addElement(this.getTopologyNode(this.model.nodeAtIndex(n)));
            ++n;
        }
        this.selectionModel.setSelectionList(vector);
    }

    public void selectAllLinks() {
        if (this.selectionModel == null) {
            throw new IllegalStateException("No selection model defined");
        }
        Vector<TopologyLink> vector = new Vector<TopologyLink>();
        int n = 0;
        while (n < this.model.getLinkCount()) {
            vector.addElement(this.model.linkAtIndex(n));
            ++n;
        }
        this.selectionModel.setSelectionList(vector);
    }

    public void clearSelection() {
        if (this.selectionModel.getCount() > 0) {
            this.selectionModel.clearSelection();
        }
    }

    public void toggleSelection(Object object) {
        if (this.isSelected(object)) {
            this.removeSelection(object);
        } else {
            this.addSelection(object);
        }
    }

    public void deleteSelection() {
        while (this.selectionModel.getCount() > 0) {
            Object object = this.selectionModel.getSelection();
            if (object instanceof TopologyNode) {
                this.removeNode(((TopologyNode)object).getObject());
                continue;
            }
            if (!(object instanceof TopologyLink)) continue;
            this.removeLink((TopologyLink)object);
        }
    }

    public void linkSelection() {
        Vector vector;
        if (this.selectionModel.getCount() == 2 && (vector = this.selectionModel.getSelectionList()).elementAt(0) instanceof TopologyNode && vector.elementAt(1) instanceof TopologyNode) {
            TopologyLink topologyLink = new TopologyLink(((TopologyNode)vector.elementAt(0)).getObject(), ((TopologyNode)vector.elementAt(1)).getObject());
            this.addLink(topologyLink);
        }
    }

    public TopologyMenuManager getMenuManager(Object object) {
        if (object == null) {
            return this.getBackgroundMenuManager();
        }
        Object v = this.menuManagers.get(object);
        if (v != null) {
            return (TopologyMenuManager)v;
        }
        return this.getDefaultMenuManager(object.getClass());
    }

    public TopologyMenuManager getMenuManager(TopologyNode topologyNode) {
        if (topologyNode == null) {
            return null;
        }
        return this.getMenuManager(topologyNode.getObject());
    }

    public void setMenuManager(Object object, TopologyMenuManager topologyMenuManager) {
        if (topologyMenuManager != null) {
            this.menuManagers.put(object, topologyMenuManager);
        } else {
            this.menuManagers.remove(object);
        }
    }

    public TopologyMenuManager getDefaultMenuManager(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object object = this.defaultMenuManagers.get(clazz);
        if (object != null) {
            return (TopologyMenuManager)object;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            object = this.getDefaultMenuManager(classArray[n]);
            if (object != null) {
                return (TopologyMenuManager)object;
            }
            ++n;
        }
        if (clazz != (class$java$lang$Object == null ? (class$java$lang$Object = Topology.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getDefaultMenuManager(clazz.getSuperclass());
        }
        return null;
    }

    public void setDefaultMenuManager(Class clazz, TopologyMenuManager topologyMenuManager) {
        if (topologyMenuManager != null) {
            this.defaultMenuManagers.put(clazz, topologyMenuManager);
        } else {
            this.defaultMenuManagers.remove(clazz);
        }
    }

    public TopologyMenuManager getBackgroundMenuManager() {
        return this.backgroundMenuManager;
    }

    public void setBackgroundMenuManager(TopologyMenuManager topologyMenuManager) {
        this.backgroundMenuManager = topologyMenuManager;
    }

    public JPopupMenu getMenuForObject(Object object) {
        TopologyMenuManager topologyMenuManager;
        if (object == null) {
            if (this.backgroundMenuManager != null) {
                return this.backgroundMenuManager.getMenu(null);
            }
            return null;
        }
        if (object instanceof TopologyNode) {
            object = ((TopologyNode)object).getObject();
        }
        if ((topologyMenuManager = this.getMenuManager(object)) == null) {
            return null;
        }
        return topologyMenuManager.getMenu(object);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getMinimumSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 32;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return (int)(0.5 * rectangle.getWidth());
        }
        return (int)(0.5 * rectangle.getHeight());
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public ImageIcon createIcon(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        byte[] byArray = new byte[65535];
        Image image = null;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream != null) {
            try {
                int n = 0;
                int n2 = 0;
                while ((n = inputStream.read(byArray, n2, 65535 - n2)) != -1) {
                    n2 += n;
                }
                if (n2 > 0) {
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                    image = toolkit.createImage(byArray2);
                }
            }
            catch (IOException iOException) {
                System.out.print("Unable to load image file '" + string + "':" + iOException + "\n");
            }
        } else {
            image = toolkit.getImage("./" + string);
        }
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

