/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.TreePath;

public class QTreeUI
extends MetalTreeUI {
    protected boolean wasNotSelected = true;

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (QTreeUI.this.tree != null && QTreeUI.this.tree.isEnabled()) {
                QTreeUI.this.tree.requestFocus();
                TreePath treePath = QTreeUI.this.getClosestPathForLocation(QTreeUI.this.tree, mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    int n;
                    Rectangle rectangle = QTreeUI.this.getPathBounds(QTreeUI.this.tree, treePath);
                    if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        QTreeUI.this.checkForClickInExpandControl(treePath, mouseEvent.getX(), mouseEvent.getY());
                    }
                    if ((n = mouseEvent.getX()) > rectangle.x && n < rectangle.x + rectangle.width && !QTreeUI.this.startEditing(treePath, mouseEvent)) {
                        if (QTreeUI.this.tree.isPathSelected(treePath)) {
                            if (QTreeUI.this.isToggleSelectionEvent(mouseEvent)) {
                                QTreeUI.this.wasNotSelected = true;
                                return;
                            }
                        } else {
                            QTreeUI.this.wasNotSelected = false;
                            QTreeUI.this.selectPathForEvent(treePath, mouseEvent);
                        }
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TreePath treePath;
            if (QTreeUI.this.tree != null && QTreeUI.this.tree.isEnabled() && (treePath = QTreeUI.this.getClosestPathForLocation(QTreeUI.this.tree, mouseEvent.getX(), mouseEvent.getY())) != null) {
                Rectangle rectangle = QTreeUI.this.getPathBounds(QTreeUI.this.tree, treePath);
                if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                    return;
                }
                int n = mouseEvent.getX();
                if (n > rectangle.x && n < rectangle.x + rectangle.width && !QTreeUI.this.startEditing(treePath, mouseEvent)) {
                    if (QTreeUI.this.isToggleSelectionEvent(mouseEvent)) {
                        if (QTreeUI.this.wasNotSelected) {
                            QTreeUI.this.wasNotSelected = false;
                            QTreeUI.this.selectPathForEvent(treePath, mouseEvent);
                        }
                    } else {
                        QTreeUI.this.selectPathForEvent(treePath, mouseEvent);
                    }
                }
            }
        }
    }
}

