/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.zoning;

import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.ZoneAlias;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.util.Invoker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ZoningErrorCheck
extends JDialog {
    int numberOfErrors = 0;
    Invoker invoker = new Invoker();
    boolean errorCheckRan = false;
    boolean okToSave = false;
    JButton startButton;
    JButton closeButton;
    JTextArea resultsArea;
    JLabel statusMessage;
    Zones zones;
    ZoningConfig config;

    public ZoningErrorCheck(JDialog jDialog, Zones zones, ZoningConfig zoningConfig) {
        super((Dialog)jDialog, true);
        this.zones = zones;
        this.config = zoningConfig;
        try {
            this.jbinit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean okToSave() {
        return this.okToSave;
    }

    private void jbinit() {
        this.setTitle(FabricTreeControl.getResource("ZoningErrorCheck.errorCheck"));
        this.startButton = new JButton(new StartAction());
        this.closeButton = new JButton(new CloseAction());
        this.resultsArea = new JTextArea();
        this.resultsArea.setEditable(false);
        this.statusMessage = new JLabel(" ");
        this.statusMessage.setBorder(BorderFactory.createBevelBorder(1));
        Dimension dimension = this.statusMessage.getPreferredSize();
        this.statusMessage.setPreferredSize(new Dimension(600, (int)dimension.getHeight()));
        JScrollPane jScrollPane = new JScrollPane(this.resultsArea);
        jScrollPane.setPreferredSize(new Dimension(600, 200));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.getContentPane().add((Component)this.statusMessage, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.getContentPane().add((Component)this.startButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.getContentPane().add((Component)this.closeButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.pack();
        this.validate();
        this.setResizable(false);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension2.width - this.getWidth()) / 2, (dimension2.height - this.getHeight()) / 2);
    }

    private void errorCheck() {
        this.invoker.invokeLater(new ErrorCheck());
    }

    private void checkSet(ZoneSet zoneSet) {
        Object object;
        ZoneMember zoneMember;
        ZoneAlias zoneAlias;
        HashMap<String, Vector<Zone>> hashMap = new HashMap<String, Vector<Zone>>();
        Zone zone = zoneSet.getFirstZone();
        while (zone != null) {
            this.setStatus(FabricTreeControl.getResource("ZoningErrorCheck.checking") + " " + zone.getName());
            zoneAlias = null;
            zoneMember = zone.getFirstMember();
            while (zoneMember != null) {
                if (zoneMember instanceof ZoneAlias && (zoneMember = (zoneAlias = (ZoneAlias)zoneMember).getFirstMember()) == null) {
                    zoneMember = zone.getNextMember((ZoneMember)zoneAlias);
                    continue;
                }
                String string = zoneMember.getMemberStorageString();
                Vector<Zone> vector = (Vector<Zone>)hashMap.get(string);
                if (vector == null) {
                    vector = new Vector<Zone>();
                    hashMap.put(string, vector);
                }
                vector.add(zone);
                object = zoneSet.getFirstZone();
                while (object != null) {
                    if (object != zone && object.isMemberInZone(zoneMember, true)) {
                        vector.add((Zone)object);
                    }
                    object = zoneSet.getNextZone((Zone)object);
                }
                if (zoneAlias == null) {
                    zoneMember = zone.getNextMember(zoneMember);
                    continue;
                }
                if ((zoneMember = zoneAlias.getNextMember(zoneMember)) != null) continue;
                zoneMember = zone.getNextMember((ZoneMember)zoneAlias);
                zoneAlias = null;
            }
            zone = zoneSet.getNextZone(zone);
        }
        zone = zoneSet.getFirstZone();
        while (zone != null) {
            Zone zone2;
            Object object2;
            this.setStatus(FabricTreeControl.getResource("ZoningErrorCheck.checking") + " " + zone.getName());
            zoneAlias = null;
            zoneMember = zone.getFirstMember();
            if (zone.getZoneType() == 1) {
                boolean bl = false;
                boolean bl2 = false;
                while (!(zoneMember == null || bl2 && bl)) {
                    if (zoneMember instanceof ZoneAlias && (zoneMember = (zoneAlias = (ZoneAlias)zoneMember).getFirstMember()) == null) {
                        zoneMember = zone.getNextMember((ZoneMember)zoneAlias);
                        continue;
                    }
                    if (zoneMember.getType() != 1) {
                        bl = true;
                    }
                    object = zoneMember.getMemberStorageString();
                    object2 = (Vector)hashMap.get(object);
                    int n = 0;
                    while (n < ((Vector)object2).size() && !bl2) {
                        zone2 = (Zone)((Vector)object2).elementAt(n);
                        if (zone2 != zone && zone2.getZoneType() == 1) {
                            bl2 = true;
                        }
                        ++n;
                    }
                    if (zoneAlias == null) {
                        zoneMember = zone.getNextMember(zoneMember);
                        continue;
                    }
                    if ((zoneMember = zoneAlias.getNextMember(zoneMember)) != null) continue;
                    zoneMember = zone.getNextMember((ZoneMember)zoneAlias);
                    zoneAlias = null;
                }
                if (bl) {
                    object = FabricTreeControl.getResource("ZoningErrorCheck.inSet") + " \"" + zoneSet.getName() + "\" " + FabricTreeControl.getResource("ZoningErrorCheck.hardZone") + " \"" + zone.getName() + "\" " + FabricTreeControl.getResource("ZoningErrorCheck.willRevertToSoftZoneDueToInvalidMembers");
                    this.addErrorMessage((String)object);
                }
                if (bl2) {
                    object = FabricTreeControl.getResource("ZoningErrorCheck.inSet") + " \"" + zoneSet.getName() + "\" " + FabricTreeControl.getResource("ZoningErrorCheck.hardZone") + " \"" + zone.getName() + "\" " + FabricTreeControl.getResource("ZoningErrorCheck.willRevertToSoftZoneDueToOverlap");
                    this.addErrorMessage((String)object);
                }
            }
            if (zone.getZoneType() == 0 || zone.getZoneType() == 2) {
                boolean bl = false;
                int n = 0;
                object = new Vector();
                while (zoneMember != null) {
                    if (zoneMember instanceof ZoneAlias && (zoneMember = (zoneAlias = (ZoneAlias)zoneMember).getFirstMember()) == null) {
                        zoneMember = zone.getNextMember((ZoneMember)zoneAlias);
                        continue;
                    }
                    if (zone.getZoneType() == 2 && zoneMember.getType() != 1) {
                        bl = true;
                    }
                    object2 = zoneMember.getMemberStorageString();
                    Vector vector = (Vector)hashMap.get(object2);
                    boolean bl3 = true;
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        Zone zone3 = (Zone)vector.elementAt(n2);
                        if (zone.getZoneType() < zone3.getZoneType()) {
                            bl3 = false;
                            if (!((Vector)object).contains(zone3)) {
                                ((Vector)object).add(zone3);
                            }
                        }
                        ++n2;
                    }
                    if (bl3 && zoneMember.getType() != 2) {
                        ++n;
                    }
                    if (zoneAlias == null) {
                        zoneMember = zone.getNextMember(zoneMember);
                        continue;
                    }
                    if ((zoneMember = zoneAlias.getNextMember(zoneMember)) != null) continue;
                    zoneMember = zone.getNextMember((ZoneMember)zoneAlias);
                    zoneAlias = null;
                }
                if (bl) {
                    object2 = FabricTreeControl.getResource("ZoningErrorCheck.inSet") + " \"" + zoneSet.getName() + "\" " + FabricTreeControl.getResource("ZoningErrorCheck.hardZone") + " \"" + zone.getName() + "\" " + FabricTreeControl.getResource("ZoningErrorCheck.willRevertToSoftZoneDueToInvalidMembers");
                    this.addErrorMessage((String)object2);
                }
                if (n > 0 && ((Vector)object).size() > 0 || n == 0 && ((Vector)object).size() > 1) {
                    object2 = FabricTreeControl.getResource("ZoningErrorCheck.inSet") + " \"" + zoneSet.getName() + "\" " + FabricTreeControl.getResource("ZoningErrorCheck.softZone") + " \"" + zone.getName() + "\" " + FabricTreeControl.getResource("ZoningErrorCheck.isDividedByHardZones") + " ";
                    int n3 = 0;
                    while (n3 < ((Vector)object).size()) {
                        zone2 = (Zone)((Vector)object).elementAt(n3);
                        object2 = (String)object2 + "\"" + zone2.getName() + "\"";
                        if (n3 < ((Vector)object).size() - 1) {
                            object2 = (String)object2 + ",";
                        }
                        ++n3;
                    }
                    this.addErrorMessage((String)object2);
                }
            }
            zone = zoneSet.getNextZone(zone);
        }
    }

    private void addMessage(String string) {
        SwingUtilities.invokeLater(new AddMessage(string));
    }

    private void addErrorMessage(String string) {
        SwingUtilities.invokeLater(new AddMessage(string));
        ++this.numberOfErrors;
    }

    private void setStatus(String string) {
        SwingUtilities.invokeLater(new SetStatus(string));
    }

    class SetStatus
    implements Runnable {
        String str;

        SetStatus(String string) {
            this.str = string;
        }

        public void run() {
            ZoningErrorCheck.this.statusMessage.setText(FabricTreeControl.getResource("ZoningErrorCheck.status") + " " + this.str);
        }
    }

    class AddMessage
    implements Runnable {
        String str;

        AddMessage(String string) {
            this.str = string;
        }

        public void run() {
            ZoningErrorCheck.this.resultsArea.setText(ZoningErrorCheck.this.resultsArea.getText() + this.str + "\n");
        }
    }

    class ShowErrors
    implements Runnable {
        ShowErrors() {
        }

        public void run() {
            if (ZoningErrorCheck.this.numberOfErrors > 0) {
                ZoningErrorCheck.this.startButton.setText(FabricTreeControl.getResource("ZoningErrorCheck.fixButton"));
                ZoningErrorCheck.this.closeButton.setText(FabricTreeControl.getResource("ZoningErrorCheck.ignoreButton"));
            } else {
                ZoningErrorCheck.this.startButton.setText(FabricTreeControl.getResource("ZoningErrorCheck.returnButton"));
                ZoningErrorCheck.this.closeButton.setText(FabricTreeControl.getResource("ZoningErrorCheck.closeButton"));
            }
            ZoningErrorCheck.this.pack();
        }
    }

    class ErrorCheck
    implements Runnable {
        ErrorCheck() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Cursor cursor = ZoningErrorCheck.this.getCursor();
            ZoningErrorCheck.this.setCursor(new Cursor(3));
            try {
                ZoningErrorCheck.this.numberOfErrors = 0;
                ZoneSet zoneSet = ZoningErrorCheck.this.zones.getFirstZoneSet();
                while (zoneSet != null) {
                    ZoningErrorCheck.this.setStatus(FabricTreeControl.getResource("ZoningErrorCheck.checking") + " " + zoneSet.getName());
                    if (zoneSet.getNumberOfZones() == 0) {
                        ZoningErrorCheck.this.addErrorMessage(FabricTreeControl.getResource("ZoningErrorCheck.zoneSet") + " \"" + zoneSet.getName() + "\" " + FabricTreeControl.getResource("ZoningErrorCheck.isEmpty"));
                    } else {
                        ZoningErrorCheck.this.checkSet(zoneSet);
                    }
                    zoneSet = ZoningErrorCheck.this.zones.getNextZoneSet(zoneSet);
                }
                Zone zone = ZoningErrorCheck.this.zones.getFirstZone();
                while (zone != null) {
                    ZoningErrorCheck.this.setStatus(FabricTreeControl.getResource("ZoningErrorCheck.checking") + " " + zone.getName());
                    if (zone.getMemberCount() == 0) {
                        ZoningErrorCheck.this.addErrorMessage(FabricTreeControl.getResource("ZoningErrorCheck.zone") + " \"" + zone.getName() + "\" " + FabricTreeControl.getResource("ZoningErrorCheck.isEmpty"));
                    }
                    zone = ZoningErrorCheck.this.zones.getNextZone(zone);
                }
                ZoneAlias zoneAlias = ZoningErrorCheck.this.zones.getFirstZoneAlias();
                while (zoneAlias != null) {
                    ZoningErrorCheck.this.setStatus(FabricTreeControl.getResource("ZoningErrorCheck.checking") + " " + zoneAlias.getName());
                    if (zoneAlias.getMemberCount() == 0) {
                        ZoningErrorCheck.this.addErrorMessage(FabricTreeControl.getResource("ZoningErrorCheck.zoneAlias") + " \"" + zoneAlias.getName() + "\" " + FabricTreeControl.getResource("ZoningErrorCheck.isEmpty"));
                    }
                    zoneAlias = ZoningErrorCheck.this.zones.getNextZoneAlias(zoneAlias);
                }
                if (ZoningErrorCheck.this.numberOfErrors == 1) {
                    ZoningErrorCheck.this.addMessage("\n" + FabricTreeControl.getResource("ZoningErrorCheck.threreWas") + " " + ZoningErrorCheck.this.numberOfErrors + " " + FabricTreeControl.getResource("ZoningErrorCheck.errorFound"));
                } else {
                    ZoningErrorCheck.this.addMessage("\n" + FabricTreeControl.getResource("ZoningErrorCheck.threreWere") + " " + ZoningErrorCheck.this.numberOfErrors + " " + FabricTreeControl.getResource("ZoningErrorCheck.errorsFound"));
                }
                ZoningErrorCheck.this.setStatus(FabricTreeControl.getResource("ZoningErrorCheck.errorCheckComplete"));
                ZoningErrorCheck.this.errorCheckRan = true;
                SwingUtilities.invokeLater(new ShowErrors());
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ZoningErrorCheck.this.setCursor(cursor);
                throw throwable;
            }
            ZoningErrorCheck.this.setCursor(cursor);
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(FabricTreeControl.getResource("ZoningErrorCheck.skipButton"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ZoningErrorCheck.this.okToSave = true;
            ZoningErrorCheck.this.setVisible(false);
        }
    }

    class StartAction
    extends AbstractAction {
        public StartAction() {
            super(FabricTreeControl.getResource("ZoningErrorCheck.startButton"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ZoningErrorCheck.this.errorCheckRan) {
                ZoningErrorCheck.this.okToSave = false;
                ZoningErrorCheck.this.setVisible(false);
            } else {
                ZoningErrorCheck.this.errorCheck();
            }
        }
    }
}

