/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.zoning;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Director;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.Sanbox8000Blade;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.ZoneAlias;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.device.fcfabric.zoning.ZoningFile;
import com.qlogic.device.fcfabric.zoning.ZoningFileException;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.SanSurferTreeNode;
import com.qlogic.qms.fabric.SanSurferTreeNodeRenderer;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.UserPreferences;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.qms.fabric.zoning.NewZoningItemDialog;
import com.qlogic.qms.fabric.zoning.NewZoningMemberDialog;
import com.qlogic.qms.fabric.zoning.SetZoneTypeDialog;
import com.qlogic.qms.fabric.zoning.TreeDragSource;
import com.qlogic.qms.fabric.zoning.ZoneSetTree;
import com.qlogic.qms.fabric.zoning.ZoningErrorCheck;
import com.qlogic.qms.fabric.zoning.ZoningUtilities;
import com.qlogic.ui.QDialog;
import com.qlogic.ui.QFileChooser;
import com.qlogic.ui.QTreeUI;
import com.qlogic.ui.StringFileFilter;
import com.qlogic.util.QHelpUtilities;
import com.qlogic.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ZoningDialog
extends QDialog
implements ChassisEventListener,
ActionListener,
TreeSelectionListener,
TreeModelListener {
    private JFrame frame;
    private JSplitPane splitPane = new JSplitPane();
    private JLabel errorLabel = new JLabel();
    private static QFileChooser fileChooser = null;
    private ZoneSetTree zoneSetTree;
    private DefaultTreeModel memberTreeModel;
    private TreeDragSource memberTreeSource;
    private JTree memberTree;
    private SanboxChassis fcSwitch;
    private Fabric fabric;
    private JToolBar toolbar;
    private Zones zones;
    private ZoneSet lastSetHighlighted;
    private boolean zoneDataLoaded = false;
    private boolean zoneDataSaved = false;
    private ErrorType applyError;
    private SavingDialog saveDlg;
    private boolean loadingCanceled = false;
    private boolean savingCanceled = false;
    private JPopupMenu zonesPopupMenu;
    private JMenuItem createZoneSet;
    private JMenuItem createZoneAlias;
    private JMenuItem clearAll;
    private JMenuItem zonesProperties;
    private JPopupMenu zoneSetPopupMenu;
    private JMenuItem setActiveZoneSet;
    private JMenuItem addZoneToZoneSet;
    private JMenuItem deleteZoneSet;
    private JMenuItem renameZoneSet;
    private JMenuItem zoneSetProperties;
    private JPopupMenu zonePopupMenu;
    private JPopupMenu zoneAliasPopupMenu;
    private JMenuItem removeZoneFromZoneSet;
    private JMenuItem renameZone;
    private JMenuItem setZoneType;
    private JMenuItem renameZoneAlias;
    private JMenuItem removeZoneAllTogether;
    private JMenuItem removeAliasAllTogether;
    private JMenuItem addZoneMembers;
    private JMenuItem createZoneMembers;
    private JMenuItem zoneProperties;
    private JMenuItem zoneAliasProperties;
    private JMenuItem zoneAliasCreateMembers;
    private JPopupMenu zoneMemberPopupMenu;
    private JMenuItem removeZoneMembers;
    private JPanel buttonPanel;
    private JMenuBar menuBar;
    private JMenu editMenu;
    private JMenuItem createZoneSetMenuItem;
    private JMenuItem createZoneAliasMenuItem;
    private JMenuItem addZoneMenuItem;
    private JMenuItem addMembersMenuItem;
    private JMenuItem createMembersMenuItem;
    private JMenuItem setZoneTypeMenuItem;
    private JMenuItem renameMenuItem;
    private JMenuItem removeMenuItem;
    private JMenuItem purgeZoneMenuItem;
    private JMenuItem purgeAliasMenuItem;
    private JMenuItem removeAllMenuItem;
    private JMenuItem propertiesMenuItem;
    private JMenu fileMenu;
    private JMenuItem loadMenuItem;
    private JMenuItem saveMenuItem;
    private AddToZoneAction addToZoneButton;
    private JButton createZoneButton;
    private JButton createAliasButton;
    private static final Font toolbarFont = new Font("Label", 1, 9);
    private static ZoningDialog instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZoningDialog zoningDialogFactory(JFrame jFrame, Fabric fabric, SanboxChassis sanboxChassis, Zones zones, boolean bl) throws IllegalArgumentException {
        Cursor cursor = jFrame.getCursor();
        jFrame.setCursor(new Cursor(3));
        try {
            if (instance == null) {
                instance = new ZoningDialog(jFrame, fabric, sanboxChassis, zones, bl);
            } else {
                instance.setZones(zones, fabric, sanboxChassis, bl);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            jFrame.setCursor(cursor);
            throw throwable;
        }
        jFrame.setCursor(cursor);
        return instance;
    }

    private ZoningDialog(JFrame jFrame, Fabric fabric, SanboxChassis sanboxChassis, Zones zones, boolean bl) throws IllegalArgumentException {
        super((Frame)jFrame, true);
        this.frame = jFrame;
        this.fabric = fabric;
        this.setTitle(FabricTreeControl.getResource("ZoningDialog.editZoning") + " - " + VendorProperties.getFrameTitle());
        try {
            this.jbinit();
            this.setZones(zones, this.fabric, sanboxChassis, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setZones(Zones zones, Fabric fabric, SanboxChassis sanboxChassis, boolean bl) {
        if (this.fcSwitch != null) {
            this.fcSwitch.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
        }
        this.fcSwitch = sanboxChassis;
        this.fcSwitch.getEventHandler().addChassisEventListener((ChassisEventListener)this);
        this.fabric = fabric;
        this.zones = zones;
        if (bl) {
            this.zones.resetDirtyFlag();
        }
        this.zoneSetTree.setZones(this.fabric, this.zones);
        this.setMenuEnables();
        this.setErrorLabel();
        this.fillMemberTree();
    }

    private void setMenuEnables() {
        this.createZoneAliasMenuItem.setEnabled(this.fcSwitch instanceof Sanbox2);
        this.setZoneTypeMenuItem.setEnabled(this.fcSwitch instanceof Sanbox2);
        this.createZoneAlias.setEnabled(this.fcSwitch instanceof Sanbox2);
        this.setZoneType.setEnabled(this.fcSwitch instanceof Sanbox2);
        this.setActiveZoneSet.setEnabled(this.fcSwitch instanceof Sanbox);
        this.createAliasButton.setEnabled(this.fcSwitch instanceof Sanbox2);
    }

    private void showLimits() {
        JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.zoningExceeded") + " " + this.zones.getMaxNumberOfSets() + " " + FabricTreeControl.getResource("ZoningDialog.andYouHave") + " " + this.zones.getNumberOfZoneSets() + FabricTreeControl.getResource("ZoningDialog.maxZones") + " " + this.zones.getMaxNumberOfZones() + " " + FabricTreeControl.getResource("ZoningDialog.andYouHave") + " " + this.zones.getNumberOfZones() + FabricTreeControl.getResource("ZoningDialog.maxAliases") + " " + this.zones.getMaxNumberOfAliases() + " " + FabricTreeControl.getResource("ZoningDialog.andYouHave") + " " + this.zones.getNumberOfZoneAliases() + FabricTreeControl.getResource("ZoningDialog.maxMembers") + " " + this.zones.getMaxNumberOfMembers() + " " + FabricTreeControl.getResource("ZoningDialog.andYouHave") + " " + this.zones.getMemberCount() + FabricTreeControl.getResource("ZoningDialog.maxZonesInSets") + " " + this.zones.getMaxZonesInSets() + " " + FabricTreeControl.getResource("ZoningDialog.andYouHave") + " " + this.zones.getNumberZonesInSets(), FabricTreeControl.getResource("ZoningDialog.maxZoning"), 0);
    }

    private void saveZoningInfo(boolean bl) {
        Object object;
        ZoneSet zoneSet;
        if (!this.zones.okToSave()) {
            this.showLimits();
            return;
        }
        ZoningErrorCheck zoningErrorCheck = new ZoningErrorCheck(this, this.zones, this.fcSwitch.getZoningConfig());
        zoningErrorCheck.setVisible(true);
        if (!zoningErrorCheck.okToSave()) {
            return;
        }
        if (this.zones.getErrorReading() && JOptionPane.showConfirmDialog(this, FabricTreeControl.getResource("ZoningDialog.warnAboutSavingIncomplete"), FabricTreeControl.getResource("ZoningDialog.applyingZoning"), 0) != 0) {
            return;
        }
        if (this.fcSwitch instanceof Sanbox) {
            int n;
            zoneSet = this.zones.getOrphanZoneSet();
            if (zoneSet.getNumberOfZones() > 0 && (n = JOptionPane.showConfirmDialog(this, FabricTreeControl.getResource("ZoningDialog.orphanZonesNotSaved"), FabricTreeControl.getResource("ZoningDialog.orphanZones"), 0)) == 1) {
                return;
            }
            object = this.zones.getActiveZoneSet();
            if (FabricUtilities.willFabricIsolate((ZoneSet)object, (Chassis)this.fcSwitch) && JOptionPane.showConfirmDialog(this, FabricTreeControl.getResource("ZoningDialog.mightIsolate"), FabricTreeControl.getResource("ZoningDialog.applyingZoning"), 0) == 1) {
                return;
            }
        }
        this.savingCanceled = false;
        this.zoneDataSaved = false;
        this.zoneDataLoaded = false;
        zoneSet = FabricList.getFabric((Chassis)this.fcSwitch);
        if (zoneSet != null) {
            zoneSet.disablePolling();
        }
        if (!this.fcSwitch.applyEPortZoning(this.zones)) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.savingFailedToStart"), FabricTreeControl.getResource("ZoningDialog.zoningData"), 0);
            return;
        }
        this.saveDlg = new SavingDialog();
        this.saveDlg.setVisible(true);
        if (zoneSet != null) {
            zoneSet.enablePolling();
        }
        if (!this.zoneDataSaved) {
            this.savingCanceled = true;
            object = FabricTreeControl.translateErrorType(this.applyError);
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.savingFailed") + " " + (String)object, FabricTreeControl.getResource("ZoningDialog.zoningData"), 0);
        } else {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.savedOk"), FabricTreeControl.getResource("ZoningDialog.zoningData"), 1);
            if (bl) {
                this.fcSwitch.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
                this.setVisible(false);
                object = new Vector();
                if (this.fcSwitch instanceof Sanbox2) {
                    ((Vector)object).add(new Integer(378));
                }
                if (this.fcSwitch instanceof Sanbox) {
                    ((Vector)object).add(new Integer(241));
                }
                WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(this.frame, this.fcSwitch, (Vector)object, FabricTreeControl.getResource("ZoningDialog.waitingForUpdate"));
                waitForUpdateDialog.setVisible(true);
            }
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getEventType() == 242) {
            if (!this.savingCanceled) {
                if (chassisEvent.isSuccessful()) {
                    this.zones.resetDirtyFlag();
                    this.zoneDataSaved = true;
                } else {
                    this.applyError = chassisEvent.getErrorType();
                }
            }
            SwingUtilities.invokeLater(new CloseSaveDialog());
        }
        if (chassisEvent.getEventType() == 219 || chassisEvent.getEventType() == 210) {
            this.repaint();
        }
    }

    private void jbinit() {
        Serializable serializable;
        Component component;
        Object object;
        Object object2;
        if (fileChooser == null) {
            object2 = UserPreferences.getInstance().getWorkingDirectory();
            fileChooser = new QFileChooser((String)object2);
            object = new StringFileFilter(".xml");
            fileChooser.setFileFilter((FileFilter)object);
            fileChooser.addChoosableFileFilter((FileFilter)object);
        }
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(FabricTreeControl.getResource("ZoningDialog.file"));
        this.fileMenu.setMnemonic('F');
        this.loadMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.openFile"));
        this.loadMenuItem.setMnemonic('O');
        this.loadMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.fileMenu.add(this.loadMenuItem);
        this.loadMenuItem.addActionListener(this);
        this.saveMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.saveAs"));
        this.fileMenu.add(this.saveMenuItem);
        this.saveMenuItem.addActionListener(this);
        this.saveMenuItem.setMnemonic('a');
        this.editMenu = new JMenu(FabricTreeControl.getResource("ZoningDialog.edit"));
        this.editMenu.setMnemonic('E');
        this.createZoneSetMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.createZoneSet"));
        this.editMenu.add(this.createZoneSetMenuItem);
        this.createZoneSetMenuItem.addActionListener(this);
        this.createZoneSetMenuItem.setMnemonic('C');
        this.createZoneAliasMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.createAlias"));
        this.editMenu.add(this.createZoneAliasMenuItem);
        this.createZoneAliasMenuItem.addActionListener(this);
        this.createZoneAliasMenuItem.setMnemonic('A');
        this.addZoneMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.addZone"));
        this.editMenu.add(this.addZoneMenuItem);
        this.addZoneMenuItem.addActionListener(this);
        this.addZoneMenuItem.setMnemonic('Z');
        this.addMembersMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.addMembers"));
        this.editMenu.add(this.addMembersMenuItem);
        this.addMembersMenuItem.addActionListener(this);
        this.addMembersMenuItem.setMnemonic('M');
        this.createMembersMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.createMembers"));
        this.editMenu.add(this.createMembersMenuItem);
        this.createMembersMenuItem.addActionListener(this);
        this.createMembersMenuItem.setMnemonic('X');
        this.setZoneTypeMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.setZoneType"));
        this.editMenu.add(this.setZoneTypeMenuItem);
        this.setZoneTypeMenuItem.addActionListener(this);
        this.setZoneTypeMenuItem.setMnemonic('S');
        this.renameMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.rename"));
        this.editMenu.add(this.renameMenuItem);
        this.renameMenuItem.addActionListener(this);
        this.renameMenuItem.setMnemonic('n');
        this.removeMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.remove"));
        this.editMenu.add(this.removeMenuItem);
        this.removeMenuItem.addActionListener(this);
        this.removeMenuItem.setMnemonic('v');
        this.purgeZoneMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.removeZoneFromAllSets"));
        this.editMenu.add(this.purgeZoneMenuItem);
        this.purgeZoneMenuItem.addActionListener(this);
        this.purgeZoneMenuItem.setMnemonic('o');
        this.purgeAliasMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.removeAliasFromAllZones"));
        this.editMenu.add(this.purgeAliasMenuItem);
        this.purgeAliasMenuItem.addActionListener(this);
        this.purgeAliasMenuItem.setMnemonic('l');
        this.removeAllMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.removeAll"));
        this.editMenu.add(this.removeAllMenuItem);
        this.removeAllMenuItem.addActionListener(this);
        this.removeAllMenuItem.setMnemonic('R');
        this.propertiesMenuItem = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.properties"));
        this.editMenu.add(this.propertiesMenuItem);
        this.propertiesMenuItem.addActionListener(this);
        this.propertiesMenuItem.setMnemonic('P');
        this.addZoneMenuItem.setEnabled(false);
        this.addMembersMenuItem.setEnabled(false);
        this.createMembersMenuItem.setEnabled(false);
        this.setZoneTypeMenuItem.setEnabled(false);
        this.renameMenuItem.setEnabled(false);
        this.removeMenuItem.setEnabled(false);
        this.purgeZoneMenuItem.setEnabled(false);
        this.purgeAliasMenuItem.setEnabled(false);
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.zonesPopupMenu = new JPopupMenu();
        this.createZoneSet = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.newZoneSet"));
        this.createZoneSet.addActionListener(this);
        this.zonesPopupMenu.add(this.createZoneSet);
        this.createZoneAlias = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.newAlias"));
        this.createZoneAlias.addActionListener(this);
        this.zonesPopupMenu.add(this.createZoneAlias);
        this.clearAll = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.clearZoning"));
        this.clearAll.addActionListener(this);
        this.zonesPopupMenu.add(this.clearAll);
        this.zonesProperties = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.properties"));
        this.zonesProperties.addActionListener(this);
        this.zonesPopupMenu.add(this.zonesProperties);
        this.zoneSetPopupMenu = new JPopupMenu();
        this.addZoneToZoneSet = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.addZone"));
        this.addZoneToZoneSet.addActionListener(this);
        this.zoneSetPopupMenu.add(this.addZoneToZoneSet);
        this.setActiveZoneSet = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.toggleActive"));
        this.setActiveZoneSet.addActionListener(this);
        this.zoneSetPopupMenu.add(this.setActiveZoneSet);
        this.deleteZoneSet = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.removeSet"));
        this.deleteZoneSet.addActionListener(this);
        this.zoneSetPopupMenu.add(this.deleteZoneSet);
        this.renameZoneSet = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.rename"));
        this.renameZoneSet.addActionListener(this);
        this.zoneSetPopupMenu.add(this.renameZoneSet);
        this.zoneSetProperties = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.properties"));
        this.zoneSetProperties.addActionListener(this);
        this.zoneSetPopupMenu.add(this.zoneSetProperties);
        this.zonePopupMenu = new JPopupMenu();
        this.renameZone = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.rename"));
        this.renameZone.addActionListener(this);
        this.zonePopupMenu.add(this.renameZone);
        this.setZoneType = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.setZoneType"));
        this.setZoneType.addActionListener(this);
        this.zonePopupMenu.add(this.setZoneType);
        this.removeZoneFromZoneSet = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.removeZoneFromSet"));
        this.removeZoneFromZoneSet.addActionListener(this);
        this.zonePopupMenu.add(this.removeZoneFromZoneSet);
        this.removeZoneAllTogether = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.removeZoneFromAllSets"));
        this.removeZoneAllTogether.addActionListener(this);
        this.zonePopupMenu.add(this.removeZoneAllTogether);
        this.addZoneMembers = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.addZoneMembers"));
        this.addZoneMembers.addActionListener(this);
        this.zonePopupMenu.add(this.addZoneMembers);
        this.createZoneMembers = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.createMembers"));
        this.createZoneMembers.addActionListener(this);
        this.zonePopupMenu.add(this.createZoneMembers);
        this.zoneProperties = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.properties"));
        this.zoneProperties.addActionListener(this);
        this.zonePopupMenu.add(this.zoneProperties);
        this.zoneMemberPopupMenu = new JPopupMenu();
        this.removeZoneMembers = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.removeZoneMember"));
        this.removeZoneMembers.addActionListener(this);
        this.zoneMemberPopupMenu.add(this.removeZoneMembers);
        this.zoneAliasPopupMenu = new JPopupMenu();
        this.renameZoneAlias = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.rename"));
        this.renameZoneAlias.addActionListener(this);
        this.zoneAliasPopupMenu.add(this.renameZoneAlias);
        this.removeAliasAllTogether = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.removeAliasFromAllZones"));
        this.removeAliasAllTogether.addActionListener(this);
        this.zoneAliasPopupMenu.add(this.removeAliasAllTogether);
        this.zoneAliasProperties = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.properties"));
        this.zoneAliasProperties.addActionListener(this);
        this.zoneAliasPopupMenu.add(this.zoneAliasProperties);
        this.zoneAliasCreateMembers = new JMenuItem(FabricTreeControl.getResource("ZoningDialog.createMembers"));
        this.zoneAliasCreateMembers.addActionListener(this);
        this.zoneAliasPopupMenu.add(this.zoneAliasCreateMembers);
        this.zoneSetTree = new ZoneSetTree(this.fabric, null, true, false, null, null);
        this.zoneSetTree.addMouseListener(new MouseListener());
        this.zoneSetTree.getTree().addTreeSelectionListener(this);
        this.zoneSetTree.getTree().getModel().addTreeModelListener(this);
        object2 = new SanSurferTreeNode((Object)FabricTreeControl.getResource("ZoningDialog.members"), 0);
        this.memberTreeModel = new DefaultTreeModel((TreeNode)object2);
        this.memberTree = new JTree(this.memberTreeModel);
        this.memberTree.setUI(new QTreeUI());
        this.memberTreeSource = new TreeDragSource(this.memberTree, this.zones);
        this.memberTree.setCellRenderer(new SanSurferTreeNodeRenderer(this.fabric));
        this.splitPane.setOrientation(1);
        this.splitPane.setLeftComponent(this.zoneSetTree);
        this.splitPane.setRightComponent(new JScrollPane(this.memberTree));
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        ((Container)object).add((Component)this.errorLabel, "North");
        ((Container)object).add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)object, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int)((double)dimension.width * 0.7), (int)((double)dimension.height * 0.7));
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.splitPane.setDividerLocation(this.getWidth() / 2);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        JButton jButton = new JButton(new CreateNewZoneSetAction(FabricTreeControl.getResource("ZoningDialog.toolbar.zoneSet"), "AddZoneSet24Disabled.gif"));
        jButton.setToolTipText(FabricTreeControl.getResource("ZoningDialog.createAZoneSet"));
        jButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("AddZoneSet24.gif")));
        SbmUtilities.setButtonParameters(jButton);
        this.toolbar.add(jButton);
        this.createZoneButton = new JButton(new CreateNewZoneAction(FabricTreeControl.getResource("ZoningDialog.toolbar.zone"), "AddZone24Disabled.gif"));
        this.createZoneButton.setEnabled(false);
        this.createZoneButton.setToolTipText(FabricTreeControl.getResource("ZoningDialog.createAZone"));
        this.createZoneButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("AddZone24.gif")));
        SbmUtilities.setButtonParameters(this.createZoneButton);
        this.toolbar.add(this.createZoneButton);
        this.createAliasButton = new JButton(new CreateNewZoneAliasAction(FabricTreeControl.getResource("ZoningDialog.toolbar.alias"), "AddZoneAlias24Disabled.gif"));
        this.createAliasButton.setToolTipText(FabricTreeControl.getResource("ZoningDialog.createAnAlias"));
        this.createAliasButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("AddZoneAlias24.gif")));
        SbmUtilities.setButtonParameters(this.createAliasButton);
        this.toolbar.add(this.createAliasButton);
        this.addToZoneButton = new AddToZoneAction(FabricTreeControl.getResource("ZoningDialog.toolbar.insert"), "ZoneInsert24Disabled.gif");
        this.addToZoneButton.setEnabled(false);
        jButton = new JButton(this.addToZoneButton);
        jButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("ZoneInsert24.gif")));
        jButton.setToolTipText(FabricTreeControl.getResource("ZoningDialog.insertZoneMembers"));
        SbmUtilities.setButtonParameters(jButton);
        this.toolbar.add(jButton);
        jButton = new JButton(new DeleteAction(FabricTreeControl.getResource("ZoningDialog.toolbar.remove"), "ZoneRemove24Disabled.gif"));
        jButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("ZoneRemove24.gif")));
        jButton.setToolTipText(FabricTreeControl.getResource("ZoningDialog.remove"));
        SbmUtilities.setButtonParameters(jButton);
        this.toolbar.add(jButton);
        this.toolbar.add(Box.createGlue());
        Dimension dimension2 = null;
        int n = 0;
        while (n < this.toolbar.getComponentCount()) {
            component = this.toolbar.getComponentAtIndex(n);
            if (component instanceof JButton) {
                if (dimension2 == null) {
                    dimension2 = component.getPreferredSize();
                } else {
                    dimension2.width = Math.max(dimension2.width, component.getPreferredSize().width);
                    dimension2.height = Math.max(dimension2.height, component.getPreferredSize().height);
                }
            }
            ++n;
        }
        if (dimension2 != null) {
            int n2 = 0;
            while (n2 < this.toolbar.getComponentCount()) {
                serializable = this.toolbar.getComponentAtIndex(n2);
                if (serializable instanceof JButton) {
                    ((JButton)serializable).setPreferredSize(dimension2);
                    ((JButton)serializable).setBorder(new EmptyBorder(((JButton)serializable).getInsets()));
                }
                ++n2;
            }
        }
        component = new JPanel();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 4, 8, 0));
        ((Container)component).add(this.buttonPanel);
        jButton = new JButton(new SaveAndQuitAction());
        this.buttonPanel.add((Component)jButton, null);
        jButton.setMnemonic('O');
        jButton = new JButton(new SaveAction());
        this.buttonPanel.add((Component)jButton, null);
        jButton.setMnemonic('A');
        jButton = new JButton(new CancelAction());
        this.buttonPanel.add((Component)jButton, null);
        jButton.setMnemonic('C');
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add(component, "South");
        serializable = this.createFabricTreePath(this.memberTreeModel);
        this.memberTree.expandPath((TreePath)serializable);
        this.memberTree.setSelectionPath((TreePath)serializable);
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.lastSetHighlighted = null;
        this.setMemberTreeHighlights();
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.lastSetHighlighted = null;
        this.setMemberTreeHighlights();
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.lastSetHighlighted = null;
        this.setMemberTreeHighlights();
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.lastSetHighlighted = null;
        this.setMemberTreeHighlights();
    }

    private void setErrorLabel() {
        if (this.zones.getErrorReading() && this.errorLabel.getText().length() == 0) {
            this.errorLabel.setText(FabricTreeControl.getResource("ZoneSetTree.errorReading"));
        }
        if (!this.zones.getErrorReading() && this.errorLabel.getText().length() > 0) {
            this.errorLabel.setText("");
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        SanSurferTreeNode[] sanSurferTreeNodeArray = this.getSelectedNodes(this.zoneSetTree.getTree());
        this.addZoneMenuItem.setEnabled(false);
        this.propertiesMenuItem.setEnabled(false);
        this.createZoneButton.setEnabled(false);
        this.addMembersMenuItem.setEnabled(false);
        this.createMembersMenuItem.setEnabled(false);
        this.setZoneTypeMenuItem.setEnabled(false);
        this.renameMenuItem.setEnabled(false);
        this.removeMenuItem.setEnabled(false);
        this.purgeZoneMenuItem.setEnabled(false);
        this.purgeAliasMenuItem.setEnabled(false);
        this.removeAliasAllTogether.setEnabled(false);
        this.setActiveZoneSet.setEnabled(false);
        this.deleteZoneSet.setEnabled(false);
        this.renameZoneSet.setEnabled(false);
        this.addToZoneButton.setEnabled(false);
        if (sanSurferTreeNodeArray != null) {
            if (sanSurferTreeNodeArray.length == 1 && sanSurferTreeNodeArray[0].getNodeType() != 12) {
                this.propertiesMenuItem.setEnabled(true);
            }
            int n = 0;
            while (n < sanSurferTreeNodeArray.length) {
                if (sanSurferTreeNodeArray[n] != null) {
                    Object object = sanSurferTreeNodeArray[n].getUserObject();
                    switch (sanSurferTreeNodeArray[n].getNodeType()) {
                        case 0: {
                            break;
                        }
                        case 8: 
                        case 9: {
                            ZoneSet zoneSet = (ZoneSet)object;
                            if (sanSurferTreeNodeArray.length == 1) {
                                this.addZoneMenuItem.setEnabled(true);
                                this.createZoneButton.setEnabled(true);
                            }
                            if (zoneSet.getIsOrphanZoneSet()) break;
                            if (sanSurferTreeNodeArray.length == 1) {
                                this.renameMenuItem.setEnabled(true);
                                if (this.fcSwitch instanceof Sanbox) {
                                    this.setActiveZoneSet.setEnabled(true);
                                }
                                this.deleteZoneSet.setEnabled(true);
                                this.renameZoneSet.setEnabled(true);
                            }
                            this.removeMenuItem.setEnabled(true);
                            break;
                        }
                        case 10: {
                            this.addToZoneButton.setEnabled(true);
                            if (sanSurferTreeNodeArray.length == 1) {
                                this.renameMenuItem.setEnabled(true);
                                this.addMembersMenuItem.setEnabled(true);
                                this.createMembersMenuItem.setEnabled(true);
                                this.setZoneTypeMenuItem.setEnabled(true);
                            }
                            this.removeMenuItem.setEnabled(true);
                            this.purgeZoneMenuItem.setEnabled(true);
                            break;
                        }
                        case 11: {
                            this.addToZoneButton.setEnabled(true);
                            if (sanSurferTreeNodeArray.length == 1) {
                                this.renameMenuItem.setEnabled(true);
                                this.addMembersMenuItem.setEnabled(true);
                                this.createMembersMenuItem.setEnabled(true);
                            }
                            this.purgeAliasMenuItem.setEnabled(true);
                            this.removeAliasAllTogether.setEnabled(true);
                            this.removeMenuItem.setEnabled(true);
                            break;
                        }
                        case 12: {
                            this.removeMenuItem.setEnabled(true);
                        }
                    }
                }
                ++n;
            }
        }
        if (!this.zoneSetTree.isDragging()) {
            this.setMemberTreeHighlights();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Zone zone;
        Object object;
        int n;
        int n2;
        SanSurferTreeNode[] sanSurferTreeNodeArray;
        Object object2 = actionEvent.getSource();
        if (object2 == this.setActiveZoneSet) {
            this.setActiveZoneSet();
        }
        if (object2 == this.addZoneToZoneSet || object2 == this.addZoneMenuItem) {
            this.createZone();
        }
        if (object2 == this.deleteZoneSet || object2 == this.removeMenuItem) {
            this.delete();
        }
        if (object2 == this.removeZoneFromZoneSet) {
            this.delete();
        }
        if ((object2 == this.removeZoneAllTogether || object2 == this.purgeZoneMenuItem) && (sanSurferTreeNodeArray = this.getSelectedNodes(this.zoneSetTree.getTree())) != null) {
            n2 = sanSurferTreeNodeArray.length;
            n = 0;
            while (n < n2) {
                if (sanSurferTreeNodeArray[n] != null && (object = sanSurferTreeNodeArray[n].getUserObject()) instanceof Zone) {
                    zone = (Zone)object;
                    this.zones.removeZone(zone);
                }
                ++n;
            }
        }
        if ((object2 == this.removeAliasAllTogether || object2 == this.purgeAliasMenuItem) && (sanSurferTreeNodeArray = this.getSelectedNodes(this.zoneSetTree.getTree())) != null) {
            n2 = sanSurferTreeNodeArray.length;
            n = 0;
            while (n < n2) {
                if (sanSurferTreeNodeArray[n] != null && (object = sanSurferTreeNodeArray[n].getUserObject()) instanceof ZoneAlias) {
                    zone = (ZoneAlias)object;
                    this.zones.removeZoneAlias((ZoneAlias)zone);
                }
                ++n;
            }
        }
        if (object2 == this.addZoneMembers || object2 == this.addMembersMenuItem) {
            this.addToZone();
        }
        if (object2 == this.createZoneMembers || object2 == this.createMembersMenuItem || object2 == this.zoneAliasCreateMembers) {
            this.createZoneMembers();
        }
        if (object2 == this.removeZoneMembers) {
            this.delete();
        }
        if (object2 == this.zonesProperties || object2 == this.zoneSetProperties || object2 == this.zoneProperties || object2 == this.zoneAliasProperties || object2 == this.propertiesMenuItem) {
            this.properties();
        }
        if (object2 == this.createZoneSet || object2 == this.createZoneSetMenuItem) {
            this.createZoneSet();
        }
        if (object2 == this.createZoneAlias || object2 == this.createZoneAliasMenuItem) {
            this.createZoneAlias();
        }
        if (object2 == this.clearAll || object2 == this.removeAllMenuItem) {
            this.clearZoningDb();
        }
        if (object2 == this.renameMenuItem || object2 == this.renameZoneSet || object2 == this.renameZone || object2 == this.renameZoneAlias) {
            this.rename();
        }
        if (object2 == this.setZoneType || object2 == this.setZoneTypeMenuItem) {
            this.setZoneType();
        }
        if (object2 == this.saveMenuItem) {
            this.save();
        }
        if (object2 == this.loadMenuItem) {
            this.load();
        }
    }

    private void setZoneType() {
        SanSurferTreeNode[] sanSurferTreeNodeArray = this.getSelectedNodes(this.zoneSetTree.getTree());
        if (sanSurferTreeNodeArray != null) {
            if (sanSurferTreeNodeArray.length != 1) {
                return;
            }
            if (sanSurferTreeNodeArray[0] != null) {
                Object object = sanSurferTreeNodeArray[0].getUserObject();
                switch (sanSurferTreeNodeArray[0].getNodeType()) {
                    case 10: {
                        Zone zone = (Zone)object;
                        SetZoneTypeDialog setZoneTypeDialog = new SetZoneTypeDialog(this, zone);
                        setZoneTypeDialog.setVisible(true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void save() {
        int n;
        File file;
        if (fileChooser.showSaveDialog(this) != 0) return;
        String string = fileChooser.getSelectedFile().toString();
        if (!string.endsWith(".xml")) {
            string = string + ".xml";
        }
        if ((file = new File(string)).exists() && (n = JOptionPane.showConfirmDialog(this, FabricTreeControl.getResource("ZoningDialog.theFile") + " " + string + " " + FabricTreeControl.getResource("ZoningDialog.overwriteIt"), FabricTreeControl.getResource("ZoningDialog.savingZoning"), 0)) == 1) {
            return;
        }
        ZoningFile zoningFile = new ZoningFile(this.zones);
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        try {
            try {
                zoningFile.save(string);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.errorSaving") + iOException.toString(), FabricTreeControl.getResource("ZoningDialog.saveZoning"), 0);
                Object var7_7 = null;
                this.setCursor(cursor);
                return;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.setCursor(cursor);
            throw throwable;
        }
        this.setCursor(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (fileChooser.showOpenDialog(this) == 0) {
            String string = fileChooser.getSelectedFile().toString();
            if (!string.endsWith(".xml")) {
                string = string + ".xml";
            }
            Cursor cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            try {
                try {
                    Zones zones = this.zones.getEmptyZones();
                    ZoningFile zoningFile = new ZoningFile(zones);
                    zoningFile.parse(string);
                    this.zones.copyZones(zones);
                    if (!(this.fcSwitch instanceof Sanbox)) {
                        this.zones.setActiveZoneSet(null);
                    }
                    this.zoneSetTree.fillTree();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.errorLoadingZoning") + string + FabricTreeControl.getResource("ZoningDialog.thereWasAnError"), FabricTreeControl.getResource("ZoningDialog.loadZoning"), 0);
                    this.setCursor(cursor);
                    Object var6_8 = null;
                    this.setCursor(cursor);
                    return;
                }
                catch (ZoningFileException zoningFileException) {
                    JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.errorLoadingZoning") + " " + zoningFileException.getMessage(), FabricTreeControl.getResource("ZoningDialog.loadZoning"), 0);
                    this.setCursor(cursor);
                    Object var6_9 = null;
                    this.setCursor(cursor);
                    return;
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.setCursor(cursor);
                throw throwable;
            }
            this.setCursor(cursor);
            if (!this.zones.okToSave()) {
                this.showLimits();
            }
        }
    }

    void clearMemberTree() {
        SanSurferTreeNode sanSurferTreeNode = this.getRootNode(this.memberTreeModel);
        int n = sanSurferTreeNode.getChildCount() - 1;
        while (n >= 0) {
            TreeNode treeNode = sanSurferTreeNode.getChildAt(n);
            this.memberTreeModel.removeNodeFromParent((MutableTreeNode)treeNode);
            --n;
        }
    }

    private void setMemberTreeHighlights() {
        this.setErrorLabel();
        ZoneSet zoneSet = this.getSelectedSet();
        if (zoneSet != this.lastSetHighlighted) {
            this.lastSetHighlighted = zoneSet;
            SanSurferTreeNode sanSurferTreeNode = this.getRootNode(this.memberTreeModel);
            if (sanSurferTreeNode != null) {
                this.setNodeHighlights(zoneSet, sanSurferTreeNode);
            }
            this.memberTree.repaint();
        }
    }

    private void setNodeHighlights(ZoneSet zoneSet, SanSurferTreeNode sanSurferTreeNode) {
        this.setNodeMemberHighlight(zoneSet, sanSurferTreeNode);
        int n = 0;
        while (n < sanSurferTreeNode.getChildCount()) {
            SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
            this.setNodeHighlights(zoneSet, sanSurferTreeNode2);
            ++n;
        }
    }

    private void setNodeMemberHighlight(ZoneSet zoneSet, SanSurferTreeNode sanSurferTreeNode) {
        long l = -1L;
        switch (sanSurferTreeNode.getNodeType()) {
            case 5: {
                FCPort fCPort = (FCPort)sanSurferTreeNode.getUserObject();
                l = StringUtilities.parseLongHexString(fCPort.getZoningStr());
                break;
            }
            case 7: {
                FCNode fCNode = (FCNode)sanSurferTreeNode.getUserObject();
                l = StringUtilities.parseLongHexString(fCNode.getWwnZoningStr());
                break;
            }
            case 6: {
                FCNode fCNode = (FCNode)sanSurferTreeNode.getUserObject();
                l = StringUtilities.parseLongHexString(fCNode.getNPortZoningStr());
            }
        }
        if (l > 0L) {
            ZoneMember zoneMember = this.zones.findZoneMember(l);
            boolean bl = false;
            if (zoneSet != null && zoneMember != null && this.zones.isMemberInZoneSet(zoneMember, zoneSet)) {
                bl = true;
            }
            sanSurferTreeNode.setHighlighted(bl);
            this.memberTreeModel.nodeChanged(sanSurferTreeNode);
        }
    }

    private void fillMemberTree() {
        this.memberTreeSource.setZones(this.zones);
        this.clearMemberTree();
        SanSurferTreeNode sanSurferTreeNode = this.getRootNode(this.memberTreeModel);
        if (sanSurferTreeNode != null) {
            Fabric fabric = FabricList.getFabric((Chassis)this.fcSwitch);
            Object object = null;
            object = fabric != null ? fabric.getFirstSwitch() : this.fcSwitch;
            while (object != null) {
                Object object2;
                SanboxChassis sanboxChassis;
                SanSurferTreeNode sanSurferTreeNode2 = ZoningUtilities.findTreeNode(sanSurferTreeNode, object, 0);
                if (sanSurferTreeNode2 == null) {
                    sanSurferTreeNode2 = this.addSwitchToTree(this.memberTreeModel, sanSurferTreeNode, (Chassis)object);
                }
                if (object instanceof SanboxChassis) {
                    sanboxChassis = (SanboxChassis)object;
                    if (sanboxChassis instanceof Sanbox8000) {
                        object2 = (Sanbox8000)sanboxChassis;
                        int n = 0;
                        while (n < 8) {
                            Sanbox8000Blade sanbox8000Blade = object2.getBlade(n);
                            SanSurferTreeNode sanSurferTreeNode3 = this.addBladeToTree(this.memberTreeModel, sanSurferTreeNode2, sanbox8000Blade);
                            int n2 = n * 8;
                            while (n2 < (n + 1) * 8) {
                                FCPort fCPort = sanboxChassis.getPort(n2);
                                this.addPortToParent(fCPort, sanSurferTreeNode3);
                                ++n2;
                            }
                            ++n;
                        }
                    } else {
                        object2 = sanboxChassis.getFirstPort();
                        while (object2 != null) {
                            this.addPortToParent((FCPort)object2, sanSurferTreeNode2);
                            object2 = sanboxChassis.getNextPort((FCPort)object2);
                        }
                    }
                } else {
                    sanboxChassis = object.getFirstNode();
                    while (sanboxChassis != null) {
                        object2 = ZoningUtilities.findTreeNode(sanSurferTreeNode2, sanboxChassis, 2);
                        if (object2 == null) {
                            object2 = this.addNodeToTree(this.memberTreeModel, sanSurferTreeNode2, (FCNode)sanboxChassis, false);
                            this.addNodeToTree(this.memberTreeModel, (SanSurferTreeNode)object2, (FCNode)sanboxChassis, true);
                        }
                        sanboxChassis = object.getNextNode((FCNode)sanboxChassis);
                    }
                }
                if (sanSurferTreeNode2.getChildCount() == 0) {
                    sanSurferTreeNode.remove(sanSurferTreeNode2);
                }
                object = fabric != null ? fabric.getNextSwitch(object) : null;
            }
        }
        this.expandAll(this.memberTree);
    }

    private void addPortToParent(FCPort fCPort, SanSurferTreeNode sanSurferTreeNode) {
        if (fCPort.getFcAddress() != 0) {
            String string;
            SanSurferTreeNode sanSurferTreeNode2 = sanSurferTreeNode;
            SanSurferTreeNode sanSurferTreeNode3 = ZoningUtilities.findTreeNode(sanSurferTreeNode, fCPort, 0);
            if (sanSurferTreeNode3 == null && ((string = VendorProperties.getResource("zoning.portBasedZoningAllowed")) == null || string.equals("True"))) {
                sanSurferTreeNode2 = sanSurferTreeNode3 = this.addPortToTree(this.memberTreeModel, sanSurferTreeNode, fCPort);
            }
            int n = 0;
            while (n < fCPort.getNodeCount()) {
                FCNode fCNode = fCPort.getNode(n);
                SanSurferTreeNode sanSurferTreeNode4 = ZoningUtilities.findTreeNode(sanSurferTreeNode2, fCNode, 0);
                if (sanSurferTreeNode4 == null) {
                    sanSurferTreeNode4 = this.addNodeToTree(this.memberTreeModel, sanSurferTreeNode2, fCNode, false);
                    this.addNodeToTree(this.memberTreeModel, sanSurferTreeNode4, fCNode, true);
                }
                ++n;
            }
        }
    }

    private SanSurferTreeNode addSwitchToTree(DefaultTreeModel defaultTreeModel, SanSurferTreeNode sanSurferTreeNode, Chassis chassis) {
        Object object;
        int n = -1;
        if (chassis instanceof SanboxChassis) {
            object = (SanboxChassis)chassis;
            switch (object.getChassisType()) {
                case 2: {
                    n = 2;
                    break;
                }
                case 0: {
                    n = 3;
                    break;
                }
                case 16: {
                    n = 4;
                    break;
                }
                case 8: {
                    n = 14;
                    break;
                }
                case 30: {
                    n = 16;
                    break;
                }
                case 26: {
                    n = 17;
                    break;
                }
                case 33: 
                case 38: {
                    n = 18;
                }
            }
        } else {
            n = chassis instanceof Director ? 15 : 99;
        }
        object = new SanSurferTreeNode((Object)chassis, n);
        defaultTreeModel.insertNodeInto((MutableTreeNode)object, sanSurferTreeNode, sanSurferTreeNode.getChildCount());
        return object;
    }

    private SanSurferTreeNode getRootNode(DefaultTreeModel defaultTreeModel) {
        SanSurferTreeNode sanSurferTreeNode = (SanSurferTreeNode)defaultTreeModel.getRoot();
        return sanSurferTreeNode;
    }

    private SanSurferTreeNode addBladeToTree(DefaultTreeModel defaultTreeModel, SanSurferTreeNode sanSurferTreeNode, Sanbox8000Blade sanbox8000Blade) {
        SanSurferTreeNode sanSurferTreeNode2 = new SanSurferTreeNode(sanbox8000Blade, 19, false);
        defaultTreeModel.insertNodeInto(sanSurferTreeNode2, sanSurferTreeNode, sanSurferTreeNode.getChildCount());
        return sanSurferTreeNode2;
    }

    private SanSurferTreeNode addPortToTree(DefaultTreeModel defaultTreeModel, SanSurferTreeNode sanSurferTreeNode, FCPort fCPort) {
        long l = StringUtilities.parseLongHexString(fCPort.getZoningStr());
        ZoneMember zoneMember = this.zones.findZoneMember(l);
        boolean bl = false;
        ZoneSet zoneSet = this.getSelectedSet();
        if (zoneSet != null && zoneMember != null && this.zones.isMemberInZoneSet(zoneMember, zoneSet)) {
            bl = true;
        }
        SanSurferTreeNode sanSurferTreeNode2 = new SanSurferTreeNode(fCPort, 5, bl);
        defaultTreeModel.insertNodeInto(sanSurferTreeNode2, sanSurferTreeNode, sanSurferTreeNode.getChildCount());
        return sanSurferTreeNode2;
    }

    private SanSurferTreeNode addNodeToTree(DefaultTreeModel defaultTreeModel, SanSurferTreeNode sanSurferTreeNode, FCNode fCNode, boolean bl) {
        int n;
        long l;
        if (bl) {
            l = StringUtilities.parseLongHexString(fCNode.getWwnZoningStr());
            n = 7;
        } else {
            l = StringUtilities.parseLongHexString(fCNode.getNPortZoningStr());
            n = 6;
        }
        ZoneMember zoneMember = this.zones.findZoneMember(l);
        boolean bl2 = false;
        ZoneSet zoneSet = this.getSelectedSet();
        if (zoneSet != null && zoneMember != null && this.zones.isMemberInZoneSet(zoneMember, zoneSet)) {
            bl2 = true;
        }
        SanSurferTreeNode sanSurferTreeNode2 = new SanSurferTreeNode(fCNode, n, bl2);
        defaultTreeModel.insertNodeInto(sanSurferTreeNode2, sanSurferTreeNode, sanSurferTreeNode.getChildCount());
        return sanSurferTreeNode2;
    }

    private ZoneSet getSelectedSet() {
        SanSurferTreeNode[] sanSurferTreeNodeArray = this.getSelectedNodes(this.zoneSetTree.getTree());
        if (sanSurferTreeNodeArray != null) {
            SanSurferTreeNode sanSurferTreeNode = sanSurferTreeNodeArray[0];
            while (sanSurferTreeNode != null) {
                Object object = sanSurferTreeNode.getUserObject();
                switch (sanSurferTreeNode.getNodeType()) {
                    case 8: 
                    case 9: {
                        ZoneSet zoneSet = (ZoneSet)sanSurferTreeNode.getUserObject();
                        return zoneSet;
                    }
                }
                sanSurferTreeNode = (SanSurferTreeNode)sanSurferTreeNode.getParent();
            }
        }
        return null;
    }

    private TreePath createFabricTreePath(DefaultTreeModel defaultTreeModel) {
        Object[] objectArray = new Object[]{this.getRootNode(defaultTreeModel)};
        return new TreePath(objectArray);
    }

    private void expandAll(JTree jTree) {
        int n = 0;
        while (n < jTree.getRowCount()) {
            jTree.expandRow(n);
            ++n;
        }
    }

    private void setActiveZoneSet() {
        Object object;
        ZoneSet zoneSet = null;
        SanSurferTreeNode sanSurferTreeNode = this.zoneSetTree.getSelectedNode();
        if (sanSurferTreeNode != null && (object = sanSurferTreeNode.getUserObject()) instanceof ZoneSet) {
            zoneSet = (ZoneSet)object;
        }
        if (zoneSet != null) {
            if (zoneSet.equals((Object)this.zones.getActiveZoneSet())) {
                zoneSet = null;
            }
            this.zones.setActiveZoneSet(zoneSet);
        }
    }

    private void createZoneAlias() {
        if (!this.zones.moreAliasesAllowed()) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.unableToCreateAlias"), FabricTreeControl.getResource("ZoningDialog.createAlias"), 1);
            return;
        }
        NewZoningItemDialog newZoningItemDialog = new NewZoningItemDialog(FabricTreeControl.getResource("ZoningDialog.createAlias"), FabricTreeControl.getResource("ZoningDialog.aliasName"), this);
        newZoningItemDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.createAliasDialogHelp"));
        newZoningItemDialog.show();
        if (newZoningItemDialog.getOption() == 1) {
            String string = newZoningItemDialog.getNewZoningItemName();
            if (this.zones.findZoneAlias(string) != null) {
                JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.aliasMustBeUnique"), FabricTreeControl.getResource("ZoningDialog.createAnAlias"), 0);
            } else {
                ZoneAlias zoneAlias = this.zones.createZoneAlias(string);
                if (zoneAlias == null) {
                    JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.unableToCreateAlias"), FabricTreeControl.getResource("ZoningDialog.createAlias"), 1);
                } else {
                    this.zones.addZoneAlias(zoneAlias);
                }
            }
        }
    }

    private void properties() {
        SanSurferTreeNode sanSurferTreeNode = this.zoneSetTree.getSelectedNode();
        if (sanSurferTreeNode != null) {
            switch (sanSurferTreeNode.getNodeType()) {
                case 0: {
                    this.properties(this.zones);
                    break;
                }
                case 8: 
                case 9: {
                    this.properties((ZoneSet)sanSurferTreeNode.getUserObject());
                    break;
                }
                case 10: {
                    this.properties((Zone)sanSurferTreeNode.getUserObject());
                    break;
                }
                case 11: {
                    this.properties((ZoneAlias)sanSurferTreeNode.getUserObject());
                    break;
                }
            }
        }
    }

    private void properties(Zones zones) {
        JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.thisConfig") + " " + zones.getNumberOfZoneSets() + " " + FabricTreeControl.getResource("ZoningDialog.sets") + "\n" + zones.getNumberOfZones() + " " + FabricTreeControl.getResource("ZoningDialog.zones") + "\n" + zones.getMemberCount() + " " + FabricTreeControl.getResource("ZoningDialog.totalMembers") + "\n" + zones.getNumberOfZoneAliases() + " " + FabricTreeControl.getResource("ZoningDialog.aliases") + "\n", "Properties", 0);
    }

    private void properties(ZoneSet zoneSet) {
        JOptionPane.showMessageDialog(this, zoneSet.getName() + " " + FabricTreeControl.getResource("ZoningDialog.has") + " " + zoneSet.getNumberOfZones() + " " + FabricTreeControl.getResource("ZoningDialog.zones") + "\n" + zoneSet.getMembersInSet() + " " + FabricTreeControl.getResource("ZoningDialog.totalMembers") + "\n", "Properties", 0);
    }

    private void properties(Zone zone) {
        JOptionPane.showMessageDialog(this, zone.getName() + " " + FabricTreeControl.getResource("ZoningDialog.has") + " " + zone.getMemberCount() + " " + FabricTreeControl.getResource("ZoningDialog.elements") + "\n" + zone.getMembersInZone() + " " + FabricTreeControl.getResource("ZoningDialog.totalMembers") + "\n", "Properties", 0);
    }

    private void properties(ZoneAlias zoneAlias) {
        JOptionPane.showMessageDialog(this, zoneAlias.getName() + " " + FabricTreeControl.getResource("ZoningDialog.has") + " " + zoneAlias.getMemberCount() + " " + FabricTreeControl.getResource("ZoningDialog.elements") + "\n", "Properties", 0);
    }

    private void createZoneSet() {
        if (!this.zones.moreZoneSetsAllowed()) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.unableToCreateZoneSet"), FabricTreeControl.getResource("ZoningDialog.createAZoneSet"), 1);
            return;
        }
        NewZoningItemDialog newZoningItemDialog = new NewZoningItemDialog(FabricTreeControl.getResource("ZoningDialog.createAZoneSet"), FabricTreeControl.getResource("ZoningDialog.zoneSetName"), this);
        newZoningItemDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.createZoneSetDialogHelp"));
        newZoningItemDialog.show();
        if (newZoningItemDialog.getOption() == 1) {
            String string = newZoningItemDialog.getNewZoningItemName();
            if (this.zones.findZoneSet(string) != null) {
                JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.zoneNameMustBeUnique"), FabricTreeControl.getResource("ZoningDialog.createAZoneSet"), 0);
            } else {
                ZoneSet zoneSet = null;
                zoneSet = this.zones.createZoneSet(string);
                if (zoneSet == null) {
                    JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.unableToCreateZoneSet"), FabricTreeControl.getResource("ZoningDialog.createAZoneSet"), 1);
                }
            }
        }
    }

    public void createZone() {
        Object object;
        if (!this.zones.moreZonesAllowed()) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.unableToCreateZone"), FabricTreeControl.getResource("ZoningDialog.createAZone"), 1);
            return;
        }
        ZoneSet zoneSet = null;
        SanSurferTreeNode sanSurferTreeNode = this.zoneSetTree.getSelectedNode();
        if (sanSurferTreeNode != null && (object = sanSurferTreeNode.getUserObject()) instanceof ZoneSet) {
            zoneSet = (ZoneSet)object;
        }
        object = null;
        boolean bl = false;
        while (!bl) {
            NewZoningItemDialog newZoningItemDialog = new NewZoningItemDialog(FabricTreeControl.getResource("ZoningDialog.createAZone"), FabricTreeControl.getResource("ZoningDialog.zoneName"), this);
            newZoningItemDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.createZoneDialogHelp"));
            newZoningItemDialog.show();
            if (newZoningItemDialog.getOption() == 1) {
                int n;
                String string = newZoningItemDialog.getNewZoningItemName();
                object = this.zones.findZone(string);
                if (object == null) {
                    object = this.zones.createZone(string);
                    n = 0;
                    if (zoneSet != null && !zoneSet.getIsOrphanZoneSet()) {
                        if (this.zones.addZoneToSet((Zone)object, zoneSet) != 0) {
                            n = 1;
                            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.unableToAddZoneToSet"), FabricTreeControl.getResource("ZoningDialog.createAZone"), 1);
                        }
                    } else {
                        n = 1;
                    }
                    if (n != 0) {
                        JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.orphanZoneCreated"), FabricTreeControl.getResource("ZoningDialog.createAZone"), 1);
                    }
                    bl = true;
                    continue;
                }
                if (zoneSet != null && zoneSet.findZone(string) == null) {
                    if (zoneSet.getIsOrphanZoneSet()) {
                        JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.zoneNameAlreadyExists"), FabricTreeControl.getResource("ZoningDialog.createAZone"), 0);
                        continue;
                    }
                    n = JOptionPane.showConfirmDialog(this, FabricTreeControl.getResource("ZoningDialog.zoneNameAlreadyExists") + "\n" + FabricTreeControl.getResource("ZoningDialog.wouldYouLikeToAddIt"), FabricTreeControl.getResource("ZoningDialog.createAZone"), 0);
                    if (n != 0) continue;
                    if (this.zones.addZoneToSet((Zone)object, zoneSet) != 0) {
                        JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.unableToAddZoneToSet"), FabricTreeControl.getResource("ZoningDialog.createAZone"), 1);
                    }
                    bl = true;
                    continue;
                }
                JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.zoneAlreadyInThisSet"), FabricTreeControl.getResource("ZoningDialog.createAZone"), 0);
                continue;
            }
            bl = true;
        }
    }

    private void createZoneMembers() {
        Object object;
        if (!this.zones.moreMembersAllowed()) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoneSetTree.maxMembers"), FabricTreeControl.getResource("ZoningDialog.createAZoneMember"), 1);
            return;
        }
        Zone zone = null;
        SanSurferTreeNode sanSurferTreeNode = this.zoneSetTree.getSelectedNode();
        if (sanSurferTreeNode != null && (object = sanSurferTreeNode.getUserObject()) instanceof Zone) {
            zone = (Zone)object;
        }
        if (zone == null) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.selectAZone"), FabricTreeControl.getResource("ZoningDialog.createAZoneMember"), 1);
            return;
        }
        object = new NewZoningMemberDialog(FabricTreeControl.getResource("ZoningDialog.createAZoneMember"), this);
        ((Dialog)object).show();
        if (((NewZoningMemberDialog)object).getOption() == 1) {
            String string = ((NewZoningMemberDialog)object).getNewZoningMemberName();
            ZoneMember zoneMember = this.zones.createZoneMember(string);
            Vector<ZoneMember> vector = new Vector<ZoneMember>();
            vector.add(zoneMember);
            this.zones.addZoneMembersToZone(zone, vector);
        }
    }

    private void closeWithCancel() {
        WindowEvent windowEvent = new WindowEvent(this, 201);
        this.closeWithCancel(windowEvent);
    }

    private void closeWithCancel(WindowEvent windowEvent) {
        if (this.zones.getDirtyFlag()) {
            switch (JOptionPane.showConfirmDialog(this, FabricTreeControl.getResource("ZoningDialog.saveChanges"), FabricTreeControl.getResource("ZoningDialog.apply"), 1)) {
                case 0: {
                    this.saveZoningInfo(true);
                    return;
                }
                case 1: {
                    super.processWindowEvent(windowEvent);
                    break;
                }
                case 2: {
                    return;
                }
            }
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.closeWithCancel(windowEvent);
        }
    }

    private void delete() {
        SanSurferTreeNode[] sanSurferTreeNodeArray = this.getSelectedNodes(this.zoneSetTree.getTree());
        int n = -1;
        if (sanSurferTreeNodeArray != null) {
            int n2;
            int n3;
            if (sanSurferTreeNodeArray.length > 0) {
                int[] nArray = this.zoneSetTree.getTree().getSelectionRows();
                n = nArray[0];
                n3 = 1;
                while (n3 < nArray.length) {
                    if (nArray[n3] < n) {
                        n = nArray[n3];
                    }
                    ++n3;
                }
                --n;
            }
            if ((n2 = JOptionPane.showConfirmDialog(this, FabricTreeControl.getResource("ZoningDialog.removeZoningItems"), FabricTreeControl.getResource("ZoningDialog.remove"), 0)) == 0) {
                n3 = 0;
                while (n3 < sanSurferTreeNodeArray.length) {
                    if (sanSurferTreeNodeArray[n3] != null) {
                        Object object = sanSurferTreeNodeArray[n3].getUserObject();
                        switch (sanSurferTreeNodeArray[n3].getNodeType()) {
                            case 0: {
                                this.zones.clearZones();
                                this.zoneSetTree.fillTree();
                                break;
                            }
                            case 8: 
                            case 9: {
                                ZoneSet zoneSet = (ZoneSet)object;
                                if (!zoneSet.getIsOrphanZoneSet()) {
                                    this.zones.removeZoneSet(zoneSet);
                                    break;
                                }
                                JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.orphanZoneCantBeDeleted"), FabricTreeControl.getResource("ZoningDialog.remove"), 0);
                                break;
                            }
                            case 10: {
                                ZoneSet zoneSet = (Zone)object;
                                SanSurferTreeNode sanSurferTreeNode = (SanSurferTreeNode)sanSurferTreeNodeArray[n3].getParent();
                                ZoneSet zoneSet2 = (ZoneSet)sanSurferTreeNode.getUserObject();
                                if (zoneSet2.getIsOrphanZoneSet()) {
                                    this.zones.removeZone((Zone)zoneSet);
                                    break;
                                }
                                zoneSet2.removeZone((Zone)zoneSet);
                                break;
                            }
                            case 11: {
                                Vector<ZoneSet> vector;
                                ZoneSet zoneSet2;
                                ZoneSet zoneSet = (ZoneAlias)object;
                                SanSurferTreeNode sanSurferTreeNode = (SanSurferTreeNode)sanSurferTreeNodeArray[n3].getParent();
                                if (sanSurferTreeNode.getUserObject() instanceof Zone) {
                                    zoneSet2 = (Zone)sanSurferTreeNode.getUserObject();
                                    vector = new Vector();
                                    vector.add(zoneSet);
                                    zoneSet2.removeMembers(vector);
                                    break;
                                }
                                this.zones.removeZoneAlias((ZoneAlias)zoneSet);
                                break;
                            }
                            case 12: {
                                ZoneSet zoneSet = (ZoneMember)object;
                                SanSurferTreeNode sanSurferTreeNode = (SanSurferTreeNode)sanSurferTreeNodeArray[n3].getParent();
                                ZoneSet zoneSet2 = (Zone)sanSurferTreeNode.getUserObject();
                                Vector<ZoneSet> vector = new Vector<ZoneSet>();
                                vector.add(zoneSet);
                                zoneSet2.removeMembers(vector);
                            }
                        }
                    }
                    ++n3;
                }
            }
        }
        if (n >= 0) {
            this.zoneSetTree.getTree().setSelectionRow(n);
        }
    }

    private void rename() {
        SanSurferTreeNode[] sanSurferTreeNodeArray = this.getSelectedNodes(this.zoneSetTree.getTree());
        if (sanSurferTreeNodeArray != null) {
            if (sanSurferTreeNodeArray.length != 1) {
                return;
            }
            if (sanSurferTreeNodeArray[0] != null) {
                Object object = sanSurferTreeNodeArray[0].getUserObject();
                switch (sanSurferTreeNodeArray[0].getNodeType()) {
                    case 8: 
                    case 9: {
                        ZoneSet zoneSet = (ZoneSet)object;
                        if (zoneSet.getIsOrphanZoneSet()) break;
                        this.renameZoneSet(zoneSet);
                        break;
                    }
                    case 10: {
                        Zone zone = (Zone)object;
                        this.renameZone(zone);
                        break;
                    }
                    case 11: {
                        ZoneAlias zoneAlias = (ZoneAlias)object;
                        this.renameZoneAlias(zoneAlias);
                        break;
                    }
                }
            }
        }
    }

    private void renameZoneSet(ZoneSet zoneSet) {
        NewZoningItemDialog newZoningItemDialog = new NewZoningItemDialog(FabricTreeControl.getResource("ZoningDialog.renameZoneSet"), FabricTreeControl.getResource("ZoningDialog.zoneSetName"), this);
        newZoningItemDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.renameZoneSetDialogHelp"));
        newZoningItemDialog.setItemName(zoneSet.getName());
        newZoningItemDialog.setVisible(true);
        if (newZoningItemDialog.getOption() == 1 && !zoneSet.getName().equals(newZoningItemDialog.getNewZoningItemName()) && !this.zones.renameZoneSet(zoneSet, newZoningItemDialog.getNewZoningItemName())) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.zoneSetUsed"), FabricTreeControl.getResource("ZoningDialog.rename"), 0);
        }
    }

    private void renameZone(Zone zone) {
        NewZoningItemDialog newZoningItemDialog = new NewZoningItemDialog(FabricTreeControl.getResource("ZoningDialog.renameZone"), FabricTreeControl.getResource("ZoningDialog.zoneName"), this);
        newZoningItemDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.renameZoneDialogHelp"));
        newZoningItemDialog.setItemName(zone.getName());
        newZoningItemDialog.setVisible(true);
        if (newZoningItemDialog.getOption() == 1 && !zone.getName().equals(newZoningItemDialog.getNewZoningItemName()) && !this.zones.renameZone(zone, newZoningItemDialog.getNewZoningItemName())) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.nameNameUsed"), FabricTreeControl.getResource("ZoningDialog.rename"), 0);
        }
    }

    private void renameZoneAlias(ZoneAlias zoneAlias) {
        NewZoningItemDialog newZoningItemDialog = new NewZoningItemDialog(FabricTreeControl.getResource("ZoningDialog.renameAlias"), FabricTreeControl.getResource("ZoningDialog.aliasName"), this);
        newZoningItemDialog.setContextHelpFile(QHelpUtilities.getResource("QDialog.renameAliasDialogHelp"));
        newZoningItemDialog.setItemName(zoneAlias.getName());
        newZoningItemDialog.setVisible(true);
        if (newZoningItemDialog.getOption() == 1 && !zoneAlias.getName().equals(newZoningItemDialog.getNewZoningItemName()) && !this.zones.renameZoneAlias(zoneAlias, newZoningItemDialog.getNewZoningItemName())) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.aliasNameUsed"), FabricTreeControl.getResource("ZoningDialog.rename"), 0);
        }
    }

    private void clearZoningDb() {
        int n = JOptionPane.showConfirmDialog(this, FabricTreeControl.getResource("ZoningDialog.removeAllZoneSets"), FabricTreeControl.getResource("ZoningDialog.removeAll"), 0);
        if (n == 0) {
            this.zones.clearZones();
            this.zoneSetTree.fillTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addToZone() {
        Cursor cursor;
        block5: {
            cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            try {
                SanSurferTreeNode[] sanSurferTreeNodeArray = this.getSelectedNodes(this.zoneSetTree.getTree());
                if (sanSurferTreeNodeArray == null) break block5;
                Vector vector = new Vector();
                int n = 0;
                while (true) {
                    if (n >= sanSurferTreeNodeArray.length) {
                        break block5;
                    }
                    Object object = sanSurferTreeNodeArray[n].getUserObject();
                    if (object instanceof Zone && !this.addZoneMembersToZone((Zone)object)) {
                        this.setCursor(cursor);
                        Object var7_6 = null;
                        break;
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.setCursor(cursor);
                throw throwable;
            }
            this.setCursor(cursor);
            return;
        }
        Object var7_7 = null;
        this.setCursor(cursor);
    }

    private boolean addZoneMembersToZone(Zone zone) {
        SanSurferTreeNode[] sanSurferTreeNodeArray = this.getSelectedNodes(this.memberTree);
        Vector<SanSurferTreeNode> vector = new Vector<SanSurferTreeNode>();
        if (sanSurferTreeNodeArray != null) {
            int n = 0;
            while (n < sanSurferTreeNodeArray.length) {
                if (sanSurferTreeNodeArray[n] instanceof SanSurferTreeNode) {
                    SanSurferTreeNode sanSurferTreeNode = sanSurferTreeNodeArray[n];
                    switch (sanSurferTreeNode.getNodeType()) {
                        case 5: 
                        case 6: 
                        case 7: {
                            vector.add(sanSurferTreeNodeArray[n]);
                        }
                    }
                }
                ++n;
            }
        }
        if (vector.size() > 0) {
            return this.zoneSetTree.addListToZone(zone, vector);
        }
        JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.nothingToAdd"));
        return false;
    }

    private SanSurferTreeNode[] getSelectedNodes(JTree jTree) {
        SanSurferTreeNode[] sanSurferTreeNodeArray = null;
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray != null) {
            int n = treePathArray.length;
            sanSurferTreeNodeArray = new SanSurferTreeNode[n];
            int n2 = 0;
            while (n2 < n) {
                sanSurferTreeNodeArray[n2] = (SanSurferTreeNode)treePathArray[n2].getLastPathComponent();
                ++n2;
            }
        }
        return sanSurferTreeNodeArray;
    }

    private class SavingDialog
    extends QDialog
    implements ActionListener {
        private Timer timer;
        private boolean canceled = false;
        JPanel dataPanel = new JPanel();
        GridBagLayout dataLayout = new GridBagLayout();
        JLabel message;
        JPanel buttonPanel = new JPanel();
        BorderLayout buttonLayout = new BorderLayout();
        JButton cancelButton = new JButton(new CancelAction());
        GridBagLayout newFabricLayout = new GridBagLayout();
        String title = FabricTreeControl.getResource("ZoningDialog.saving") + " - " + VendorProperties.getFrameTitle();
        String messageStr = FabricTreeControl.getResource("ZoningDialog.savingWait");

        public SavingDialog() {
            super((Dialog)ZoningDialog.this, true);
            try {
                this.jbInit();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setTitle(this.title);
            this.message = new JLabel(this.messageStr);
            this.getContentPane().setLayout(this.newFabricLayout);
            this.dataPanel.setLayout(this.dataLayout);
            this.dataPanel.add((Component)this.message, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
            this.getContentPane().add((Component)this.dataPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
            this.buttonPanel.setLayout(this.buttonLayout);
            this.buttonPanel.add((Component)this.cancelButton, "Center");
            this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
            this.getRootPane().setDefaultButton(this.cancelButton);
            this.pack();
        }

        public boolean getCanceled() {
            return this.canceled;
        }

        public void cancelTimer() {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.timer) {
                JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningDialog.unableToCancel"), "", 0);
                this.setVisible(false);
                this.cancelTimer();
            }
        }

        class CancelAction
        extends AbstractAction {
            public CancelAction() {
                super(FabricTreeControl.getResource("ZoningDialog.cancel"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SavingDialog.this.cancelButton.setEnabled(false);
                ZoningDialog.this.fcSwitch.cancelEPortZoningSave();
                SavingDialog.this.message.setText(FabricTreeControl.getResource("ZoningDialog.canceling"));
                SavingDialog.this.pack();
                SavingDialog.this.timer = new Timer(60000, SavingDialog.this);
                SavingDialog.this.timer.start();
                SavingDialog.this.canceled = true;
            }
        }
    }

    protected class MouseListener
    extends MouseInputAdapter {
        public void mouseEntered(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (mouseEvent.isPopupTrigger()) {
                ZoningDialog.this.zoneSetTree.selectItemAtPoint(point);
                this.popupMenu(mouseEvent);
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (mouseEvent.isPopupTrigger()) {
                ZoningDialog.this.zoneSetTree.selectItemAtPoint(point);
                this.popupMenu(mouseEvent);
                return;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (mouseEvent.isPopupTrigger()) {
                ZoningDialog.this.zoneSetTree.selectItemAtPoint(point);
                this.popupMenu(mouseEvent);
                return;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        private void popupMenu(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            SanSurferTreeNode[] sanSurferTreeNodeArray = ZoningDialog.this.getSelectedNodes(ZoningDialog.this.zoneSetTree.getTree());
            if (sanSurferTreeNodeArray == null || sanSurferTreeNodeArray.length > 1) {
                return;
            }
            SanSurferTreeNode sanSurferTreeNode = ZoningDialog.this.zoneSetTree.getSelectedNode();
            if (sanSurferTreeNode != null) {
                switch (sanSurferTreeNode.getNodeType()) {
                    case 0: {
                        ZoningDialog.this.zoneSetTree.showPopup(ZoningDialog.this.zonesPopupMenu, point.x, point.y);
                        break;
                    }
                    case 8: 
                    case 9: {
                        ZoningDialog.this.zoneSetTree.showPopup(ZoningDialog.this.zoneSetPopupMenu, point.x, point.y);
                        break;
                    }
                    case 10: {
                        ZoningDialog.this.zoneSetTree.showPopup(ZoningDialog.this.zonePopupMenu, point.x, point.y);
                        break;
                    }
                    case 11: {
                        ZoningDialog.this.zoneSetTree.showPopup(ZoningDialog.this.zoneAliasPopupMenu, point.x, point.y);
                        break;
                    }
                    case 12: {
                        ZoningDialog.this.zoneSetTree.showPopup(ZoningDialog.this.zoneMemberPopupMenu, point.x, point.y);
                    }
                }
            }
        }
    }

    class AddToZoneAction
    extends AbstractAction {
        public AddToZoneAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public AddToZoneAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ZoningDialog.this.addToZone();
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public DeleteAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ZoningDialog.this.delete();
        }
    }

    class SaveAndQuitAction
    extends AbstractAction {
        public SaveAndQuitAction() {
            super(FabricTreeControl.getResource("ZoningDialog.ok"));
        }

        public SaveAndQuitAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public SaveAndQuitAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ZoningDialog.this.zones.getDirtyFlag()) {
                ZoningDialog.this.saveZoningInfo(true);
            } else {
                ZoningDialog.this.fcSwitch.getEventHandler().removeChassisEventListener((ChassisEventListener)ZoningDialog.this);
                ZoningDialog.this.setVisible(false);
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super(FabricTreeControl.getResource("ZoningDialog.apply"));
        }

        public SaveAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public SaveAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ZoningDialog.this.saveZoningInfo(false);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(FabricTreeControl.getResource("ZoningDialog.cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ZoningDialog.this.closeWithCancel();
        }
    }

    class CreateNewZoneAction
    extends AbstractAction {
        public CreateNewZoneAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public CreateNewZoneAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ZoningDialog.this.createZone();
        }
    }

    class CreateNewZoneAliasAction
    extends AbstractAction {
        public CreateNewZoneAliasAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public CreateNewZoneAliasAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ZoningDialog.this.createZoneAlias();
        }
    }

    class CreateNewZoneSetAction
    extends AbstractAction {
        public CreateNewZoneSetAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public CreateNewZoneSetAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ZoningDialog.this.createZoneSet();
        }
    }

    class CloseSaveDialog
    implements Runnable {
        CloseSaveDialog() {
        }

        public void run() {
            if (ZoningDialog.this.saveDlg != null) {
                ZoningDialog.this.saveDlg.cancelTimer();
                ZoningDialog.this.saveDlg.setVisible(false);
            }
        }
    }
}

