/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.zoning;

import com.qlogic.qms.fabric.SanSurferTreeNode;
import com.qlogic.qms.fabric.zoning.TreeDropTargetListener;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeDropTarget
extends JTree
implements DropTargetListener {
    private DropTarget dropTarget;
    private DataFlavor memberListFlavor;
    private DataFlavor zoneFlavor;
    private DataFlavor zoneAliasFlavor;
    private TreeDropTargetListener listener;
    private boolean dragging;

    public TreeDropTarget(TreeModel treeModel, boolean bl, TreeDropTargetListener treeDropTargetListener) {
        block2: {
            super(treeModel);
            this.dragging = false;
            if (!bl) break block2;
            this.listener = treeDropTargetListener;
            this.dropTarget = new DropTarget(this, 3, this);
            try {
                this.memberListFlavor = new DataFlavor(Class.forName("java.util.Vector"), "Zone Members");
                this.zoneFlavor = new DataFlavor(Class.forName("java.lang.String"), "Zone");
                this.zoneAliasFlavor = new DataFlavor(Class.forName("java.lang.String"), "ZoneAlias");
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.dragging = true;
        dropTargetDragEvent.acceptDrag(3);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.dragging = false;
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(this.memberListFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                Vector vector = (Vector)transferable.getTransferData(this.memberListFlavor);
                this.listener.receiveDrop(vector);
                return;
            }
            if (transferable.isDataFlavorSupported(this.zoneFlavor) || transferable.isDataFlavorSupported(this.zoneAliasFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                String string = (String)transferable.getTransferData(this.zoneFlavor);
                Vector<String> vector = new Vector<String>();
                vector.add(string);
                this.listener.receiveDrop(vector);
                return;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.dragging = false;
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.listener.dragLocation(dropTargetDragEvent.getLocation());
        this.dragging = true;
        Point point = dropTargetDragEvent.getLocation();
        dropTargetDragEvent.rejectDrag();
        int n = this.getRowForLocation(point.x, point.y);
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        boolean bl = false;
        if (treePath != null) {
            List<DataFlavor> list = dropTargetDragEvent.getCurrentDataFlavorsAsList();
            SanSurferTreeNode sanSurferTreeNode = (SanSurferTreeNode)treePath.getLastPathComponent();
            if (sanSurferTreeNode.getNodeType() == 10) {
                if (dropTargetDragEvent.isDataFlavorSupported(this.memberListFlavor)) {
                    dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                    bl = true;
                }
                if (dropTargetDragEvent.isDataFlavorSupported(this.zoneAliasFlavor)) {
                    dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                    bl = true;
                }
            }
            if (sanSurferTreeNode.getNodeType() == 11 && dropTargetDragEvent.isDataFlavorSupported(this.memberListFlavor)) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                bl = true;
            }
            if ((sanSurferTreeNode.getNodeType() == 8 || sanSurferTreeNode.getNodeType() == 9) && dropTargetDragEvent.isDataFlavorSupported(this.zoneFlavor)) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                bl = true;
            }
        }
        if (!bl) {
            this.setSelectionRowz(-1);
        } else {
            this.setSelectionRowz(n);
        }
    }

    public int getSelectionRow() {
        int[] nArray = this.getSelectionRows();
        if (nArray != null && nArray.length == 1) {
            return nArray[0];
        }
        return -1;
    }

    public void setSelectionRowz(int n) {
        if (this.getSelectionRow() != n) {
            SwingUtilities.invokeLater(new SetSel(n));
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public class SetSel
    implements Runnable {
        int row;

        SetSel(int n) {
            this.row = n;
        }

        public void run() {
            TreeDropTarget.this.setSelectionRow(this.row);
        }
    }
}

