/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.zoning;

import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SetZoneTypeDialog
extends QDialog {
    private SanboxChassis theSwitch;
    private JFrame frame;
    private JLabel zoneTypeLabel = new JLabel(FabricTreeControl.getResource("SetZoneTypeDialog.zoneType"));
    private JComboBox zoneType;
    Zone zone;
    private boolean quitWhenDone = true;
    JButton saveButton = new JButton(new SaveAndQuitAction());
    JButton cancelButton = new JButton(new CancelAction());

    public SetZoneTypeDialog(JDialog jDialog, Zone zone) throws IllegalArgumentException {
        super((Dialog)jDialog, true);
        this.setTitle(FabricTreeControl.getResource("ZoningDialog.setZoneType") + " - " + VendorProperties.getFrameTitle());
        this.zone = zone;
        try {
            this.jbinit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doClose() {
        this.setVisible(false);
    }

    private void saveZoningInfo() {
        if (this.zoneType.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this.frame, FabricTreeControl.getResource("SetZoneTypeDialog.invalidZoneType"), this.getTitle(), 0);
            return;
        }
        this.zone.setZoneType(this.zoneType.getSelectedIndex());
    }

    public void jbinit() {
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        boolean bl = false;
        this.zoneType = new JComboBox<String>(Zone.zoneTypeStrings);
        int n = (int)this.zoneType.getPreferredSize().getHeight();
        this.zoneType.setPreferredSize(new Dimension(160, n));
        this.zoneType.setSelectedIndex(this.zone.getZoneType());
        jPanel.add((Component)this.zoneTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        jPanel.add((Component)this.zoneType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 4, 8, 0));
        jPanel2.add(this.saveButton);
        this.saveButton.setMnemonic('O');
        jPanel2.add(this.cancelButton);
        this.cancelButton.setMnemonic('C');
        jPanel2.add(this.helpContextButton);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.setZoneTypeDialogHelp"));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel2);
        this.getContentPane().add((Component)jPanel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.getRootPane().setDefaultButton(this.saveButton);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            if (this.changesMade()) {
                switch (JOptionPane.showConfirmDialog(this.frame, "Would you like to save your changes?", this.getTitle(), 1)) {
                    case 0: {
                        this.saveZoningInfo();
                        this.doClose();
                        return;
                    }
                    case 1: {
                        this.doClose();
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            } else {
                this.doClose();
            }
        }
    }

    private boolean changesMade() {
        return this.zoneType.getSelectedIndex() != this.zone.getZoneType();
    }

    class SaveAndQuitAction
    extends AbstractAction {
        public SaveAndQuitAction() {
            super(FabricTreeControl.getResource("SetZoneTypeDialog.ok"));
        }

        public SaveAndQuitAction(String string) {
            Image image = SbmUtilities.getImage(string);
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public SaveAndQuitAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SetZoneTypeDialog.this.saveZoningInfo();
            SetZoneTypeDialog.this.doClose();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(FabricTreeControl.getResource("SetZoneTypeDialog.cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SetZoneTypeDialog.this.doClose();
        }
    }
}

