/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.zoning;

import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.FixedLengthTextField;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class NewZoningMemberDialog
extends QDialog {
    public static final int ADD_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private int option = 2;
    JPanel dataPanel = new JPanel();
    GridBagLayout dataLayout = new GridBagLayout();
    JLabel nameLabel;
    FixedLengthTextField nameTextField = new FixedLengthTextField(16);
    JPanel radioPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    GridLayout buttonLayout = new GridLayout(1, 2, 8, 0);
    JButton okItemButton = new JButton(new OkItemAction());
    JButton cancelButton = new JButton(new CancelAction());
    ButtonGroup typeButtonGroup = new ButtonGroup();
    JRadioButton wwnButton = new JRadioButton(new WwnAction());
    JRadioButton domainPortButton = new JRadioButton(new DomainPortAction());
    JRadioButton fcaddressButton = new JRadioButton(new FcAddressAction());
    GridBagLayout newFabricLayout = new GridBagLayout();
    String title;

    public NewZoningMemberDialog(String string, JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.title = string + " - " + VendorProperties.getFrameTitle();
        try {
            this.jbInit();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setModal(true);
        this.setTitle(this.title);
        this.nameLabel = new JLabel(FabricTreeControl.getResource("NewZoningMemberDialog.newMember"));
        this.getContentPane().setLayout(this.newFabricLayout);
        this.nameTextField.setPreferredSize(new Dimension(160, 21));
        this.wwnButton.setSelected(true);
        this.typeButtonGroup.add(this.wwnButton);
        this.typeButtonGroup.add(this.domainPortButton);
        this.typeButtonGroup.add(this.fcaddressButton);
        this.radioPanel.setLayout(new GridBagLayout());
        this.radioPanel.add((Component)this.wwnButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.radioPanel.add((Component)this.domainPortButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.radioPanel.add((Component)this.fcaddressButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.setLayout(this.dataLayout);
        this.dataPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.getContentPane().add((Component)this.dataPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.buttonPanel.setLayout(this.buttonLayout);
        this.buttonPanel.add((Component)this.okItemButton, null);
        this.okItemButton.setMnemonic('O');
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.cancelButton.setMnemonic('C');
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.newZoningMemberDialogHelp"));
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.getContentPane().add((Component)this.radioPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.getRootPane().setDefaultButton(this.okItemButton);
        this.pack();
        this.nameTextField.requestFocus();
    }

    public int getOption() {
        return this.option;
    }

    void mustBeLength(int n) {
        JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("NewZoningMemberDialog.hexValueMustBe") + " " + n + " " + FabricTreeControl.getResource("NewZoningMemberDialog.characters"), FabricTreeControl.getResource("NewZoningMemberDialog.createMembers"), 1);
    }

    void limitLength(int n) {
        String string = this.nameTextField.getText();
        this.nameTextField.setMaxLength(n);
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        this.nameTextField.setText(string);
    }

    public void setItemName(String string) {
        this.nameTextField.setText(string);
    }

    public String getNewZoningMemberName() {
        return this.nameTextField.getText();
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(FabricTreeControl.getResource("NewZoningMemberDialog.cancelButton"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewZoningMemberDialog.this.option = 2;
            NewZoningMemberDialog.this.setVisible(false);
        }
    }

    class FcAddressAction
    extends AbstractAction {
        public FcAddressAction() {
            super(FabricTreeControl.getResource("NewZoningMemberDialog.fcaddressButton"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewZoningMemberDialog.this.limitLength(6);
        }
    }

    class DomainPortAction
    extends AbstractAction {
        public DomainPortAction() {
            super(FabricTreeControl.getResource("NewZoningMemberDialog.domainPortButton"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewZoningMemberDialog.this.limitLength(4);
        }
    }

    class WwnAction
    extends AbstractAction {
        public WwnAction() {
            super(FabricTreeControl.getResource("NewZoningMemberDialog.wwnButton"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewZoningMemberDialog.this.limitLength(16);
        }
    }

    class OkItemAction
    extends AbstractAction {
        public OkItemAction() {
            super(FabricTreeControl.getResource("NewZoningMemberDialog.ok"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = NewZoningMemberDialog.this.getNewZoningMemberName();
            int n = 0;
            while (n < string.length()) {
                if (Character.digit(string.charAt(n), 16) == -1) {
                    JOptionPane.showMessageDialog(NewZoningMemberDialog.this, FabricTreeControl.getResource("NewZoningMemberDialog.invalidCharacters"), FabricTreeControl.getResource("NewZoningMemberDialog.createMembers"), 1);
                    return;
                }
                ++n;
            }
            if (NewZoningMemberDialog.this.wwnButton.isSelected() && string.length() != 16) {
                NewZoningMemberDialog.this.mustBeLength(16);
                return;
            }
            if (NewZoningMemberDialog.this.domainPortButton.isSelected() && string.length() != 4) {
                NewZoningMemberDialog.this.mustBeLength(4);
                return;
            }
            if (NewZoningMemberDialog.this.fcaddressButton.isSelected() && string.length() != 6) {
                NewZoningMemberDialog.this.mustBeLength(6);
                return;
            }
            NewZoningMemberDialog.this.option = 1;
            NewZoningMemberDialog.this.setVisible(false);
        }
    }
}

