/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.wizards.zoning;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.wizards.ButtonPanel;
import com.qlogic.qms.fabric.wizards.ButtonPanelFactory;
import com.qlogic.qms.fabric.wizards.zoning.ZoningGroup;
import com.qlogic.qms.fabric.wizards.zoning.ZoningPanel;
import com.qlogic.qms.fabric.wizards.zoning.ZoningWizard;
import com.qlogic.ui.tools.SmartScrollingTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class SelectInitiatorPortsInGroupPanel
extends JPanel
implements ZoningPanel,
ActionListener {
    JLabel label;
    PickTableModel tableModel;
    JTable initiatorTable;
    Vector initiatorList;
    ZoningGroup current;
    ButtonPanel buttonPanel;
    ZoningWizard wiz;

    public SelectInitiatorPortsInGroupPanel(ZoningWizard zoningWizard, Vector vector) {
        this.wiz = zoningWizard;
        this.initiatorList = vector;
        try {
            this.jbInit();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void jbInit() {
        this.buttonPanel = ButtonPanelFactory.createDefaultButtonPanel();
        this.setLayout(new GridBagLayout());
        this.label = new JLabel();
        this.tableModel = new PickTableModel();
        this.tableModel.setData(this.getData());
        this.initiatorTable = new SmartScrollingTable((TableModel)this.tableModel);
        this.initiatorTable.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.initiatorTable.getTableHeader().setReorderingAllowed(false);
        this.initiatorTable.setAutoResizeMode(3);
        TableColumn tableColumn = this.initiatorTable.getColumn(FabricTreeControl.getResource("SelectInitiatorPortsInGroupPanel.col0"));
        tableColumn.setPreferredWidth(150);
        JScrollPane jScrollPane = new JScrollPane(this.initiatorTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    public abstract String getLine0();

    private void setLabel() {
        this.label.setText(this.getLine0() + " " + this.current.getName());
    }

    public boolean saveData() {
        boolean bl = false;
        this.current.removeAllInitiators();
        int n = 0;
        int n2 = 0;
        while (n2 < this.initiatorList.size()) {
            FCNode fCNode = (FCNode)this.initiatorList.elementAt(n2);
            if (this.includeNode(fCNode)) {
                Boolean bl2 = (Boolean)this.tableModel.getValueAt(n, 4);
                if (bl2.booleanValue()) {
                    bl = true;
                    this.current.addInitiator(fCNode);
                }
                ++n;
            }
            ++n2;
        }
        return bl;
    }

    protected abstract boolean includeNode(FCNode var1);

    private Object[][] getData() {
        FCNode fCNode;
        int n = 0;
        int n2 = 0;
        while (n2 < this.initiatorList.size()) {
            fCNode = (FCNode)this.initiatorList.elementAt(n2);
            if (this.includeNode(fCNode)) {
                ++n;
            }
            ++n2;
        }
        fCNode = new Object[n][5];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.initiatorList.size()) {
            FCNode fCNode2 = (FCNode)this.initiatorList.elementAt(n4);
            if (this.includeNode(fCNode2)) {
                fCNode[n3][0] = fCNode2.getPortWWName().delimit();
                fCNode[n3][1] = fCNode2.delimitFCAddress();
                Chassis chassis = fCNode2.getChassis();
                fCNode[n3][2] = chassis.toString();
                ZoningGroup zoningGroup = this.wiz.getGroupInitiatorIsIn(fCNode2);
                fCNode[n3][3] = zoningGroup != null ? zoningGroup.getName() : new String();
                fCNode[n3][4] = new Boolean(this.current.indexOfInitiator(fCNode2) > 0);
                ++n3;
            }
            ++n4;
        }
        return fCNode;
    }

    public void fillDataControls() {
        this.setLabel();
        this.tableModel.setData(this.getData());
    }

    public void setCurrent(ZoningGroup zoningGroup) {
        this.current = zoningGroup;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setNextButton();
    }

    protected void setNextButton() {
        boolean bl = false;
        int n = 0;
        while (n < this.tableModel.getRowCount()) {
            Boolean bl2 = (Boolean)this.tableModel.getValueAt(n, 0);
            if (bl2.booleanValue()) {
                bl = true;
            }
            ++n;
        }
        this.buttonPanel.nextButton.setEnabled(bl);
    }

    class PickTableModel
    extends AbstractTableModel {
        Object[][] data;
        final String[] columnNames = new String[]{FabricTreeControl.getResource("SelectInitiatorPortsInGroupPanel.col0"), FabricTreeControl.getResource("SelectInitiatorPortsInGroupPanel.col1"), FabricTreeControl.getResource("SelectInitiatorPortsInGroupPanel.col2"), FabricTreeControl.getResource("SelectInitiatorPortsInGroupPanel.col3"), FabricTreeControl.getResource("SelectInitiatorPortsInGroupPanel.col4")};

        PickTableModel() {
        }

        public void setData(Object[][] objectArray) {
            this.data = objectArray;
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 4) {
                FCNode fCNode = (FCNode)SelectInitiatorPortsInGroupPanel.this.initiatorList.elementAt(n);
                ZoningGroup zoningGroup = SelectInitiatorPortsInGroupPanel.this.wiz.getGroupInitiatorIsIn(fCNode);
                return zoningGroup == null || zoningGroup == SelectInitiatorPortsInGroupPanel.this.current;
            }
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }
}

