/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.wizards.zoning;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.wizards.ButtonPanel;
import com.qlogic.qms.fabric.wizards.ButtonPanelFactory;
import com.qlogic.qms.fabric.wizards.zoning.ZoningPanel;
import com.qlogic.ui.tools.SmartScrollingTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PickSharableTargetsPanel
extends JPanel
implements ZoningPanel {
    String yesStr = FabricTreeControl.getResource("PickSharableTargetsPanel.yes");
    String noStr = FabricTreeControl.getResource("PickSharableTargetsPanel.no");
    Vector targetList;
    PickTableModel tableModel;
    JTable targetTable;
    ButtonPanel buttonPanel;

    public PickSharableTargetsPanel(Vector vector) {
        this.targetList = vector;
        try {
            this.jbInit();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setData(Vector vector) {
        this.targetList = vector;
        this.tableModel.setData(this.getData());
    }

    public boolean saveData() {
        TableModel tableModel = this.targetTable.getModel();
        int n = 0;
        while (n < tableModel.getRowCount()) {
            Boolean bl = (Boolean)tableModel.getValueAt(n, 3);
            FCNode fCNode = (FCNode)this.targetList.elementAt(n);
            fCNode.setSharable(bl.booleanValue());
            ++n;
        }
        return true;
    }

    public void fillDataControls() {
    }

    public void jbInit() {
        this.buttonPanel = ButtonPanelFactory.createDefaultButtonPanel();
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(FabricTreeControl.getResource("PickSharableTargetsPanel.title")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(1, 1, 1, 1), 0, 20));
        JLabel jLabel = new JLabel(" ");
        JLabel jLabel2 = new JLabel(FabricTreeControl.getResource("PickSharableTargetsPanel.line0"));
        JLabel jLabel3 = new JLabel(FabricTreeControl.getResource("PickSharableTargetsPanel.line1"));
        JPanel jPanel = new JPanel();
        this.tableModel = new PickTableModel();
        this.tableModel.setData(this.getData());
        this.targetTable = new SmartScrollingTable((TableModel)this.tableModel);
        TableColumn tableColumn = this.targetTable.getColumn(FabricTreeControl.getResource("PickSharableTargetsPanel.col1"));
        tableColumn.setPreferredWidth(150);
        jPanel.setLayout(new GridLayout(1, 1));
        this.targetTable.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.targetTable.getTableHeader().setReorderingAllowed(false);
        this.targetTable.setAutoResizeMode(3);
        this.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 1, new Insets(1, 1, 1, 1), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.targetTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 11, 1, new Insets(1, 1, 1, 1), 0, 20));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    private Object[][] getData() {
        Object[][] objectArray = new Object[this.targetList.size()][4];
        int n = 0;
        while (n < this.targetList.size()) {
            FCNode fCNode = (FCNode)this.targetList.elementAt(n);
            objectArray[n][0] = fCNode.getPortWWName().delimit();
            objectArray[n][1] = fCNode.delimitFCAddress();
            Chassis chassis = fCNode.getChassis();
            objectArray[n][2] = chassis.toString();
            objectArray[n][3] = new Boolean(fCNode.isSharable());
            ++n;
        }
        return objectArray;
    }

    class PickTableModel
    extends AbstractTableModel {
        Object[][] data;
        final String[] columnNames = new String[]{FabricTreeControl.getResource("PickSharableTargetsPanel.col1"), FabricTreeControl.getResource("PickSharableTargetsPanel.col2"), FabricTreeControl.getResource("PickSharableTargetsPanel.col3"), FabricTreeControl.getResource("PickSharableTargetsPanel.col4")};

        PickTableModel() {
        }

        public void setData(Object[][] objectArray) {
            this.data = objectArray;
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 3;
        }

        public void setValueAt(Object object, int n, int n2) {
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }
}

