/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.wizards.zoning;

import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.wizards.ButtonPanel;
import com.qlogic.qms.fabric.wizards.ButtonPanelFactory;
import com.qlogic.qms.fabric.wizards.zoning.ZoningPanel;
import com.qlogic.qms.fabric.wizards.zoning.ZoningWizard;
import com.qlogic.ui.FixedLengthTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GenerationPanel
extends JPanel
implements ZoningPanel,
KeyListener {
    ButtonPanel buttonPanel;
    ZoningWizard wiz;
    JList listBox;
    FixedLengthTextField nameTextField = new FixedLengthTextField(64);
    String configName = new String();

    public GenerationPanel(ZoningWizard zoningWizard) {
        this.wiz = zoningWizard;
        try {
            this.jbInit();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void jbInit() {
        this.buttonPanel = ButtonPanelFactory.createConfirmationButtonPanel();
        this.setLayout(new GridBagLayout());
        this.buttonPanel.finishButton.setEnabled(false);
        JLabel jLabel = new JLabel(" ");
        JLabel jLabel2 = new JLabel(FabricTreeControl.getResource("GenerationPanel.title"));
        JLabel jLabel3 = new JLabel(FabricTreeControl.getResource("GenerationPanel.line0"));
        JLabel jLabel4 = new JLabel(FabricTreeControl.getResource("GenerationPanel.line1"));
        JLabel jLabel5 = new JLabel(FabricTreeControl.getResource("GenerationPanel.line2"));
        JLabel jLabel6 = new JLabel(FabricTreeControl.getResource("GenerationPanel.line3"));
        JLabel jLabel7 = new JLabel(FabricTreeControl.getResource("GenerationPanel.line4"));
        JLabel jLabel8 = new JLabel(FabricTreeControl.getResource("GenerationPanel.enterName"));
        this.listBox = new JList();
        this.listBox.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.listBox);
        this.nameTextField.addKeyListener(this);
        double d = this.nameTextField.getPreferredSize().getHeight();
        this.nameTextField.setPreferredSize(new Dimension(200, (int)d));
        this.add((Component)jLabel2, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)jLabel4, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)jLabel5, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)jLabel6, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)jLabel7, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)jLabel8, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)this.nameTextField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    public String getConfigName() {
        return this.configName;
    }

    public boolean saveData() {
        this.configName = this.nameTextField.getText();
        if (!Zones.verifyName((String)this.configName)) {
            JOptionPane.showMessageDialog(this.wiz, FabricTreeControl.getResource("GenerationPanel.theZoneSet") + " " + this.nameTextField.getText() + " " + FabricTreeControl.getResource("GenerationPanel.isNotValid"), FabricTreeControl.getResource("GenerationPanel.invalidName"), 0);
            return false;
        }
        if (this.wiz.doesZoneSetExist(this.configName)) {
            JOptionPane.showMessageDialog(this.wiz, FabricTreeControl.getResource("GenerationPanel.theZoneSet") + " " + this.configName + " " + FabricTreeControl.getResource("GenerationPanel.alreadyExists"), FabricTreeControl.getResource("GenerationPanel.invalidName"), 0);
            return false;
        }
        return true;
    }

    public void fillDataControls() {
        this.nameTextField.setText(this.configName);
        Vector vector = this.wiz.createSummary();
        this.listBox.setListData(vector);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.buttonPanel.finishButton.setEnabled(this.nameTextField.getText().length() > 0);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.buttonPanel.finishButton.setEnabled(this.nameTextField.getText().length() > 0);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.buttonPanel.finishButton.setEnabled(this.nameTextField.getText().length() > 0);
    }
}

