/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.wizards;

import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.wizards.BottomPanel;
import com.qlogic.qms.fabric.wizards.ButtonPanel;
import com.qlogic.qms.fabric.wizards.HotSwapWizard;
import com.qlogic.qms.fabric.wizards.LeftPanel;
import com.qlogic.qms.fabric.wizards.Navigator;
import com.qlogic.qms.fabric.wizards.Page;
import com.qlogic.qms.fabric.wizards.QWizard;
import com.qlogic.qms.fabric.wizards.RightPanel;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;

public class HotSwapNavigator
extends Navigator {
    public HotSwapNavigator(QWizard qWizard, RightPanel rightPanel, BottomPanel bottomPanel, LeftPanel leftPanel) {
        super(qWizard, rightPanel, bottomPanel, leftPanel);
    }

    public HotSwapNavigator(QWizard qWizard, Vector vector, RightPanel rightPanel, BottomPanel bottomPanel, LeftPanel leftPanel) {
        super(qWizard, vector, rightPanel, bottomPanel, leftPanel);
    }

    protected void addActionListener(Vector vector) {
        int n = this.pageList.size();
        int n2 = 0;
        while (n2 < n) {
            Page page = (Page)this.pageList.elementAt(n2);
            ButtonPanel buttonPanel = page.getButtonPanel();
            if (buttonPanel.backButton != null) {
                buttonPanel.backButton.addActionListener(this);
            }
            if (buttonPanel.nextButton != null) {
                buttonPanel.nextButton.addActionListener(this);
            }
            if (buttonPanel.helpButton != null) {
                buttonPanel.helpButton.addActionListener(this);
            }
            if (buttonPanel.cancelButton != null) {
                buttonPanel.cancelButton.addActionListener(this);
            }
            if (buttonPanel.finishButton != null) {
                buttonPanel.finishButton.addActionListener(this);
            }
            if (buttonPanel.closeButton != null) {
                buttonPanel.closeButton.addActionListener(this);
            }
            ++n2;
        }
    }

    public void setRightPanel(RightPanel rightPanel) {
        this.rightPanel = rightPanel;
    }

    public void first() {
        this.current = (Page)this.pageList.firstElement();
        this.pageHistory.push(this.current);
        this.rightPanel.showFirst();
        this.bottomPanel.showFirst();
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    public void last() {
        this.current = (Page)this.pageList.lastElement();
        this.pageHistory.push(this.current);
        this.rightPanel.showLast();
        this.bottomPanel.showLast();
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    public void next() {
        this.savePage(this.current);
        HotSwapWizard hotSwapWizard = (HotSwapWizard)this.wizard;
        int n = this.current.getIndex();
        switch (this.current.getIndex()) {
            case 1: {
                if (hotSwapWizard.selectedHSP == 2) {
                    n = 2;
                    break;
                }
                if (hotSwapWizard.selectedHSP == 1) {
                    n = 5;
                    break;
                }
                if (hotSwapWizard.selectedHSP == 0) {
                    n = 8;
                    break;
                }
                n = 2;
                break;
            }
            case 2: {
                hotSwapWizard.performHotSwapProcedure(true, true);
                n = 3;
                break;
            }
            case 3: {
                hotSwapWizard.performFollowUpHotSwapProcedure(true);
                if (hotSwapWizard.selectedHSP == 0) {
                    n = 9;
                    break;
                }
                n = 4;
                break;
            }
            case 5: {
                hotSwapWizard.performHotSwapProcedure(false, true);
                n = 6;
                break;
            }
            case 6: {
                hotSwapWizard.performFollowUpHotSwapProcedure(false);
                n = 7;
                break;
            }
            case 8: {
                hotSwapWizard.performHotSwapProcedure(true, true);
                n = 3;
                break;
            }
            case 9: {
                hotSwapWizard.performHotSwapProcedure(false, false);
                n = 6;
                break;
            }
            default: {
                if (n >= this.pageList.size() - 1) break;
                ++n;
            }
        }
        this.current = (Page)this.pageList.elementAt(n);
        this.pageHistory.push(this.current);
        Page page = (Page)this.pageList.elementAt(n);
        ButtonPanel buttonPanel = page.getButtonPanel();
        switch (n) {
            case 1: {
                hotSwapWizard.initBladeSlotSelectPanel();
                break;
            }
            case 2: {
                hotSwapWizard.initConfirmRemovePanel();
                break;
            }
            case 3: {
                hotSwapWizard.initPerformRemovePanel();
                break;
            }
            case 4: {
                hotSwapWizard.initRemoveResultsPanel();
                break;
            }
            case 5: {
                hotSwapWizard.initConfirmInsertPanel();
                break;
            }
            case 6: {
                hotSwapWizard.initPerformInsertPanel();
                break;
            }
            case 7: {
                hotSwapWizard.initInsertResultsPanel();
                break;
            }
            case 8: {
                hotSwapWizard.initConfirmReplacePanel();
                break;
            }
            case 9: {
                hotSwapWizard.initReplaceRemoveResultsPanel();
            }
        }
        this.rightPanel.showPage(this.current.getTitle());
        this.bottomPanel.showPage(this.current.getTitle());
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    public void prev() {
        this.savePage(this.current);
        this.pageHistory.pop();
        this.current = (Page)this.pageHistory.peek();
        this.rightPanel.showPage(this.current.getTitle());
        this.bottomPanel.showPage(this.current.getTitle());
        this.leftPanel.highlightStep(this.current.getStepNumber());
    }

    protected void printPageHistory() {
        System.err.print("PageHistory=[ ");
        int n = 0;
        while (n < this.pageHistory.size()) {
            Page page = (Page)this.pageHistory.elementAt(n);
            System.err.print("Page:" + page.getIndex() + ", ");
            ++n;
        }
        System.err.println(" ]");
    }

    protected void savePage(Page page) {
        switch (page.getIndex()) {
            case 0: {
                ((HotSwapWizard)this.wizard).saveHotSwapProcedure();
                break;
            }
            case 1: {
                ((HotSwapWizard)this.wizard).saveHotSwapBladeSlotSelection();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        HotSwapWizard hotSwapWizard = (HotSwapWizard)this.wizard;
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            String string = ((JButton)object).getText();
            if (string.equals(FabricTreeControl.getResource("Wizard.back"))) {
                this.prev();
            } else if (string.equals(FabricTreeControl.getResource("Wizard.next"))) {
                this.next();
            } else if (string.equals(FabricTreeControl.getResource("Wizard.cancel"))) {
                if (!this.isStandardCancel()) {
                    if (((HotSwapWizard)this.wizard).cancelWizardConfirmation()) {
                        if (this.current.getIndex() == 3) {
                            ((HotSwapWizard)this.wizard).cancelHotSwapProcedure(true);
                        } else if (this.current.getIndex() == 6) {
                            ((HotSwapWizard)this.wizard).cancelHotSwapProcedure(false);
                        }
                        ((HotSwapWizard)this.wizard).releaseWizard();
                        this.savePage(this.current);
                        int n = 10;
                        this.current = (Page)this.pageList.elementAt(n);
                        this.pageHistory.push(this.current);
                        Page page = (Page)this.pageList.elementAt(n);
                        ButtonPanel buttonPanel = page.getButtonPanel();
                        ((HotSwapWizard)this.wizard).initCancelPanel();
                        this.rightPanel.showPage(this.current.getTitle());
                        this.bottomPanel.showPage(this.current.getTitle());
                        this.leftPanel.highlightStep(this.current.getStepNumber());
                    }
                } else {
                    ((HotSwapWizard)this.wizard).releaseWizard();
                    this.wizard.close();
                }
            } else if (string.equals(FabricTreeControl.getResource("Wizard.help"))) {
                this.wizard.help();
            } else if (string.equals(FabricTreeControl.getResource("Wizard.close"))) {
                ((HotSwapWizard)this.wizard).releaseWizard();
                this.wizard.close();
            } else if (string.equals(FabricTreeControl.getResource("Wizard.finish"))) {
                ((HotSwapWizard)this.wizard).releaseWizard();
                this.wizard.close();
            }
        }
    }

    protected boolean isStandardCancel() {
        switch (this.current.getIndex()) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: {
                return true;
            }
        }
        return false;
    }
}

