/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.wizards;

import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.Sanbox8000Blade;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.SwitchBlade;
import com.qlogic.device.fcfabric.SwitchBladePort;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.qms.fabric.wizards.ButtonPanelFactory;
import com.qlogic.qms.fabric.wizards.ExtCreditNavigatorSanbox8000;
import com.qlogic.qms.fabric.wizards.Page;
import com.qlogic.qms.fabric.wizards.QWizard;
import com.qlogic.util.QHelpUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class ExtCreditWizardSanbox8000
extends QWizard
implements ChassisEventListener {
    public static final int BLADE_COUNT = 8;
    public static final int INTRO_PAGE = 0;
    public static final int EXT_CREDITS_PAGE = 1;
    public static final int TL_PORT_CHECK_PAGE = 2;
    public static final int LOOP_ENABLED_PORT_CHECK_PAGE = 3;
    public static final int DONOR_PORT_AVAILABILITY_PAGE = 4;
    public static final int BLADE_0_DONOR_PORT_PAGE = 5;
    public static final int BLADE_1_DONOR_PORT_PAGE = 6;
    public static final int BLADE_2_DONOR_PORT_PAGE = 7;
    public static final int BLADE_3_DONOR_PORT_PAGE = 8;
    public static final int BLADE_4_DONOR_PORT_PAGE = 9;
    public static final int BLADE_5_DONOR_PORT_PAGE = 10;
    public static final int BLADE_6_DONOR_PORT_PAGE = 11;
    public static final int BLADE_7_DONOR_PORT_PAGE = 12;
    public static final int ACTIVE_DONOR_PORT_CHECK_PAGE = 13;
    public static final int OFFLINE_DONOR_PORT_PAGE = 14;
    public static final int CONFIRMATION_PAGE = 15;
    public static final int APPLY_CHANGES_PAGE = 16;
    public static final int SUMMARY_PAGE = 17;
    protected String[] portSpeedOptions = new String[]{"Unknown", "1 Gb", "2 Gb", "Auto"};
    protected String[] distanceOptions = new String[]{"10  km", "20  km", "30  km", "40  km", "50  km", "70  km", "100 km"};
    protected JLabel applyChangesWorkingLabel = new JLabel("Applying changes ... please wait");
    protected JLabel applyChangesCompleteLabel = new JLabel("Changes completed successfully.");
    protected JLabel[] applyChangesErrorLabels;
    protected JScrollPane applyChangesOutputScrollPane;
    protected JTextArea outputText = new JTextArea();
    protected int[] portMode;
    protected String[] portModeLabelString;
    protected int[] extCredits;
    protected int[] portActive;
    protected int[] portSpeed;
    protected int[] alDisabled;
    protected int[] extCreditsRequested;
    protected int[] maxCredits;
    protected boolean[] donorPortsRequested;
    protected int[] distanceRequested;
    protected int[] portModeChangeRequests;
    protected int[] portSpeedRequested;
    JComboBox[] distanceCombo;
    JComboBox[] portSpeedCombo;
    JLabel[] portModeLabel;
    JList[] selectedDonorPortList = new JList[8];
    JList[] availPortList = new JList[8];
    JProgressBar progressBar;
    JButton[] leftButton = new JButton[8];
    JButton[] rightButton = new JButton[8];
    JList loopEnabledPortList;
    JList tlPortList;
    JScrollPane loopEnabledScrollPane;
    JScrollPane tlPortScrollPane;
    JTextField currentDonorPortCountText;
    JTextField requiredDonorPortCountText;
    JTextField inactivePortCountText;
    JTextField[] numPortsSelectedText = new JTextField[8];
    JTextField[] numPortsNeededText = new JTextField[8];
    JScrollPane[] availPortsScrollPane = new JScrollPane[8];
    JScrollPane[] selectedPortsScrollPane = new JScrollPane[8];
    JList overallSelectedDonorPortList;
    String[] donorPortStrings;
    String[] extCreditStrings;
    String[] portSpeedStrings;
    boolean[] portModeChangeRequired;
    boolean[] portSpeedChangeRequired;
    JList donorPortList;
    JList portModeChangeList;
    JList extCreditList;
    JList portSpeedChangeList;
    JScrollPane extCreditScrollPane;
    JScrollPane portModeChangeScrollPane;
    JScrollPane donorPortScrollPane;
    JScrollPane portSpeedScrollPane;
    JList activeDonorPortList;
    JScrollPane activeDonorPortScrollPane;
    JList offlineDonorPortList;
    JScrollPane offlineDonorPortScrollPane;
    boolean alreadyWarnedAboutLoopEnabled = false;
    boolean alreadyWarnedAboutPortsAvailable = false;
    boolean alreadyWarnedAboutActiveDonorPorts = false;
    boolean alreadyWarnedAboutOfflineDonorPorts = false;
    int changeCount = 0;
    int changesComplete = 0;
    int applyChangesErrorCount = 0;
    int releaseAdminCompletedCount = 0;

    public ExtCreditWizardSanbox8000(JFrame jFrame, Sanbox8000 sanbox8000) {
        super(jFrame, FabricTreeControl.getResource("ExtCreditWizard.title"), (SanboxChassis)sanbox8000);
        this.leftPanel.setFontSize(8);
        this.navigator = new ExtCreditNavigatorSanbox8000(this, this.rightPanel, this.bottomPanel, this.leftPanel);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.extCreditWizardSanbox8000Help"));
        this.initWizard();
        this.initSwitchData();
    }

    public void initSwitchData() {
        PortStates portStates;
        int n = this.blade.getPortCount();
        this.portMode = new int[n];
        this.portModeLabelString = new String[n];
        this.extCredits = new int[n];
        this.portActive = new int[n];
        this.portSpeed = new int[n];
        this.alDisabled = new int[n];
        this.maxCredits = new int[n];
        this.donorPortsRequested = new boolean[n];
        this.portSpeedRequested = new int[n];
        int n2 = 0;
        while (n2 < n) {
            S16Port s16Port = (S16Port)this.blade.getPort(n2);
            portStates = s16Port.getPortStates();
            this.extCredits[n2] = s16Port.getExtCredits();
            this.maxCredits[n2] = s16Port.getMaxCredits();
            this.portMode[n2] = portStates.getConfigPortType();
            this.portSpeed[n2] = s16Port.getOperationalPortSpeed();
            this.portSpeedRequested[n2] = s16Port.getAdminPortSpeed();
            this.portActive[n2] = portStates.getLoggedIn();
            this.alDisabled[n2] = portStates.getAlDisabled();
            this.donorPortsRequested[n2] = portStates.getConfigPortType() == 6;
            ++n2;
        }
        this.loopEnabledPortList = null;
        this.portSpeedChangeList = null;
        int n3 = 0;
        while (n3 < n) {
            portStates = (S16Port)this.blade.getPort(n3);
            if (this.portSpeed[n3] == 4 || this.portSpeed[n3] == 0) {
                this.portSpeedCombo[n3].setSelectedIndex(0);
            } else {
                this.portSpeedCombo[n3].setSelectedIndex(this.portSpeed[n3]);
            }
            String string = SbmUtilities.getPortConfigModeString(portStates.getPortStates());
            if (string.equals("don")) {
                string = FabricTreeControl.getResource("ExtCreditWizard.donor");
            }
            this.portModeLabelString[n3] = string;
            this.portModeLabel[n3].setText(string);
            int n4 = this.computeDistance(this.maxCredits[n3], this.portSpeed[n3]);
            this.distanceCombo[n3].setSelectedIndex(this.translateDistanceToIndex(n4));
            ++n3;
        }
    }

    public Properties createWizardProperties() {
        Properties properties = new Properties();
        properties.setProperty("Port0", "donor");
        properties.setProperty("Port1", "11");
        properties.setProperty("port2", "0");
        properties.setProperty("Port3", "0");
        properties.setProperty("Port4", "0");
        properties.setProperty("port5", "0");
        properties.setProperty("Port6", "0");
        properties.setProperty("Port7", "0");
        properties.setProperty("port8", "0");
        properties.setProperty("Port9", "0");
        properties.setProperty("Port10", "0");
        properties.setProperty("port11", "0");
        properties.setProperty("Port12", "0");
        properties.setProperty("Port13", "0");
        properties.setProperty("port14", "0");
        properties.setProperty("Port15", "0");
        return properties;
    }

    public Vector createWizardPageList() {
        Vector<Page> vector = new Vector<Page>();
        Sanbox8000Blade sanbox8000Blade = ((Sanbox8000)this.blade).getBlade(0);
        Sanbox8000Blade sanbox8000Blade2 = ((Sanbox8000)this.blade).getBlade(1);
        Sanbox8000Blade sanbox8000Blade3 = ((Sanbox8000)this.blade).getBlade(2);
        Sanbox8000Blade sanbox8000Blade4 = ((Sanbox8000)this.blade).getBlade(3);
        Sanbox8000Blade sanbox8000Blade5 = ((Sanbox8000)this.blade).getBlade(4);
        Sanbox8000Blade sanbox8000Blade6 = ((Sanbox8000)this.blade).getBlade(5);
        Sanbox8000Blade sanbox8000Blade7 = ((Sanbox8000)this.blade).getBlade(6);
        Sanbox8000Blade sanbox8000Blade8 = ((Sanbox8000)this.blade).getBlade(7);
        Page page = new Page(FabricTreeControl.getResource("ExtCreditWizard.jupiter.title.introPage"), this.createIntroPanel(), ButtonPanelFactory.createDefaultButtonPanel(), 1, 0, 0);
        page.getButtonPanel().backButton.setEnabled(false);
        vector.add(page);
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.extCreditPage"), this.createExtCreditPanel(), ButtonPanelFactory.createDefaultButtonPanel(), 3, 1, 1));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.TLPortCheckPage"), this.createTLPortCheckPanel(), ButtonPanelFactory.createDefaultButtonPanel(), 3, 2, 1));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.loopEnabledPage"), this.createLoopEnabledPortCheckPanel(), ButtonPanelFactory.createDefaultButtonPanel(), 3, 3, 1));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortAvailPage"), this.createDonorPortAvailabilityPanel(), ButtonPanelFactory.createDefaultButtonPanel(), 3, 4, 1));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortPage") + sanbox8000Blade.toString(), this.createDonorPortPanel(0), ButtonPanelFactory.createDefaultButtonPanel(), 3, 5, 2));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortPage") + sanbox8000Blade2.toString(), this.createDonorPortPanel(1), ButtonPanelFactory.createDefaultButtonPanel(), 3, 6, 2));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortPage") + sanbox8000Blade3.toString(), this.createDonorPortPanel(2), ButtonPanelFactory.createDefaultButtonPanel(), 3, 7, 2));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortPage") + sanbox8000Blade4.toString(), this.createDonorPortPanel(3), ButtonPanelFactory.createDefaultButtonPanel(), 3, 8, 2));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortPage") + sanbox8000Blade5.toString(), this.createDonorPortPanel(4), ButtonPanelFactory.createDefaultButtonPanel(), 3, 9, 2));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortPage") + sanbox8000Blade6.toString(), this.createDonorPortPanel(5), ButtonPanelFactory.createDefaultButtonPanel(), 3, 10, 2));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortPage") + sanbox8000Blade7.toString(), this.createDonorPortPanel(6), ButtonPanelFactory.createDefaultButtonPanel(), 3, 11, 2));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortPage") + sanbox8000Blade8.toString(), this.createDonorPortPanel(7), ButtonPanelFactory.createDefaultButtonPanel(), 3, 12, 2));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortCheckPage"), this.createDonorPortCheckPanel(), ButtonPanelFactory.createDefaultButtonPanel(), 3, 13, 2));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.offlineDonorPortPage"), this.createOfflineDonorPortPanel(), ButtonPanelFactory.createDefaultButtonPanel(), 3, 14, 2));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.confirmationPage"), this.createConfirmationPanel(), ButtonPanelFactory.createConfirmationButtonPanel(), 4, 15, 3));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.applyChangesPage"), this.createApplyChangesPanel(), ButtonPanelFactory.createConfirmationButtonPanel(), 5, 16, 4));
        vector.add(new Page(FabricTreeControl.getResource("ExtCreditWizard.title.summaryPage"), this.createSummaryPanel(), ButtonPanelFactory.createSummaryButtonPanel(), 6, 17, 5));
        return vector;
    }

    public String[] createWizardStepsList() {
        String[] stringArray = new String[]{FabricTreeControl.getResource("ExtCreditWizard.jupiter.step.0"), FabricTreeControl.getResource("ExtCreditWizard.step.1"), FabricTreeControl.getResource("ExtCreditWizard.step.2"), FabricTreeControl.getResource("ExtCreditWizard.step.3"), FabricTreeControl.getResource("ExtCreditWizard.step.4"), FabricTreeControl.getResource("ExtCreditWizard.step.5")};
        return stringArray;
    }

    protected JPanel createIntroPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new BorderLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)new JLabel(FabricTreeControl.getResource("ExtCreditWizard.jupiter.title.introPage")), "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        Box box = new Box(1);
        JLabel jLabel = new JLabel(" ");
        JLabel jLabel2 = new JLabel(" ");
        JLabel jLabel3 = new JLabel(" ");
        JLabel jLabel4 = new JLabel(" ");
        JLabel jLabel5 = new JLabel(" ");
        JLabel jLabel6 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.1"));
        JLabel jLabel7 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.2"));
        JLabel jLabel8 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.3"));
        JLabel jLabel9 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.4"));
        JLabel jLabel10 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.5"));
        JLabel jLabel11 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.6"));
        JLabel jLabel12 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.7"));
        JLabel jLabel13 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.8"));
        JLabel jLabel14 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.9"));
        JLabel jLabel15 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.10"));
        JLabel jLabel16 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.11"));
        JLabel jLabel17 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.12"));
        JLabel jLabel18 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.13"));
        JLabel jLabel19 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.14"));
        JLabel jLabel20 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.intro.15"));
        Font font = jLabel15.getFont();
        Font font2 = font.deriveFont(3);
        jLabel15.setFont(font2);
        jLabel16.setFont(font2);
        jLabel17.setFont(font2);
        box.add(jLabel);
        box.add(jLabel6);
        box.add(jLabel7);
        box.add(jLabel8);
        box.add(jLabel9);
        box.add(jLabel2);
        box.add(jLabel10);
        box.add(jLabel11);
        box.add(jLabel3);
        box.add(jLabel12);
        box.add(jLabel13);
        box.add(jLabel14);
        box.add(jLabel4);
        box.add(jLabel15);
        box.add(jLabel16);
        box.add(jLabel17);
        box.add(jLabel5);
        box.add(jLabel18);
        box.add(jLabel19);
        box.add(jLabel20);
        jPanel2.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel.add((Component)box, "Center");
        return jPanel;
    }

    protected JPanel createDonorPortPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Sanbox8000Blade sanbox8000Blade = ((Sanbox8000)this.blade).getBlade(n);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)new JLabel(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortPage") + " - " + sanbox8000Blade.toString()), gridBagConstraints);
        JLabel jLabel = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.availPorts"));
        JLabel jLabel2 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.selectedPorts"));
        JLabel jLabel3 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.neededPorts"));
        JLabel jLabel4 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.designatedPorts"));
        JLabel jLabel5 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.donorPortCaution"));
        this.numPortsNeededText[n] = new JTextField();
        this.numPortsSelectedText[n] = new JTextField();
        this.numPortsNeededText[n].setEditable(false);
        this.numPortsSelectedText[n].setEditable(false);
        this.availPortsScrollPane[n] = new JScrollPane();
        this.availPortsScrollPane[n].setPreferredSize(new Dimension(150, 120));
        this.selectedPortsScrollPane[n] = new JScrollPane();
        this.selectedPortsScrollPane[n].setPreferredSize(new Dimension(150, 120));
        this.rightButton[n] = new JButton(FabricTreeControl.getResource("ExtCreditWizard.rightArrow"));
        this.leftButton[n] = new JButton(FabricTreeControl.getResource("ExtCreditWizard.leftArrow"));
        this.rightButton[n].setPreferredSize(new Dimension(30, 20));
        this.leftButton[n].setPreferredSize(new Dimension(30, 20));
        this.rightButton[n].addActionListener(new RightButtonListener(this, n));
        this.leftButton[n].addActionListener(new LeftButtonListener(this, n));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(18, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.availPortsScrollPane[n], gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.selectedPortsScrollPane[n], gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.rightButton[n], gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.leftButton[n], gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 100);
        jPanel2.add((Component)this.numPortsNeededText[n], gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 100);
        jPanel2.add((Component)this.numPortsSelectedText[n], gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(20, 2, 2, 2);
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(10, 2, 80, 2);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    protected int getLowPortNumber(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return 24;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 40;
            }
            case 6: {
                return 48;
            }
            case 7: {
                return 56;
            }
        }
        return 0;
    }

    protected int getHighPortNumber(int n) {
        switch (n) {
            case 0: {
                return 8;
            }
            case 1: {
                return 16;
            }
            case 2: {
                return 24;
            }
            case 3: {
                return 32;
            }
            case 4: {
                return 40;
            }
            case 5: {
                return 48;
            }
            case 6: {
                return 56;
            }
            case 7: {
                return 64;
            }
        }
        return 64;
    }

    protected void initDonorPortPanel(int n) {
        String string;
        String string2;
        String string3;
        String string4;
        Sanbox8000Blade sanbox8000Blade = ((Sanbox8000)this.blade).getBlade(n);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        int n2 = this.getLowPortNumber(n);
        while (n2 < this.getHighPortNumber(n)) {
            string4 = (S16Port)this.blade.getPort(n2);
            if (this.donorPortsRequested[n2]) {
                vector2.add(string4);
            } else if (this.extCreditsRequested[n2] == 0) {
                vector.add(string4);
            }
            ++n2;
        }
        string4 = FabricTreeControl.getResource("ExtCreditWizard.port");
        String string5 = FabricTreeControl.getResource("ExtCreditWizard.active");
        String string6 = FabricTreeControl.getResource("ExtCreditWizard.inactive");
        String[] stringArray = new String[vector.size()];
        int n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            S16Port s16Port = (S16Port)vector.elementAt(n4);
            string3 = this.blade instanceof SwitchBlade ? ((SwitchBladePort)s16Port).toString() : string4 + " " + Integer.toString(s16Port.getPortNumber());
            stringArray[n4] = string3 + " - " + this.portModeLabelString[s16Port.getPortNumber()];
            if (s16Port.getPortStates().getLoggedIn() == 1) {
                int n5 = n4;
                stringArray[n5] = stringArray[n5] + " - " + string5;
            } else {
                int n6 = n4;
                stringArray[n6] = stringArray[n6] + " - " + string6;
            }
            string2 = s16Port.getPortStates();
            string = "unknown";
            if (string2 != null) {
                string = SbmUtilities.getPortStateString(string2.getActiveAdminState());
            }
            int n7 = n4++;
            stringArray[n7] = stringArray[n7] + ", " + string;
        }
        this.availPortList[n] = new JList<String>(stringArray);
        if (this.overallSelectedDonorPortList == null) {
            this.overallSelectedDonorPortList = new JList();
        }
        this.donorPortStrings = new String[vector2.size()];
        n3 = vector2.size();
        int n8 = 0;
        while (n8 < n3) {
            string3 = (S16Port)vector2.elementAt(n8);
            string2 = this.blade instanceof SwitchBlade ? ((SwitchBladePort)string3).toString() : string4 + " " + Integer.toString(string3.getPortNumber());
            this.donorPortStrings[n8] = string2 + " - " + this.portModeLabelString[string3.getPortNumber()];
            if (string3.getPortStates().getLoggedIn() == 1) {
                int n9 = n8;
                this.donorPortStrings[n9] = this.donorPortStrings[n9] + " - " + string5;
            } else {
                int n10 = n8;
                this.donorPortStrings[n10] = this.donorPortStrings[n10] + " - " + string6;
            }
            PortStates portStates = string3.getPortStates();
            string = "unknown";
            if (portStates != null) {
                string = SbmUtilities.getPortStateString(portStates.getActiveAdminState());
            }
            int n11 = n8++;
            this.donorPortStrings[n11] = this.donorPortStrings[n11] + ", " + string;
        }
        this.selectedDonorPortList[n] = new JList<String>(this.donorPortStrings);
        this.availPortsScrollPane[n].setViewportView(this.availPortList[n]);
        this.selectedPortsScrollPane[n].setViewportView(this.selectedDonorPortList[n]);
        int n12 = 0;
        int n13 = this.getLowPortNumber(n);
        while (n13 < this.getHighPortNumber(n)) {
            n12 += this.extCreditsRequested[n13];
            ++n13;
        }
        this.numPortsNeededText[n].setText(Integer.toString(n12 / 11));
        this.numPortsSelectedText[n].setText(Integer.toString(vector2.size()));
        this.alreadyWarnedAboutOfflineDonorPorts = false;
    }

    protected JPanel createExtCreditPanel() {
        JScrollPane jScrollPane;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)new JLabel(FabricTreeControl.getResource("ExtCreditWizard.title.extCreditPage")), gridBagConstraints);
        JLabel jLabel = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.port"));
        JLabel jLabel2 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.portSpeed"));
        JLabel jLabel3 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.portMode"));
        JLabel jLabel4 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.distance"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 2, 2, 20);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        int n = this.blade.getPortCount();
        JLabel[] jLabelArray = new JLabel[n];
        this.portModeLabel = new JLabel[n];
        this.distanceCombo = new JComboBox[n];
        this.portSpeedCombo = new JComboBox[n];
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        int n2 = 0;
        while (n2 < n) {
            jScrollPane = this.blade.getPort(n2);
            jLabelArray[n2] = this.blade instanceof SwitchBlade ? new JLabel(((SwitchBladePort)jScrollPane).toString()) : new JLabel(Integer.toString(n2));
            this.portModeLabel[n2] = new JLabel("");
            this.distanceCombo[n2] = new JComboBox<String>(this.distanceOptions);
            this.portSpeedCombo[n2] = new JComboBox<String>(this.portSpeedOptions);
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(10, 10, 2, 20);
            jPanel2.add((Component)jLabelArray[n2], gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(10, 2, 2, 20);
            jPanel2.add((Component)this.portSpeedCombo[n2], gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(10, 2, 2, 20);
            jPanel2.add((Component)this.portModeLabel[n2], gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.insets = new Insets(10, 2, 2, 10);
            jPanel2.add((Component)this.distanceCombo[n2], gridBagConstraints);
            ++n2;
        }
        jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setPreferredSize(new Dimension(300, 280));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.insets = new Insets(0, 2, 20, 20);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createConfirmationPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 10, 2);
        jPanel.add((Component)new JLabel(FabricTreeControl.getResource("ExtCreditWizard.title.confirmationPage")), gridBagConstraints);
        JLabel jLabel = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.extendedDistance"));
        JLabel jLabel2 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.portModeChanges"));
        JLabel jLabel3 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.portSpeedChanges"));
        JLabel jLabel4 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.selectedDonor"));
        this.extCreditScrollPane = new JScrollPane();
        this.extCreditScrollPane.setPreferredSize(new Dimension(150, 180));
        this.portModeChangeScrollPane = new JScrollPane();
        this.portModeChangeScrollPane.setPreferredSize(new Dimension(150, 180));
        this.portSpeedScrollPane = new JScrollPane();
        this.portSpeedScrollPane.setPreferredSize(new Dimension(150, 180));
        this.donorPortScrollPane = new JScrollPane();
        this.donorPortScrollPane.setPreferredSize(new Dimension(150, 180));
        JLabel jLabel5 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.verify.1"));
        JLabel jLabel6 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.verify.2"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        jPanel2.add((Component)this.extCreditScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        jPanel2.add((Component)this.donorPortScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 5);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 5, 0, 10);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        jPanel2.add((Component)this.portModeChangeScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        jPanel2.add((Component)this.portSpeedScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 14;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 4.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 2, 20, 2);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        return jPanel;
    }

    protected void initConfirmationPanel() {
        int n;
        int n2;
        this.overallSelectedDonorPortList = new JList();
        Vector vector = new Vector();
        int n3 = 0;
        while (n3 < 8) {
            ListModel listModel = this.selectedDonorPortList[n3].getModel();
            int n4 = 0;
            while (n4 < listModel.getSize()) {
                vector.add(listModel.getElementAt(n4));
                ++n4;
            }
            ++n3;
        }
        this.overallSelectedDonorPortList.setListData(vector);
        ListModel listModel = this.overallSelectedDonorPortList.getModel();
        int n5 = listModel.getSize();
        this.donorPortStrings = new String[n5];
        int n6 = this.blade.getPortCount();
        int n7 = 0;
        while (n7 < n5) {
            String string;
            this.donorPortStrings[n7] = string = (String)listModel.getElementAt(n7);
            n2 = this.stringToPortNumber(string);
            if (n2 >= 0 && n2 <= n6) {
                this.donorPortsRequested[n2] = true;
            }
            ++n7;
        }
        this.donorPortScrollPane.setViewportView(this.overallSelectedDonorPortList);
        int n8 = this.extCreditsRequested.length;
        n2 = 0;
        Vector<Integer> vector2 = new Vector<Integer>();
        int n9 = 0;
        while (n9 < n8) {
            if (this.distanceRequested[n9] > 10) {
                vector2.add(new Integer(n9));
                ++n2;
            }
            ++n9;
        }
        String string = FabricTreeControl.getResource("ExtCreditWizard.port");
        this.extCreditStrings = new String[n2];
        int n10 = 0;
        while (n10 < n2) {
            n = (Integer)vector2.elementAt(n10);
            FCPort fCPort = this.blade.getPort(n);
            String string2 = this.blade instanceof SwitchBlade ? ((SwitchBladePort)fCPort).toString() : string + " " + n;
            if (this.distanceRequested[n] > 10) {
                this.extCreditStrings[n10] = string2 + " - " + this.distanceRequested[n] + " " + FabricTreeControl.getResource("ExtCreditWizard.km");
            }
            ++n10;
        }
        this.extCreditList = new JList<String>(this.extCreditStrings);
        this.extCreditScrollPane.setViewportView(this.extCreditList);
        this.portModeChangeScrollPane.setViewportView(this.loopEnabledPortList);
        listModel = this.loopEnabledPortList.getModel();
        n = listModel.getSize();
        n6 = this.blade.getPortCount();
        this.portModeChangeRequired = new boolean[n6];
        int n11 = 0;
        while (n11 < n6) {
            this.portModeChangeRequired[n11] = false;
            int n12 = 0;
            while (n12 < n) {
                String string3 = (String)listModel.getElementAt(n12);
                int n13 = this.stringToPortNumber(string3);
                if (n11 == n13) {
                    this.portModeChangeRequired[n11] = true;
                }
                ++n12;
            }
            ++n11;
        }
        this.portSpeedScrollPane.setViewportView(this.portSpeedChangeList);
        listModel = this.portSpeedChangeList.getModel();
        n = listModel.getSize();
        n6 = this.blade.getPortCount();
        this.portSpeedChangeRequired = new boolean[n6];
        int n14 = 0;
        while (n14 < n6) {
            this.portSpeedChangeRequired[n14] = false;
            int n15 = 0;
            while (n15 < n) {
                String string4 = (String)listModel.getElementAt(n15);
                int n16 = this.stringToPortNumber(string4);
                if (n14 == n16) {
                    this.portSpeedChangeRequired[n14] = true;
                }
                ++n15;
            }
            ++n14;
        }
    }

    protected JPanel createSummaryPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)new JLabel(FabricTreeControl.getResource("ExtCreditWizard.title.summaryPage")), gridBagConstraints);
        JLabel jLabel = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.hasBeenApplied"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(20, 2, 80, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont(3);
        JLabel jLabel2 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.summary.caution.1"));
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        jLabel2.setFont(font2);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.summary.caution.2"));
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jLabel3.setFont(font2);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.summary.caution.3"));
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 2, 140, 2);
        jLabel4.setFont(font2);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createLoopEnabledPortCheckPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 20, 2);
        jPanel.add((Component)new JLabel(FabricTreeControl.getResource("ExtCreditWizard.title.loopEnabledPage")), gridBagConstraints);
        JLabel jLabel = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.loopEnabled.1"));
        JLabel jLabel2 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.loopEnabled.2"));
        JLabel jLabel3 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.loopEnabled.3"));
        JLabel jLabel4 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.loopEnabled.4"));
        JLabel jLabel5 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.loopEnabled.5"));
        JLabel jLabel6 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.loopEnabled.6"));
        JLabel jLabel7 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.loopEnabled.7"));
        JLabel jLabel8 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.loopEnabled.8"));
        this.loopEnabledScrollPane = new JScrollPane();
        this.loopEnabledScrollPane.setPreferredSize(new Dimension(80, 60));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(2, 80, 10, 160);
        jPanel.add((Component)this.loopEnabledScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        jPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridy = 11;
        jPanel.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints.gridy = 12;
        gridBagConstraints.insets = new Insets(2, 2, 80, 2);
        jPanel.add((Component)jLabel8, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createTLPortCheckPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 20, 2);
        jPanel.add((Component)new JLabel(FabricTreeControl.getResource("ExtCreditWizard.title.TLPortCheckPage")), gridBagConstraints);
        JLabel jLabel = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.tlPort.1"));
        JLabel jLabel2 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.tlPort.2"));
        JLabel jLabel3 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.tlPort.3"));
        JLabel jLabel4 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.tlPort.4"));
        JLabel jLabel5 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.tlPort.5"));
        this.tlPortScrollPane = new JScrollPane();
        this.tlPortScrollPane.setPreferredSize(new Dimension(80, 60));
        this.tlPortScrollPane.setMinimumSize(new Dimension(80, 60));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(10, 40, 40, 160);
        jPanel.add((Component)this.tlPortScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(2, 2, 20, 2);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(2, 2, 100, 2);
        jPanel.add((Component)jLabel5, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createDonorPortAvailabilityPanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 20, 2);
        jPanel.add((Component)new JLabel(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortAvailPage")), gridBagConstraints);
        JLabel jLabel = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.avail.1"));
        JLabel jLabel2 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.avail.2"));
        JLabel jLabel3 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.avail.3"));
        JLabel jLabel4 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.avail.4"));
        JLabel jLabel5 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.avail.5"));
        JLabel jLabel6 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.avail.6"));
        JLabel jLabel7 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.curCount"));
        JLabel jLabel8 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.reqCount"));
        JLabel jLabel9 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.inactiveCount"));
        this.currentDonorPortCountText = new JTextField();
        this.requiredDonorPortCountText = new JTextField();
        this.inactivePortCountText = new JTextField();
        this.currentDonorPortCountText.setEditable(false);
        this.requiredDonorPortCountText.setEditable(false);
        this.inactivePortCountText.setEditable(false);
        JLabel jLabel10 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.avail.7"));
        JLabel jLabel11 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.avail.8"));
        JLabel jLabel12 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.avail.9"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 2, 20, 2);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(20, 2, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(2, 2, 20, 2);
        jPanel.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(20, 2, 2, 80);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.currentDonorPortCountText, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(2, 2, 2, 80);
        jPanel.add((Component)this.requiredDonorPortCountText, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(2, 2, 20, 80);
        jPanel.add((Component)this.inactivePortCountText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints.gridy = 11;
        jPanel.add((Component)jLabel11, gridBagConstraints);
        gridBagConstraints.gridy = 12;
        gridBagConstraints.insets = new Insets(2, 2, 50, 2);
        jPanel.add((Component)jLabel12, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createDonorPortCheckPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)new JLabel(FabricTreeControl.getResource("ExtCreditWizard.title.donorPortCheckPage")), gridBagConstraints);
        JLabel jLabel = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.portCheck.1"));
        JLabel jLabel2 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.portCheck.2"));
        JLabel jLabel3 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.portCheck.3"));
        JLabel jLabel4 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.portCheck.4"));
        JLabel jLabel5 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.portCheck.5"));
        this.activeDonorPortScrollPane = new JScrollPane();
        this.activeDonorPortScrollPane.setPreferredSize(new Dimension(150, 120));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(18, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 80, 2, 160);
        jPanel.add((Component)this.activeDonorPortScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(2, 2, 80, 2);
        jPanel.add((Component)jLabel5, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createOfflineDonorPortPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)new JLabel(FabricTreeControl.getResource("ExtCreditWizard.title.offlineDonorPortPage")), gridBagConstraints);
        JLabel jLabel = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.offlineDonorPorts.1"));
        JLabel jLabel2 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.offlineDonorPorts.2"));
        JLabel jLabel3 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.offlineDonorPorts.3"));
        JLabel jLabel4 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.offlineDonorPorts.4"));
        JLabel jLabel5 = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.offlineDonorPorts.5"));
        this.offlineDonorPortScrollPane = new JScrollPane();
        this.offlineDonorPortScrollPane.setPreferredSize(new Dimension(150, 120));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(18, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 80, 2, 160);
        jPanel.add((Component)this.offlineDonorPortScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(2, 2, 80, 2);
        jPanel.add((Component)jLabel5, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createApplyChangesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)new JLabel(FabricTreeControl.getResource("ExtCreditWizard.title.applyChangesPage")), gridBagConstraints);
        JLabel jLabel = new JLabel(FabricTreeControl.getResource("ExtCreditWizard.progress"));
        this.progressBar = new JProgressBar();
        this.applyChangesWorkingLabel.setText(FabricTreeControl.getResource("ExtCreditWizard.pleaseWait"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 120);
        jPanel.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 10, 2);
        jPanel.add((Component)this.applyChangesWorkingLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 2, 20, 2);
        this.applyChangesOutputScrollPane = new JScrollPane(this.outputText);
        this.outputText.setEditable(false);
        this.applyChangesOutputScrollPane.setPreferredSize(new Dimension(400, 200));
        jPanel.add((Component)this.applyChangesOutputScrollPane, gridBagConstraints);
        return jPanel;
    }

    public void resetWizard() {
        this.initSwitchData();
        this.applyChangesWorkingLabel.setText(FabricTreeControl.getResource("ExtCreditWizard.pleaseWait"));
        this.changeCount = 0;
        this.changesComplete = 0;
        this.applyChangesErrorCount = 0;
        this.outputText.setText("");
    }

    public void resetWizard(Sanbox8000 sanbox8000) {
        this.blade = (SanboxChassis)sanbox8000;
        this.resetWizard();
    }

    public void addMessage(String string) {
        if (string != null) {
            this.outputText.append(string + "\n");
        } else {
            this.outputText.setText("");
        }
        this.repaint();
    }

    public boolean arePortSpeedsIndicated() {
        int n = this.blade.getPortCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.distanceCombo[n2].getSelectedIndex();
            int n4 = this.portSpeedCombo[n2].getSelectedIndex();
            if (n3 > 0) {
                switch (n4) {
                    case 0: 
                    case 3: 
                    case 4: {
                        return false;
                    }
                }
            }
            ++n2;
        }
        return true;
    }

    public void saveExtCreditRequest() {
        int n = this.blade.getPortCount();
        this.extCreditsRequested = new int[n];
        this.distanceRequested = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.distanceCombo[n2].getSelectedIndex();
            this.distanceRequested[n2] = this.translateDistanceRequest(n3);
            if (this.portSpeedCombo[n2].getSelectedIndex() != 0) {
                this.portSpeedRequested[n2] = this.portSpeedCombo[n2].getSelectedIndex();
            }
            this.extCreditsRequested[n2] = this.computeExtCredits(this.distanceRequested[n2], this.portSpeedRequested[n2]);
            ++n2;
        }
        this.alreadyWarnedAboutLoopEnabled = false;
        this.alreadyWarnedAboutPortsAvailable = false;
    }

    protected int computeExtCredits(int n, int n2) {
        int n3 = 0;
        int n4 = 12;
        int n5 = 0;
        if (n2 == 1) {
            n3 = (int)((double)n * 0.6 - 12.0);
            n5 = n3 % 11 <= 0 ? n3 / 11 : n3 / 11 + 1;
            return n5 * 11;
        }
        n3 = (int)((double)n * 1.2 - 12.0);
        n5 = n3 % 11 == 0 ? n3 / 11 : n3 / 11 + 1;
        return n5 * 11;
    }

    protected int computeDistance(int n, int n2) {
        int n3 = n2 == 1 ? (int)((double)n / 0.6) : (int)((double)n / 1.2);
        return n3;
    }

    protected int translateDistanceToIndex(int n) {
        if (n < 20) {
            return 0;
        }
        if (n < 30) {
            return 1;
        }
        if (n < 40) {
            return 2;
        }
        if (n < 50) {
            return 3;
        }
        if (n < 70) {
            return 4;
        }
        if (n < 100) {
            return 5;
        }
        return 6;
    }

    protected int translateDistanceRequest(int n) {
        switch (n) {
            case 0: {
                return 10;
            }
            case 1: {
                return 20;
            }
            case 2: {
                return 30;
            }
            case 3: {
                return 40;
            }
            case 4: {
                return 50;
            }
            case 5: {
                return 70;
            }
            case 6: {
                return 100;
            }
        }
        return 10;
    }

    public boolean areExtCreditPortsLoopEnabled() {
        int n = this.blade.getPortCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.extCreditsRequested[n2] > 0 && this.alDisabled[n2] == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean areTLPortsExtended() {
        int n = this.blade.getPortCount();
        int n2 = 0;
        while (n2 < n) {
            S16Port s16Port = (S16Port)this.blade.getPort(n2);
            PortStates portStates = s16Port.getPortStates();
            if (this.extCreditsRequested[n2] > 0 && portStates.getConfigPortType() == 5) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean alreadyWarnedAboutLoopEnabled() {
        return this.alreadyWarnedAboutLoopEnabled;
    }

    public boolean alreadyWarnedAboutPortsAvailable() {
        return this.alreadyWarnedAboutPortsAvailable;
    }

    public boolean isLoopEnabledPortListInitialized() {
        return this.loopEnabledPortList != null;
    }

    public boolean isPortSpeedChangeListInitialized() {
        return this.portSpeedChangeList != null;
    }

    public void initLoopEnabledPortList() {
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        int n = this.blade.getPortCount();
        String string = FabricTreeControl.getResource("ExtCreditWizard.port");
        String string2 = FabricTreeControl.getResource("ExtCreditWizard.active");
        String string3 = FabricTreeControl.getResource("ExtCreditWizard.inactive");
        int n2 = 0;
        while (n2 < n) {
            if (this.extCreditsRequested[n2] > 0 && this.alDisabled[n2] == 0) {
                S16Port s16Port = (S16Port)this.blade.getPort(n2);
                String string4 = this.blade instanceof SwitchBlade ? ((SwitchBladePort)s16Port).toString() : string + " " + Integer.toString(n2);
                String string5 = s16Port.getPortStates().getLoggedIn() == 1 ? string2 : string3;
                vector.add(string4 + " - " + this.portModeLabelString[n2] + " - " + string5);
                vector2.add(new Integer(n2));
            }
            ++n2;
        }
        this.loopEnabledPortList = new JList(vector);
        int n3 = vector2.size();
        this.portModeChangeRequests = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.portModeChangeRequests[n4] = (Integer)vector2.elementAt(n4);
            ++n4;
        }
        this.loopEnabledScrollPane.setViewportView(this.loopEnabledPortList);
        this.alreadyWarnedAboutLoopEnabled = true;
    }

    public void initPortSpeedChangeList() {
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        int n = this.blade.getPortCount();
        String string = FabricTreeControl.getResource("ExtCreditWizard.port");
        String string2 = FabricTreeControl.getResource("ExtCreditWizard.1Gb");
        String string3 = FabricTreeControl.getResource("ExtCreditWizard.2Gb");
        int n2 = 0;
        while (n2 < n) {
            if (this.portSpeedRequested[n2] != this.portSpeed[n2]) {
                S16Port s16Port = (S16Port)this.blade.getPort(n2);
                String string4 = this.blade instanceof SwitchBlade ? ((SwitchBladePort)s16Port).toString() : string + " " + Integer.toString(n2);
                if (this.portSpeedRequested[n2] == 1) {
                    vector.add(string4 + " - " + string2);
                } else if (this.portSpeedRequested[n2] == 2) {
                    vector.add(string4 + " - " + string3);
                }
                vector2.add(new Integer(n2));
            }
            ++n2;
        }
        this.portSpeedChangeList = new JList(vector);
        this.portSpeedScrollPane.setViewportView(this.portSpeedChangeList);
    }

    public void initTLPortList() {
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        int n = this.blade.getPortCount();
        String string = FabricTreeControl.getResource("ExtCreditWizard.port");
        String string2 = FabricTreeControl.getResource("ExtCreditWizard.active");
        String string3 = FabricTreeControl.getResource("ExtCreditWizard.inactive");
        int n2 = 0;
        while (n2 < n) {
            S16Port s16Port = (S16Port)this.blade.getPort(n2);
            PortStates portStates = s16Port.getPortStates();
            if (this.extCreditsRequested[n2] > 0 && portStates.getConfigPortType() == 5) {
                String string4 = s16Port.getPortStates().getLoggedIn() == 1 ? string2 : string3;
                vector.add(string + " " + Integer.toString(n2) + " - " + this.portModeLabelString[n2] + " - " + string4);
                vector2.add(new Integer(n2));
            }
            ++n2;
        }
        this.tlPortList = new JList(vector);
        this.tlPortScrollPane.setViewportView(this.tlPortList);
    }

    public boolean areDonorPortsOffline() {
        int n = this.blade.getPortCount();
        int n2 = 0;
        while (n2 < n) {
            S16Port s16Port;
            PortStates portStates;
            if (this.donorPortsRequested[n2] && (portStates = (s16Port = (S16Port)this.blade.getPort(n2)).getPortStates()) != null && portStates.getActiveAdminState() != 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean areEnoughDonorPortsDesignated(int n) {
        if (this.numPortsNeededText[n] != null && this.numPortsSelectedText[n] != null) {
            int n2;
            int n3;
            String string = this.numPortsNeededText[n].getText();
            String string2 = this.numPortsSelectedText[n].getText();
            try {
                n3 = Integer.parseInt(string);
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return true;
            }
            if (n3 > n2) {
                return false;
            }
        }
        return true;
    }

    public boolean areEnoughDonorPortsAvailable() {
        int n = this.blade.getPortCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            S16Port s16Port = (S16Port)this.blade.getPort(n6);
            n4 += this.extCreditsRequested[n6];
            if (this.extCreditsRequested[n6] > 0) {
                ++n5;
            } else {
                String string = SbmUtilities.getPortConfigModeString(s16Port.getPortStates());
                if (string.equals("don")) {
                    ++n2;
                } else if (this.portActive[n6] == 0) {
                    ++n3;
                }
            }
            ++n6;
        }
        int n7 = n4 / 11;
        return n7 <= n2 + n3;
    }

    public boolean alreadyWarnedAboutOfflineDonorPorts() {
        return this.alreadyWarnedAboutOfflineDonorPorts;
    }

    public void setAlreadyWarnedAboutOfflineDonorPorts(boolean bl) {
        this.alreadyWarnedAboutOfflineDonorPorts = bl;
    }

    public boolean alreadyWarnedAboutActiveDonorPorts() {
        return this.alreadyWarnedAboutActiveDonorPorts;
    }

    public void initAvailDonorPortPage() {
        int n = this.blade.getPortCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            S16Port s16Port = (S16Port)this.blade.getPort(n6);
            n4 += this.extCreditsRequested[n6];
            if (this.extCreditsRequested[n6] > 0) {
                ++n5;
            } else {
                String string = SbmUtilities.getPortConfigModeString(s16Port.getPortStates());
                if (string.equals("don")) {
                    ++n2;
                } else if (this.portActive[n6] == 0) {
                    ++n3;
                }
            }
            ++n6;
        }
        int n7 = n4 / 11;
        this.currentDonorPortCountText.setText(Integer.toString(n2));
        this.requiredDonorPortCountText.setText(Integer.toString(n7));
        this.inactivePortCountText.setText(Integer.toString(n3));
        this.alreadyWarnedAboutPortsAvailable = true;
    }

    public boolean areDonorPortsActive() {
        int n = this.blade.getPortCount();
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            S16Port s16Port = (S16Port)this.blade.getPort(n2);
            String string = SbmUtilities.getPortConfigModeString(s16Port.getPortStates());
            boolean bl2 = bl = string.equals("don");
            if (this.donorPortsRequested[n2] && this.portActive[n2] == 1 && !bl) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void initActiveDonorPortCheckPage() {
        int n = this.blade.getPortCount();
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            S16Port s16Port = (S16Port)this.blade.getPort(n2);
            String string = FabricTreeControl.getResource("ExtCreditWizard.port");
            String string2 = FabricTreeControl.getResource("ExtCreditWizard.active");
            String string3 = FabricTreeControl.getResource("ExtCreditWizard.inactive");
            String string4 = s16Port.getPortStates().getLoggedIn() == 1 ? string2 : string3;
            String string5 = SbmUtilities.getPortConfigModeString(s16Port.getPortStates());
            boolean bl2 = bl = string5.equals("don");
            if (this.donorPortsRequested[n2] && this.portActive[n2] == 1 && !bl) {
                vector.add(string + " " + n2 + " - " + this.portModeLabelString[n2] + " - " + string4);
            }
            ++n2;
        }
        int n3 = vector.size();
        this.donorPortStrings = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.donorPortStrings[n4] = (String)vector.elementAt(n4);
            ++n4;
        }
        this.activeDonorPortList = new JList<String>(this.donorPortStrings);
        this.activeDonorPortScrollPane.setViewportView(this.activeDonorPortList);
        this.alreadyWarnedAboutActiveDonorPorts = true;
    }

    public void initOfflineDonorPortPage() {
        Object object;
        int n = this.blade.getPortCount();
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < n) {
            S16Port s16Port = (S16Port)this.blade.getPort(n2);
            object = FabricTreeControl.getResource("ExtCreditWizard.port");
            String string = FabricTreeControl.getResource("ExtCreditWizard.active");
            String string2 = FabricTreeControl.getResource("ExtCreditWizard.inactive");
            String string3 = s16Port.getPortStates().getLoggedIn() == 1 ? string : string2;
            String string4 = SbmUtilities.getPortConfigModeString(s16Port.getPortStates());
            boolean bl = string4.equals("don");
            PortStates portStates = s16Port.getPortStates();
            String string5 = "unknown state";
            if (portStates != null && portStates.getActiveAdminState() != 1) {
                string5 = SbmUtilities.getPortStateString(portStates.getActiveAdminState());
            }
            if (this.donorPortsRequested[n2] && portStates.getActiveAdminState() != 1) {
                vector.add((String)object + " " + n2 + " - " + this.portModeLabelString[n2] + " - " + string3 + ", " + string5);
            }
            ++n2;
        }
        int n3 = vector.size();
        object = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            object[n4] = (String)vector.elementAt(n4);
            ++n4;
        }
        this.offlineDonorPortList = new JList<String>((E[])object);
        this.offlineDonorPortScrollPane.setViewportView(this.offlineDonorPortList);
        this.alreadyWarnedAboutOfflineDonorPorts = true;
    }

    public void saveDonorPortRequest(int n) {
        int n2 = this.blade.getPortCount();
        int n3 = this.getLowPortNumber(n);
        while (n3 < this.getHighPortNumber(n)) {
            this.donorPortsRequested[n3] = false;
            ++n3;
        }
        ListModel listModel = this.selectedDonorPortList[n].getModel();
        int n4 = listModel.getSize();
        this.donorPortStrings = new String[n4];
        int n5 = 0;
        while (n5 < n4) {
            String string;
            this.donorPortStrings[n5] = string = (String)listModel.getElementAt(n5);
            int n6 = this.stringToPortNumber(string);
            if (n6 >= 0 && n6 <= n2) {
                this.donorPortsRequested[n6] = true;
            }
            ++n5;
        }
        this.alreadyWarnedAboutActiveDonorPorts = false;
        this.alreadyWarnedAboutOfflineDonorPorts = false;
    }

    protected int stringToPortNumber(String string) {
        block7: {
            if (this.blade instanceof SwitchBlade) {
                if (string.length() >= 6 && string.substring(0, 6).equals("Ext1:0")) {
                    return 0;
                }
                if (string.length() >= 7 && string.substring(0, 7).equals("Ext2:15")) {
                    return 15;
                }
                try {
                    return Integer.parseInt(string.substring(4, 6).trim());
                }
                catch (Exception exception) {
                    break block7;
                }
            }
            try {
                return Integer.parseInt(string.substring(5, 7).trim());
            }
            catch (Exception exception) {}
            {
            }
        }
        return -1;
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    public void applyExtCreditChanges() {
        int n;
        int n2;
        int n3;
        this.releaseAdminCompletedCount = 0;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        ((Sanbox2)this.blade).requestAdmin();
        ((Sanbox2)this.blade).editConfig();
        this.changeCount = 2;
        int n4 = this.portModeChangeRequests.length;
        int n5 = 0;
        while (n5 < n4) {
            n3 = this.portModeChangeRequests[n5];
            PortStates portStates = this.blade.getPort(n3).getPortStates();
            n = n2 = (int)portStates.getConfigPortType();
            switch (n2) {
                case 2: {
                    n = 1;
                    break;
                }
                case 5: 
                case 9: {
                    n = 8;
                }
            }
            ((Sanbox2)this.blade).applyPortMode(n3, n);
            ++this.changeCount;
            ++n5;
        }
        n3 = this.blade.getPortCount();
        int n6 = 0;
        while (n6 < n3) {
            if (this.portSpeedChangeRequired[n6]) {
                ((Sanbox2)this.blade).applyPortSpeed(n6, this.portSpeedRequested[n6]);
                ++this.changeCount;
            }
            ++n6;
        }
        n2 = this.blade.getPortCount();
        n = 0;
        while (n < n2) {
            PortStates portStates = this.blade.getPort(n).getPortStates();
            if (this.donorPortsRequested[n]) {
                ++this.changeCount;
                ((Sanbox2)this.blade).applyPortMode(n, 6);
                ++this.changeCount;
                ((Sanbox2)this.blade).applyPortState(n, 1);
            } else if (portStates.getConfigPortType() == 6) {
                ++this.changeCount;
                ((Sanbox2)this.blade).applyPortMode(n, 8);
            }
            ++n;
        }
        ((Sanbox2)this.blade).saveConfig();
        ((Sanbox2)this.blade).activateConfigAndReleaseAdmin(20000, 3000);
        this.changeCount += 2;
        ((Sanbox2)this.blade).requestAdmin();
        ((Sanbox2)this.blade).editConfig();
        this.changeCount += 2;
        int n7 = 0;
        while (n7 < n2) {
            ((Sanbox2)this.blade).applyExtCredit(n7, this.extCreditsRequested[n7]);
            ++this.changeCount;
            ++n7;
        }
        ((Sanbox2)this.blade).saveConfig();
        ((Sanbox2)this.blade).activateConfigAndReleaseAdmin(20000, 3000);
        this.changeCount += 2;
        this.startProgressBar(this.changeCount);
        this.changesComplete = 1;
    }

    public void startProgressBar(int n) {
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(n);
        this.progressBar.setValue(0);
    }

    public void updateProgressBar(int n) {
        this.progressBar.setValue(n);
        this.repaint();
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(269));
        vector.add(new Integer(225));
        vector.add(new Integer(288));
        return vector;
    }

    public void appliedChangesComplete() {
        if (this.applyChangesErrorCount == 0) {
            this.applyChangesWorkingLabel.setText(FabricTreeControl.getResource("ExtCreditWizard.changeSuccessful"));
        } else {
            this.applyChangesWorkingLabel.setText(FabricTreeControl.getResource("ExtCreditWizard.changeErrors"));
        }
        this.repaint();
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        ExtCreditWizardSanbox8000 dialog = null;

        public ApplyResponseHandler(ExtCreditWizardSanbox8000 extCreditWizardSanbox80002, ChassisEvent chassisEvent) {
            this.dialog = extCreditWizardSanbox80002;
            this.evt = chassisEvent;
        }

        public void run() {
            int n = this.evt.getEventType();
            switch (n) {
                case 238: {
                    if (this.evt.isSuccessful()) {
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.reqAdmin.ok"));
                    } else {
                        ++ExtCreditWizardSanbox8000.this.applyChangesErrorCount;
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.reqAdmin.ok"));
                    }
                    ExtCreditWizardSanbox8000.this.updateProgressBar(ExtCreditWizardSanbox8000.this.changesComplete++);
                    break;
                }
                case 264: {
                    ++ExtCreditWizardSanbox8000.this.releaseAdminCompletedCount;
                    if (this.evt.isSuccessful()) {
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.activateConfigRelAdmin.ok"));
                    } else {
                        ++ExtCreditWizardSanbox8000.this.applyChangesErrorCount;
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.activateConfigRelAdmin.notOk"));
                    }
                    ExtCreditWizardSanbox8000.this.updateProgressBar(ExtCreditWizardSanbox8000.this.changesComplete++);
                    if (ExtCreditWizardSanbox8000.this.releaseAdminCompletedCount != 2) break;
                    ExtCreditWizardSanbox8000.this.appliedChangesComplete();
                    ExtCreditWizardSanbox8000.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(ExtCreditWizardSanbox8000.this.frame, ExtCreditWizardSanbox8000.this.blade, ExtCreditWizardSanbox8000.this.getEventList(), FabricTreeControl.getResource("ExtCreditWizard.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 237: {
                    if (this.evt.isSuccessful()) {
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.editConfig.ok"));
                    } else {
                        ++ExtCreditWizardSanbox8000.this.applyChangesErrorCount;
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.editConfig.notOk"));
                    }
                    ExtCreditWizardSanbox8000.this.updateProgressBar(ExtCreditWizardSanbox8000.this.changesComplete++);
                    break;
                }
                case 235: {
                    if (this.evt.isSuccessful()) {
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.saveConfig.ok"));
                    } else {
                        ++ExtCreditWizardSanbox8000.this.applyChangesErrorCount;
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.saveConfig.notOk"));
                    }
                    ExtCreditWizardSanbox8000.this.updateProgressBar(ExtCreditWizardSanbox8000.this.changesComplete++);
                    break;
                }
                case 317: {
                    if (this.evt.isSuccessful()) {
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.portStateChange.ok"));
                    } else {
                        ++ExtCreditWizardSanbox8000.this.applyChangesErrorCount;
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.portStateChange.notOk"));
                    }
                    ExtCreditWizardSanbox8000.this.updateProgressBar(ExtCreditWizardSanbox8000.this.changesComplete++);
                    break;
                }
                case 273: {
                    if (this.evt.isSuccessful()) {
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.portModeChange.ok"));
                    } else {
                        ++ExtCreditWizardSanbox8000.this.applyChangesErrorCount;
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.portModeChange.notOk"));
                    }
                    ExtCreditWizardSanbox8000.this.updateProgressBar(ExtCreditWizardSanbox8000.this.changesComplete++);
                    break;
                }
                case 227: {
                    if (this.evt.isSuccessful()) {
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.portSpeedChange.ok"));
                    } else {
                        ++ExtCreditWizardSanbox8000.this.applyChangesErrorCount;
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.portSpeedChange.notOk"));
                    }
                    ExtCreditWizardSanbox8000.this.updateProgressBar(ExtCreditWizardSanbox8000.this.changesComplete++);
                    break;
                }
                case 287: {
                    if (this.evt.isSuccessful()) {
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.extCredits.ok"));
                    } else {
                        ++ExtCreditWizardSanbox8000.this.applyChangesErrorCount;
                        ExtCreditWizardSanbox8000.this.addMessage(FabricTreeControl.getResource("ExtCreditWizard.extCredits.notOk"));
                    }
                    ExtCreditWizardSanbox8000.this.updateProgressBar(ExtCreditWizardSanbox8000.this.changesComplete++);
                }
            }
        }
    }

    class RightButtonListener
    implements ActionListener {
        ExtCreditWizardSanbox8000 theWizard = null;
        int index;

        public RightButtonListener(ExtCreditWizardSanbox8000 extCreditWizardSanbox80002, int n) {
            this.theWizard = extCreditWizardSanbox80002;
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            Object[] objectArray = ExtCreditWizardSanbox8000.this.availPortList[this.index].getSelectedValues();
            ListModel listModel = ExtCreditWizardSanbox8000.this.availPortList[this.index].getModel();
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < listModel.getSize()) {
                if (!ExtCreditWizardSanbox8000.this.availPortList[this.index].isSelectedIndex(n)) {
                    vector.add(listModel.getElementAt(n));
                }
                ++n;
            }
            ExtCreditWizardSanbox8000.this.availPortList[this.index].setListData(vector);
            ListModel listModel2 = ExtCreditWizardSanbox8000.this.selectedDonorPortList[this.index].getModel();
            vector = new Vector();
            int n2 = 0;
            while (n2 < listModel2.getSize()) {
                vector.add(listModel2.getElementAt(n2));
                ++n2;
            }
            int n3 = 0;
            while (n3 < objectArray.length) {
                vector.add(objectArray[n3]);
                ++n3;
            }
            ExtCreditWizardSanbox8000.this.selectedDonorPortList[this.index].setListData(vector);
            ExtCreditWizardSanbox8000.this.numPortsSelectedText[this.index].setText(Integer.toString(ExtCreditWizardSanbox8000.this.selectedDonorPortList[this.index].getModel().getSize()));
        }
    }

    class LeftButtonListener
    implements ActionListener {
        ExtCreditWizardSanbox8000 theWizard = null;
        int index;

        public LeftButtonListener(ExtCreditWizardSanbox8000 extCreditWizardSanbox80002, int n) {
            this.theWizard = extCreditWizardSanbox80002;
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            Object[] objectArray = ExtCreditWizardSanbox8000.this.selectedDonorPortList[this.index].getSelectedValues();
            ListModel listModel = ExtCreditWizardSanbox8000.this.selectedDonorPortList[this.index].getModel();
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < listModel.getSize()) {
                if (!ExtCreditWizardSanbox8000.this.selectedDonorPortList[this.index].isSelectedIndex(n)) {
                    vector.add(listModel.getElementAt(n));
                }
                ++n;
            }
            ExtCreditWizardSanbox8000.this.selectedDonorPortList[this.index].setListData(vector);
            ListModel listModel2 = ExtCreditWizardSanbox8000.this.availPortList[this.index].getModel();
            vector = new Vector();
            int n2 = 0;
            while (n2 < listModel2.getSize()) {
                vector.add(listModel2.getElementAt(n2));
                ++n2;
            }
            int n3 = 0;
            while (n3 < objectArray.length) {
                vector.add(objectArray[n3]);
                ++n3;
            }
            ExtCreditWizardSanbox8000.this.availPortList[this.index].setListData(vector);
            ExtCreditWizardSanbox8000.this.numPortsSelectedText[this.index].setText(Integer.toString(ExtCreditWizardSanbox8000.this.selectedDonorPortList[this.index].getModel().getSize()));
        }
    }

    public class ClearMessage
    implements Runnable {
        public void run() {
            ExtCreditWizardSanbox8000.this.outputText.setText("");
        }
    }

    public class AddMessage
    implements Runnable {
        String str;

        public AddMessage(String string) {
            this.str = string;
        }

        public void run() {
            ExtCreditWizardSanbox8000.this.addMessage(this.str);
        }
    }
}

