/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TempMonitoringDialogSanbox2
extends QDialog
implements ChassisEventListener {
    protected Sanbox2 blade = null;
    protected ChassisEventAdapter eventAdapter = null;
    protected JFrame frame = null;
    protected JPanel propertyPanel = null;
    protected JPanel buttonPanel = null;
    protected boolean waitingOnTempMonitoringChange = false;
    JCheckBox tempMonEnableCheckBox = new JCheckBox(FabricTreeControl.getResource("TempMonitoring.enableLabel"));
    JLabel warningTempLabel = new JLabel(FabricTreeControl.getResource("TempMonitoring.warningTempLabel"));
    JLabel failureTempLabel = new JLabel(FabricTreeControl.getResource("TempMonitoring.failureTempLabel"));
    JLabel rangeLabel = new JLabel(FabricTreeControl.getResource("TempMonitoring.validRange"));
    JTextField warningTempText = new JTextField();
    JTextField failureTempText = new JTextField();
    JButton applyButton = new JButton(FabricTreeControl.getResource("TempMonitoring.applyButton"));
    JButton cancelButton = new JButton(FabricTreeControl.getResource("TempMonitoring.cancelButton"));
    boolean tempMonitoringEnabled;
    int warningTemp;
    int failureTemp;

    public TempMonitoringDialogSanbox2(JFrame jFrame, boolean bl, Sanbox2 sanbox2) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("TempMonitoring.title") + " - " + VendorProperties.getFrameTitle());
        this.blade = sanbox2;
        this.frame = jFrame;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        this.propertyPanel = this.createPropertyPanel();
        this.buttonPanel = this.createButtonPanel();
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.tempMonitoringDialogSanbox2Help"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.propertyPanel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void resetDialog(Sanbox2 sanbox2) {
        this.blade.removeChassisEventListener((ChassisEventListener)this);
        this.enableButtons();
        this.waitingOnTempMonitoringChange = false;
        this.blade = sanbox2;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        this.tempMonitoringEnabled = this.blade.getTempMonEnable() == 1;
        if (this.tempMonitoringEnabled) {
            this.tempMonEnableCheckBox.setSelected(true);
        } else {
            this.tempMonEnableCheckBox.setSelected(false);
        }
        this.warningTempText.setText(Integer.toString(this.blade.getWarningTemp()));
        this.failureTempText.setText(Integer.toString(this.blade.getFailureTemp()));
    }

    public JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 4, 8, 0));
        this.applyButton.addActionListener(new ApplyButtonListener(this));
        this.applyButton.setMnemonic('O');
        this.cancelButton.addActionListener(new CancelButtonListener(this));
        this.cancelButton.setMnemonic('C');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.applyButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    protected JPanel createPropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 20, 10, 20);
        jPanel.add((Component)this.tempMonEnableCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 20, 2, 0);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.warningTempLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 0, 2, 20);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.warningTempText, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 20, 2, 0);
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.failureTempLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 0, 2, 20);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.failureTempText, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 20, 10, 20);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.rangeLabel, gridBagConstraints);
        this.tempMonitoringEnabled = this.blade.getTempMonEnable() == 1;
        if (this.tempMonitoringEnabled) {
            this.tempMonEnableCheckBox.setSelected(true);
        } else {
            this.tempMonEnableCheckBox.setSelected(false);
        }
        this.warningTempText.setText(Integer.toString(this.blade.getWarningTemp()));
        this.failureTempText.setText(Integer.toString(this.blade.getFailureTemp()));
        return jPanel;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.blade.removeChassisEventListener((ChassisEventListener)this);
            this.setVisible(false);
        }
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    public void disableButtons() {
        this.applyButton.setEnabled(false);
    }

    public void enableButtons() {
        this.applyButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    protected int applyTempMonitoring() {
        int n;
        int n2;
        int n3 = this.tempMonEnableCheckBox.isSelected() ? 1 : 2;
        try {
            n2 = Integer.parseInt(this.warningTempText.getText().trim());
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("TempMonitoring.invalidWarningTemp"));
            return -1;
        }
        try {
            n = Integer.parseInt(this.failureTempText.getText().trim());
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("TempMonitoring.invalidFailureTemp"));
            return -1;
        }
        if (n2 < 0 || n2 > 100 || n < 0 || n > 100) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("TempMonitoring.invalidTemp"));
            return -1;
        }
        if (n2 > n) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("TempMonitoring.tempConflict"));
            return -1;
        }
        if (n3 != this.blade.getTempMonEnable() || n2 != this.blade.getWarningTemp() || n != this.blade.getFailureTemp()) {
            this.waitingOnTempMonitoringChange = true;
            this.blade.applyTempMonitoring(n3, n2, n);
        }
        return 1;
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(358));
        return vector;
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        TempMonitoringDialogSanbox2 dialog = null;

        public ApplyResponseHandler(TempMonitoringDialogSanbox2 tempMonitoringDialogSanbox22, ChassisEvent chassisEvent) {
            this.dialog = tempMonitoringDialogSanbox22;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 359: {
                    TempMonitoringDialogSanbox2.this.waitingOnTempMonitoringChange = false;
                    if (!this.evt.isSuccessful()) {
                        TempMonitoringDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("TempMonitoring.enableFailed") + "\n" + TempMonitoringDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        TempMonitoringDialogSanbox2.this.enableButtons();
                        this.dialog.setVisible(false);
                        break;
                    }
                    if (TempMonitoringDialogSanbox2.this.waitingOnTempMonitoringChange) break;
                    TempMonitoringDialogSanbox2.this.enableButtons();
                    TempMonitoringDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(TempMonitoringDialogSanbox2.this.frame, (SanboxChassis)TempMonitoringDialogSanbox2.this.blade, TempMonitoringDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("PortPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        TempMonitoringDialogSanbox2 theDialog = null;

        public CancelButtonListener(TempMonitoringDialogSanbox2 tempMonitoringDialogSanbox22) {
            this.theDialog = tempMonitoringDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TempMonitoringDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.theDialog);
            TempMonitoringDialogSanbox2.this.enableButtons();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        TempMonitoringDialogSanbox2 theDialog = null;

        public ApplyButtonListener(TempMonitoringDialogSanbox2 tempMonitoringDialogSanbox22) {
            this.theDialog = tempMonitoringDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyTempMonitoring() == 1) {
                if (TempMonitoringDialogSanbox2.this.waitingOnTempMonitoringChange) {
                    TempMonitoringDialogSanbox2.this.disableButtons();
                } else {
                    TempMonitoringDialogSanbox2.this.enableButtons();
                    this.theDialog.setVisible(false);
                }
            }
        }
    }
}

