/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricLink;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S43Port;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.util.SanboxUtil;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.PortProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PortPropertiesDialogSanbox
extends QDialog {
    protected SanboxChassis blade = null;
    protected ChassisEventAdapter eventAdapter = null;
    protected Vector portList = null;
    protected JFrame frame = null;
    protected JPanel propertyPanel = null;
    protected JPanel buttonPanel = null;
    protected JPanel idPanel = null;
    protected JPanel portStatePanel = null;
    protected JPanel portModePanel = null;
    protected JPanel tlModePanel = null;
    protected JPanel rscnPanel = null;
    protected boolean waitingOnPortStateChange = false;
    protected boolean waitingOnPortModeChange = false;
    protected boolean waitingOnSaveActive = false;
    protected boolean waitingOnSavePending = false;
    protected boolean waitingOnTLConfigChange = false;
    protected boolean waitingOnTLMode = false;
    protected boolean waitingOnRscn = false;
    JLabel portStatesLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.portStatesLabel"));
    ButtonGroup stateButtonGroup = new ButtonGroup();
    JRadioButton onlineButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.onlineButton"));
    JRadioButton offlineButton = new JRadioButton(FabricTreeControl.getResource("PortPropertiesDialog.offlineButton"));
    protected PortProperties properties = new PortProperties();

    public PortPropertiesDialogSanbox(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis, Vector vector) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("PortPropertiesDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.blade = sanboxChassis;
        this.frame = jFrame;
        this.portList = vector;
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.propertyPanel = this.createPropertyPanel();
        this.properties.tlPortButton.addChangeListener(new TLModeButtonListener(this));
        this.buttonPanel = this.properties.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.portPropertiesDialogSanboxHelp"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.propertyPanel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.properties.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.updateRadioButtons();
    }

    public void resetDialog(SanboxChassis sanboxChassis, Vector vector) {
        this.unregisterForEvents();
        this.setEnabled(true);
        this.blade = sanboxChassis;
        this.portList = vector;
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.properties.resetIdPanel(this.blade, this.portList);
        this.updateRadioButtons();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.properties.setPortModeButtonsEnabled(bl);
        this.properties.setPortStateButtonsEnabled(bl);
        this.properties.setTLModeButtonsEnabled(bl);
    }

    protected JPanel createPropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.idPanel = this.properties.createIdPanel(this.blade, this.portList);
        this.portStatePanel = this.createPortStatesPanel();
        this.portModePanel = this.properties.createPortModesPanel(this.blade.getChassisType());
        this.tlModePanel = this.properties.createTLModePanel();
        this.rscnPanel = this.properties.createRscnPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.portStatePanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.portModePanel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.rscnPanel, gridBagConstraints);
        return jPanel;
    }

    public JPanel createPortStatesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.stateButtonGroup.add(this.onlineButton);
        this.stateButtonGroup.add(this.offlineButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.portStatesLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 7);
        jPanel.add((Component)this.onlineButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.offlineButton, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    public void setPorts(SanboxChassis sanboxChassis, Vector vector) {
        this.blade = sanboxChassis;
        this.portList = vector;
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
    }

    protected void updateRadioButtons() {
        if (this.portList == null || this.portList.size() < 1) {
            return;
        }
        this.updatePortStateButtons(this.portList);
        this.updatePortModeButtons(this.portList);
        this.properties.updateS43TLModeButtons(this.portList);
        this.updateRscnButtons(this.portList);
    }

    public void updateRscnButtons(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        Object[] objectArray = vector.toArray();
        boolean bl = true;
        S43Port s43Port = (S43Port)objectArray[0];
        boolean bl2 = s43Port.isRscnSuppressed();
        int n = 1;
        while (n < objectArray.length) {
            S43Port s43Port2 = (S43Port)objectArray[n];
            if (bl2 != s43Port2.isRscnSuppressed()) {
                bl = false;
            }
            ++n;
        }
        if (bl) {
            if (bl2) {
                this.properties.rscnEnableButton.setSelected(true);
                this.properties.rscnDisableButton.setSelected(false);
            } else {
                this.properties.rscnEnableButton.setSelected(false);
                this.properties.rscnDisableButton.setSelected(true);
            }
        } else {
            this.properties.rscnButtonGroup.remove(this.properties.rscnEnableButton);
            this.properties.rscnButtonGroup.remove(this.properties.rscnDisableButton);
            this.properties.rscnEnableButton.setSelected(false);
            this.properties.rscnDisableButton.setSelected(false);
            this.properties.rscnButtonGroup.add(this.properties.rscnEnableButton);
            this.properties.rscnButtonGroup.add(this.properties.rscnDisableButton);
        }
    }

    public void updatePortStateButtons(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        Object[] objectArray = vector.toArray();
        boolean bl = true;
        PortStates portStates = null;
        FCPort fCPort = (FCPort)objectArray[0];
        portStates = fCPort.getPortStates();
        if (portStates == null) {
            return;
        }
        int n = 1;
        while (n < objectArray.length) {
            FCPort fCPort2 = (FCPort)objectArray[n];
            PortStates portStates2 = fCPort2.getPortStates();
            if (portStates2 == null || portStates.getActiveAdminState() != portStates2.getActiveAdminState()) {
                bl = false;
            }
            ++n;
        }
        if (bl && portStates != null) {
            switch (portStates.getActiveAdminState()) {
                case 1: {
                    this.onlineButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.offlineButton.setSelected(true);
                }
            }
        } else {
            this.stateButtonGroup.remove(this.onlineButton);
            this.stateButtonGroup.remove(this.offlineButton);
            this.onlineButton.setSelected(false);
            this.offlineButton.setSelected(false);
            this.stateButtonGroup.add(this.onlineButton);
            this.stateButtonGroup.add(this.offlineButton);
        }
    }

    public void updatePortModeButtons(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        Object[] objectArray = vector.toArray();
        boolean bl = true;
        boolean bl2 = false;
        PortStates portStates = null;
        FCPort fCPort = (FCPort)objectArray[0];
        portStates = fCPort.getPortStates();
        int n = 1;
        while (n < objectArray.length) {
            FCPort fCPort2 = (FCPort)objectArray[n];
            if (fCPort.getPortStates() == null || fCPort2.getPortStates() == null) {
                bl = false;
                bl2 = true;
            } else {
                if (fCPort.getPortStates().getAlDisabled() != fCPort2.getPortStates().getAlDisabled()) {
                    bl = false;
                }
                if (fCPort2.getPortStates().getPortType() == 5) {
                    bl2 = true;
                }
            }
            ++n;
        }
        if (portStates != null && portStates.getPortType() == 5) {
            bl2 = true;
        }
        boolean bl3 = true;
        S43Port s43Port = (S43Port)fCPort;
        int n2 = 1;
        while (n2 < objectArray.length) {
            S43Port s43Port2 = (S43Port)((FCPort)objectArray[n2]);
            if (s43Port.getPortStates() == null) {
                bl3 = false;
                break;
            }
            if (s43Port.getPortStates().getPortType() != 5) {
                bl3 = false;
                break;
            }
            if (s43Port.getPortStates().getPortType() != s43Port2.getPortStates().getPortType()) {
                bl3 = false;
            }
            ++n2;
        }
        if (bl3 && s43Port.getPortStates().getPortType() == 5) {
            this.properties.tlPortButton.setSelected(true);
        } else if (bl && fCPort.getPortStates() != null && !bl2) {
            switch (fCPort.getPortStates().getAlDisabled()) {
                case 1: {
                    this.properties.gPortButton.setSelected(true);
                    break;
                }
                case 0: {
                    this.properties.glPortButton.setSelected(true);
                }
            }
        } else {
            this.properties.modeButtonGroup.remove(this.properties.gPortButton);
            this.properties.modeButtonGroup.remove(this.properties.glPortButton);
            this.properties.modeButtonGroup.remove(this.properties.tlPortButton);
            this.properties.gPortButton.setSelected(false);
            this.properties.glPortButton.setSelected(false);
            this.properties.tlPortButton.setSelected(false);
            this.properties.modeButtonGroup.add(this.properties.gPortButton);
            this.properties.modeButtonGroup.add(this.properties.glPortButton);
            this.properties.modeButtonGroup.add(this.properties.tlPortButton);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.unregisterForEvents();
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
        this.eventAdapter.unregisterEventHandler(227);
        this.eventAdapter.unregisterEventHandler(231);
        this.eventAdapter.unregisterEventHandler(273);
        this.eventAdapter.unregisterEventHandler(267);
        this.eventAdapter.unregisterEventHandler(266);
        this.eventAdapter.unregisterEventHandler(304);
        this.eventAdapter.unregisterEventHandler(305);
        this.eventAdapter.unregisterEventHandler(298);
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(297));
        vector.add(new Integer(300));
        vector.add(new Integer(269));
        vector.add(new Integer(230));
        return vector;
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyPortProperties() {
        this.waitingOnPortStateChange = false;
        this.waitingOnPortModeChange = false;
        this.waitingOnSaveActive = false;
        this.waitingOnSavePending = false;
        this.waitingOnTLConfigChange = false;
        this.waitingOnTLMode = false;
        this.waitingOnRscn = false;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        this.waitingOnPortStateChange = true;
        if (this.onlineButton.isSelected()) {
            n2 = 1;
        } else if (this.offlineButton.isSelected()) {
            n2 = 2;
        }
        this.waitingOnPortModeChange = true;
        if (this.properties.gPortButton.isSelected()) {
            n = 8;
        } else if (this.properties.glPortButton.isSelected()) {
            n = 9;
        } else if (this.properties.tlPortButton.isSelected()) {
            n = 5;
        }
        this.waitingOnRscn = true;
        if (this.properties.rscnEnableButton.isSelected()) {
            bl2 = true;
        } else if (this.properties.rscnDisableButton.isSelected()) {
            bl2 = false;
        } else {
            this.waitingOnRscn = false;
        }
        if (this.waitingOnPortStateChange || this.waitingOnPortModeChange || this.waitingOnRscn) {
            int n3;
            int n4;
            int n5;
            Fabric fabric = FabricList.getFabric((Chassis)this.blade);
            boolean bl3 = false;
            int n6 = this.portList.size();
            int n7 = 0;
            while (n7 < n6) {
                FCPort fCPort = (FCPort)this.portList.elementAt(n7);
                FabricLink fabricLink = fabric.getLinkByEnd((Chassis)this.blade, fCPort);
                if (fabricLink != null && fCPort.getAdminState() == 1 && n2 != 1) {
                    bl3 = true;
                }
                ++n7;
            }
            if (bl3 && !PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("PortPropertiesDialog.applyOfflineWarning"))) {
                return -1;
            }
            int n8 = this.blade.getPortCount();
            int n9 = this.blade.getMfsTimeout();
            int[] nArray = new int[n8];
            int[] nArray2 = new int[n8];
            int[] nArray3 = new int[n8];
            int[] nArray4 = new int[n8];
            byte[] byArray = new byte[n8];
            boolean[] blArray = new boolean[n8];
            int n10 = 0;
            while (n10 < n8) {
                nArray[n10] = this.blade.getPort(n10).getAlDisabled();
                nArray2[n10] = this.blade.getPort(n10).getMfsMode();
                nArray3[n10] = this.blade.getPort(n10).getAdminState();
                nArray4[n10] = this.blade.getPort(n10).getPortStates().getPortType();
                byArray[n10] = (byte)((S43Port)this.blade.getPort(n10)).getDonorMode();
                blArray[n10] = ((S43Port)this.blade.getPort(n10)).isRscnSuppressed();
                ++n10;
            }
            if (n == 5) {
                n5 = this.portList.size();
                n4 = 0;
                while (n4 < n5) {
                    n3 = ((FCPort)this.portList.elementAt(n4)).getPortNumber();
                    byArray[n3] = (byte)n;
                    nArray[n3] = 0;
                    nArray4[n3] = n;
                    ++n4;
                }
            } else {
                this.waitingOnTLConfigChange = false;
                if (n != 0) {
                    this.properties.setPortTypes(this.portList, nArray4, n);
                }
                n5 = this.portList.size();
                n4 = 0;
                while (n4 < n5) {
                    n3 = ((FCPort)this.portList.elementAt(n4)).getPortNumber();
                    if (n != 0) {
                        byArray[n3] = 1;
                        nArray4[n3] = 1;
                    }
                    if (n == 9) {
                        nArray[n3] = 0;
                        nArray4[n3] = 2;
                    } else if (n == 8) {
                        nArray[n3] = 1;
                        nArray4[n3] = 1;
                    }
                    ++n4;
                }
            }
            n5 = this.portList.size();
            n4 = 0;
            while (n4 < n5) {
                n3 = ((FCPort)this.portList.elementAt(n4)).getPortNumber();
                if (n2 != 0) {
                    nArray3[n3] = n2;
                }
                blArray[n3] = bl2;
                ++n4;
            }
            this.eventAdapter.registerEventHandler(231, "receiveChassisEvent");
            this.eventAdapter.registerEventHandler(273, "receiveChassisEvent");
            this.eventAdapter.registerEventHandler(267, "receiveChassisEvent");
            this.eventAdapter.registerEventHandler(266, "receiveChassisEvent");
            this.waitingOnSaveActive = true;
            if (this.waitingOnTLConfigChange) {
                this.eventAdapter.registerEventHandler(304, "receiveChassisEvent");
                this.eventAdapter.registerEventHandler(305, "receiveChassisEvent");
            }
            this.eventAdapter.registerEventHandler(298, "receiveChassisEvent");
            n3 = this.blade.getDomainId();
            this.waitingOnSavePending = true;
            if (this.waitingOnRscn) {
                ((Sanbox)this.blade).applyRscn(blArray);
            }
            ((Sanbox)this.blade).applySwitchConfig(n3, this.blade.getDomainIdLock(), this.blade.getStageType(), this.blade.getAdminMode(), n9, nArray3, nArray2, nArray, nArray4, this.blade.getRtTimeout(), this.blade.getRaTimeout(), this.blade.getEdTimeout());
            ((SanboxUtil)this.blade).applySavePendingSwitchConfig();
            ((Sanbox)this.blade).applyActiveSwitchConfig(n3, this.blade.getDomainIdLock(), this.blade.getStageType(), this.blade.getAdminMode(), n9, nArray3, nArray2, nArray, nArray4, this.blade.getRtTimeout(), this.blade.getRaTimeout(), this.blade.getEdTimeout());
            ((Sanbox)this.blade).applySaveActiveSwitchConfig();
        }
        return 1;
    }

    public void receiveChassisEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        PortPropertiesDialogSanbox dialog = null;

        public ApplyResponseHandler(PortPropertiesDialogSanbox portPropertiesDialogSanbox2, ChassisEvent chassisEvent) {
            this.dialog = portPropertiesDialogSanbox2;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 298: {
                    PortPropertiesDialogSanbox.this.waitingOnRscn = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.rscnFailed") + "\n" + PortPropertiesDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (PortPropertiesDialogSanbox.this.waitingOnSaveActive || PortPropertiesDialogSanbox.this.waitingOnPortModeChange || PortPropertiesDialogSanbox.this.waitingOnSavePending || PortPropertiesDialogSanbox.this.waitingOnPortStateChange || PortPropertiesDialogSanbox.this.waitingOnTLConfigChange) break;
                    PortPropertiesDialogSanbox.this.properties.enableButtons();
                    PortPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    break;
                }
                case 304: 
                case 305: {
                    PortPropertiesDialogSanbox.this.waitingOnTLConfigChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.tlConfigError") + "\n" + PortPropertiesDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (PortPropertiesDialogSanbox.this.waitingOnSaveActive || PortPropertiesDialogSanbox.this.waitingOnPortModeChange || PortPropertiesDialogSanbox.this.waitingOnSavePending || PortPropertiesDialogSanbox.this.waitingOnPortStateChange || PortPropertiesDialogSanbox.this.waitingOnRscn) break;
                    PortPropertiesDialogSanbox.this.properties.enableButtons();
                    PortPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    break;
                }
                case 231: {
                    PortPropertiesDialogSanbox.this.waitingOnPortStateChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.switchConfigError") + "\n" + PortPropertiesDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (PortPropertiesDialogSanbox.this.waitingOnSaveActive || PortPropertiesDialogSanbox.this.waitingOnPortModeChange || PortPropertiesDialogSanbox.this.waitingOnSavePending || PortPropertiesDialogSanbox.this.waitingOnTLConfigChange || PortPropertiesDialogSanbox.this.waitingOnRscn) break;
                    PortPropertiesDialogSanbox.this.properties.enableButtons();
                    PortPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    break;
                }
                case 266: {
                    PortPropertiesDialogSanbox.this.waitingOnSavePending = false;
                    if (PortPropertiesDialogSanbox.this.waitingOnSaveActive) break;
                    PortPropertiesDialogSanbox.this.properties.enableButtons();
                    PortPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    break;
                }
                case 273: {
                    PortPropertiesDialogSanbox.this.waitingOnPortModeChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.portModeError") + "\n" + PortPropertiesDialogSanbox.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (PortPropertiesDialogSanbox.this.waitingOnSaveActive || PortPropertiesDialogSanbox.this.waitingOnPortStateChange || PortPropertiesDialogSanbox.this.waitingOnSavePending || PortPropertiesDialogSanbox.this.waitingOnTLConfigChange || PortPropertiesDialogSanbox.this.waitingOnRscn) break;
                    PortPropertiesDialogSanbox.this.properties.enableButtons();
                    PortPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    break;
                }
                case 267: {
                    PortPropertiesDialogSanbox.this.waitingOnSaveActive = false;
                    PortPropertiesDialogSanbox.this.properties.enableButtons();
                    PortPropertiesDialogSanbox.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(PortPropertiesDialogSanbox.this.frame, PortPropertiesDialogSanbox.this.blade, PortPropertiesDialogSanbox.this.getEventList(), FabricTreeControl.getResource("PortPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                }
            }
        }
    }

    class TLModeButtonListener
    implements ChangeListener {
        PortPropertiesDialogSanbox theDialog = null;

        public TLModeButtonListener(PortPropertiesDialogSanbox portPropertiesDialogSanbox2) {
            this.theDialog = portPropertiesDialogSanbox2;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == PortPropertiesDialogSanbox.this.properties.tlPortButton) {
                if (PortPropertiesDialogSanbox.this.properties.tlPortButton.isSelected()) {
                    PortPropertiesDialogSanbox.this.properties.autoLearnButton.setEnabled(true);
                    PortPropertiesDialogSanbox.this.properties.autoBridgeButton.setEnabled(true);
                    PortPropertiesDialogSanbox.this.properties.tlModeLabel.setEnabled(true);
                } else {
                    PortPropertiesDialogSanbox.this.properties.autoLearnButton.setEnabled(false);
                    PortPropertiesDialogSanbox.this.properties.autoBridgeButton.setEnabled(false);
                    PortPropertiesDialogSanbox.this.properties.tlModeLabel.setEnabled(false);
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        PortPropertiesDialogSanbox theDialog = null;

        public CancelButtonListener(PortPropertiesDialogSanbox portPropertiesDialogSanbox2) {
            this.theDialog = portPropertiesDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PortPropertiesDialogSanbox.this.unregisterForEvents();
            PortPropertiesDialogSanbox.this.properties.enableButtons();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        PortPropertiesDialogSanbox theDialog = null;

        public ApplyButtonListener(PortPropertiesDialogSanbox portPropertiesDialogSanbox2) {
            this.theDialog = portPropertiesDialogSanbox2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyPortProperties() == 1) {
                if (PortPropertiesDialogSanbox.this.waitingOnPortStateChange || PortPropertiesDialogSanbox.this.waitingOnPortModeChange || PortPropertiesDialogSanbox.this.waitingOnSavePending) {
                    PortPropertiesDialogSanbox.this.properties.disableButtons();
                } else {
                    PortPropertiesDialogSanbox.this.properties.enableButtons();
                    PortPropertiesDialogSanbox.this.unregisterForEvents();
                    this.theDialog.setVisible(false);
                }
            }
        }
    }
}

