/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.PortProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class InternalPortPropertiesDialogSwitchblade
extends QDialog {
    protected SanboxChassis blade = null;
    protected ChassisEventAdapter eventAdapter = null;
    protected Vector portList = null;
    protected JFrame frame = null;
    protected JPanel propertyPanel = null;
    protected JPanel buttonPanel = null;
    protected JPanel idPanel = null;
    protected JPanel portStatePanel = null;
    protected boolean waitingOnPortStateChange = false;
    protected boolean waitingOnRequestAdmin = false;
    protected boolean waitingOnReleaseAdmin = false;
    protected PortProperties properties = new PortProperties();

    public InternalPortPropertiesDialogSwitchblade(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis, Vector vector) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("PortPropertiesDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.blade = sanboxChassis;
        this.frame = jFrame;
        this.portList = vector;
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.propertyPanel = this.createPropertyPanel();
        this.buttonPanel = this.properties.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.internalPortPropertiesDialogSwitchbladeHelp"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.propertyPanel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.properties.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.updateRadioButtons();
    }

    public void resetDialog(SanboxChassis sanboxChassis, Vector vector) {
        this.unregisterForEvents();
        this.setEnabled(true);
        this.blade = sanboxChassis;
        this.portList = vector;
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.properties.resetIdPanel(this.blade, this.portList);
        this.updateRadioButtons();
    }

    protected JPanel createPropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.idPanel = this.properties.createIdPanel(this.blade, this.portList);
        this.portStatePanel = this.properties.createPortStatesPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.portStatePanel, gridBagConstraints);
        return jPanel;
    }

    protected void updateRadioButtons() {
        if (this.portList == null || this.portList.size() < 1) {
            return;
        }
        this.properties.updatePortStateButtons(this.portList);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.properties.setPortStateButtonsEnabled(bl);
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(210));
        return vector;
    }

    protected void registerForEvents() {
        this.eventAdapter.registerEventHandler(376, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(238, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(239, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(237, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(235, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(236, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(264, "receiveChassisEvent");
    }

    public void receiveChassisEvent(ChassisEvent chassisEvent) {
        if (!chassisEvent.isSuccessful()) {
            this.unregisterForEvents();
        }
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.unregisterForEvents();
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
        this.eventAdapter.unregisterEventHandler(376);
        this.eventAdapter.unregisterEventHandler(238);
        this.eventAdapter.unregisterEventHandler(239);
        this.eventAdapter.unregisterEventHandler(237);
        this.eventAdapter.unregisterEventHandler(235);
        this.eventAdapter.unregisterEventHandler(236);
        this.eventAdapter.unregisterEventHandler(264);
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyPortProperties() {
        this.waitingOnPortStateChange = false;
        this.waitingOnRequestAdmin = false;
        this.waitingOnReleaseAdmin = false;
        int n = 0;
        this.waitingOnPortStateChange = true;
        if (this.properties.onlineButton.isSelected()) {
            n = 1;
        } else if (this.properties.offlineButton.isSelected()) {
            n = 2;
        } else if (this.properties.testButton.isSelected()) {
            n = 3;
        }
        if (this.waitingOnPortStateChange) {
            this.registerForEvents();
            this.waitingOnRequestAdmin = true;
            ((Sanbox2Sml)this.blade).requestAdmin();
            ((Sanbox2Sml)this.blade).editConfig();
        }
        if (this.waitingOnPortStateChange) {
            int n2 = this.blade.getPortCount();
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                PortStates portStates = this.blade.getPort(n3).getPortStates();
                if (portStates != null) {
                    nArray[n3] = portStates.getActiveAdminState();
                    nArray2[n3] = portStates.getConfigPortType();
                }
                ++n3;
            }
            if (n != 0) {
                int n4 = this.portList.size();
                int n5 = 0;
                while (n5 < n4) {
                    FCPort fCPort = (FCPort)this.portList.elementAt(n5);
                    nArray[fCPort.getPortNumber()] = n;
                    ++n5;
                }
            }
            this.eventAdapter.registerEventHandler(376, "receiveChassisEvent");
            ((Sanbox2)this.blade).applyPortConfig(nArray, nArray2);
        }
        if (this.waitingOnPortStateChange) {
            this.waitingOnReleaseAdmin = true;
            ((Sanbox2)this.blade).saveConfig();
            ((Sanbox2Sml)this.blade).activateConfigAndReleaseAdmin();
        }
        return 1;
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        InternalPortPropertiesDialogSwitchblade dialog = null;

        public ApplyResponseHandler(InternalPortPropertiesDialogSwitchblade internalPortPropertiesDialogSwitchblade2, ChassisEvent chassisEvent) {
            this.dialog = internalPortPropertiesDialogSwitchblade2;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 238: {
                    InternalPortPropertiesDialogSwitchblade.this.waitingOnRequestAdmin = false;
                    if (this.evt.isSuccessful()) break;
                    InternalPortPropertiesDialogSwitchblade.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.adminFailed") + "\n" + InternalPortPropertiesDialogSwitchblade.this.getFailedString(this.evt.getErrorType()));
                    InternalPortPropertiesDialogSwitchblade.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    return;
                }
                case 239: {
                    InternalPortPropertiesDialogSwitchblade.this.waitingOnReleaseAdmin = false;
                    if (!this.evt.isSuccessful()) {
                        InternalPortPropertiesDialogSwitchblade.this.unregisterForEvents();
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.relAdminFailed") + "\n" + InternalPortPropertiesDialogSwitchblade.this.getFailedString(this.evt.getErrorType()));
                        InternalPortPropertiesDialogSwitchblade.this.properties.enableButtons();
                        this.dialog.setVisible(false);
                        break;
                    }
                    InternalPortPropertiesDialogSwitchblade.this.unregisterForEvents();
                    InternalPortPropertiesDialogSwitchblade.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    break;
                }
                case 237: {
                    if (this.evt.isSuccessful()) break;
                    InternalPortPropertiesDialogSwitchblade.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.editSwitchConfigFailed") + "\n" + InternalPortPropertiesDialogSwitchblade.this.getFailedString(this.evt.getErrorType()));
                    InternalPortPropertiesDialogSwitchblade.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    return;
                }
                case 235: {
                    if (this.evt.isSuccessful()) break;
                    InternalPortPropertiesDialogSwitchblade.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.saveSwitchConfigFailed") + "\n" + InternalPortPropertiesDialogSwitchblade.this.getFailedString(this.evt.getErrorType()));
                    InternalPortPropertiesDialogSwitchblade.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    return;
                }
                case 236: {
                    if (this.evt.isSuccessful()) break;
                    InternalPortPropertiesDialogSwitchblade.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.activateSwitchConfigFailed") + "\n" + InternalPortPropertiesDialogSwitchblade.this.getFailedString(this.evt.getErrorType()));
                    InternalPortPropertiesDialogSwitchblade.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    return;
                }
                case 264: {
                    InternalPortPropertiesDialogSwitchblade.this.waitingOnReleaseAdmin = false;
                    if (!this.evt.isSuccessful()) {
                        InternalPortPropertiesDialogSwitchblade.this.unregisterForEvents();
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.saveAndActivateSwitchConfigFailed") + "\n" + InternalPortPropertiesDialogSwitchblade.this.getFailedString(this.evt.getErrorType()));
                        InternalPortPropertiesDialogSwitchblade.this.properties.enableButtons();
                        this.dialog.setVisible(false);
                        return;
                    }
                    InternalPortPropertiesDialogSwitchblade.this.unregisterForEvents();
                    InternalPortPropertiesDialogSwitchblade.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(InternalPortPropertiesDialogSwitchblade.this.frame, InternalPortPropertiesDialogSwitchblade.this.blade, InternalPortPropertiesDialogSwitchblade.this.getEventList(), FabricTreeControl.getResource("PortPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 376: {
                    InternalPortPropertiesDialogSwitchblade.this.waitingOnPortStateChange = false;
                    if (this.evt.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.portStateError") + "\n" + InternalPortPropertiesDialogSwitchblade.this.getFailedString(this.evt.getErrorType()));
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        InternalPortPropertiesDialogSwitchblade theDialog = null;

        public CancelButtonListener(InternalPortPropertiesDialogSwitchblade internalPortPropertiesDialogSwitchblade2) {
            this.theDialog = internalPortPropertiesDialogSwitchblade2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InternalPortPropertiesDialogSwitchblade.this.unregisterForEvents();
            InternalPortPropertiesDialogSwitchblade.this.properties.enableButtons();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        InternalPortPropertiesDialogSwitchblade theDialog = null;

        public ApplyButtonListener(InternalPortPropertiesDialogSwitchblade internalPortPropertiesDialogSwitchblade2) {
            this.theDialog = internalPortPropertiesDialogSwitchblade2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyPortProperties() == 1) {
                if (InternalPortPropertiesDialogSwitchblade.this.waitingOnPortStateChange) {
                    InternalPortPropertiesDialogSwitchblade.this.properties.disableButtons();
                } else {
                    InternalPortPropertiesDialogSwitchblade.this.unregisterForEvents();
                    InternalPortPropertiesDialogSwitchblade.this.properties.enableButtons();
                    this.theDialog.setVisible(false);
                }
            }
        }
    }
}

