/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FirmwareFallbackDialogSanbox2
extends QDialog
implements ChassisEventListener {
    protected Sanbox2 blade = null;
    protected ChassisEventAdapter eventAdapter = null;
    protected JFrame frame = null;
    protected JPanel propertyPanel = null;
    protected JPanel buttonPanel = null;
    protected JPanel versionPanel = null;
    protected boolean waitingOnFirmwareFallback = false;
    protected boolean waitingOnRequestAdmin = false;
    protected boolean waitingOnReleaseAdmin = false;
    protected boolean fallbackCompleted = false;
    JLabel currentFirmwareLabel = new JLabel(FabricTreeControl.getResource("FirmwareFallback.currentFirmware"));
    JLabel fallbackFirmwareLabel = new JLabel(FabricTreeControl.getResource("FirmwareFallback.fallbackFirmware"));
    JLabel textLabel = new JLabel(FabricTreeControl.getResource("FirmwareFallback.text"));
    JTextField currentFirmwareContent = new JTextField();
    JTextField fallbackFirmwareContent = new JTextField();
    JButton applyButton = new JButton(FabricTreeControl.getResource("FirmwareFallback.applyButton"));
    JButton cancelButton = new JButton(FabricTreeControl.getResource("FirmwareFallback.cancelButton"));
    JLabel chassisNameLabel = new JLabel(FabricTreeControl.getResource("PortPropertiesDialog.chassisNameLabel"));
    JLabel chassisNameContent = new JLabel();

    public FirmwareFallbackDialogSanbox2(JFrame jFrame, boolean bl, Sanbox2 sanbox2) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("FirmwareFallback.title") + " - " + VendorProperties.getFrameTitle());
        this.blade = sanbox2;
        this.frame = jFrame;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        this.propertyPanel = this.createPropertyPanel();
        this.buttonPanel = this.createButtonPanel();
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.firmwareFallbackDialogSanbox2Help"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.propertyPanel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void resetDialog(Sanbox2 sanbox2) {
        this.blade.removeChassisEventListener((ChassisEventListener)this);
        this.enableButtons();
        this.waitingOnFirmwareFallback = false;
        this.waitingOnRequestAdmin = false;
        this.waitingOnReleaseAdmin = false;
        this.fallbackCompleted = false;
        this.blade = sanbox2;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        String string = this.blade.getFlashVersionString() + " [" + this.blade.getFlashTimestamp().toString() + "]";
        String string2 = this.blade.getInactiveFlashVersionString() + " [" + this.blade.getInactiveFlashTimestamp().toString() + "]";
        this.currentFirmwareContent.setText(string);
        this.fallbackFirmwareContent.setText(string2);
    }

    public JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        this.applyButton.addActionListener(new ApplyButtonListener(this));
        this.applyButton.setMnemonic('O');
        this.cancelButton.addActionListener(new CancelButtonListener(this));
        this.cancelButton.setMnemonic('C');
        jPanel.add(this.applyButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public JPanel createVersionPanel(Sanbox2 sanbox2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.currentFirmwareLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.currentFirmwareContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.fallbackFirmwareLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.fallbackFirmwareContent, gridBagConstraints);
        String string = sanbox2.getFlashVersionString() + " [" + sanbox2.getFlashTimestamp().toString() + "]";
        String string2 = sanbox2.getInactiveFlashVersionString() + " [" + sanbox2.getInactiveFlashTimestamp().toString() + "]";
        this.currentFirmwareContent.setText(string);
        this.currentFirmwareContent.setEditable(false);
        this.currentFirmwareContent.setBackground(Color.white);
        this.fallbackFirmwareContent.setText(string2);
        this.fallbackFirmwareContent.setEditable(false);
        this.fallbackFirmwareContent.setBackground(Color.white);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(20, 60, 10, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.textLabel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    protected JPanel createPropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.versionPanel = this.createVersionPanel(this.blade);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.versionPanel, gridBagConstraints);
        return jPanel;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.blade.removeChassisEventListener((ChassisEventListener)this);
            this.setVisible(false);
        }
    }

    public boolean fallbackCompleted() {
        return this.fallbackCompleted;
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    public void disableButtons() {
        this.applyButton.setEnabled(false);
    }

    public void enableButtons() {
        this.applyButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    protected int applyFirmwareFallback() {
        boolean bl;
        if (this.blade.getFirmwareVersion() != 2 && this.blade.getInactiveFirmwareVersion() == 2 && !(bl = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("FirmwareFallback.fallbackTo1.3.warning")))) {
            return -1;
        }
        this.waitingOnFirmwareFallback = true;
        this.waitingOnRequestAdmin = true;
        this.waitingOnReleaseAdmin = true;
        this.blade.requestAdmin();
        this.blade.applyFirmwareFallback();
        this.blade.releaseAdmin();
        return 1;
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        FirmwareFallbackDialogSanbox2 dialog = null;

        public ApplyResponseHandler(FirmwareFallbackDialogSanbox2 firmwareFallbackDialogSanbox22, ChassisEvent chassisEvent) {
            this.dialog = firmwareFallbackDialogSanbox22;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 238: {
                    if (!this.evt.isSuccessful()) {
                        FirmwareFallbackDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("FirmwareFallback.adminReqFailed") + "\n" + FirmwareFallbackDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        FirmwareFallbackDialogSanbox2.this.enableButtons();
                        this.dialog.setVisible(false);
                        break;
                    }
                    FirmwareFallbackDialogSanbox2.this.waitingOnRequestAdmin = false;
                    if (FirmwareFallbackDialogSanbox2.this.waitingOnFirmwareFallback || FirmwareFallbackDialogSanbox2.this.waitingOnReleaseAdmin) break;
                    FirmwareFallbackDialogSanbox2.this.enableButtons();
                    FirmwareFallbackDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    this.dialog.setVisible(false);
                    break;
                }
                case 239: {
                    if (!this.evt.isSuccessful()) {
                        FirmwareFallbackDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("FirmwareFallback.adminRelFailed") + "\n" + FirmwareFallbackDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        FirmwareFallbackDialogSanbox2.this.enableButtons();
                        this.dialog.setVisible(false);
                        break;
                    }
                    FirmwareFallbackDialogSanbox2.this.waitingOnReleaseAdmin = false;
                    FirmwareFallbackDialogSanbox2.this.enableButtons();
                    FirmwareFallbackDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    this.dialog.setVisible(false);
                    break;
                }
                case 347: {
                    FirmwareFallbackDialogSanbox2.this.waitingOnFirmwareFallback = false;
                    if (!this.evt.isSuccessful()) {
                        FirmwareFallbackDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("FirmwareFallback.failed") + "\n" + FirmwareFallbackDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        FirmwareFallbackDialogSanbox2.this.enableButtons();
                        this.dialog.setVisible(false);
                        break;
                    }
                    FirmwareFallbackDialogSanbox2.this.fallbackCompleted = true;
                    if (FirmwareFallbackDialogSanbox2.this.waitingOnReleaseAdmin) break;
                    FirmwareFallbackDialogSanbox2.this.enableButtons();
                    FirmwareFallbackDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    this.dialog.setVisible(false);
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        FirmwareFallbackDialogSanbox2 theDialog = null;

        public CancelButtonListener(FirmwareFallbackDialogSanbox2 firmwareFallbackDialogSanbox22) {
            this.theDialog = firmwareFallbackDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FirmwareFallbackDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.theDialog);
            FirmwareFallbackDialogSanbox2.this.enableButtons();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        FirmwareFallbackDialogSanbox2 theDialog = null;

        public ApplyButtonListener(FirmwareFallbackDialogSanbox2 firmwareFallbackDialogSanbox22) {
            this.theDialog = firmwareFallbackDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyFirmwareFallback() == 1) {
                if (FirmwareFallbackDialogSanbox2.this.waitingOnFirmwareFallback) {
                    FirmwareFallbackDialogSanbox2.this.disableButtons();
                } else {
                    FirmwareFallbackDialogSanbox2.this.enableButtons();
                }
            }
        }
    }
}

