/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.QColumnHeaderTextArea;
import com.qlogic.ui.QDialog;
import com.qlogic.ui.Spinner;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ExtCreditDialogSanbox2
extends QDialog {
    JButton applyButton = new JButton(FabricTreeControl.getResource("ExtCreditDialog.apply"));
    JButton cancelButton = new JButton(FabricTreeControl.getResource("ExtCreditDialog.cancel"));
    GridBagLayout idLayout = new GridBagLayout();
    JLabel wwNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.wwNameLabel"));
    JLabel wwNameContent = new JLabel();
    JLabel ipAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.ipAddrLabel"));
    JLabel ipAddrContent = new JLabel();
    JLabel fcAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.fcAddrLabel"));
    JLabel fcAddrContent = new JLabel();
    JLabel curChassisNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.chassisNameLabel"));
    JLabel curChassisNameContent = new JLabel();
    QColumnHeaderTextArea portNumberLabel = new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portNumber"));
    QColumnHeaderTextArea portModeLabel = new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.portMode"));
    QColumnHeaderTextArea extCreditsLabel = new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.reqExtCredits"));
    QColumnHeaderTextArea maxCreditsLabel = new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.maxCredits"));
    QColumnHeaderTextArea donatedToPortLabel = new QColumnHeaderTextArea(FabricTreeControl.getResource("ExtCreditDialog.donatedToPort"));
    JLabel creditPoolLabel = new JLabel(FabricTreeControl.getResource("ExtCreditDialog.creditPool"));
    JLabel note1Label = new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note1"));
    JLabel note2Label = new JLabel(FabricTreeControl.getResource("ExtCreditDialog.note2"));
    JLabel[] portNumberContent;
    JLabel[] portModeContent;
    JLabel[] maxCreditContent;
    JLabel[] donatedToPortContent;
    JLabel creditPoolContent = new JLabel();
    Spinner[] reqCreditSpinner;
    protected Sanbox2 blade = null;
    protected int portCount;
    protected ChassisEventAdapter eventAdapter = null;
    protected JFrame frame = null;
    protected JPanel donorPanel = null;
    protected JPanel buttonPanel = null;
    protected JPanel creditPoolPanel = null;
    protected JPanel idPanel = null;
    protected boolean waitingOnApply = false;
    protected boolean waitingOnAdmin = false;
    protected int errCount = 0;
    protected boolean errAlreadyDisplayed = false;
    protected int responseCount = 0;
    protected int creditPool = 0;
    protected int[] curExtCredits;
    protected int[] maxExtCredits;
    protected int[] minExtCredits;
    protected int[] beholdenPort;

    public ExtCreditDialogSanbox2(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("ExtCreditDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.blade = (Sanbox2)sanboxChassis;
        this.frame = jFrame;
        this.portCount = this.blade.getPortCount();
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.donorPanel = this.createDonorPanel();
        this.buttonPanel = this.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.extCreditDialogSanbox2Help"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.idPanel = this.createIdPanel(this.blade);
        this.getContentPane().add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = this.portCount + 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.donorPanel, gridBagConstraints);
        gridBagConstraints.gridy = this.portCount + 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.creditPoolPanel = this.createCreditPoolPanel();
        this.getContentPane().add((Component)this.creditPoolPanel, gridBagConstraints);
        gridBagConstraints.gridy = this.portCount + 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.pack();
        this.validate();
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    protected void initIdPanel() {
        this.fcAddrContent.setText(this.blade.delimitFCAddress());
        this.curChassisNameContent.setText(this.blade.getChassisName());
        this.wwNameContent.setText(this.blade.getWWName().delimit());
        IPInfo iPInfo = this.blade.getIpInfo();
        if (iPInfo != null) {
            this.ipAddrContent.setText(iPInfo.getIpAddress().getHostAddress());
        } else {
            this.ipAddrContent.setText("unknown");
        }
    }

    protected void initCreditPoolPanel() {
        this.creditPool = this.blade.getUnusedCreditPool();
        this.creditPoolContent.setText(Integer.toString(this.creditPool));
    }

    protected void initExtCreditPanel() {
        this.curExtCredits = new int[this.portCount];
        this.minExtCredits = new int[this.portCount];
        this.maxExtCredits = new int[this.portCount];
        this.beholdenPort = new int[this.portCount];
        int n = 0;
        while (n < this.portCount) {
            S16Port s16Port = (S16Port)this.blade.getPort(n);
            this.curExtCredits[n] = s16Port.getExtCredits();
            this.minExtCredits[n] = s16Port.getMinExtCredits();
            this.maxExtCredits[n] = s16Port.getMaxCredits();
            this.beholdenPort[n] = s16Port.getPortDonatedTo();
            String string = SbmUtilities.getPortConfigModeString(s16Port.getPortStates());
            if (string.equals("don")) {
                string = "Donor";
            }
            this.portModeContent[n].setText(string);
            this.reqCreditSpinner[n].setText(Integer.toString(this.curExtCredits[n]));
            this.setSpinnerEnables(n);
            this.maxCreditContent[n].setText(Integer.toString(this.maxExtCredits[n]));
            if (this.beholdenPort[n] >= 0) {
                this.donatedToPortContent[n].setText(Integer.toString(this.beholdenPort[n]));
            } else {
                this.donatedToPortContent[n].setText(FabricTreeControl.getResource("ExtCreditDialog.none"));
            }
            ++n;
        }
    }

    private void setSpinnerEnables(int n) {
        int n2 = Integer.parseInt(this.reqCreditSpinner[n].getText());
        S16Port s16Port = (S16Port)this.blade.getPort(n);
        this.reqCreditSpinner[n].downButtonSetEnabled(n2 > s16Port.getMinExtCredits());
        this.reqCreditSpinner[n].upButtonSetEnabled(n2 < s16Port.getMaxExtCredits());
    }

    public JPanel createButtonPanel(ActionListener actionListener, ActionListener actionListener2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        this.applyButton.addActionListener(actionListener);
        this.applyButton.setMnemonic('O');
        this.cancelButton.addActionListener(actionListener2);
        this.cancelButton.setMnemonic('C');
        jPanel.add(this.applyButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public JPanel createIdPanel(Sanbox2 sanbox2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = new JTextField().getFont().getSize();
        Font font = new Font("Dialog", 0, n);
        jPanel.setLayout(this.idLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        jPanel.add((Component)this.wwNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.wwNameContent.setFont(font);
        this.wwNameContent.setForeground(Color.black);
        jPanel.add((Component)this.wwNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.curChassisNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.curChassisNameContent.setFont(font);
        this.curChassisNameContent.setForeground(Color.black);
        jPanel.add((Component)this.curChassisNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.fcAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.fcAddrContent.setFont(font);
        this.fcAddrContent.setForeground(Color.black);
        jPanel.add((Component)this.fcAddrContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.ipAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.ipAddrContent.setFont(font);
        this.ipAddrContent.setForeground(Color.black);
        jPanel.add((Component)this.ipAddrContent, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setBackground(Color.white);
        this.initIdPanel();
        return jPanel;
    }

    protected JPanel createCreditPoolPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = new JTextField().getFont().getSize();
        Font font = new Font("Dialog", 0, n);
        Font font2 = new Font("Dialog", 1, n);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 40, 1, 2);
        jPanel.add((Component)this.creditPoolLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(1, 2, 1, 40);
        gridBagConstraints.anchor = 17;
        this.creditPoolContent.setFont(font);
        this.creditPoolContent.setForeground(Color.black);
        jPanel.add((Component)this.creditPoolContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 46, 1, 4);
        this.note1Label.setFont(font2);
        jPanel.add((Component)this.note1Label, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(1, 140, 1, 4);
        this.note2Label.setFont(font2);
        jPanel.add((Component)this.note2Label, gridBagConstraints);
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.initCreditPoolPanel();
        return jPanel;
    }

    protected JPanel createDonorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.portNumberContent = new JLabel[this.portCount];
        this.portModeContent = new JLabel[this.portCount];
        this.reqCreditSpinner = new Spinner[this.portCount];
        this.maxCreditContent = new JLabel[this.portCount];
        this.donatedToPortContent = new JLabel[this.portCount];
        int n = new JTextField().getFont().getSize();
        Font font = new Font("Dialog", 0, n);
        int n2 = 0;
        while (n2 < this.portCount) {
            this.portNumberContent[n2] = new JLabel(this.blade.getPort(n2).toString());
            this.portNumberContent[n2].setFont(font);
            this.portNumberContent[n2].setForeground(Color.black);
            this.portModeContent[n2] = new JLabel();
            this.portModeContent[n2].setFont(font);
            this.portModeContent[n2].setForeground(Color.black);
            this.reqCreditSpinner[n2] = new Spinner();
            this.reqCreditSpinner[n2].setUpArrowAction(this, "upArrowAction");
            this.reqCreditSpinner[n2].setDownArrowAction(this, "downArrowAction");
            this.maxCreditContent[n2] = new JLabel();
            this.maxCreditContent[n2].setFont(font);
            this.maxCreditContent[n2].setForeground(Color.black);
            this.donatedToPortContent[n2] = new JLabel();
            this.donatedToPortContent[n2].setFont(font);
            this.donatedToPortContent[n2].setForeground(Color.black);
            ++n2;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 7, 1, 7);
        jPanel.add((Component)this.portNumberLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.portModeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.extCreditsLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.maxCreditsLabel, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jPanel.add((Component)this.donatedToPortLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 20, 1, 20);
        if (this.blade.getChassisType() == 33 || this.blade.getChassisType() == 38) {
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)this.portNumberContent[0], gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)this.portModeContent[0], gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)this.reqCreditSpinner[0], gridBagConstraints);
            gridBagConstraints.gridx = 3;
            jPanel.add((Component)this.maxCreditContent[0], gridBagConstraints);
            gridBagConstraints.gridx = 4;
            jPanel.add((Component)this.donatedToPortContent[0], gridBagConstraints);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)this.portNumberContent[15], gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)this.portModeContent[15], gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)this.reqCreditSpinner[15], gridBagConstraints);
            gridBagConstraints.gridx = 3;
            jPanel.add((Component)this.maxCreditContent[15], gridBagConstraints);
            gridBagConstraints.gridx = 4;
            jPanel.add((Component)this.donatedToPortContent[15], gridBagConstraints);
            int n3 = 1;
            while (n3 < this.portCount - 1) {
                gridBagConstraints.gridy = n3 + 2;
                gridBagConstraints.gridx = 0;
                jPanel.add((Component)this.portNumberContent[n3], gridBagConstraints);
                gridBagConstraints.gridx = 1;
                jPanel.add((Component)this.portModeContent[n3], gridBagConstraints);
                gridBagConstraints.gridx = 2;
                jPanel.add((Component)this.reqCreditSpinner[n3], gridBagConstraints);
                gridBagConstraints.gridx = 3;
                jPanel.add((Component)this.maxCreditContent[n3], gridBagConstraints);
                gridBagConstraints.gridx = 4;
                jPanel.add((Component)this.donatedToPortContent[n3], gridBagConstraints);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < this.portCount) {
                gridBagConstraints.gridy = n4 + 1;
                gridBagConstraints.gridx = 0;
                jPanel.add((Component)this.portNumberContent[n4], gridBagConstraints);
                gridBagConstraints.gridx = 1;
                jPanel.add((Component)this.portModeContent[n4], gridBagConstraints);
                gridBagConstraints.gridx = 2;
                jPanel.add((Component)this.reqCreditSpinner[n4], gridBagConstraints);
                gridBagConstraints.gridx = 3;
                jPanel.add((Component)this.maxCreditContent[n4], gridBagConstraints);
                gridBagConstraints.gridx = 4;
                jPanel.add((Component)this.donatedToPortContent[n4], gridBagConstraints);
                ++n4;
            }
        }
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.initExtCreditPanel();
        return jPanel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(288));
        return vector;
    }

    protected void registerForEvents() {
        this.eventAdapter.registerEventHandler(287, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(238, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(239, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(237, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(264, "receiveChassisEvent");
    }

    public void receiveChassisEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.unregisterForEvents();
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
        this.eventAdapter.unregisterEventHandler(287);
        this.eventAdapter.unregisterEventHandler(238);
        this.eventAdapter.unregisterEventHandler(239);
        this.eventAdapter.unregisterEventHandler(237);
        this.eventAdapter.unregisterEventHandler(264);
    }

    public void disableButtons() {
        this.applyButton.setEnabled(false);
    }

    public void enableButtons() {
        this.applyButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyExtCreditRequests() {
        this.waitingOnApply = true;
        this.waitingOnAdmin = true;
        this.errAlreadyDisplayed = false;
        this.responseCount = 0;
        this.errCount = 0;
        this.registerForEvents();
        this.blade.requestAdmin();
        this.blade.editConfig();
        int n = 0;
        while (n < this.portCount) {
            String string = this.reqCreditSpinner[n].getText();
            int n2 = 0;
            try {
                n2 = Integer.decode(string);
                this.blade.applyExtCredit(n, n2);
            }
            catch (Exception exception) {
                System.err.println("Non-integer value found in requested extended credit column");
                this.waitingOnApply = false;
                ((Sanbox2Sml)this.blade).releaseAdmin();
                return -1;
            }
            ++n;
        }
        this.blade.saveConfig();
        this.blade.activateConfigAndReleaseAdmin(20000, 3000);
        return 1;
    }

    private int getPortIndexOfSpinner(Spinner spinner) {
        int n = 0;
        while (n < this.portCount) {
            if (spinner.equals(this.reqCreditSpinner[n])) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public void upArrowAction(Spinner spinner) {
        block3: {
            int n = this.getPortIndexOfSpinner(spinner);
            S16Port s16Port = (S16Port)this.blade.getPort(n);
            String string = spinner.getText();
            if (string == null) break block3;
            try {
                int n2 = Integer.decode(string);
                if (n2 <= s16Port.getMaxExtCredits() - 11) {
                    spinner.setText(Integer.toString(n2 += 11));
                    this.setSpinnerEnables(n);
                    break block3;
                }
                n2 = s16Port.getMaxExtCredits();
                spinner.setText(Integer.toString(n2));
                this.setSpinnerEnables(n);
            }
            catch (Exception exception) {}
        }
    }

    public void downArrowAction(Spinner spinner) {
        block3: {
            int n = this.getPortIndexOfSpinner(spinner);
            S16Port s16Port = (S16Port)this.blade.getPort(n);
            String string = spinner.getText();
            if (string == null) break block3;
            try {
                int n2 = Integer.decode(string);
                if (n2 >= s16Port.getMinExtCredits() - 11) {
                    spinner.setText(Integer.toString(n2 -= 11));
                    this.setSpinnerEnables(n);
                    break block3;
                }
                n2 = s16Port.getMinExtCredits();
                spinner.setText(Integer.toString(n2));
                this.setSpinnerEnables(n);
            }
            catch (Exception exception) {}
        }
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        ExtCreditDialogSanbox2 dialog = null;

        public ApplyResponseHandler(ExtCreditDialogSanbox2 extCreditDialogSanbox22, ChassisEvent chassisEvent) {
            this.dialog = extCreditDialogSanbox22;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 287: {
                    ++ExtCreditDialogSanbox2.this.responseCount;
                    if (!this.evt.isSuccessful()) {
                        ++ExtCreditDialogSanbox2.this.errCount;
                    }
                    if (ExtCreditDialogSanbox2.this.responseCount != ExtCreditDialogSanbox2.this.portCount) break;
                    if (ExtCreditDialogSanbox2.this.errCount > 0) {
                        ExtCreditDialogSanbox2.this.errAlreadyDisplayed = true;
                        String string = FabricTreeControl.getResource("ExtCreditDialog.error.applyRequestFailed") + " on " + Integer.toString(ExtCreditDialogSanbox2.this.errCount) + " ports.\n" + ExtCreditDialogSanbox2.this.getFailedString(this.evt.getErrorType());
                        PopupDialog.showDialog(this.dialog, 3, string);
                    }
                    ExtCreditDialogSanbox2.this.waitingOnApply = false;
                    break;
                }
                case 238: {
                    ExtCreditDialogSanbox2.this.waitingOnAdmin = false;
                    if (this.evt.isSuccessful()) break;
                    ExtCreditDialogSanbox2.this.unregisterForEvents();
                    ExtCreditDialogSanbox2.this.errAlreadyDisplayed = true;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("ExtCreditDialog.error.adminReqFailed") + "\n" + ExtCreditDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    ExtCreditDialogSanbox2.this.enableButtons();
                    this.dialog.setVisible(false);
                    break;
                }
                case 264: {
                    if (!this.evt.isSuccessful() && !ExtCreditDialogSanbox2.this.errAlreadyDisplayed) {
                        ExtCreditDialogSanbox2.this.unregisterForEvents();
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("ExtCreditDialog.error.saveAndActivateConfigFailed") + "\n" + ExtCreditDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        ExtCreditDialogSanbox2.this.errAlreadyDisplayed = true;
                        ExtCreditDialogSanbox2.this.enableButtons();
                        this.dialog.setVisible(false);
                    }
                    if (ExtCreditDialogSanbox2.this.waitingOnApply) break;
                    ExtCreditDialogSanbox2.this.unregisterForEvents();
                    ExtCreditDialogSanbox2.this.enableButtons();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(ExtCreditDialogSanbox2.this.frame, (SanboxChassis)ExtCreditDialogSanbox2.this.blade, ExtCreditDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("ExtCreditDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 237: {
                    if (this.evt.isSuccessful() || ExtCreditDialogSanbox2.this.errAlreadyDisplayed) break;
                    ExtCreditDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("ExtCreditDialog.error.editConfigFailed") + "\n" + ExtCreditDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    ExtCreditDialogSanbox2.this.errAlreadyDisplayed = true;
                    ExtCreditDialogSanbox2.this.enableButtons();
                    this.dialog.setVisible(false);
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        ExtCreditDialogSanbox2 theDialog = null;

        public CancelButtonListener(ExtCreditDialogSanbox2 extCreditDialogSanbox22) {
            this.theDialog = extCreditDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExtCreditDialogSanbox2.this.enableButtons();
            ExtCreditDialogSanbox2.this.unregisterForEvents();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        ExtCreditDialogSanbox2 theDialog = null;

        public ApplyButtonListener(ExtCreditDialogSanbox2 extCreditDialogSanbox22) {
            this.theDialog = extCreditDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyExtCreditRequests() == 1) {
                if (ExtCreditDialogSanbox2.this.waitingOnApply || ExtCreditDialogSanbox2.this.waitingOnAdmin) {
                    ExtCreditDialogSanbox2.this.disableButtons();
                }
            } else {
                ExtCreditDialogSanbox2.this.unregisterForEvents();
                ExtCreditDialogSanbox2.this.enableButtons();
            }
        }
    }
}

