/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.DateTimeDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DateTimeDialogSanbox2
extends DateTimeDialog
implements ChassisEventListener {
    protected JFrame frame;
    protected Sanbox2 blade = null;
    protected ChassisEventAdapter eventAdapter = null;
    protected boolean waitingOnDateTimeChange = false;
    protected boolean waitingOnRequestAdmin = false;
    protected boolean waitingOnReleaseAdmin = false;
    protected boolean dateTimeChangeCompleted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateTimeDialogSanbox2(JFrame jFrame, boolean bl, Sanbox2 sanbox2) {
        super((Frame)jFrame, bl);
        this.frame = jFrame;
        this.setTitle(this.getTitle() + " - " + VendorProperties.getFrameTitle());
        this.blade = sanbox2;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        this.blade.updateDateTime();
        try {
            DateTimeDialogSanbox2 dateTimeDialogSanbox2 = this;
            synchronized (dateTimeDialogSanbox2) {
                this.wait(1250L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parseDateTime(this.blade.getDateTime());
        this.fillControls();
    }

    protected void parseDateTime(String string) {
        if (string.equals("Unknown") || string.length() != 12) {
            this.AM = false;
            this.month = 1;
            this.day = 1;
            this.year = 0;
            this.hour = 12;
            this.min = 0;
            return;
        }
        String string2 = string.substring(0, 2);
        String string3 = string.substring(2, 4);
        String string4 = string.substring(4, 6);
        String string5 = string.substring(6, 8);
        String string6 = string.substring(8);
        try {
            this.month = Integer.parseInt(string2);
            this.day = Integer.parseInt(string3);
            this.hour = Integer.parseInt(string4);
            boolean bl = this.AM = this.hour < 12;
            if (this.hour > 12) {
                this.hour -= 12;
            } else if (this.hour == 0) {
                this.hour = 12;
            }
            this.min = Integer.parseInt(string5);
            this.year = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {
            this.AM = false;
            this.month = 1;
            this.day = 1;
            this.year = 0;
            this.hour = 12;
            this.min = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDialog(Sanbox2 sanbox2) {
        this.enableButtons();
        this.blade.removeChassisEventListener((ChassisEventListener)this);
        this.waitingOnDateTimeChange = false;
        this.waitingOnRequestAdmin = false;
        this.waitingOnReleaseAdmin = false;
        this.dateTimeChangeCompleted = false;
        this.blade = sanbox2;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        this.blade.updateDateTime();
        try {
            DateTimeDialogSanbox2 dateTimeDialogSanbox2 = this;
            synchronized (dateTimeDialogSanbox2) {
                this.wait(1250L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parseDateTime(this.blade.getDateTime());
        this.fillControls();
    }

    protected void closeDownDialog() {
        this.blade.removeChassisEventListener((ChassisEventListener)this);
        super.closeDownDialog();
    }

    public boolean isDateTimeChangeCompleted() {
        return this.dateTimeChangeCompleted;
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected boolean applyDateTime() {
        if (!this.getDateTimeFromControls()) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.month < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toString(this.month));
        if (this.day < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toString(this.day));
        if (this.hour == 12 && this.AM) {
            this.hour = 0;
        }
        if (this.hour < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toString(this.hour));
        if (this.min < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toString(this.min));
        stringBuffer.append(Integer.toString(this.year));
        this.newDateTime = stringBuffer.toString();
        this.waitingOnDateTimeChange = true;
        this.waitingOnRequestAdmin = true;
        this.waitingOnReleaseAdmin = true;
        this.blade.requestAdmin();
        this.blade.applyDateTime(this.newDateTime);
        this.blade.releaseAdmin();
        return true;
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(350));
        return vector;
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        DateTimeDialogSanbox2 dialog = null;

        public ApplyResponseHandler(DateTimeDialogSanbox2 dateTimeDialogSanbox22, ChassisEvent chassisEvent) {
            this.dialog = dateTimeDialogSanbox22;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 238: {
                    DateTimeDialogSanbox2.this.waitingOnRequestAdmin = false;
                    if (!this.evt.isSuccessful()) {
                        DateTimeDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("DateTimeDialog.adminReqFailed") + "\n" + DateTimeDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        DateTimeDialogSanbox2.this.enableButtons();
                        this.dialog.setVisible(false);
                        break;
                    }
                    if (DateTimeDialogSanbox2.this.waitingOnDateTimeChange || DateTimeDialogSanbox2.this.waitingOnReleaseAdmin) break;
                    DateTimeDialogSanbox2.this.enableButtons();
                    DateTimeDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    this.dialog.setVisible(false);
                    break;
                }
                case 239: {
                    DateTimeDialogSanbox2.this.waitingOnReleaseAdmin = false;
                    if (!this.evt.isSuccessful()) {
                        DateTimeDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("DateTimeDialog.adminRelFailed") + "\n" + DateTimeDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        DateTimeDialogSanbox2.this.enableButtons();
                        this.dialog.setVisible(false);
                        break;
                    }
                    DateTimeDialogSanbox2.this.enableButtons();
                    if (!DateTimeDialogSanbox2.this.waitingOnDateTimeChange) {
                        DateTimeDialogSanbox2.this.dateTimeChangeCompleted = true;
                    }
                    DateTimeDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(DateTimeDialogSanbox2.this.frame, (SanboxChassis)DateTimeDialogSanbox2.this.blade, DateTimeDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("DateTimeDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 351: {
                    DateTimeDialogSanbox2.this.waitingOnDateTimeChange = false;
                    if (!this.evt.isSuccessful()) {
                        DateTimeDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("DateTimeDialog.failed") + "\n" + DateTimeDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        DateTimeDialogSanbox2.this.enableButtons();
                        this.dialog.setVisible(false);
                        break;
                    }
                    DateTimeDialogSanbox2.this.dateTimeChangeCompleted = true;
                    if (DateTimeDialogSanbox2.this.waitingOnReleaseAdmin) break;
                    DateTimeDialogSanbox2.this.enableButtons();
                    DateTimeDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.dialog);
                    this.dialog.setVisible(false);
                }
            }
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        DateTimeDialogSanbox2 theDialog = null;

        public ApplyButtonListener(DateTimeDialogSanbox2 dateTimeDialogSanbox22) {
            this.theDialog = dateTimeDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyDateTime()) {
                DateTimeDialogSanbox2.this.disableButtons();
            }
        }
    }
}

