/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class TrapLogPanel
extends JPanel
implements ChassisEventListener {
    JTextArea textArea = new JTextArea();
    Sanbox sanbox = null;

    public TrapLogPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.textArea.setVisible(true);
        this.textArea.setEditable(false);
        this.add(new JScrollPane(this.textArea));
    }

    public void setSelectedSwitch(Chassis chassis) {
        if (this.sanbox != null) {
            this.sanbox.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
        }
        if (chassis instanceof Sanbox) {
            this.sanbox = (Sanbox)chassis;
            this.sanbox.getEventHandler().addChassisEventListener((ChassisEventListener)this);
            SwingUtilities.invokeLater(new RepaintClass());
        } else {
            this.sanbox = null;
        }
    }

    private void fillLog() {
        if (this.sanbox == null) {
            return;
        }
        String string = this.sanbox.getChassisName() + "\n";
        if (!(string = string + this.sanbox.decodeLog()).equals(this.textArea.getText())) {
            this.textArea.setText(string);
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getEventType() == 274) {
            SwingUtilities.invokeLater(new RepaintClass());
        }
    }

    class RepaintClass
    implements Runnable {
        RepaintClass() {
        }

        public void run() {
            TrapLogPanel.this.fillLog();
            TrapLogPanel.this.repaint();
        }
    }
}

