/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCDiscovery;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricLink;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ComAgentEvent;
import com.qlogic.device.fcfabric.event.ComAgentEventListener;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.device.fcfabric.event.FabricListEvent;
import com.qlogic.device.fcfabric.event.FabricListEventListener;
import com.qlogic.qms.fabric.FabricTopologyLink;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.FcSwitchRenderer;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.SwitchLinkRenderer;
import com.qlogic.qms.fabric.TopologyTabPanel;
import com.qlogic.qms.fabric.UnmanageableSw_Renderer;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.DialogCreateException;
import com.qlogic.qms.fabric.propertyDialogs.NetworkPropertiesDialogSanbox;
import com.qlogic.qms.fabric.propertyDialogs.NetworkPropertiesDialogSanbox2;
import com.qlogic.qms.fabric.propertyDialogs.SwitchPropertiesDialogSanbox;
import com.qlogic.qms.fabric.propertyDialogs.SwitchPropertiesDialogSanbox2;
import com.qlogic.ui.Topology;
import com.qlogic.ui.topology.TopologyMenuManager;
import com.qlogic.ui.topology.TopologyNode;
import com.qlogic.ui.topology.TopologyRingLayout;
import com.qlogic.ui.topology.TopologySelectionEvent;
import com.qlogic.ui.topology.TopologySelectionListener;
import com.qlogic.ui.topology.TopologySelectionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class TopologyPanel
extends JPanel
implements FabricEventListener,
ChassisEventListener,
TopologySelectionListener,
ActionListener,
FabricListEventListener,
ComAgentEventListener {
    private Fabric fabric;
    private Topology topology;
    private static Hashtable topologyHashTable = new Hashtable();
    private static Vector chassisPosList = new Vector();
    private JSplitPane splitPane = new JSplitPane();
    private TopologyTabPanel topologyTabPanel = null;
    private JMenuItem deleteMenuItem;
    private JMenuItem switchPropertiesMenuItem;
    private JMenuItem networkPropertiesMenuItem;
    private JMenuItem exportNameServerMenuItem;
    private JMenuItem layoutTopologyMenuItem;
    private JCheckBoxMenuItem autoLayoutToggleItem;
    private JCheckBoxMenuItem viewNameServerInfoItem;
    private JMenuItem saveLayoutTopologyMenuItem;
    protected SwitchPropertiesDialogSanbox2 switchPropertiesDialogSB2 = null;
    protected SwitchPropertiesDialogSanbox switchPropertiesDialogSB = null;
    protected NetworkPropertiesDialogSanbox2 networkPropertiesDialogSB2 = null;
    protected NetworkPropertiesDialogSanbox networkPropertiesDialogSB = null;
    static /* synthetic */ Class class$com$qlogic$device$fcfabric$Chassis;
    static /* synthetic */ Class class$com$qlogic$qms$fabric$FabricTopologyLink;

    public TopologyPanel(Fabric fabric) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setFabric(fabric);
        this.splitPane.setOrientation(0);
        FabricList.getInstance().addEventListener((FabricListEventListener)this);
    }

    private void layoutTopology() {
        if (this.topology.isAutoLayoutEnabled()) {
            this.topology.layoutAllNodes();
        } else {
            this.restoreLayout();
        }
    }

    private void restoreLayout() {
        if (this.fabric != null) {
            Chassis chassis = this.fabric.getFirstSwitch();
            while (chassis != null) {
                TopologyNode topologyNode = this.topology.getTopologyNode(chassis);
                if (topologyNode != null) {
                    Point point = TopologyPanel.getChassisPos(this.fabric.getName(), chassis.getWWName());
                    if (point != null) {
                        this.topology.layoutNodeAt(topologyNode, point.x, point.y);
                    } else {
                        this.topology.layoutNode(topologyNode);
                    }
                }
                chassis = this.fabric.getNextSwitch(chassis);
            }
        }
    }

    private void saveLayout() {
        if (this.fabric != null) {
            Chassis chassis = this.fabric.getFirstSwitch();
            while (chassis != null) {
                TopologyNode topologyNode = this.topology.getTopologyNode(chassis);
                if (topologyNode != null) {
                    TopologyPanel.saveChassisPos(this.fabric.getName(), chassis.getWWName(), topologyNode.getX(), topologyNode.getY());
                }
                chassis = this.fabric.getNextSwitch(chassis);
            }
        }
    }

    public static void saveChassisPos(String string, WorldWideName worldWideName, int n, int n2) {
        Point point = TopologyPanel.getChassisPos(string, worldWideName);
        if (point != null) {
            point.x = n;
            point.y = n2;
        } else {
            chassisPosList.add(new ChassisPos(string, worldWideName, n, n2));
        }
    }

    private static Point getChassisPos(String string, WorldWideName worldWideName) {
        int n = 0;
        while (n < chassisPosList.size()) {
            ChassisPos chassisPos = (ChassisPos)chassisPosList.elementAt(n);
            if (chassisPos.fabName.equals(string) && chassisPos.wwn.equals((Object)worldWideName)) {
                return chassisPos.pos;
            }
            ++n;
        }
        return null;
    }

    public static Point getPos(Chassis chassis, Fabric fabric) {
        TopologyNode topologyNode;
        Topology topology = (Topology)topologyHashTable.get(fabric);
        if (topology != null && (topologyNode = topology.getTopologyNode(chassis)) != null) {
            return new Point(topologyNode.getX(), topologyNode.getY());
        }
        return null;
    }

    public Topology getCurrentTopology() {
        return this.topology;
    }

    public int getSplitPaneDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    public int getSplitPaneWidth() {
        return this.splitPane.getWidth();
    }

    public int getSplitPaneHeight() {
        return this.splitPane.getHeight();
    }

    public Fabric getCurrentFabric() {
        return this.fabric;
    }

    public void setFabric(Fabric fabric) {
        TopologySelectionModel topologySelectionModel;
        Chassis chassis;
        if (this.fabric != null) {
            chassis = this.fabric.getFirstSwitch();
            while (chassis != null) {
                chassis.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
                chassis = this.fabric.getNextSwitch(chassis);
            }
            if (this.topology != null) {
                topologySelectionModel = this.topology.getSelectionModel();
                topologySelectionModel.removeSelectionListener(this);
            }
        }
        this.fabric = fabric;
        this.topologyTabPanel.setComAgent(this.fabric.getComAgent());
        this.topologyTabPanel.setFabric(this.fabric);
        this.topology = (Topology)topologyHashTable.get(this.fabric);
        if (this.topology == null) {
            this.fabric.addEventListener((FabricEventListener)this);
            this.fabric.getComAgent().addComAgentListener((ComAgentEventListener)this);
            chassis = this.fabric.getFirstSwitch();
            while (chassis != null) {
                this.addSwitch(chassis);
                chassis = this.fabric.getNextSwitch(chassis);
            }
            topologySelectionModel = this.fabric.getFirstLink();
            while (topologySelectionModel != null) {
                this.addLink(topologySelectionModel);
                topologySelectionModel = this.fabric.getNextLink((FabricLink)topologySelectionModel);
            }
            this.topology = new Topology();
            this.topology.setToolTipText(FabricTreeControl.getResource("TopologyPanel.topology"));
            topologyHashTable.put(this.fabric, this.topology);
            this.topology.setTopologyLinkRenderer(new SwitchLinkRenderer(this.topology));
            this.topology.setDefaultRenderer(class$com$qlogic$device$fcfabric$Chassis == null ? (class$com$qlogic$device$fcfabric$Chassis = TopologyPanel.class$("com.qlogic.device.fcfabric.Chassis")) : class$com$qlogic$device$fcfabric$Chassis, new UnmanageableSw_Renderer());
            this.topology.setDefaultMenuManager(class$com$qlogic$device$fcfabric$Chassis == null ? (class$com$qlogic$device$fcfabric$Chassis = TopologyPanel.class$("com.qlogic.device.fcfabric.Chassis")) : class$com$qlogic$device$fcfabric$Chassis, new FcSwitchMenuManager());
            this.topology.setDefaultMenuManager(class$com$qlogic$qms$fabric$FabricTopologyLink == null ? (class$com$qlogic$qms$fabric$FabricTopologyLink = TopologyPanel.class$("com.qlogic.qms.fabric.FabricTopologyLink")) : class$com$qlogic$qms$fabric$FabricTopologyLink, new FcLinkMenuManager());
            this.topology.setBackgroundMenuManager(new BackgroundMenuManager());
            this.topology.setTopologyLayout(new TopologyRingLayout(this.topology));
            this.topology.setSnapToPosition(false);
            this.topology.setAutoLayout(true);
        } else {
            chassis = this.fabric.getFirstSwitch();
            while (chassis != null) {
                chassis.getEventHandler().addChassisEventListener((ChassisEventListener)this);
                chassis = this.fabric.getNextSwitch(chassis);
            }
        }
        this.splitPane.setTopComponent(new JScrollPane(this.topology));
        int n = this.splitPane.getDividerLocation();
        if (n <= 0) {
            this.splitPane.setDividerLocation(0.5);
        } else {
            this.splitPane.setDividerLocation(n);
        }
        topologySelectionModel = this.topology.getSelectionModel();
        topologySelectionModel.addSelectionListener(this);
        this.setTabPanelSelection();
        this.splitPane.resetToPreferredSizes();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopologyPanel.this.autoLayoutToggleItem.setSelected(TopologyPanel.this.topology.isAutoLayoutEnabled());
                TopologyPanel.this.viewNameServerInfoItem.setSelected(FcSwitchRenderer.getViewNameServerInfo());
            }
        });
    }

    private void jbInit() throws Exception {
        this.topologyTabPanel = new TopologyTabPanel(null, null, null);
        this.setToolTipText(FabricTreeControl.getResource("TopologyPanel.topologyPanel"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setBottomComponent(this.topologyTabPanel);
        this.splitPane.setDividerLocation(0.5);
        this.deleteMenuItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.delete"));
        this.deleteMenuItem.addActionListener(this);
        this.deleteMenuItem.setMnemonic('D');
        this.switchPropertiesMenuItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.switchProperties"));
        this.switchPropertiesMenuItem.addActionListener(this);
        this.switchPropertiesMenuItem.setMnemonic('P');
        this.networkPropertiesMenuItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.networkProperties"));
        this.networkPropertiesMenuItem.addActionListener(this);
        this.networkPropertiesMenuItem.setMnemonic('N');
        this.exportNameServerMenuItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.exportNameServer"));
        this.exportNameServerMenuItem.addActionListener(this);
        this.exportNameServerMenuItem.setMnemonic('E');
        this.layoutTopologyMenuItem = new JMenuItem(FabricTreeControl.getResource("menu.view.layoutTopology"));
        this.layoutTopologyMenuItem.addActionListener(this);
        this.layoutTopologyMenuItem.setMnemonic('L');
        this.autoLayoutToggleItem = new JCheckBoxMenuItem(FabricTreeControl.getResource("TopologyPanel.toggleAutoLayout"));
        this.autoLayoutToggleItem.setSelected(false);
        this.autoLayoutToggleItem.addActionListener(this);
        this.autoLayoutToggleItem.setMnemonic('A');
        this.viewNameServerInfoItem = new JCheckBoxMenuItem(FabricTreeControl.getResource("TopologyPanel.viewNameServerInfo"));
        this.viewNameServerInfoItem.setSelected(false);
        this.viewNameServerInfoItem.addActionListener(this);
        this.viewNameServerInfoItem.setMnemonic('A');
        this.saveLayoutTopologyMenuItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.saveLayout"));
        this.saveLayoutTopologyMenuItem.addActionListener(this);
        this.saveLayoutTopologyMenuItem.setMnemonic('M');
        this.switchPropertiesMenuItem.setEnabled(false);
        this.networkPropertiesMenuItem.setEnabled(false);
        this.deleteMenuItem.setEnabled(false);
    }

    public Hashtable getTopologyHashtable() {
        return topologyHashTable;
    }

    public Vector getToolBarExtension() {
        Vector vector = new Vector();
        return vector;
    }

    private boolean isSwitchEditable(Chassis chassis) {
        return chassis.getComAgent().getLoginInfo().getLevel() == 2 || chassis.getComAgent().getLoginInfo().getLevel() == 0 || chassis.getComAgent().getLoginInfo().getLevel() == 3;
    }

    public Vector getMenuBarExtension() {
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        boolean bl = false;
        if (this.topology.getSelectionCount() == 1 && (object2 = this.topology.getSelection()) instanceof SanboxChassis) {
            object = (Chassis)object2;
            bl = this.isSwitchEditable((Chassis)object);
        }
        object2 = new JMenu(FabricTreeControl.getResource("TopologyPanel.switch"));
        ((JMenu)object2).add(this.deleteMenuItem);
        ((JMenu)object2).add(this.exportNameServerMenuItem);
        ((AbstractButton)object2).setMnemonic('S');
        if (bl) {
            ((JMenu)object2).add(this.switchPropertiesMenuItem);
            ((JMenu)object2).add(this.networkPropertiesMenuItem);
        }
        vector.add(object2);
        object = new JMenu(FabricTreeControl.getResource("menu.view"));
        ((AbstractButton)object).setMnemonic('V');
        ((JMenu)object).add(this.layoutTopologyMenuItem);
        ((JMenu)object).add(this.autoLayoutToggleItem);
        ((JMenu)object).add(this.saveLayoutTopologyMenuItem);
        vector.add(object);
        return vector;
    }

    private void setMenuEnable() {
        Object object;
        boolean bl = false;
        if (this.topology.getSelectionCount() == 1 && (object = this.topology.getSelection()) instanceof Chassis) {
            bl = true;
        }
        this.switchPropertiesMenuItem.setEnabled(bl);
        this.networkPropertiesMenuItem.setEnabled(bl);
        this.exportNameServerMenuItem.setEnabled(true);
        this.deleteMenuItem.setEnabled(this.topology.getSelectionCount() > 0);
    }

    public void selectionChanged(TopologySelectionEvent topologySelectionEvent) {
        switch (topologySelectionEvent.getType()) {
            case 1: 
            case 2: 
            case 3: {
                this.setTabPanelSelection();
            }
        }
        this.setMenuEnable();
    }

    private void setTabPanelSelection() {
        Object object;
        Vector vector = this.topology.getSelectionModel().getSelectionList();
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            object = vector.elementAt(n);
            if (object instanceof TopologyNode) {
                TopologyNode topologyNode = (TopologyNode)object;
                object = topologyNode.getObject();
            }
            if (object instanceof Chassis) {
                vector2.add(object);
            }
            ++n;
        }
        if (vector2.size() == 0) {
            object = this.fabric.getFirstSwitch();
            while (object != null) {
                vector2.add(object);
                object = this.fabric.getNextSwitch(object);
            }
        }
        this.topologyTabPanel.setSelectedSwitches(vector2);
        object = new Vector();
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e = vector.elementAt(n2);
            if (e instanceof FabricTopologyLink) {
                ((Vector)object).add(((FabricTopologyLink)e).fabricLink);
            }
            ++n2;
        }
        if (((Vector)object).size() == 0) {
            this.topologyTabPanel.setSelectedLinks(this.fabric.getLinks());
        } else {
            this.topologyTabPanel.setSelectedLinks((Vector)object);
        }
        this.topologyTabPanel.setComAgent(this.fabric.getComAgent());
    }

    public void refresh() {
        this.fabric.refresh();
    }

    public void addSwitch(Object object) {
        if (object instanceof Chassis) {
            Chassis chassis = (Chassis)object;
            chassis.getEventHandler().addChassisEventListener((ChassisEventListener)this);
        }
        SwingUtilities.invokeLater(new AddSwitchClass(object));
    }

    public void addLink(Object object) {
        SwingUtilities.invokeLater(new AddLinkClass(object));
    }

    public void removeLink(Object object) {
        SwingUtilities.invokeLater(new RemoveLinkClass(object));
    }

    public void removeSwitch(Fabric fabric, Chassis chassis) {
        SwingUtilities.invokeLater(new RemoveSwitchClass(fabric, chassis));
    }

    public void receiveEvent(ComAgentEvent comAgentEvent) {
        if (comAgentEvent.getEventType() == 4) {
            this.repaint();
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (this.isVisible()) {
            int n = chassisEvent.getEventType();
            switch (n) {
                case 200: 
                case 208: 
                case 213: 
                case 219: 
                case 232: 
                case 243: 
                case 253: {
                    this.repaint();
                }
            }
        }
    }

    public void receiveEvent(FabricEvent fabricEvent) {
        switch (fabricEvent.getEventType()) {
            case 2018: {
                this.rediscoveryFailed(((FCDiscovery)fabricEvent.getValue()).getErrorCode());
                break;
            }
            case 2002: {
                this.topologyTabPanel.setComAgent(this.fabric.getComAgent());
                Object object = fabricEvent.getValue();
                if (object == null) break;
                this.addSwitch(object);
                break;
            }
            case 2003: {
                Object object = fabricEvent.getValue();
                if (object == null || !(object instanceof Chassis)) break;
                this.removeSwitch(fabricEvent.getFabric(), (Chassis)object);
                break;
            }
            case 2001: {
                break;
            }
            case 2004: {
                Object object = fabricEvent.getValue();
                if (object == null || !(object instanceof FabricLink)) break;
                this.addLink(object);
                break;
            }
            case 2005: {
                this.removeLink(fabricEvent);
                break;
            }
            case 2006: {
                this.repaint();
                break;
            }
        }
    }

    public void receiveEvent(FabricListEvent fabricListEvent) {
        switch (fabricListEvent.getEventType()) {
            case 5001: {
                break;
            }
            case 5002: {
                topologyHashTable.remove((Fabric)fabricListEvent.getValue());
                break;
            }
        }
    }

    private void rediscoveryFailed(int n) {
        SwingUtilities.invokeLater(new DiscoveryError(n));
    }

    private void doSwitchProperties(Chassis chassis) {
        block11: {
            JFrame jFrame = SbmUtilities.getFrame(this.topology);
            try {
                if (chassis instanceof SanboxChassis) {
                    int n = chassis.getChassisType();
                    switch (n) {
                        case 8: 
                        case 16: 
                        case 25: 
                        case 26: 
                        case 30: 
                        case 33: 
                        case 38: {
                            if (this.switchPropertiesDialogSB2 == null) {
                                this.switchPropertiesDialogSB2 = new SwitchPropertiesDialogSanbox2(jFrame, true, (SanboxChassis)chassis, this.fabric);
                            } else {
                                this.switchPropertiesDialogSB2.resetDialog((SanboxChassis)chassis, this.fabric);
                            }
                            this.switchPropertiesDialogSB2.setVisible(true);
                            break;
                        }
                        case 0: 
                        case 2: {
                            if (this.switchPropertiesDialogSB == null) {
                                this.switchPropertiesDialogSB = new SwitchPropertiesDialogSanbox(jFrame, true, (SanboxChassis)chassis, this.fabric);
                            } else {
                                this.switchPropertiesDialogSB.resetDialog((SanboxChassis)chassis, this.fabric);
                            }
                            this.switchPropertiesDialogSB.setVisible(true);
                        }
                    }
                    break block11;
                }
                JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("TopologyPanel.noDialog"));
            }
            catch (DialogCreateException dialogCreateException) {
                JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("TopologyPanel.infoMissing"));
            }
        }
    }

    private void doNetworkProperties(Chassis chassis) {
        block11: {
            JFrame jFrame = SbmUtilities.getFrame(this.topology);
            try {
                if (chassis instanceof SanboxChassis) {
                    int n = chassis.getChassisType();
                    switch (n) {
                        case 8: 
                        case 16: 
                        case 25: 
                        case 26: 
                        case 30: 
                        case 33: 
                        case 38: {
                            if (this.networkPropertiesDialogSB2 == null) {
                                this.networkPropertiesDialogSB2 = new NetworkPropertiesDialogSanbox2(jFrame, true, (SanboxChassis)chassis, this.fabric);
                            } else {
                                this.networkPropertiesDialogSB2.resetDialog((SanboxChassis)chassis, this.fabric);
                            }
                            this.networkPropertiesDialogSB2.setVisible(true);
                            break;
                        }
                        case 0: 
                        case 2: {
                            if (this.networkPropertiesDialogSB == null) {
                                this.networkPropertiesDialogSB = new NetworkPropertiesDialogSanbox(jFrame, true, (SanboxChassis)chassis, this.fabric);
                            } else {
                                this.networkPropertiesDialogSB.resetDialog((SanboxChassis)chassis, this.fabric);
                            }
                            this.networkPropertiesDialogSB.setVisible(true);
                        }
                    }
                    break block11;
                }
                JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("TopologyPanel.noDialog"));
            }
            catch (DialogCreateException dialogCreateException) {
                JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("TopologyPanel.infoMissing"));
            }
        }
    }

    public void selectAll() {
        this.topology.selectAllNodes();
    }

    private void removeSelected() {
        Vector vector = this.topology.getSelectionList();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof Chassis) {
                this.fabric.removeSwitch((Chassis)e);
            }
            if (e instanceof FabricTopologyLink) {
                FabricTopologyLink fabricTopologyLink = (FabricTopologyLink)e;
                FabricLink fabricLink = fabricTopologyLink.getFabricLink();
                FabricList fabricList = FabricList.getInstance();
                Fabric fabric = FabricList.getFabric((Chassis)fabricLink.getSwitch1());
                if (fabric != null) {
                    fabric.removeLink(fabricLink);
                }
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource();
        if (object2 == this.deleteMenuItem) {
            this.removeSelected();
        }
        if (object2 == this.switchPropertiesMenuItem && this.topology.getSelectionCount() > 0 && (object = this.topology.getSelection()) instanceof Chassis) {
            this.doSwitchProperties((Chassis)object);
        }
        if (object2 == this.networkPropertiesMenuItem && this.topology.getSelectionCount() > 0 && (object = this.topology.getSelection()) instanceof Chassis) {
            this.doNetworkProperties((Chassis)object);
        }
        if (object2 == this.exportNameServerMenuItem) {
            object = this.topologyTabPanel.getNameServerPanel().exportData(this.fabric);
            JFrame jFrame = SbmUtilities.getFrame(this);
            SbmUtilities.export(jFrame, VendorProperties.getFrameTitle(), (String)object);
        }
        if (object2 == this.layoutTopologyMenuItem) {
            this.layoutTopology();
        }
        if (object2 == this.autoLayoutToggleItem) {
            this.topology.setAutoLayout(!this.topology.isAutoLayoutEnabled());
        }
        if (object2 == this.saveLayoutTopologyMenuItem) {
            this.saveLayout();
        }
        if (object2 == this.viewNameServerInfoItem) {
            FcSwitchRenderer.setViewNameServerInfo(!FcSwitchRenderer.getViewNameServerInfo());
            this.repaint();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BackgroundMenuManager
    implements TopologyMenuManager,
    ActionListener {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem refreshItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.refreshFabric"));
        JMenuItem selectAllSwitchesItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.selectAllSwitches"));
        JMenuItem selectAllLinksItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.selectAllLinks"));
        JMenuItem layoutTopoItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.layoutTopology"));

        public BackgroundMenuManager() {
            this.refreshItem.addActionListener(this);
            this.selectAllSwitchesItem.addActionListener(this);
            this.selectAllLinksItem.addActionListener(this);
            this.layoutTopoItem.addActionListener(this);
        }

        public JPopupMenu getMenu(Object object) {
            this.menu.removeAll();
            this.menu.add(this.refreshItem);
            this.menu.add(this.selectAllSwitchesItem);
            this.menu.add(this.selectAllLinksItem);
            this.menu.add(this.layoutTopoItem);
            SanboxChassis sanboxChassis = TopologyPanel.this.fabric.getConnectionSwitch();
            return this.menu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.refreshItem) {
                TopologyPanel.this.refresh();
            }
            if (object == this.selectAllSwitchesItem) {
                TopologyPanel.this.selectAll();
            }
            if (object == this.selectAllLinksItem) {
                TopologyPanel.this.topology.selectAllLinks();
            }
            if (object == this.layoutTopoItem) {
                TopologyPanel.this.layoutTopology();
            }
        }
    }

    class FcLinkMenuManager
    implements TopologyMenuManager,
    ActionListener {
        Fabric fabric;
        FabricLink link;
        JPopupMenu menu = new JPopupMenu();
        JMenuItem deleteItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.deleteLink"));

        public FcLinkMenuManager() {
            this.deleteItem.addActionListener(this);
            this.menu.add(this.deleteItem);
        }

        public JPopupMenu getMenu(Object object) {
            FabricTopologyLink fabricTopologyLink = (FabricTopologyLink)object;
            this.link = fabricTopologyLink.getFabricLink();
            FabricList fabricList = FabricList.getInstance();
            this.fabric = FabricList.getFabric((Chassis)this.link.getSwitch1());
            return this.menu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.deleteItem) {
                this.fabric.removeLink(this.link);
            }
        }
    }

    class FcSwitchMenuManager
    implements TopologyMenuManager,
    ActionListener {
        Chassis sw;
        Fabric fabric;
        JMenuItem propertiesItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.switchProperties"));
        JMenuItem refreshItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.refreshSwitch"));
        JMenuItem deleteItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.deleteSwitch"));
        JMenuItem networkItem = new JMenuItem(FabricTreeControl.getResource("TopologyPanel.networkProperties"));

        public FcSwitchMenuManager() {
            this.refreshItem.addActionListener(this);
            this.deleteItem.addActionListener(this);
            this.propertiesItem.addActionListener(this);
            this.networkItem.addActionListener(this);
        }

        public JPopupMenu getMenu(Object object) {
            this.sw = (Chassis)object;
            FabricList fabricList = FabricList.getInstance();
            this.fabric = FabricList.getFabric((Chassis)this.sw);
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.refreshItem);
            jPopupMenu.add(this.deleteItem);
            if (object instanceof SanboxChassis && TopologyPanel.this.isSwitchEditable((Chassis)object)) {
                jPopupMenu.add(this.propertiesItem);
                jPopupMenu.add(this.networkItem);
            }
            return jPopupMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.deleteItem) {
                TopologyPanel.this.removeSelected();
                return;
            }
            if (!this.sw.isReachable()) {
                JFrame jFrame = SbmUtilities.getFrame(TopologyPanel.this.topology);
                if (jFrame == null) {
                    return;
                }
                PopupDialog.showDialog(jFrame, 3, FabricTreeControl.getResource("TopologyPanel.unableToPerformReq"));
                return;
            }
            if (object == this.refreshItem) {
                this.fabric.refresh(this.sw);
            }
            if (object == this.propertiesItem) {
                TopologyPanel.this.doSwitchProperties(this.sw);
            }
            if (object == this.networkItem) {
                TopologyPanel.this.doNetworkProperties(this.sw);
            }
        }
    }

    class DiscoveryError
    implements Runnable {
        int reason;

        public DiscoveryError(int n) {
            this.reason = n;
        }

        public void run() {
            JFrame jFrame = SbmUtilities.getFrame(TopologyPanel.this.topology);
            if (jFrame == null) {
                return;
            }
            String string = FabricTreeControl.getResource("TopologyPanel.rediscFailed");
            String string2 = "DiscoverError." + this.reason;
            string = string + (string2 != null ? FabricTreeControl.getResource(string2) : string2);
            PopupDialog.showDialog(jFrame, 3, string);
        }
    }

    private class RemoveSwitchClass
    implements Runnable {
        Chassis sw;
        Fabric fabricTarget;

        RemoveSwitchClass(Fabric fabric, Chassis chassis) {
            this.fabricTarget = fabric;
            this.sw = chassis;
        }

        public void run() {
            Topology topology;
            if (this.fabricTarget != null && (topology = (Topology)topologyHashTable.get(this.fabricTarget)) != null) {
                try {
                    topology.removeNode(this.sw);
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                TopologyPanel.this.setTabPanelSelection();
            }
        }
    }

    private class RemoveLinkClass
    implements Runnable {
        Object obj;
        Topology tp;

        RemoveLinkClass(Object object) {
            this.obj = object;
        }

        public void run() {
            if (this.obj instanceof FabricEvent && ((FabricEvent)this.obj).getEventType() == 2005) {
                FabricEvent fabricEvent = (FabricEvent)this.obj;
                Fabric fabric = fabricEvent.getFabric();
                if (fabric == null) {
                    return;
                }
                this.tp = (Topology)topologyHashTable.get(fabric);
                if (this.tp == null) {
                    return;
                }
                FabricLink fabricLink = (FabricLink)fabricEvent.getValue();
                int n = 0;
                while (n < this.tp.getLinkCount()) {
                    FabricTopologyLink fabricTopologyLink = (FabricTopologyLink)this.tp.getLinkAtIndex(n);
                    if (fabricTopologyLink.getFabricLink() == fabricLink) {
                        this.tp.removeLink(fabricTopologyLink);
                        break;
                    }
                    ++n;
                }
                TopologyPanel.this.setTabPanelSelection();
            }
        }
    }

    private class AddLinkClass
    implements Runnable {
        Object obj;

        AddLinkClass(Object object) {
            this.obj = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Topology topology = TopologyPanel.this.topology;
            synchronized (topology) {
                if (this.obj instanceof FabricLink) {
                    FabricLink fabricLink = (FabricLink)this.obj;
                    Fabric fabric = null;
                    Chassis chassis = fabricLink.getSwitch1();
                    FabricList fabricList = FabricList.getInstance();
                    fabric = FabricList.getFabric((Chassis)chassis);
                    if (fabric != null) {
                        Topology topology2 = (Topology)topologyHashTable.get(fabric);
                        FabricTopologyLink fabricTopologyLink = new FabricTopologyLink(fabricLink);
                        topology2.addLink(fabricTopologyLink);
                        TopologyPanel.this.setTabPanelSelection();
                        if (topology2 == TopologyPanel.this.topology) {
                            TopologyPanel.this.repaint();
                        }
                    }
                }
            }
        }
    }

    private class AddSwitchClass
    implements Runnable {
        Object obj;

        AddSwitchClass(Object object) {
            this.obj = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Topology topology = TopologyPanel.this.topology;
            synchronized (topology) {
                Fabric fabric = null;
                if (this.obj instanceof Chassis) {
                    Topology topology2;
                    Chassis chassis = (Chassis)this.obj;
                    FabricList fabricList = FabricList.getInstance();
                    fabric = FabricList.getFabric((Chassis)chassis);
                    if (fabric != null && (topology2 = (Topology)topologyHashTable.get(fabric)).getModel().indexOfNode(this.obj) < 0) {
                        topology2.addNode(this.obj);
                        topology2.setNodeRenderer(this.obj, FcSwitchRenderer.getNodeRenderer((Chassis)this.obj));
                        TopologyNode topologyNode = topology2.getTopologyNode(this.obj);
                        Point point = TopologyPanel.getChassisPos(fabric.getName(), chassis.getWWName());
                        if (point == null) {
                            topology2.layoutNode(topologyNode);
                        } else {
                            topology2.setAutoLayout(false);
                            topology2.setSnapToPosition(false);
                            topology2.layoutNodeAt(topologyNode, point.x, point.y);
                        }
                        TopologyPanel.this.setTabPanelSelection();
                        if (topology2 == TopologyPanel.this.topology) {
                            TopologyPanel.this.repaint();
                        }
                    }
                }
            }
        }
    }

    static class ChassisPos {
        public String fabName;
        public WorldWideName wwn;
        Point pos;

        ChassisPos(String string, WorldWideName worldWideName, int n, int n2) {
            this.fabName = string;
            this.wwn = worldWideName;
            this.pos = new Point(n, n2);
        }
    }
}

