/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FabricLink;
import com.qlogic.qms.fabric.FabricTopologyLink;
import com.qlogic.qms.fabric.FcSwitchRenderer;
import com.qlogic.ui.Topology;
import com.qlogic.ui.topology.DefaultTopologyLinkRenderer;
import com.qlogic.ui.topology.TopologyLink;
import com.qlogic.ui.topology.TopologyNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.io.Serializable;

public class SwitchLinkRenderer
extends DefaultTopologyLinkRenderer {
    Color normalLinkColor = Color.green;
    Color badStatusLinkColor = Color.red;
    Color unknownStatusLinkColor = Color.blue;
    Topology topology;

    public SwitchLinkRenderer(Topology topology) {
        super(topology);
        this.topology = topology;
    }

    protected Point getLinkEndpoint(TopologyLink topologyLink, TopologyNode topologyNode) {
        Point point = this.getIconBounds(topologyNode).getLocation();
        Component component = this.topology.getNodeRenderer(topologyNode, false);
        if (topologyLink instanceof FabricTopologyLink) {
            int n;
            FcSwitchRenderer fcSwitchRenderer = (FcSwitchRenderer)component;
            FabricTopologyLink fabricTopologyLink = (FabricTopologyLink)topologyLink;
            FabricLink fabricLink = fabricTopologyLink.getFabricLink();
            if (fabricLink == null || topologyNode == null) {
                return new Point(0, 0);
            }
            if (fabricLink.getSwitch1() == topologyNode.getObject()) {
                n = fabricLink.getPortNumber1();
                Chassis chassis = fabricLink.getSwitch1();
            } else {
                n = fabricLink.getPortNumber2();
                Chassis chassis = fabricLink.getSwitch2();
            }
            Point point2 = fcSwitchRenderer.getPortPoint(n);
            if (point2 != null) {
                point.x += point2.x;
                point.y += point2.y;
                return point;
            }
        }
        return point;
    }

    private Point getLinkEndpoint(TopologyLink topologyLink, Object object) {
        TopologyNode topologyNode = this.topology.getTopologyNode(object);
        return this.getLinkEndpoint(topologyLink, topologyNode);
    }

    public void paintLink(Graphics graphics, TopologyLink topologyLink) {
        Serializable serializable;
        Object object = topologyLink.getEndPoint1();
        Object object2 = topologyLink.getEndPoint2();
        Point point = this.getLinkEndpoint(topologyLink, object);
        Point point2 = this.getLinkEndpoint(topologyLink, object2);
        int n = ((FabricTopologyLink)topologyLink).getFabricLink().getState();
        switch (n) {
            case 2: {
                graphics.setColor(this.badStatusLinkColor);
                break;
            }
            case 3: {
                graphics.setColor(this.unknownStatusLinkColor);
                break;
            }
            case 0: {
                graphics.setColor(this.normalLinkColor);
                break;
            }
            default: {
                graphics.setColor(this.unknownStatusLinkColor);
            }
        }
        if (this.topology.isSelected(topologyLink)) {
            serializable = this.getBounds(topologyLink, 3);
            graphics.fillPolygon((Polygon)serializable);
        } else {
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        }
        serializable = this.topology.getTopologyNode(object);
        Component component = this.topology.getNodeRenderer((TopologyNode)serializable, false);
        FcSwitchRenderer fcSwitchRenderer = (FcSwitchRenderer)component;
        if (fcSwitchRenderer == null) {
            return;
        }
        Dimension dimension = fcSwitchRenderer.getPortDimension();
        graphics.fillRect(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
        serializable = this.topology.getTopologyNode(object2);
        component = this.topology.getNodeRenderer((TopologyNode)serializable, false);
        fcSwitchRenderer = (FcSwitchRenderer)component;
        if (fcSwitchRenderer == null) {
            return;
        }
        dimension = fcSwitchRenderer.getPortDimension();
        graphics.fillRect(point2.x - dimension.width / 2, point2.y - dimension.height / 2, dimension.width, dimension.height);
    }
}

