/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.Status;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.UserPreferences;
import com.qlogic.ui.QFileChooser;
import com.qlogic.ui.tools.RolloverListener;
import com.qlogic.util.EolBufferedOutputStream;
import java.awt.Container;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SbmUtilities {
    public static final Toolkit appToolkit = Toolkit.getDefaultToolkit();

    public static Image getImage(String string) {
        JButton jButton = new JButton();
        string = "/Images/" + string;
        URL uRL = jButton.getClass().getResource(string);
        Image image = null;
        if (uRL != null) {
            try {
                MediaTracker mediaTracker = new MediaTracker(jButton);
                image = appToolkit.getImage(uRL);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (image == null) {
            image = appToolkit.getImage(string);
        }
        return image;
    }

    public static String reasonToString(List list) {
        if (list.size() == 0) {
            return Status.toString((String)"Status.unknown");
        }
        StringBuffer stringBuffer = new StringBuffer(list.size() * 10);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(Status.toString((String)((String)iterator.next())));
            stringBuffer.append("/");
        }
        return stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString();
    }

    public static void setButtonParameters(JButton jButton) {
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        jButton.setHorizontalAlignment(0);
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.setAlignmentY(0.5f);
        jButton.setRequestFocusEnabled(false);
        jButton.addMouseListener((MouseListener)new RolloverListener(jButton));
    }

    public static JFrame getFrame(Container container) {
        Container container2;
        if (container == null) {
            return null;
        }
        boolean bl = false;
        while (!bl) {
            if (container instanceof JFrame) {
                bl = true;
                continue;
            }
            container2 = container.getParent();
            if (container2 == container) {
                return null;
            }
            container = container2;
            if (container != null) continue;
            return null;
        }
        container2 = (JFrame)container;
        return container2;
    }

    public static void export(JFrame jFrame, String string, String string2) {
        block5: {
            UserPreferences userPreferences = UserPreferences.getInstance();
            String string3 = userPreferences.getWorkingDirectory();
            QFileChooser qFileChooser = new QFileChooser(string3);
            if (qFileChooser.showSaveDialog(jFrame) != 0) break block5;
            try {
                File file = qFileChooser.getSelectedFile();
                if (file.exists()) {
                    int n = JOptionPane.showConfirmDialog(jFrame, "The file " + qFileChooser.getSelectedFile().toString() + " currently exists. Do you wish to overwrite it?", string + " - " + "Export", 0);
                    if (n != 0) {
                        return;
                    }
                } else {
                    file.createNewFile();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                EolBufferedOutputStream eolBufferedOutputStream = new EolBufferedOutputStream(fileOutputStream);
                eolBufferedOutputStream.write(string2.getBytes());
                eolBufferedOutputStream.close();
                JOptionPane.showMessageDialog(jFrame, "Data exported", string + " - " + "Export", 1);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jFrame, "Error saving zoning \n" + iOException.toString(), string + " - " + "Export", 0);
            }
        }
    }

    public static String getPortConfigModeString(PortStates portStates) {
        String string = "";
        if (portStates == null) {
            return "unknown";
        }
        switch (portStates.getConfigPortType()) {
            case 6: {
                string = FabricTreeControl.getResource("AbstractFaceplate.donorPort");
                break;
            }
            case 7: {
                string = FabricTreeControl.getResource("AbstractFaceplate.ePort");
                break;
            }
            case 2: {
                string = FabricTreeControl.getResource("AbstractFaceplate.flPort");
                break;
            }
            case 1: {
                string = FabricTreeControl.getResource("AbstractFaceplate.fPort");
                break;
            }
            case 4: {
                string = FabricTreeControl.getResource("AbstractFaceplate.slPort");
                break;
            }
            case 5: {
                string = FabricTreeControl.getResource("AbstractFaceplate.tlPort");
                break;
            }
            case 3: {
                string = FabricTreeControl.getResource("AbstractFaceplate.tPort");
                break;
            }
            case 8: {
                string = FabricTreeControl.getResource("AbstractFaceplate.gPort");
                break;
            }
            case 9: {
                string = FabricTreeControl.getResource("AbstractFaceplate.glPort");
                break;
            }
            case 0: {
                string = FabricTreeControl.getResource("AbstractFaceplate.unknown");
            }
        }
        return string;
    }

    public static String getPortStateString(int n) {
        switch (n) {
            case 1: {
                return FabricTreeControl.getResource("FCPort.portOnline");
            }
            case 2: {
                return FabricTreeControl.getResource("FCPort.portOffline");
            }
            case 4: {
                return FabricTreeControl.getResource("FCPort.portDowned");
            }
            case 3: {
                return FabricTreeControl.getResource("FCPort.portTesting");
            }
            case 6: {
                return FabricTreeControl.getResource("AbstractFaceplate.portIsolated");
            }
            case 5: {
                return FabricTreeControl.getResource("FCPort.portNotInstalled");
            }
        }
        return FabricTreeControl.getResource("AbstractFaceplate.unknown");
    }

    public static String getNodeTypeLongNameString(int n) {
        String string = new String();
        switch (n) {
            case 1: {
                string = FabricTreeControl.getResource("FCNode.nPortLongName");
                break;
            }
            case 2: {
                string = FabricTreeControl.getResource("FCNode.nlPortLongName");
                break;
            }
            default: {
                string = FabricTreeControl.getResource("FCPort.unknownLongName");
            }
        }
        return string;
    }

    public static String getPortTypeLongNameString(int n) {
        String string = new String();
        switch (n) {
            case 7: {
                string = FabricTreeControl.getResource("FCPort.ePortLongName");
                break;
            }
            case 2: {
                string = FabricTreeControl.getResource("FCPort.flPortLongName");
                break;
            }
            case 1: {
                string = FabricTreeControl.getResource("FCPort.fPortLongName");
                break;
            }
            case 4: {
                string = FabricTreeControl.getResource("FCPort.slPortLongName");
                break;
            }
            case 5: {
                string = FabricTreeControl.getResource("FCPort.tlPortLongName");
                break;
            }
            case 3: {
                string = FabricTreeControl.getResource("FCPort.tPortLongName");
                break;
            }
            case 8: {
                string = FabricTreeControl.getResource("FCPort.gPortLongName");
                break;
            }
            case 9: {
                string = FabricTreeControl.getResource("FCPort.glPortLongName");
                break;
            }
            case 0: {
                string = FabricTreeControl.getResource("FCPort.unknownLongName");
                break;
            }
            case 6: {
                string = FabricTreeControl.getResource("FCPort.donorPortLongName");
                break;
            }
            default: {
                string = FabricTreeControl.getResource("FCPort.inactivePortLongName");
            }
        }
        return string;
    }

    public static String getGbicModeString(FCPort fCPort) {
        String string = FabricTreeControl.getResource("AbstractFaceplate.unknown");
        switch (fCPort.getGbicType()) {
            case 3: 
            case 5: {
                string = FabricTreeControl.getResource("FCPort.copper");
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                string = FabricTreeControl.getResource("FCPort.optical");
                break;
            }
            case 6: {
                string = FabricTreeControl.getResource("FCPort.serial");
                break;
            }
            case 7: 
            case 99: {
                string = FabricTreeControl.getResource("FCPort.inactivePort");
                break;
            }
            case 8: 
            case 9: {
                string = FabricTreeControl.getResource("FCPort.hardwiredPort");
            }
        }
        return string;
    }

    public static String getEPortConnString(FCPort fCPort) {
        switch (fCPort.getEPortConnState()) {
            case 0: {
                return FabricTreeControl.getResource("FCPort.ePortNone");
            }
            case 1: {
                return FabricTreeControl.getResource("FCPort.ePortConnecting");
            }
            case 2: {
                return FabricTreeControl.getResource("FCPort.ePortConnected");
            }
            case 3: {
                return FabricTreeControl.getResource("FCPort.ePortIsolated");
            }
        }
        return FabricTreeControl.getResource("FCPort.ePortUnknown");
    }
}

