/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.qms.fabric.AbstractFaceplate;
import com.qlogic.qms.fabric.LedRenderer;
import com.qlogic.qms.fabric.SbmUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Sanbox2_8Faceplate
extends AbstractFaceplate {
    private Rectangle[] portLocations = new Rectangle[8];
    private static final int FIRST_PORT_X = 173;
    private static final int FIRST_PORT_Y = 19;
    private static final int PORT_OFFSET_X = 32;
    private static final int PORT_OFFSET_Y = 22;
    private static final int PORT_WIDTH = 22;
    private static final int PORT_HEIGHT = 17;
    private static final int ROW_COUNT = 2;
    private static final int COLUMN_COUNT = 4;
    private static final int BOTTOM_RIGHT_X = 118;
    private static final int BOTTOM_RIGHT_Y = 39;
    private static final int MINI_LED_SIZE = 6;
    private static final int LARGE_LED_SIZE = 9;
    private static final Point TEMP_LED_POINT = new Point(129, 13);
    private static final Point FAN_LED_POINT = new Point(137, 13);
    private static final Point HEART_LED_POINT = new Point(145, 13);
    private static final Point MINI_POWER_LED_POINT = new Point(153, 13);
    private static final Rectangle POWER_LED1_POINT = new Rectangle(95, 25, 9, 9);
    private static final Rectangle POWER_LED2_POINT = new Rectangle(558, 25, 9, 9);
    private static final Rectangle LED_AREA = new Rectangle(Sanbox2_8Faceplate.TEMP_LED_POINT.x, Sanbox2_8Faceplate.TEMP_LED_POINT.y, 160, 20);
    private static final Icon COPPER_ONLINE_ICON = null;
    private static final Icon COPPER_OFFLINE_ICON = null;
    private static final Icon OPTICAL_ONLINE_ICON = new ImageIcon(SbmUtilities.getImage("gbicSanbox2OptOnline.gif"));
    private static final Icon OPTICAL_OFFLINE_ICON = new ImageIcon(SbmUtilities.getImage("gbicSanbox2OptOffline.gif"));
    private LedRenderer m_LedRenderer = new LedRenderer(6);
    static ImageIcon faceplateIcon;

    public Sanbox2_8Faceplate(Sanbox2 sanbox2) throws IllegalArgumentException {
        super((Chassis)sanbox2);
        if (faceplateIcon == null) {
            faceplateIcon = new ImageIcon(SbmUtilities.getImage("Itasca8Faceplate.gif"));
        }
        this.setFaceplateIcon(faceplateIcon);
        if (this.fcSwitch.getPortCount() != 8) {
            throw new IllegalArgumentException();
        }
    }

    protected int getPowerSupplyCount() {
        return 2;
    }

    protected void paintPowerSupply(int n, Graphics graphics) {
        int n2 = 10;
        int n3 = 10;
        int n4 = 109;
        int n5 = 56;
        switch (n) {
            case 0: {
                n2 = 10;
                break;
            }
            case 1: {
                n2 = 475;
                break;
            }
            default: {
                return;
            }
        }
        this.paintPowerSupply(n, graphics, n2, n3, n4, n5);
    }

    protected Icon getGbicIcon(FCPort fCPort, int n) {
        return this.getSFPIcon(fCPort, n);
    }

    public Rectangle getPort(int n) {
        if (this.portLocations[n] == null) {
            int n2 = 19 + n % 2 * 22;
            int n3 = 173 + 32 * (n / 2);
            this.portLocations[n] = new Rectangle(n3, n2, 22, 17);
        }
        return this.portLocations[n];
    }

    public int getPortCount() {
        return 8;
    }

    protected void paintLeds(Graphics graphics) {
        int n = this.fcSwitch.getFanCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && n2 == 0) {
            n2 = this.fcSwitch.getFanStatus(n3);
            ++n3;
        }
        this.m_LedRenderer.setColor(this.getFanColor(n2));
        this.m_RendererPane.paintComponent(graphics, this.m_LedRenderer, this, Sanbox2_8Faceplate.FAN_LED_POINT.x, Sanbox2_8Faceplate.FAN_LED_POINT.y, 6, 6);
        this.m_LedRenderer.setColor(this.getTemperatureColor(this.fcSwitch.getTemperatureStatus()));
        this.m_RendererPane.paintComponent(graphics, this.m_LedRenderer, this, Sanbox2_8Faceplate.TEMP_LED_POINT.x, Sanbox2_8Faceplate.TEMP_LED_POINT.y, 6, 6);
        this.m_LedRenderer.setColor(Color.orange);
        this.m_RendererPane.paintComponent(graphics, this.m_LedRenderer, this, Sanbox2_8Faceplate.HEART_LED_POINT.x, Sanbox2_8Faceplate.HEART_LED_POINT.y, 6, 6);
        this.m_LedRenderer.setColor(Color.green);
        this.m_RendererPane.paintComponent(graphics, this.m_LedRenderer, this, Sanbox2_8Faceplate.MINI_POWER_LED_POINT.x, Sanbox2_8Faceplate.MINI_POWER_LED_POINT.y, 6, 6);
        switch (this.fcSwitch.getPowerSupplyCount()) {
            case 0: {
                break;
            }
            case 1: {
                this.m_LedRenderer.setColor(this.getPowerColor(this.fcSwitch.getPowerSupplyStatus(0)));
                this.m_RendererPane.paintComponent(graphics, this.m_LedRenderer, this, Sanbox2_8Faceplate.POWER_LED1_POINT.x, Sanbox2_8Faceplate.POWER_LED1_POINT.y, 9, 9);
                break;
            }
            case 2: {
                this.m_LedRenderer.setColor(this.getPowerColor(this.fcSwitch.getPowerSupplyStatus(0)));
                this.m_RendererPane.paintComponent(graphics, this.m_LedRenderer, this, Sanbox2_8Faceplate.POWER_LED1_POINT.x, Sanbox2_8Faceplate.POWER_LED1_POINT.y, 9, 9);
                this.m_LedRenderer.setColor(this.getPowerColor(this.fcSwitch.getPowerSupplyStatus(1)));
                this.m_RendererPane.paintComponent(graphics, this.m_LedRenderer, this, Sanbox2_8Faceplate.POWER_LED2_POINT.x, Sanbox2_8Faceplate.POWER_LED2_POINT.y, 9, 9);
                break;
            }
        }
    }

    protected Color getFanColor(int n) {
        switch (n) {
            case 0: {
                return Color.black;
            }
            case 1: {
                return Color.orange;
            }
            case 2: {
                return Color.red;
            }
        }
        return Color.blue;
    }

    protected Color getPowerColor(int n) {
        switch (n) {
            case 0: {
                return Color.green;
            }
            case 1: {
                return Color.orange;
            }
            case 2: {
                return Color.red;
            }
        }
        return Color.blue;
    }

    protected Color getTemperatureColor(int n) {
        switch (n) {
            case 0: {
                return Color.black;
            }
            case 1: {
                return Color.orange;
            }
            case 2: {
                return Color.red;
            }
        }
        return Color.blue;
    }

    protected String getPortModeTooltip(FCPort fCPort) {
        String string = "";
        PortStates portStates = fCPort.getPortStates();
        if (portStates != null) {
            switch (portStates.getConfigPortType()) {
                case 7: {
                    string = "E-port";
                    break;
                }
                case 2: {
                    string = "FL-port";
                    break;
                }
                case 1: {
                    string = "F-port";
                    break;
                }
                case 4: {
                    string = "SL-port";
                    break;
                }
                case 5: {
                    string = "TL-port";
                    break;
                }
                case 3: {
                    string = "T-port";
                    break;
                }
                case 8: {
                    string = "G-port";
                    break;
                }
                case 9: {
                    string = "GL-port";
                    break;
                }
                case 0: {
                    string = "Inactive";
                }
            }
        } else {
            string = "Unknown";
        }
        if (fCPort instanceof S16Port) {
            string = string + " " + AbstractFaceplate.getOperPortSpeedString(fCPort);
        }
        return string;
    }

    protected String getLedTooltip(int n, int n2) {
        String string = null;
        StringBuffer stringBuffer = null;
        if (LED_AREA.contains(n, n2)) {
            stringBuffer = new StringBuffer(Integer.toString(this.fcSwitch.getTemperature()));
            stringBuffer.append("\u00b2 Celsius  ");
            int n3 = this.fcSwitch.getFanCount();
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3 && n4 == 0) {
                n4 = this.fcSwitch.getFanStatus(n5);
                ++n5;
            }
            switch (n4) {
                case 0: {
                    stringBuffer.append("Fan: OK  ");
                    break;
                }
                case 1: 
                case 2: {
                    stringBuffer.append("Fan: Not Present  ");
                    break;
                }
                default: {
                    stringBuffer.append("Fan: Unknown ");
                }
            }
            stringBuffer.append("Heartbeat: OK  ");
            String string2 = this.getPowerSupplyStatus();
            stringBuffer.append("Power: " + string2);
            string = stringBuffer.toString();
        } else if (POWER_LED1_POINT.contains(n, n2)) {
            switch (this.fcSwitch.getPowerSupplyStatus(0)) {
                case 0: {
                    string = "Power: OK";
                    break;
                }
                case 1: {
                    string = "Power: Warning";
                    break;
                }
                case 2: {
                    string = "Power: Failed";
                    break;
                }
                default: {
                    string = "Power: Unknown";
                    break;
                }
            }
        } else if (POWER_LED2_POINT.contains(n, n2)) {
            switch (this.fcSwitch.getPowerSupplyStatus(1)) {
                case 0: {
                    string = "Power: OK";
                    break;
                }
                case 1: {
                    string = "Power: Warning";
                    break;
                }
                case 2: {
                    string = "Power: Failed";
                    break;
                }
                default: {
                    string = "Power: Unknown";
                }
            }
        }
        return string;
    }
}

