/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.FCStatistics;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.S43Port;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.AbstractFaceplate;
import com.qlogic.qms.fabric.FabricTableModel;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.ui.tools.SmartScrollingTable;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PortInfoPanel
extends JPanel
implements ChassisEventListener {
    FabricTableModel model = new FabricTableModel();
    JTable table = new SmartScrollingTable((TableModel)this.model);
    Chassis theSwitch = null;
    Vector portList = null;

    public PortInfoPanel() {
        this.setEmptyTable();
        this.setLayout(new GridLayout(1, 1));
        this.table.getColumnModel().setColumnSelectionAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(3);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.add(jScrollPane);
    }

    public void setSelectedPorts(Vector vector) {
        if (this.theSwitch != null) {
            this.theSwitch.removeChassisEventListener((ChassisEventListener)this);
        }
        this.portList = vector;
        if (vector == null || vector.size() < 1) {
            this.theSwitch = null;
        } else {
            this.theSwitch = ((FCPort)vector.elementAt(0)).getChassis();
            this.theSwitch.addChassisEventListener((ChassisEventListener)this);
        }
        this.setupTable();
        this.fillTableData();
    }

    public void setEmptyTable() {
        this.model.setColumnCount(0);
        this.model.setRowCount(0);
    }

    public void setupTable() {
        Object object;
        this.setEmptyTable();
        FCStatistics fCStatistics = null;
        if (this.theSwitch != null && this.theSwitch instanceof SanboxChassis) {
            object = (SanboxChassis)this.theSwitch;
            this.model.addColumn(object.getChassisName());
            int n = 0;
            while (n < this.portList.size()) {
                FCPort fCPort = (FCPort)this.portList.elementAt(n);
                if (fCPort.getStats() != null) {
                    fCStatistics = fCPort.getStats();
                }
                String string = this.getColumnName(fCPort);
                this.model.addColumn(string);
                ++n;
            }
            this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.portAddress"));
            this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.adminPortMode"));
            this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.operPortMode"));
            this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.adminPortState"));
            this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.operPortState"));
            if (object instanceof Sanbox2) {
                this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.configuredAdminPortState"));
            }
            this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.loggedIn"));
            this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.ePortConnectionStatus"));
            this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.ePortIsolationReason"));
            this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.mfsMode"));
            this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.ioStreamGuard"));
            if (object instanceof Sanbox2) {
                this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.adminPortSpeed"));
                this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.operPortSpeed"));
                this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.bbCredits"));
                this.model.addRow("Symbolic Name");
            } else if (object instanceof Sanbox) {
                // empty if block
            }
            if (object instanceof Sanbox2) {
                this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.extCreditsRequested"));
            } else {
                this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.extCreditMode"));
            }
            this.model.addRow(FabricTreeControl.getResource("PortInfoPanel.medium"));
        } else {
            this.model.addColumn(FabricTreeControl.getResource("PortInfoPanel.noPortsSelected"));
        }
        object = this.table.getColumnModel();
        TableColumn tableColumn = object.getColumn(0);
        if (tableColumn != null) {
            tableColumn.setMinWidth(150);
        }
        int n = 1;
        while (n < this.table.getColumnCount()) {
            tableColumn = object.getColumn(n);
            ++n;
        }
    }

    private String getColumnName(FCPort fCPort) {
        return fCPort.toString();
    }

    public void fillTableData() {
        Object object;
        int n;
        Object object2;
        if (this.portList == null) {
            this.setEmptyTable();
            return;
        }
        int n2 = this.portList.size();
        Vector<Vector> vector = this.model.getDataVector();
        Vector vector2 = this.getColumnNames();
        String string = new String("<html><Font color=#ff0000>");
        String string2 = FabricTreeControl.getResource("PortInfoPanel.na");
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            FCPort fCPort = (FCPort)this.portList.elementAt(n3);
            String string3 = fCPort.toString();
            int n4 = 1;
            int n5 = this.model.getColumnCount();
            while (n4 < n5) {
                if (vector2.get(n4).equals(string3)) break;
                ++n4;
            }
            if (n4 >= this.model.getColumnCount()) {
                return;
            }
            object2 = fCPort.getPortStates();
            n = 0;
            if (object2 != null) {
                object = fCPort.delimitFCAddress();
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = fCPort instanceof S16Port ? SbmUtilities.getPortTypeLongNameString(object2.getConfigPortType()) : string2;
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = SbmUtilities.getPortTypeLongNameString(object2.getPortType());
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = SbmUtilities.getPortStateString(object2.getActiveAdminState());
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = SbmUtilities.getPortStateString(object2.getOperationalAdminState());
                bl |= this.changeString(vector, (String)object, n++, n4);
                if (fCPort instanceof S16Port) {
                    object = SbmUtilities.getPortStateString(object2.getPendingAdminState());
                    bl |= this.changeString(vector, (String)object, n++, n4);
                }
                object = object2.getLoggedIn() == 1 ? FabricTreeControl.getResource("PortInfoPanel.loggedIn") : FabricTreeControl.getResource("PortInfoPanel.inactive");
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = SbmUtilities.getEPortConnString(fCPort);
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = fCPort.getEPortConnState() == 3 ? fCPort.getEPortIsolatedReason() : string2;
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = this.MfsModeStr(object2.getMfsMode());
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = fCPort instanceof S16Port ? this.translateRscnEnableString(!((S16Port)fCPort).getRscnEnable()) : this.translateRscnEnableString(((S43Port)fCPort).isRscnSuppressed());
                bl |= this.changeString(vector, (String)object, n++, n4);
            } else {
                object = SbmUtilities.getPortTypeLongNameString(0);
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = SbmUtilities.getPortTypeLongNameString(0);
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = SbmUtilities.getPortStateString(0);
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = SbmUtilities.getPortStateString(0);
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = "??";
                bl |= this.changeString(vector, (String)object, n++, n4);
                bl |= this.changeString(vector, (String)object, n++, n4);
                bl |= this.changeString(vector, (String)object, n++, n4);
            }
            if (fCPort instanceof S16Port) {
                S16Port s16Port = (S16Port)fCPort;
                object = AbstractFaceplate.getLongAdminPortSpeedString((FCPort)s16Port);
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = AbstractFaceplate.getLongOperPortSpeedString((FCPort)s16Port);
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = Integer.toString(s16Port.getBBCredits());
                bl |= this.changeString(vector, (String)object, n++, n4);
                object = s16Port.getPortName();
                bl |= this.changeString(vector, (String)object, n++, n4);
            } else if (fCPort instanceof S43Port) {
                // empty if block
            }
            object = this.getExtCreditString(fCPort);
            bl |= this.changeString(vector, (String)object, n++, n4);
            object = SbmUtilities.getGbicModeString(fCPort);
            bl |= this.changeString(vector, (String)object, n++, n4);
            ++n3;
        }
        if (bl) {
            int n6 = this.model.getColumnCount();
            int[] nArray = new int[n6];
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            object2 = tableColumnModel.getColumns();
            n = 0;
            while (object2.hasMoreElements()) {
                nArray[n++] = object2.nextElement().getWidth();
            }
            this.model.setDataVector(vector, vector2);
            object2 = tableColumnModel.getColumns();
            n = 0;
            while (object2.hasMoreElements()) {
                object = (TableColumn)object2.nextElement();
                if (((TableColumn)object).getWidth() != nArray[n]) {
                    ((TableColumn)object).setPreferredWidth(nArray[n]);
                }
                ++n;
            }
            this.repaint();
        }
    }

    private boolean changeString(Vector vector, String string, int n, int n2) {
        String string2 = (String)this.getValueAt(vector, n, n2);
        if (string2 == null || !string2.equals(string)) {
            this.setValueAt(vector, string, n, n2);
            return true;
        }
        return false;
    }

    private void setValueAt(Vector vector, Object object, int n, int n2) {
        Vector vector2;
        if (n < vector.size() && n2 < (vector2 = (Vector)vector.get(n)).size()) {
            vector2.set(n2, object);
        }
    }

    private Object getValueAt(Vector vector, int n, int n2) {
        Vector vector2;
        if (n < vector.size() && n2 < (vector2 = (Vector)vector.get(n)).size()) {
            return vector2.get(n2);
        }
        return null;
    }

    private Vector getColumnNames() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = this.model.getColumnCount();
        while (n < n2) {
            vector.add(this.model.getColumnName(n));
            ++n;
        }
        return vector;
    }

    protected String getExtCreditString(FCPort fCPort) {
        String string = FabricTreeControl.getResource("PortInfoPanel.none");
        if (fCPort instanceof S16Port) {
            S16Port s16Port = (S16Port)fCPort;
            int n = s16Port.getExtCredits();
            if (n > 0) {
                string = new Integer(n).toString();
            } else {
                PortStates portStates = fCPort.getPortStates();
                if (portStates != null && portStates.getConfigPortType() == 6) {
                    string = FabricTreeControl.getResource("PortInfoPanel.donor");
                }
            }
        } else {
            SanboxChassis sanboxChassis = fCPort.getChassis();
            int n = fCPort.getPortNumber();
            if (n == 0 || n % 4 == 0) {
                int n2 = ((Sanbox)sanboxChassis).getExtCreditMode(n);
                switch (n2) {
                    case 1: {
                        string = FabricTreeControl.getResource("PortInfoPanel.ext16");
                        break;
                    }
                    case 2: {
                        string = FabricTreeControl.getResource("PortInfoPanel.ext24");
                        break;
                    }
                    case 3: {
                        string = FabricTreeControl.getResource("PortInfoPanel.ext32");
                    }
                }
            } else {
                S43Port s43Port = (S43Port)fCPort;
                if (s43Port.isDonorPort()) {
                    string = FabricTreeControl.getResource("PortInfoPanel.donor");
                }
            }
        }
        return string;
    }

    private String MfsModeStr(byte by) {
        switch (by) {
            default: {
                return FabricTreeControl.getResource("PortInfoPanel.normal");
            }
            case 1: {
                return FabricTreeControl.getResource("PortInfoPanel.nonInterleaved");
            }
            case 2: {
                return FabricTreeControl.getResource("PortInfoPanel.minimizedInterleaved");
            }
            case 3: {
                return FabricTreeControl.getResource("PortInfoPanel.frameLimit8");
            }
            case 4: {
                return FabricTreeControl.getResource("PortInfoPanel.frameLimit16");
            }
            case 5: {
                return FabricTreeControl.getResource("PortInfoPanel.frameLimit32");
            }
            case 6: {
                return FabricTreeControl.getResource("PortInfoPanel.frameLimit128");
            }
            case 64: 
        }
        return FabricTreeControl.getResource("PortInfoPanel.enabled");
    }

    private String translateRscnEnableString(boolean bl) {
        if (!bl) {
            return FabricTreeControl.getResource("PortInfoPanel.disabled");
        }
        return FabricTreeControl.getResource("PortInfoPanel.enabled");
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        switch (chassisEvent.getEventType()) {
            case 210: 
            case 225: 
            case 228: 
            case 232: 
            case 246: 
            case 255: 
            case 257: 
            case 259: 
            case 265: 
            case 269: 
            case 279: 
            case 285: 
            case 286: 
            case 288: 
            case 297: 
            case 300: 
            case 311: {
                SwingUtilities.invokeLater(new FillTableClass());
            }
        }
    }

    class FillTableClass
    implements Runnable {
        FillTableClass() {
        }

        public void run() {
            PortInfoPanel.this.fillTableData();
        }
    }
}

