/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.FCStatistics;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.qms.fabric.FabricTableModel;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.ui.tools.SmartScrollingTable;
import com.qlogic.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PortCountersPanel
extends JPanel
implements ActionListener {
    private static final int ABSOLUTE = 0;
    private static final int RATE = 1;
    private static final int DELTA = 2;
    public static final long secondsInMinute = 60L;
    public static final long secondsInHour = 3600L;
    public static final long secondsInDay = 86400L;
    FabricTableModel model = new FabricTableModel();
    JTable table = new SmartScrollingTable((TableModel)this.model);
    JButton zeroDeltas = new JButton(new ClearDeltaAction());
    JComboBox displayMode;
    Chassis theSwitch = null;
    Vector portList = null;
    ChassisEventAdapter eventAdapter = null;
    static String absoulteStr = FabricTreeControl.getResource("PortCountersPanel.absoulte");
    static String rateStr = FabricTreeControl.getResource("PortCountersPanel.rate");
    static String deltaStr = FabricTreeControl.getResource("PortCountersPanel.delta");
    static String baseTimeStr = FabricTreeControl.getResource("PortCountersPanel.baseTime");
    static String lastTimeStr = FabricTreeControl.getResource("PortCountersPanel.lastTime");
    static String totalTimeStr = FabricTreeControl.getResource("PortCountersPanel.totalTime");
    static String secStr = FabricTreeControl.getResource("PortCountersPanel.sec");
    static String secondsStr = FabricTreeControl.getResource("PortCountersPanel.seconds");
    static String clearStr = FabricTreeControl.getResource("PortCountersPanel.clear");
    static String noPortsSelectedStr = FabricTreeControl.getResource("PortCountersPanel.noPortsSelected");

    public PortCountersPanel() {
        this.setEmptyTable();
        this.setLayout(new BorderLayout());
        this.table.getColumnModel().setColumnSelectionAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(3);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.add((Component)jScrollPane, "Center");
        Vector<String> vector = new Vector<String>();
        vector.add(absoulteStr);
        vector.add(rateStr);
        vector.add(deltaStr);
        this.displayMode = new JComboBox(vector);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.displayMode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        jPanel.add((Component)this.zeroDeltas, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)jPanel, "North");
        this.displayMode.setSelectedIndex(0);
        this.zeroDeltas.setEnabled(false);
        this.displayMode.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.displayMode) {
            this.zeroDeltas.setEnabled(this.displayMode.getSelectedIndex() == 2);
            this.fillTableData();
        }
    }

    public void setSelectedPorts(Vector vector) {
        if (this.theSwitch != null) {
            this.eventAdapter.unregisterEventHandler(221);
        }
        this.portList = vector;
        if (vector == null || vector.size() < 1) {
            this.theSwitch = null;
        } else {
            this.theSwitch = ((FCPort)vector.elementAt(0)).getChassis();
            this.eventAdapter = new ChassisEventAdapter((Object)this, this.theSwitch);
            this.eventAdapter.registerEventHandler(221, "updateReceived");
        }
        this.setupTable();
        this.fillTableData();
    }

    public void setEmptyTable() {
        this.model.setColumnCount(0);
        this.model.setRowCount(0);
    }

    public String formatTimeString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (l == 0L) {
            return "0 sec";
        }
        if (l >= 86400L) {
            long l2 = l / 86400L;
            stringBuffer.append(l2 + " days ");
            l %= 86400L;
        }
        if (l >= 3600L) {
            long l3 = l / 3600L;
            stringBuffer.append(l3 + " hrs ");
            l %= 3600L;
        }
        if (l >= 60L) {
            long l4 = l / 60L;
            stringBuffer.append(l4 + " min ");
            l %= 60L;
        }
        if (l > 0L) {
            stringBuffer.append(l + " sec");
        }
        return stringBuffer.toString();
    }

    public void setupTable() {
        TableColumnModel tableColumnModel;
        TableColumn tableColumn;
        int n;
        this.setEmptyTable();
        FCStatistics fCStatistics = null;
        if (this.theSwitch != null && this.theSwitch instanceof SanboxChassis) {
            this.model.addColumn(this.theSwitch.toString());
            n = 0;
            while (n < this.portList.size()) {
                tableColumn = (FCPort)this.portList.elementAt(n);
                if (tableColumn.getStats() != null) {
                    fCStatistics = tableColumn.getStats();
                }
                String string = this.getColumnName((FCPort)tableColumn);
                this.model.addColumn(string);
                ++n;
            }
        } else {
            this.model.addColumn(noPortsSelectedStr);
        }
        if (fCStatistics != null) {
            try {
                this.model.addRow(baseTimeStr);
                this.model.addRow(lastTimeStr);
                this.model.addRow(totalTimeStr);
                n = 0;
                while (n < fCStatistics.getNumberOfStatistics()) {
                    this.model.addRow(fCStatistics.getStatisticsName(n));
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((tableColumn = (tableColumnModel = this.table.getColumnModel()).getColumn(0)) != null) {
            tableColumn.setMinWidth(150);
        }
        int n2 = 1;
        while (n2 < this.table.getColumnCount()) {
            tableColumn = tableColumnModel.getColumn(n2);
            ++n2;
        }
    }

    private String getColumnName(FCPort fCPort) {
        return fCPort.toString();
    }

    public void fillTableData() {
        Vector vector;
        if (this.portList == null) {
            this.setEmptyTable();
            return;
        }
        int n = this.portList.size();
        Vector<Vector> vector2 = this.model.getDataVector();
        String string = FabricTreeControl.getResource("SwitchDisplayPanel.na");
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            FCPort fCPort = (FCPort)this.portList.elementAt(n2);
            vector = fCPort.getStats();
            if (vector == null) {
                return;
            }
            String string2 = fCPort.toString();
            int n3 = 1;
            int n4 = this.model.getColumnCount();
            while (n3 < n4) {
                if (this.model.getColumnName(n3).equals(string2)) break;
                ++n3;
            }
            if (n3 >= this.model.getColumnCount()) {
                return;
            }
            try {
                String string3;
                int n5 = 0;
                switch (this.displayMode.getSelectedIndex()) {
                    case 0: {
                        string3 = string;
                        bl |= this.changeString(vector2, string3, n5++, n3);
                        bl |= this.changeString(vector2, string3, n5++, n3);
                        bl |= this.changeString(vector2, string3, n5++, n3);
                        break;
                    }
                    case 1: {
                        string3 = vector.getSecondToLastTimeStamp().toString();
                        bl |= this.changeString(vector2, string3, n5++, n3);
                        string3 = vector.getTimeStamp().toString();
                        bl |= this.changeString(vector2, string3, n5++, n3);
                        long l = vector.getTimeStamp().getTime() - vector.getSecondToLastTimeStamp().getTime();
                        string3 = this.formatTimeString(l / 1000L);
                        bl |= this.changeString(vector2, string3, n5++, n3);
                        break;
                    }
                    case 2: {
                        string3 = vector.getBaseTimeStamp().toString();
                        bl |= this.changeString(vector2, string3, n5++, n3);
                        string3 = vector.getTimeStamp().toString();
                        bl |= this.changeString(vector2, string3, n5++, n3);
                        long l = vector.getTimeStamp().getTime() - vector.getBaseTimeStamp().getTime();
                        string3 = this.formatTimeString(l / 1000L);
                        bl |= this.changeString(vector2, string3, n5++, n3);
                    }
                }
                int n6 = 0;
                while (n6 < vector.getNumberOfStatistics()) {
                    switch (this.displayMode.getSelectedIndex()) {
                        case 0: {
                            string3 = StringUtilities.formatNumber(vector.getStatisticValue(n6));
                            bl |= this.changeString(vector2, string3, n5++, n3);
                            break;
                        }
                        case 2: {
                            string3 = StringUtilities.formatNumber(vector.getStatisticDelta(n6));
                            bl |= this.changeString(vector2, string3, n5++, n3);
                            break;
                        }
                        case 1: {
                            string3 = StringUtilities.formatNumber(vector.getStatisticRate(n6)) + "/sec";
                            bl |= this.changeString(vector2, string3, n5++, n3);
                        }
                    }
                    ++n6;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        if (bl) {
            vector = this.getColumnNames();
            int n7 = this.model.getColumnCount();
            int[] nArray = new int[n7];
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
            int n8 = 0;
            while (enumeration.hasMoreElements()) {
                nArray[n8++] = enumeration.nextElement().getWidth();
            }
            this.model.setDataVector(vector2, vector);
            enumeration = tableColumnModel.getColumns();
            n8 = 0;
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                if (tableColumn.getWidth() != nArray[n8]) {
                    tableColumn.setPreferredWidth(nArray[n8]);
                }
                ++n8;
            }
            this.repaint();
        }
    }

    private boolean changeString(Vector vector, String string, int n, int n2) {
        String string2 = (String)this.getValueAt(vector, n, n2);
        if (string2 == null || !string2.equals(string)) {
            this.setValueAt(vector, string, n, n2);
            return true;
        }
        return false;
    }

    private void setValueAt(Vector vector, Object object, int n, int n2) {
        Vector vector2;
        if (n < vector.size() && n2 < (vector2 = (Vector)vector.get(n)).size()) {
            vector2.set(n2, object);
        }
    }

    private Object getValueAt(Vector vector, int n, int n2) {
        Vector vector2;
        if (n < vector.size() && n2 < (vector2 = (Vector)vector.get(n)).size()) {
            return vector2.get(n2);
        }
        return null;
    }

    private Vector getColumnNames() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = this.model.getColumnCount();
        while (n < n2) {
            vector.add(this.model.getColumnName(n));
            ++n;
        }
        return vector;
    }

    public void updateReceived(ChassisEvent chassisEvent) {
        if (chassisEvent.getChassis() == this.theSwitch && chassisEvent.getEventType() == 221) {
            SwingUtilities.invokeLater(new FillTableClass());
        }
    }

    class FillTableClass
    implements Runnable {
        FillTableClass() {
        }

        public void run() {
            PortCountersPanel.this.fillTableData();
        }
    }

    class ClearDeltaAction
    extends AbstractAction {
        public ClearDeltaAction() {
            super(clearStr);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PortCountersPanel.this.portList != null) {
                int n = PortCountersPanel.this.portList.size();
                int n2 = 0;
                while (n2 < n) {
                    FCPort fCPort = (FCPort)PortCountersPanel.this.portList.elementAt(n2);
                    FCStatistics fCStatistics = fCPort.getStats();
                    if (fCStatistics != null) {
                        fCStatistics.resetBaseline();
                    }
                    ++n2;
                }
                PortCountersPanel.this.fillTableData();
            }
        }
    }
}

