/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricLink;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.Status;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.SbmUtilities;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class LinkDisplayPanel
extends JPanel
implements FabricEventListener,
ChassisEventListener {
    private static final ImageIcon UNKNOWN_ICON = new ImageIcon(SbmUtilities.getImage("StatusUnknownSm.gif"));
    private static final ImageIcon WARNING_ICON = new ImageIcon(SbmUtilities.getImage("StatusWarningSm.gif"));
    private static final ImageIcon CRITICAL_ICON = new ImageIcon(SbmUtilities.getImage("StatusCriticalSm.gif"));
    private static final ImageIcon NORMAL_ICON = new ImageIcon(SbmUtilities.getImage("StatusNormalSm.gif"));
    private static String SW1_HDR;
    private static String SW2_HDR;
    private int col0Width;
    DefaultTableModel tableModel;
    JTable table;
    Vector linkList;
    Fabric fabric;
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$java$lang$String;

    public LinkDisplayPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        SW1_HDR = FabricTreeControl.getResource("LinkDisplayPanel.switch1");
        SW2_HDR = FabricTreeControl.getResource("LinkDisplayPanel.switch2");
        this.tableModel = new LinkTableModel();
        this.table = new JTable(this.tableModel);
        this.setNumberOfCollumns();
        this.tableModel.setRowCount(0);
        this.table.getColumnModel().setColumnSelectionAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.setLayout(new GridLayout(1, 1));
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.add(new JScrollPane(this.table));
    }

    public void receiveEvent(FabricEvent fabricEvent) {
        switch (fabricEvent.getEventType()) {
            case 2002: {
                ((Chassis)fabricEvent.getValue()).addChassisEventListener((ChassisEventListener)this);
                this.fillTable();
                break;
            }
            case 2003: {
                ((Chassis)fabricEvent.getValue()).removeChassisEventListener((ChassisEventListener)this);
                this.fillTable();
                break;
            }
            case 2001: 
            case 2004: 
            case 2005: 
            case 2006: {
                this.fillTable();
                break;
            }
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        switch (chassisEvent.getEventType()) {
            case 210: 
            case 213: 
            case 269: 
            case 311: {
                this.updateTable();
                break;
            }
        }
    }

    public void setFabric(Fabric fabric) {
        if (this.fabric != null) {
            this.fabric.removeEventListener((FabricEventListener)this);
        }
        this.fabric = fabric;
        this.fabric.addEventListener((FabricEventListener)this);
    }

    public void setLinkList(Vector vector) {
        this.linkList = vector;
        this.fillTable();
    }

    private void doFillTable() {
        if (this.linkList == null) {
            return;
        }
        Object[] objectArray = new Object[3];
        this.tableModel.setRowCount(0);
        ListIterator listIterator = this.linkList.listIterator();
        while (listIterator.hasNext()) {
            this.tableModel.addRow(objectArray);
            this.fillLink((FabricLink)listIterator.next(), listIterator.previousIndex());
        }
        this.repaint();
    }

    void fillTable() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LinkDisplayPanel.this.doFillTable();
            }
        });
    }

    void updateTable() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LinkDisplayPanel.this.doUpdateTable();
            }
        });
    }

    private void doUpdateTable() {
        if (this.linkList != null) {
            ListIterator listIterator = this.linkList.listIterator();
            while (listIterator.hasNext()) {
                this.fillLink((FabricLink)listIterator.next(), listIterator.previousIndex());
            }
        }
        this.repaint();
    }

    public void fillLink(FabricLink fabricLink, int n) {
        if (this.tableModel.getRowCount() <= n) {
            return;
        }
        Chassis chassis = fabricLink.getSwitch1();
        Chassis chassis2 = fabricLink.getSwitch2();
        int n2 = fabricLink.getPortNumber1();
        int n3 = fabricLink.getPortNumber2();
        String string = null;
        String string2 = null;
        string = chassis instanceof SanboxChassis && ((SanboxChassis)chassis).getOverallStatus() != 3 ? this.getPortStatusString(((SanboxChassis)chassis).getPort(n2)) : this.getChassisStatusString(chassis);
        string2 = chassis2 instanceof SanboxChassis && ((SanboxChassis)chassis2).getOverallStatus() != 3 ? this.getPortStatusString(((SanboxChassis)chassis2).getPort(n3)) : this.getChassisStatusString(chassis2);
        String string3 = chassis + ", " + FabricTreeControl.getResource("LinkDisplayPanel.port") + " " + fabricLink.getPortNumber1() + (string != null ? " <" + string + ">" : "");
        String string4 = chassis2 + ", " + FabricTreeControl.getResource("LinkDisplayPanel.port") + " " + fabricLink.getPortNumber2() + (string2 != null ? " <" + string2 + ">" : "");
        ImageIcon imageIcon = UNKNOWN_ICON;
        switch (fabricLink.getState()) {
            case 0: {
                imageIcon = NORMAL_ICON;
                break;
            }
            case 2: {
                imageIcon = CRITICAL_ICON;
                break;
            }
            case 3: {
                imageIcon = UNKNOWN_ICON;
            }
        }
        this.table.setRowHeight(n, imageIcon.getIconHeight() + 4);
        this.col0Width = NORMAL_ICON.getIconWidth() + 6;
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(this.col0Width);
        tableColumnModel.getColumn(0).setMinWidth(this.col0Width);
        tableColumnModel.getColumn(0).setMaxWidth(this.col0Width);
        this.tableModel.setValueAt(imageIcon, n, 0);
        this.tableModel.setValueAt(string3, n, 1);
        this.tableModel.setValueAt(string4, n, 2);
        this.invalidate();
        this.repaint();
    }

    private void setNumberOfCollumns() {
        this.tableModel.setColumnCount(0);
        this.tableModel.addColumn(" ");
        this.tableModel.addColumn(SW1_HDR);
        this.tableModel.addColumn(SW2_HDR);
    }

    private String getChassisStatusString(Chassis chassis) {
        List list = chassis.getReasonForStatus();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.equals("Status.offline") && !string.equals("Status.unreachable") && !string.equals("Status.noEntrySession") && !string.equals("Status.isInPromMode") && !string.equals("Status.noResponse")) continue;
            return Status.toString((String)string);
        }
        return null;
    }

    private String getPortStatusString(FCPort fCPort) {
        int n = fCPort.getEPortConnState();
        PortStates portStates = fCPort.getPortStates();
        if (n == 3) {
            return fCPort.getEPortIsolatedReason();
        }
        if (portStates != null && (portStates.getPendingAdminState() == 2 || portStates.getActiveAdminState() == 2)) {
            return Status.toString((String)"Status.portOffline");
        }
        if (n == 0) {
            return FabricTreeControl.getResource("LinkDisplayPanel.noLnk");
        }
        if (n != 2 && n != -1) {
            return SbmUtilities.getEPortConnString(fCPort);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class LinkTableModel
    extends DefaultTableModel {
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = LinkDisplayPanel.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon;
            }
            return class$java$lang$String == null ? (class$java$lang$String = LinkDisplayPanel.class$("java.lang.String")) : class$java$lang$String;
        }
    }
}

