/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.Status;
import com.qlogic.qms.fabric.Director_Renderer;
import com.qlogic.qms.fabric.Sanbox2_16Renderer;
import com.qlogic.qms.fabric.Sanbox2_8CRenderer;
import com.qlogic.qms.fabric.Sanbox2_8Renderer;
import com.qlogic.qms.fabric.Sanbox8000Renderer;
import com.qlogic.qms.fabric.Sanbox_16Renderer;
import com.qlogic.qms.fabric.Sanbox_8Renderer;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.SwitchBladeRenderer;
import com.qlogic.qms.fabric.UnmanageableSw_Renderer;
import com.qlogic.ui.Topology;
import com.qlogic.ui.topology.TopologyNode;
import com.qlogic.ui.topology.TopologyNodeRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.View;

public abstract class FcSwitchRenderer
extends JComponent
implements TopologyNodeRenderer {
    Chassis sw;
    Topology topology;
    Object value;
    boolean isSelected;
    boolean cellHasFocus;
    Color selectedBackground = new Color(204, 204, 255);
    Color normalBackground = Color.white;
    private static boolean viewNameServerInfo = false;
    private static Icon goodStatusIcon = new ImageIcon(SbmUtilities.getImage("StatusNormal.gif"));
    private static Icon warningStatusIcon = new ImageIcon(SbmUtilities.getImage("StatusWarning.gif"));
    private static Icon criticalStatusIcon = new ImageIcon(SbmUtilities.getImage("StatusCritical.gif"));
    private static Icon unknownStatusIcon = new ImageIcon(SbmUtilities.getImage("StatusUnknown.gif"));
    private static Icon enetGoodIcon = new ImageIcon(SbmUtilities.getImage("EthernetPortGood.gif"));
    private static Icon enetWarningIcon = new ImageIcon(SbmUtilities.getImage("EthernetPortWarn.gif"));
    private static Icon enetBadIcon = new ImageIcon(SbmUtilities.getImage("EthernetPortBad.gif"));
    private static Icon targetIcon = new ImageIcon(SbmUtilities.getImage("Target2.gif"));
    private static Icon initiatorIcon = new ImageIcon(SbmUtilities.getImage("Initiator2.gif"));
    private static Icon unknownTiIcon = new ImageIcon(SbmUtilities.getImage("UnknownTI.gif"));
    private Icon statusIcon = null;
    private Icon switchIcon = null;
    private Icon enetIcon = null;
    protected int iconGap = 1;
    protected JLabel nameLabel;
    protected JLabel idLabel;
    protected JLabel statusLabel;
    protected String nodeName;
    protected String nodeID;
    protected String nodeStatus;
    protected int nodeStatusVal = 3;
    protected Font textFont = new Font("sansserif", 0, 12);
    protected Rectangle newBounds = new Rectangle();
    protected Rectangle statusIconBounds = new Rectangle();
    protected Rectangle switchIconBounds = new Rectangle();
    protected Rectangle enetIconBounds = new Rectangle();
    private Point nodeNameLocation = new Point();
    private Point nodeIdLocation = new Point();
    private Point nodeStatusLocation = new Point();
    private FontMetrics fm;
    private int fontHeight;
    private int ascent;
    private int textHeight;
    private View statusView;
    private Rectangle statusBounds = new Rectangle();

    protected abstract Icon getSwitchIcon();

    public abstract Dimension getPortDimension();

    public abstract Point getPortPoint(int var1);

    public static boolean getViewNameServerInfo() {
        return viewNameServerInfo;
    }

    public static void setViewNameServerInfo(boolean bl) {
        viewNameServerInfo = bl;
    }

    public static FcSwitchRenderer getNodeRenderer(Chassis chassis) {
        switch (chassis.getChassisType()) {
            case 30: {
                return new Sanbox2_8CRenderer();
            }
            case 8: {
                return new Sanbox2_8Renderer();
            }
            case 16: {
                return new Sanbox2_16Renderer();
            }
            case 2: {
                return new Sanbox_8Renderer();
            }
            case 26: {
                return new Sanbox8000Renderer();
            }
            case 33: 
            case 38: {
                return new SwitchBladeRenderer();
            }
            case 0: {
                return new Sanbox_16Renderer();
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new Director_Renderer();
            }
        }
        return new UnmanageableSw_Renderer();
    }

    public Component getTopologyNodeRendererComponent(Topology topology, TopologyNode topologyNode, boolean bl, boolean bl2) {
        this.topology = topology;
        if (this.fm == null) {
            this.fm = topology.getFontMetrics(this.textFont);
            this.fontHeight = this.fm.getHeight();
            this.ascent = this.fm.getAscent();
            this.textHeight = this.ascent + this.fm.getDescent();
        }
        this.setSwitchInfo((Chassis)topologyNode.getObject());
        this.setLocation(topologyNode.getX(), topologyNode.getY());
        this.doLayout();
        if (bl) {
            this.setOpaque(true);
            this.setBackground(this.selectedBackground);
        } else {
            this.setOpaque(false);
            this.setBackground(this.normalBackground);
        }
        return this;
    }

    public Rectangle getIconBounds(TopologyNode topologyNode, Component component) {
        Rectangle rectangle = null;
        rectangle = this.switchIcon != null ? new Rectangle(this.getX() + this.switchIconBounds.x, this.getY() + this.switchIconBounds.y, this.switchIconBounds.width, this.switchIconBounds.height) : (this.statusIcon != null ? new Rectangle(this.statusIconBounds) : this.getBounds());
        return rectangle;
    }

    protected void setSwitchInfo(Chassis chassis) {
        this.sw = chassis;
        this.statusIconBounds.height = 0;
        this.statusIconBounds.width = 0;
        this.statusIcon = this.getStatusIcon(chassis);
        if (this.statusIcon != null) {
            this.statusIconBounds.width = this.statusIcon.getIconWidth();
            this.statusIconBounds.height = this.statusIcon.getIconHeight();
        }
        this.statusIconBounds.height = 0;
        this.switchIconBounds.width = 0;
        this.switchIcon = this.getSwitchIcon();
        if (this.switchIcon != null) {
            this.switchIconBounds.width = this.switchIcon.getIconWidth();
            this.switchIconBounds.height = this.switchIcon.getIconHeight();
        }
        this.statusIconBounds.height = 0;
        this.enetIconBounds.width = 0;
        this.enetIcon = this.getEnetIcon(chassis);
        if (this.enetIcon != null) {
            this.enetIconBounds.width = this.enetIcon.getIconWidth();
            this.enetIconBounds.height = this.enetIcon.getIconHeight();
        }
        this.nodeName = this.getChassisName(chassis);
        this.nodeID = this.getChassisID(chassis);
        String string = this.nodeStatus;
        this.nodeStatus = this.getChassisStatus(chassis);
        this.nodeStatusVal = chassis.getOverallStatus();
    }

    protected Icon getStatusIcon(Chassis chassis) {
        switch (chassis.getOverallStatus()) {
            case 0: {
                return goodStatusIcon;
            }
            case 3: {
                return unknownStatusIcon;
            }
            case 1: {
                return warningStatusIcon;
            }
            case 2: {
                return criticalStatusIcon;
            }
        }
        return null;
    }

    protected Icon getEnetIcon(Chassis chassis) {
        try {
            if (chassis.getDiscoveredByIpAddress()) {
                switch (chassis.getComAgent().getComAgentStatus()) {
                    case 1: {
                        return enetGoodIcon;
                    }
                    case 2: 
                    case 3: {
                        return enetBadIcon;
                    }
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void doLayout() {
        int n = 0;
        int n2 = 0;
        if (this.statusIcon != null) {
            n += this.statusIconBounds.width;
            n2 = Math.max(n2, this.statusIconBounds.height);
        }
        if (this.switchIcon != null) {
            if (n > 0) {
                n += this.iconGap;
            }
            this.switchIconBounds.width = this.switchIcon.getIconWidth();
            this.switchIconBounds.height = this.switchIcon.getIconHeight();
            n += this.switchIconBounds.width;
            n2 = Math.max(n2, this.switchIconBounds.height);
        }
        if (this.enetIcon != null) {
            if (n > 0) {
                n += this.iconGap;
            }
            this.enetIconBounds.width = this.enetIcon.getIconWidth();
            this.enetIconBounds.height = this.enetIcon.getIconHeight();
            n += this.enetIconBounds.width;
            n2 = Math.max(n2, this.enetIconBounds.height);
        }
        int n3 = 0;
        int n4 = 0;
        if (this.nodeName != null) {
            n3 += this.textHeight;
            n4 = Math.max(n4, this.fm.stringWidth(this.nodeName));
        }
        if (this.nodeStatus != null) {
            n3 += this.textHeight;
            n4 = Math.max(n4, this.fm.stringWidth(this.nodeStatus));
        }
        if (n3 > 0) {
            if (n > 0) {
                n += this.iconGap + n4;
            }
            n2 = Math.max(n2, n3);
        }
        Insets insets = this.getInsets();
        this.setSize(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
        if (this.statusIcon != null) {
            this.statusIconBounds.x = insets.left;
            this.statusIconBounds.y = (n2 - this.statusIcon.getIconHeight() + 1) / 2;
        }
        if (this.switchIcon != null) {
            this.switchIconBounds.x = this.statusIcon != null ? this.statusIconBounds.x + this.statusIconBounds.width + this.iconGap : insets.left;
            this.switchIconBounds.y = (n2 - this.switchIcon.getIconHeight() + 1) / 2;
        }
        if (this.enetIcon != null) {
            this.enetIconBounds.x = this.switchIcon != null ? this.switchIconBounds.x + this.switchIconBounds.width + this.iconGap : (this.statusIcon != null ? this.statusIconBounds.x + this.statusIconBounds.width + this.iconGap : insets.left);
            this.enetIconBounds.y = (n2 - this.enetIcon.getIconHeight() + 1) / 2;
        }
        int n5 = 0;
        n5 = this.enetIcon != null ? this.enetIconBounds.x + this.enetIconBounds.width + this.iconGap : (this.switchIcon != null ? this.switchIconBounds.x + this.switchIconBounds.width + this.iconGap : (this.statusIcon != null ? this.statusIconBounds.x + this.statusIconBounds.width + this.iconGap : insets.left));
        int n6 = (n2 - n3 + 1) / 2;
        if (this.nodeName != null) {
            this.nodeNameLocation.setLocation(n5, n6 += this.ascent);
        }
        if (this.nodeStatus != null) {
            this.nodeStatusLocation.setLocation(n5, n6 + this.textHeight);
        }
    }

    public String getChassisName(Chassis chassis) {
        if (chassis instanceof SanboxChassis) {
            return ((SanboxChassis)chassis).getChassisName();
        }
        return chassis.toString();
    }

    public String getChassisID(Chassis chassis) {
        return chassis.getWWName().delimit();
    }

    public String getChassisStatus(Chassis chassis) {
        return SbmUtilities.reasonToString(chassis.getReasonForStatus());
    }

    public int getIconGap() {
        return this.iconGap;
    }

    public void setIconGap(int n) {
        int n2 = this.iconGap;
        this.iconGap = n;
        if (n != n2) {
            this.revalidate();
            this.repaint();
        }
    }

    protected static void paintText(String string, FcSwitchRenderer fcSwitchRenderer, Graphics graphics, int n, int n2) {
        graphics.setColor(fcSwitchRenderer.getForeground());
        graphics.drawString(string, n, n2);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (jComponent == this) {
            this.paint(graphics);
        }
    }

    public void paint(Graphics graphics) {
        Serializable serializable;
        Color color = graphics.getColor();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.statusIcon != null) {
            this.statusIcon.paintIcon(null, graphics, this.statusIconBounds.x, this.statusIconBounds.y);
        }
        if (this.switchIcon != null) {
            this.switchIcon.paintIcon(null, graphics, this.switchIconBounds.x, this.switchIconBounds.y);
        }
        if (this.enetIcon != null) {
            this.enetIcon.paintIcon(null, graphics, this.enetIconBounds.x, this.enetIconBounds.y);
        }
        Font font = graphics.getFont();
        graphics.setFont(this.textFont);
        graphics.setColor(Color.black);
        if (this.nodeName != null) {
            graphics.drawString(this.nodeName, this.nodeNameLocation.x, this.nodeNameLocation.y);
        }
        if (this.nodeStatus != null) {
            if (this.nodeStatusVal != 0) {
                serializable = graphics.getColor();
                graphics.setColor(Status.getColor((int)this.nodeStatusVal));
                graphics.fillRect(this.nodeStatusLocation.x, this.nodeStatusLocation.y - this.ascent, this.fm.stringWidth(this.nodeStatus) + 2, this.textHeight);
                graphics.setColor(this.nodeStatusVal == 3 ? Color.white : serializable);
            }
            graphics.drawString(this.nodeStatus, this.nodeStatusLocation.x, this.nodeStatusLocation.y);
        }
        if (this.sw != null && viewNameServerInfo) {
            String string;
            serializable = this.nodeNameLocation.getLocation();
            ((Point)serializable).x += this.statusIconBounds.x;
            ((Point)serializable).y += 5;
            FCPort fCPort = this.sw.getFirstPort();
            while (fCPort != null) {
                if (fCPort.getNodeCount() > 0) {
                    Point point = this.getPortPoint(fCPort.getPortNumber());
                    Dimension dimension = this.getPortDimension();
                    Point point2 = new Point(this.switchIconBounds.x, this.switchIconBounds.y);
                    point2.x += point.x;
                    point2.y += point.y;
                    graphics.setColor(Color.GREEN);
                    graphics.fillRect(point2.x - dimension.width / 2, point2.y - dimension.height / 2, dimension.width, dimension.height);
                }
                fCPort = this.sw.getNextPort(fCPort);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            serializable = this.nodeNameLocation.getLocation();
            ((Point)serializable).x = this.statusIconBounds.x;
            ((Point)serializable).y += this.statusIcon.getIconHeight();
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            FCNode fCNode = this.sw.getFirstNode();
            while (fCNode != null) {
                switch (fCNode.getTargetInitiator()) {
                    case 1: {
                        ++n2;
                        break;
                    }
                    case 0: {
                        ++n;
                        break;
                    }
                    default: {
                        fCPort = fCNode.getPort();
                        if (fCPort == null || fCPort.getNodeCount() <= 1) break;
                        ++n;
                    }
                }
                fCNode = this.sw.getNextNode(fCNode);
            }
            graphics.setColor(Color.BLACK);
            if (n > 0) {
                targetIcon.paintIcon(null, graphics, ((Point)serializable).x, ((Point)serializable).y);
                ((Point)serializable).x += targetIcon.getIconWidth();
                string = "(" + n + ")";
                graphics.drawString(string, ((Point)serializable).x, ((Point)serializable).y + targetIcon.getIconHeight());
                ((Point)serializable).x += fontMetrics.charsWidth(string.toCharArray(), 0, string.length());
            }
            if (n2 > 0) {
                initiatorIcon.paintIcon(null, graphics, ((Point)serializable).x, ((Point)serializable).y);
                ((Point)serializable).x += initiatorIcon.getIconWidth();
                string = "(" + n2 + ")";
                graphics.drawString(string, ((Point)serializable).x, ((Point)serializable).y + initiatorIcon.getIconHeight());
                ((Point)serializable).x += fontMetrics.charsWidth(string.toCharArray(), 0, string.length());
            }
            if (n3 > 0) {
                unknownTiIcon.paintIcon(null, graphics, ((Point)serializable).x, ((Point)serializable).y);
                ((Point)serializable).x += unknownTiIcon.getIconWidth();
                string = "(" + n3 + ")";
                graphics.drawString(string, ((Point)serializable).x, ((Point)serializable).y + unknownTiIcon.getIconHeight());
                ((Point)serializable).x += fontMetrics.charsWidth(string.toCharArray(), 0, string.length());
            }
        }
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

