/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.FaceplateListener;
import com.qlogic.qms.fabric.FaceplateStatusPanel;
import com.qlogic.qms.fabric.FaceplateTabPanel;
import com.qlogic.qms.fabric.FaceplateTopPanel;
import com.qlogic.qms.fabric.SbmUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FaceplatePanel
extends JPanel
implements FaceplateListener {
    Chassis fcSwitch = null;
    public JPanel splitPanel = new JPanel();
    public FaceplateTabPanel faceplateTabPanel;
    public FaceplateTopPanel faceplateTopPanel;
    public FaceplateStatusPanel faceplateStatusPanel;
    public JScrollPane faceplatePane;
    public JButton zoningButton = new JButton(new ZoningAction(FabricTreeControl.getResource("toolbar.zoning"), "Zone24Disabled.gif"));

    public FaceplatePanel(Chassis chassis) {
        this.zoningButton.setToolTipText(FabricTreeControl.getResource("FaceplatePanel.zoningToolTip"));
        this.zoningButton.setRolloverIcon(new ImageIcon(SbmUtilities.getImage("Zone24.gif")));
        SbmUtilities.setButtonParameters(this.zoningButton);
        this.fcSwitch = chassis;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.faceplateTabPanel = new FaceplateTabPanel(this.fcSwitch);
        this.faceplateStatusPanel = new FaceplateStatusPanel(this.fcSwitch);
        this.faceplateTopPanel = new FaceplateTopPanel(this.fcSwitch, this, this.faceplateStatusPanel);
        this.faceplateTopPanel.getFaceplate().setNameServerPanel(this.faceplateTabPanel.getNameServerPanel());
        this.setLayout(new BorderLayout());
        this.splitPanel.setLayout(new BorderLayout());
        this.add((Component)this.faceplateStatusPanel, "North");
        this.add((Component)this.splitPanel, "Center");
        this.placePanels();
    }

    public Vector getToolBarExtension() {
        Vector<JButton> vector = new Vector<JButton>();
        this.zoningButton.setEnabled(this.faceplateTopPanel.zoningAllowed());
        vector.add(this.zoningButton);
        return vector;
    }

    public Vector getMenuBarExtension() {
        return this.faceplateTopPanel.getMenuBarExtension();
    }

    public void statusChanged() {
        this.zoningButton.setEnabled(this.faceplateTopPanel.zoningAllowed());
    }

    public void cleanupPopup() {
        this.repaint();
        this.faceplateTabPanel.repaint();
    }

    public void portSelectionChanged(Vector vector) {
        this.faceplateTabPanel.setPortsSelected(vector);
    }

    public void bladeSelectionChanged(Vector vector) {
        this.faceplateTabPanel.setBladesSelected(vector);
    }

    public void doRefresh() {
        this.refresh();
    }

    public void refresh() {
        Fabric fabric = FabricList.getFabric((Chassis)this.fcSwitch);
        if (fabric != null) {
            fabric.refresh(this.fcSwitch);
        }
    }

    public void setSelectedSwitch(Chassis chassis) {
        this.fcSwitch = chassis;
        this.faceplateTabPanel.setSwitch(this.fcSwitch, new Vector());
        this.faceplateTopPanel.setSwitch(this.fcSwitch);
        this.faceplateTopPanel.getFaceplate().setNameServerPanel(this.faceplateTabPanel.getNameServerPanel());
        this.splitPanel.remove(this.faceplatePane);
        this.splitPanel.remove(this.faceplateTabPanel);
        this.placePanels();
        this.splitPanel.doLayout();
        this.invalidate();
        this.repaint();
    }

    public void selectAll() {
        this.faceplateTopPanel.selectAll();
    }

    public void placePanels() {
        this.faceplatePane = new JScrollPane(this.faceplateTopPanel);
        if (this.faceplateTopPanel.placeFaceplateOnLeft()) {
            this.splitPanel.add((Component)this.faceplatePane, "West");
            this.splitPanel.add((Component)this.faceplateTabPanel, "Center");
        } else {
            this.faceplatePane.setVerticalScrollBarPolicy(21);
            this.splitPanel.add((Component)this.faceplatePane, "North");
            this.splitPanel.add((Component)this.faceplateTabPanel, "Center");
        }
        this.splitPanel.doLayout();
        this.splitPanel.validate();
        this.splitPanel.repaint();
    }

    class ZoningAction
    extends AbstractAction {
        public ZoningAction() {
            super("Zoning");
        }

        public ZoningAction(String string, String string2) {
            super(string, new ImageIcon(SbmUtilities.getImage(string2)));
        }

        public ZoningAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FaceplatePanel.this.faceplateTopPanel.doZoning();
        }
    }
}

