/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.qms.fabric.FabricTableModel;
import com.qlogic.ui.tools.SmartScrollingTable;
import com.qlogic.util.StringUtilities;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class ComDisplayPanel
extends JPanel {
    Timer timer = new Timer();
    long lateUpdate = System.currentTimeMillis();
    FabricTableModel tableModel = new FabricTableModel();
    JTable statTable = new SmartScrollingTable((TableModel)this.tableModel);
    ComAgent agent;

    public ComDisplayPanel(ComAgent comAgent) {
        this.timer.schedule((TimerTask)new TimerUpdateTableDataClass(), 1000L, 1000L);
        this.setAgent(comAgent);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.tableModel.addColumn("Stat");
        this.tableModel.addColumn("Value");
        this.cleanoutTableData();
        this.setLayout(new GridLayout(1, 1));
        this.statTable.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.statTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.statTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.add(jScrollPane);
    }

    void cleanoutTableData() {
        this.tableModel.setRowCount(0);
    }

    public void setAgent(ComAgent comAgent) {
        if (this.agent != comAgent) {
            this.agent = comAgent;
            SwingUtilities.invokeLater(new UpdateTableDataClass());
        }
    }

    public void updateTableData() {
        this.lateUpdate = System.currentTimeMillis();
        int n = 0;
        if (this.agent != null) {
            this.tableModel.setRowCount(13);
            this.setValueAt("Address talking to:", n, 0);
            this.setValueAt(this.agent.getIpAddress().getHostAddress().toString(), n++, 1);
            this.setValueAt("Connection status", n, 0);
            this.setValueAt(this.getConnectionString(this.agent.getComAgentStatus()), n++, 1);
            this.setValueAt("Messages In Send Queue", n, 0);
            this.setValueAt(Integer.toString(this.agent.getMessagesInSendQueue()), n++, 1);
            this.setValueAt("Messages In Response Queue", n, 0);
            this.setValueAt(Integer.toString(this.agent.getMessagesInResponseQueue()), n++, 1);
            this.setValueAt("Messages Sent", n, 0);
            this.setValueAt(Integer.toString(this.agent.getMessagesSent()), n++, 1);
            this.setValueAt("Messages Returned", n, 0);
            this.setValueAt(Integer.toString(this.agent.getMessagesReturned()), n++, 1);
            this.setValueAt("Messages Sent/Sec", n, 0);
            Object[] objectArray = new Object[]{new Double(this.agent.getMessagesSentPerSecond())};
            String string = StringUtilities.formatString("{0,number,#.##}", objectArray);
            this.setValueAt(string, n++, 1);
            this.setValueAt("Messages Discards", n, 0);
            this.setValueAt(Integer.toString(this.agent.getMessagesDiscards()), n++, 1);
            this.setValueAt("Messages Timed Out", n, 0);
            this.setValueAt(Integer.toString(this.agent.getMessagesTimedOut()), n++, 1);
            this.setValueAt("Messages Resent", n, 0);
            this.setValueAt(Integer.toString(this.agent.getMessagesResent()), n++, 1);
            this.setValueAt("Average time", n, 0);
            objectArray[0] = new Double(this.agent.getAveTime());
            string = StringUtilities.formatString("{0,number,#.##}", objectArray);
            this.setValueAt(string + " ms", n++, 1);
            this.setValueAt("Total time wait for responses", n, 0);
            objectArray[0] = new Double(this.agent.getAveTime() * (double)this.agent.getMessagesReturned() / 1000.0);
            string = StringUtilities.formatString("{0,number,#.##}", objectArray);
            this.setValueAt(string + " sec", n++, 1);
            this.setValueAt("Number of notifcations", n, 0);
            this.setValueAt(Integer.toString(this.agent.getNotifications()), n++, 1);
            this.repaint();
        }
    }

    private String getConnectionString(int n) {
        switch (n) {
            case 1: {
                return "Connected";
            }
            case 3: {
                return "Connecting";
            }
            case 2: {
                return "NOT Connected";
            }
        }
        return "Unknown = " + n;
    }

    private void setValueAt(String string, int n, int n2) {
        if (!string.equals(this.tableModel.getValueAt(n, n2))) {
            this.tableModel.setValueAt(string, n, n2);
        }
    }

    class UpdateTableDataClass
    implements Runnable {
        UpdateTableDataClass() {
        }

        public void run() {
            ComDisplayPanel.this.updateTableData();
        }
    }

    class TimerUpdateTableDataClass
    extends TimerTask {
        TimerUpdateTableDataClass() {
        }

        public void run() {
            SwingUtilities.invokeLater(new UpdateTableDataClass());
        }
    }
}

