/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.FabricTableModel;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.ui.tools.SmartScrollingTable;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AlarmLogPanel
extends JPanel
implements ChassisEventListener {
    FabricTableModel tableModel = new FabricTableModel();
    JTable alarmTable = new SmartScrollingTable((TableModel)this.tableModel);
    Sanbox2 sanbox2 = null;

    public AlarmLogPanel() {
        try {
            this.jbinit();
        }
        catch (Exception exception) {}
    }

    public void jbinit() {
        this.tableModel.addColumn(FabricTreeControl.getResource("AlarmLogPanel.Entry"));
        this.tableModel.addColumn(FabricTreeControl.getResource("AlarmLogPanel.TimeStamp"));
        this.tableModel.addColumn(FabricTreeControl.getResource("AlarmLogPanel.Type"));
        this.tableModel.addColumn(FabricTreeControl.getResource("AlarmLogPanel.Description"));
        TableColumnModel tableColumnModel = this.alarmTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMinWidth(30);
        tableColumn.setPreferredWidth(50);
        tableColumn.setWidth(50);
        this.cleanoutTableData();
        this.setLayout(new GridLayout(1, 1));
        this.alarmTable.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.alarmTable.getTableHeader().setReorderingAllowed(false);
        this.alarmTable.setAutoResizeMode(3);
        JScrollPane jScrollPane = new JScrollPane(this.alarmTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.add(jScrollPane);
    }

    void cleanoutTableData() {
        this.tableModel.setRowCount(0);
    }

    public void setSelectedSwitch(Chassis chassis) {
        if (this.sanbox2 != null) {
            this.sanbox2.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
        }
        if (chassis instanceof Sanbox2) {
            this.sanbox2 = (Sanbox2)chassis;
            this.sanbox2.getEventHandler().addChassisEventListener((ChassisEventListener)this);
            SwingUtilities.invokeLater(new RepaintClass(true));
        } else {
            this.sanbox2 = null;
        }
    }

    private void fillLog(boolean bl) {
        if (this.sanbox2 == null) {
            this.cleanoutTableData();
            return;
        }
        this.cleanoutTableData();
        Vector vector = this.sanbox2.getAlarmLog();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            int n2 = 0;
            while (n2 < 4) {
                int n3 = string.indexOf(91);
                int n4 = string.indexOf(93);
                if (n3 >= 0 && n4 >= 0 && n4 > n3) {
                    String string2 = string.substring(n3 + 1, n4);
                    string = string.substring(n4 + 1);
                    if (n2 == 3) {
                        n3 = string.indexOf(91);
                        n4 = string.indexOf(93);
                        if (n3 < 0 || n4 < 0 || n4 <= n3) {
                            n3 = 0;
                            n4 = string.length() - 1;
                        }
                        string2 = string.substring(n3 + 1, n4) + "(" + string2 + ")";
                    }
                    switch (n2) {
                        case 0: {
                            this.tableModel.addRow(string2);
                        }
                        case 2: {
                            if (string2.charAt(0) == 'A') {
                                String string3 = null;
                                int n5 = string2.indexOf(46);
                                if (n5 < 0) {
                                    int n6 = Integer.parseInt(string2.substring(1));
                                    string3 = Integer.toHexString(n6);
                                } else {
                                    string3 = string2.substring(1, n5);
                                }
                                String string4 = FabricTreeControl.getResource("AlarmLogPanel.AlarmType" + string3);
                                if (string4 != null) {
                                    string2 = string4;
                                }
                            }
                        }
                        case 1: 
                        case 3: {
                            this.tableModel.setValueAt(string2, n, n2);
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (!bl) {
            this.tableModel.addRow("****");
            this.tableModel.setValueAt("****", n, 1);
            this.tableModel.setValueAt("****", n, 2);
            this.tableModel.setValueAt(FabricTreeControl.getResource("AlarmLogPanel.failureReadingRestOfLog"), n, 3);
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getEventType() == 277) {
            SwingUtilities.invokeLater(new RepaintClass(chassisEvent.isSuccessful()));
        }
    }

    class RepaintClass
    implements Runnable {
        boolean ok;

        public RepaintClass(boolean bl) {
            this.ok = bl;
        }

        public void run() {
            AlarmLogPanel.this.fillLog(this.ok);
            AlarmLogPanel.this.repaint();
        }
    }
}

