/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.util.CommandInterpreter;
import com.qlogic.util.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class SingleInstance
extends Thread {
    private String m_Greeting = null;
    private CommandInterpreter[] m_Interpreters = null;
    private ServerSocket m_ServerSocket = null;

    public SingleInstance(String greeting, int port, CommandInterpreter[] interpreters) throws IOException {
        this.m_ServerSocket = new ServerSocket(port);
        this.m_Interpreters = interpreters;
        this.m_Greeting = greeting;
    }

    public void run() {
        try {
            while (true) {
                this.handleRequest(this.m_ServerSocket.accept());
            }
        }
        catch (IOException ioe) {
            Trace.warn("SingleInstance: server terminated.");
            Trace.warn(ioe.toString());
            try {
                this.m_ServerSocket.close();
                this.m_ServerSocket = null;
            }
            catch (IOException ioe2) {
                this.m_ServerSocket = null;
                Trace.warn("SingleInstance: error closing server socket.");
            }
            return;
        }
    }

    private void handleRequest(Socket socket) {
        block6: {
            String request = null;
            boolean validCommand = false;
            try {
                PrintWriter writer = new PrintWriter(socket.getOutputStream(), true);
                BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                writer.println(this.m_Greeting);
                request = reader.readLine();
                if (this.m_Interpreters != null) {
                    for (int i = 0; i < this.m_Interpreters.length; ++i) {
                        validCommand &= this.m_Interpreters[i].processCommand(request);
                    }
                }
            }
            catch (IOException ioe) {
                Trace.warn("SingleInstance: error reading/writing to client.");
            }
            try {
                socket.close();
            }
            catch (IOException ioe) {
                Trace.warn("SingleInstance: error closing client socket.");
            }
            if (validCommand) break block6;
            Trace.warn(String.valueOf("SingleInstance: bad command ").concat(String.valueOf(request)));
        }
    }
}

