/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;

public abstract class QPrintable
implements Printable {
    protected abstract double printHeader(Graphics2D var1, PageFormat var2, int var3, double var4);

    protected abstract double printBody(Graphics2D var1, PageFormat var2, int var3, double var4);

    protected abstract boolean pageExists(int var1);

    public int print(Graphics g, PageFormat format, int pageIndex) {
        Graphics2D g2 = (Graphics2D)g;
        double currentY = format.getImageableY();
        if (this.pageExists(pageIndex)) {
            currentY = this.printHeader(g2, format, pageIndex, currentY);
            currentY = this.printBody(g2, format, pageIndex, currentY);
            return 0;
        }
        return 1;
    }

    protected boolean checkPageBreak(PageFormat format, double currentY, double padding) {
        return currentY + padding > format.getImageableHeight() + format.getImageableY();
    }

    protected double printSeparator(Graphics2D g, PageFormat format, double increment, double currentY) {
        Line2D.Double line = new Line2D.Double(format.getImageableX(), currentY, format.getImageableX() + format.getImageableWidth(), currentY);
        g.draw(line);
        return currentY += increment;
    }

    protected void printOutline(Graphics2D g2, PageFormat format) {
        Rectangle2D.Double outline = new Rectangle2D.Double(format.getImageableX(), format.getImageableY(), format.getImageableWidth(), format.getImageableHeight());
        g2.draw(outline);
    }

    public int getNumberOfPages() {
        return -1;
    }
}

