/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Properties;

public class AppProperties {
    private static final String CLASS_NAME = "AppProperties";
    private final byte[] m_aIoLoFaro = new byte[]{-72, -114, 45, -28, -97, -40, 41, 104};
    private final byte[] m_aDellIoLoFaro = new byte[]{-7, 73, -93, -119, -42, 39, 14, -48};
    private final byte[] m_aNonPosso = new byte[]{-88, 1, -71, -40, -39, 18, 14, -8};
    static final String APPLICATION_TYPE_KEY = new String("node.application.build");
    private boolean m_bPropertiesReady = false;
    private String m_strApplicationProperties = null;

    public AppProperties() {
        String strTrace = CLASS_NAME;
        Trace.traceAt(900, String.valueOf(String.valueOf("IN ").concat(String.valueOf(strTrace))).concat(String.valueOf(".")));
        this.loadSettingsFromPropertiesFile();
        this.m_bPropertiesReady = true;
        Trace.traceAt(900, String.valueOf(String.valueOf("OUT ").concat(String.valueOf(strTrace))).concat(String.valueOf(".")));
    }

    public boolean isHighAvailability() {
        if (this.toHexString(this.m_aIoLoFaro).compareTo(this.m_strApplicationProperties) == 0) {
            return true;
        }
        return this.isHAsansLunMasking();
    }

    public boolean isHAsansLunMasking() {
        return this.toHexString(this.m_aDellIoLoFaro).compareTo(this.m_strApplicationProperties) == 0;
    }

    public boolean isStandardEdition() {
        boolean bRetVal = false;
        if (this.toHexString(this.m_aNonPosso).compareTo(this.m_strApplicationProperties) == 0) {
            bRetVal = true;
        }
        return bRetVal;
    }

    private void byte2hex(byte bToEncode, StringBuffer strBuffer) {
        char[] arrHexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (bToEncode & 0xF0) >> 4;
        int low = bToEncode & 0xF;
        strBuffer.append(arrHexChars[high]);
        strBuffer.append(arrHexChars[low]);
    }

    private String toHexString(byte[] byteArray) {
        StringBuffer buf = new StringBuffer();
        int len = byteArray.length;
        for (int iter = 0; iter < len; ++iter) {
            this.byte2hex(byteArray[iter], buf);
        }
        return buf.toString();
    }

    private void loadSettingsFromPropertiesFile() {
        String strTrace = "AppProperties.loadSettingsFromPropertiesFile";
        String valueString = null;
        Properties localProperties = null;
        Trace.traceAt(900, String.valueOf(String.valueOf("IN ").concat(String.valueOf(strTrace))).concat(String.valueOf(".")));
        this.m_strApplicationProperties = "";
        try {
            localProperties = new Properties(System.getProperties());
            localProperties.load(new BufferedInputStream(new FileInputStream(Utilities.LOCAL_PROPERTIES)));
            valueString = localProperties.getProperty(APPLICATION_TYPE_KEY);
            if (valueString != null) {
                this.m_strApplicationProperties = new String(valueString);
            }
        }
        catch (Exception ex) {
            Trace.warn(String.valueOf(strTrace).concat(String.valueOf(": cannot load setup values from properties file, using defaults")));
        }
        Trace.traceAt(900, String.valueOf(String.valueOf("OUT ").concat(String.valueOf(strTrace))).concat(String.valueOf(".")));
    }
}

