/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools.treetable;

import com.qlogic.ui.tools.treetable.TreeTableModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractTreeTableModel(Object root) {
        this.root = root;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(Class.forName("javax.swing.event.TreeModelListener"), l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(Class.forName("javax.swing.event.TreeModelListener"), l);
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Class.forName("javax.swing.event.TreeModelListener")) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Class.forName("javax.swing.event.TreeModelListener")) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Class.forName("javax.swing.event.TreeModelListener")) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Class.forName("javax.swing.event.TreeModelListener")) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public Class getColumnClass(int column) {
        return Class.forName("java.lang.Object");
    }

    public boolean isCellEditable(Object node, int column) {
        return this.getColumnClass(column) == Class.forName("com.qlogic.ui.tools.treetable.TreeTableModel");
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public abstract Object getValueAt(Object var1, int var2);

    public abstract String getColumnName(int var1);

    public abstract int getColumnCount();

    public abstract int getChildCount(Object var1);

    public abstract Object getChild(Object var1, int var2);
}

