/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools.chart;

import com.qlogic.ui.tools.chart.TraceSettingsListener;
import java.awt.BasicStroke;
import java.awt.Color;

public class ChartTrace {
    public static final int SOLID_LINE = 0;
    public static final int DASHED_LINE = 1;
    public static final BasicStroke DEFAULT_STROKE = new BasicStroke(2.0f);
    public static final BasicStroke DASH_STROKE = new BasicStroke(2.0f, 2, 2, 1.0f, new float[]{5.0f, 5.0f}, 5.0f);
    private int m_Style = 0;
    private Color m_Color = null;
    private String m_Name = null;
    private String m_Units = null;
    private boolean m_Visible = true;
    private double[] m_DataPoints = null;
    private int m_Index = 0;
    private TraceSettingsListener m_Listener = null;

    public ChartTrace(int dataPoints) {
        if (dataPoints < 0) {
            throw new IllegalArgumentException(String.valueOf("Invalid number of data points: ").concat(String.valueOf(dataPoints)));
        }
        this.m_Color = Color.black;
        this.m_DataPoints = new double[dataPoints];
    }

    protected void finalize() throws Throwable {
        this.m_Color = null;
        this.m_Name = null;
        this.m_Units = null;
        this.m_DataPoints = null;
        this.m_Listener = null;
        super.finalize();
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String name) {
        this.m_Name = name;
    }

    public String getUnits() {
        return this.m_Units;
    }

    public void setUnits(String units) {
        this.m_Units = units;
    }

    public void addTraceSettingsListener(TraceSettingsListener listener) {
        this.m_Listener = listener;
    }

    protected void fireSettingsChanged() {
        TraceSettingsListener listener = this.m_Listener;
        if (listener != null) {
            listener.settingsChanged(this);
        }
    }

    public void removeTraceSettingsListener(TraceSettingsListener listener) {
        this.m_Listener = null;
    }

    public double getData(int index) {
        if (index < 0 || index >= this.m_DataPoints.length) {
            return -1.0;
        }
        int point = (index + this.m_Index) % this.m_DataPoints.length;
        return this.m_DataPoints[point];
    }

    public void setData(double value) {
        this.m_DataPoints[this.m_Index] = value;
    }

    public void rollData() {
        this.m_Index = (this.m_Index + 1) % this.m_DataPoints.length;
    }

    public double getMaxValue() {
        double max = 0.0;
        for (int i = 0; i < this.m_DataPoints.length; ++i) {
            max = Math.max(max, this.m_DataPoints[i]);
        }
        return max;
    }

    public double getMinValue() {
        return 0.0;
    }

    public int getStyle() {
        return this.m_Style;
    }

    public void setStyle(int style) {
        this.m_Style = style == 0 || style == 1 ? style : 0;
        this.fireSettingsChanged();
    }

    public BasicStroke getStroke() {
        if (this.getStyle() == 1) {
            return DASH_STROKE;
        }
        return DEFAULT_STROKE;
    }

    public Color getColor() {
        return this.m_Color;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.m_Color = color;
            this.fireSettingsChanged();
        }
    }

    public boolean isVisible() {
        return this.m_Visible;
    }

    public void setVisible(boolean visible) {
        this.m_Visible = visible;
        this.fireSettingsChanged();
    }
}

