/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools.chart;

import com.qlogic.ui.tools.chart.ChartTrace;
import com.qlogic.ui.tools.chart.DataListener;
import com.qlogic.ui.tools.chart.TraceSettingsListener;
import javax.swing.event.EventListenerList;

public class ChartData
implements TraceSettingsListener {
    private EventListenerList m_Listeners = new EventListenerList();
    private int m_DataPoints = 0;
    private ChartTrace[] m_Traces = null;
    private String[] m_Labels = null;
    private int m_LabelIndex = 0;

    public ChartData(int traces, int dataPoints) {
        if (traces < 0 || dataPoints < 0) {
            throw new IllegalArgumentException("Traces or Data Points less than 0");
        }
        this.m_DataPoints = dataPoints;
        this.m_Traces = new ChartTrace[traces];
        for (int i = 0; i < this.m_Traces.length; ++i) {
            this.m_Traces[i] = new ChartTrace(dataPoints);
            this.m_Traces[i].addTraceSettingsListener(this);
        }
        this.m_Labels = new String[dataPoints];
    }

    protected void finalize() throws Throwable {
        this.m_Listeners = null;
        this.m_Traces = null;
        this.m_Labels = null;
        super.finalize();
    }

    public void addDataListener(DataListener listener) {
        this.m_Listeners.add(Class.forName("com.qlogic.ui.tools.chart.DataListener"), listener);
    }

    public void removeDataListener(DataListener listener) {
        this.m_Listeners.remove(Class.forName("com.qlogic.ui.tools.chart.DataListener"), listener);
    }

    public void addTraceSettingsListener(TraceSettingsListener listener) {
        this.m_Listeners.add(Class.forName("com.qlogic.ui.tools.chart.TraceSettingsListener"), listener);
    }

    public void removeTraceSettingsListener(TraceSettingsListener listener) {
        this.m_Listeners.remove(Class.forName("com.qlogic.ui.tools.chart.TraceSettingsListener"), listener);
    }

    public int getTraceCount() {
        return this.m_Traces.length;
    }

    public int getDataPoints() {
        return this.m_DataPoints;
    }

    public ChartTrace getTrace(int traceIndex) {
        return this.m_Traces[traceIndex];
    }

    public double getMaxValue(int traceIndex) {
        return this.getTrace(traceIndex).getMaxValue();
    }

    public double getData(int traceIndex, int dataPoint) {
        return this.getTrace(traceIndex).getData(dataPoint);
    }

    public void setData(int traceIndex, double data) {
        this.getTrace(traceIndex).setData(data);
    }

    public void rollData() {
        for (int i = 0; i < this.m_Traces.length; ++i) {
            this.getTrace(i).rollData();
        }
        this.fireDataUpdated();
    }

    public void settingsChanged(ChartTrace trace) {
        this.fireSettingsChanged(trace);
    }

    protected void fireDataUpdated() {
        Object[] listeners = this.m_Listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != Class.forName("com.qlogic.ui.tools.chart.DataListener")) continue;
            DataListener listener = (DataListener)listeners[i + 1];
            listener.dataChanged();
        }
    }

    protected void fireSettingsChanged(ChartTrace trace) {
        Object[] listeners = this.m_Listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != Class.forName("com.qlogic.ui.tools.chart.TraceSettingsListener")) continue;
            TraceSettingsListener listener = (TraceSettingsListener)listeners[i + 1];
            listener.settingsChanged(trace);
        }
    }

    public int getLabelCount() {
        return this.m_Labels.length;
    }

    public String getLabel(int index) {
        return this.m_Labels[(index + this.m_LabelIndex) % this.m_Labels.length];
    }

    public void addLabel(String label) {
        this.m_Labels[this.m_LabelIndex] = label;
        this.m_LabelIndex = (this.m_LabelIndex + 1) % this.m_Labels.length;
    }
}

